/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.build.api.builder.dependency;

import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.jfrog.build.api.dependency.BuildPatternArtifacts;
import org.jfrog.build.api.dependency.PatternResult;

public class BuildPatternArtifactsBuilder {
    private String buildName;
    private String buildNumber;
    private String started;
    private String url;
    private List<PatternResult> patternResults = Lists.newArrayList();

    public BuildPatternArtifacts build() {
        if (this.buildName == null) {
            throw new IllegalArgumentException("BuildPatternArtifacts must have a name.");
        }
        if (this.buildNumber == null) {
            throw new IllegalArgumentException("BuildPatternArtifacts must have a number.");
        }
        if (this.started == null) {
            throw new IllegalArgumentException("BuildPatternArtifacts must have a started.");
        }
        if (this.url == null) {
            throw new IllegalArgumentException("BuildPatternArtifacts must have a url.");
        }
        BuildPatternArtifacts buildPatternArtifacts = new BuildPatternArtifacts(this.buildName, this.buildNumber, this.started, this.url);
        buildPatternArtifacts.setPatternResults(this.patternResults);
        return buildPatternArtifacts;
    }

    public BuildPatternArtifactsBuilder buildName(String buildName) {
        this.buildName = buildName;
        return this;
    }

    public BuildPatternArtifactsBuilder buildNumber(String buildNumber) {
        this.buildNumber = buildNumber;
        return this;
    }

    public BuildPatternArtifactsBuilder patternResult(PatternResult patternResult) {
        this.patternResults.add(patternResult);
        return this;
    }

    public BuildPatternArtifactsBuilder started(String started) {
        this.started = started;
        return this;
    }

    public BuildPatternArtifactsBuilder startedDate(Date started) {
        if (started == null) {
            throw new IllegalArgumentException("Cannot format a null date.");
        }
        this.started = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ").format(started);
        return this;
    }

    public BuildPatternArtifactsBuilder url(String url) {
        this.url = url;
        return this;
    }
}

