/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.version;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.jfrog.common.ClockUtils;

public class AccessVersion {
    public static final String ACCESS_VERSION_FOR_ARTIFATORY_6_11_0 = "4.5.0";
    public static final String ACCESS_VERSION_FOR_ARTIFATORY_7_0_0 = "5.0.0";
    private static final AccessVersion CURRENT;
    private static final String ACCESS_VERSION = "access.version";
    private static final String ACCESS_TIMESTAMP = "access.timestamp";
    private static final String ACCESS_REVISION = "access.revision";
    private static final String VERSION_PROPS_FILE = "META-INF/access.version.properties";
    static final String VERSION_OVERRIDE_SYSTEM_PROP = "access.debug.version";
    private final String name;
    private final String timestamp;
    private final String revision;

    private static AccessVersion createDevenvVersion(Properties properties, String overrideVersion) {
        String versionProperty = properties.getProperty(ACCESS_VERSION);
        String version = StringUtils.isBlank((String)versionProperty) ? overrideVersion : versionProperty;
        return new AccessVersion(version, Long.toString(ClockUtils.epochMillis()), "devenv");
    }

    private AccessVersion(String name, String timestamp, String revision) {
        this.name = name;
        this.timestamp = timestamp;
        this.revision = revision;
        this.validate(this);
    }

    public static AccessVersion read(@Nonnull Properties properties) {
        String name = properties.getProperty(ACCESS_VERSION);
        String timestamp = properties.getProperty(ACCESS_TIMESTAMP);
        String revision = properties.getProperty(ACCESS_REVISION);
        return new AccessVersion(name, timestamp, revision);
    }

    public void write(@Nonnull Properties properties) {
        properties.setProperty(ACCESS_VERSION, this.name);
        properties.setProperty(ACCESS_TIMESTAMP, this.timestamp);
        properties.setProperty(ACCESS_REVISION, this.revision);
    }

    public String getName() {
        return this.name;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getRevision() {
        return this.revision;
    }

    public static AccessVersion current() {
        return CURRENT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccessVersion that = (AccessVersion)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.timestamp.equals(that.timestamp)) {
            return false;
        }
        return this.revision.equals(that.revision);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.timestamp.hashCode();
        result = 31 * result + this.revision.hashCode();
        return result;
    }

    private void validate(AccessVersion accessVersion) {
        if (StringUtils.isBlank((String)accessVersion.getName()) || StringUtils.isBlank((String)accessVersion.getRevision()) || StringUtils.isBlank((String)accessVersion.getTimestamp())) {
            throw new IllegalArgumentException("Version number, revision and timestamp can not be blank.");
        }
    }

    static {
        Properties properties = new Properties();
        try (InputStream inputStream = AccessVersion.class.getClassLoader().getResourceAsStream(VERSION_PROPS_FILE);){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error occurred wile reading 'access.version.properties' file.", e);
        }
        String overrideVersion = System.getProperty(VERSION_OVERRIDE_SYSTEM_PROP);
        CURRENT = org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)overrideVersion) ? AccessVersion.createDevenvVersion(properties, overrideVersion) : AccessVersion.read(properties);
    }
}

