/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.util;

import com.google.common.hash.Hashing;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.jfrog.access.common.ScopeContainer;
import org.jfrog.access.token.JwtAccessToken;
import org.jfrog.access.token.exception.TokenScopeException;

public abstract class TokenScopeUtils {
    public static final String SCOPE_TOKEN_DELIMITER = "(?!\\B\"[^\"]*) (?![^\"]*\"\\B)";
    public static final String HASHED_PREFIX = "HASHED:";

    public static List<String> scopeToList(String scope) throws TokenScopeException {
        if (StringUtils.isBlank((String)scope)) {
            return Collections.emptyList();
        }
        if (!JwtAccessToken.SCOPE_PATTERN.matcher(scope).matches()) {
            throw new TokenScopeException("scope is malformed: " + scope);
        }
        return Stream.of(scope.split(SCOPE_TOKEN_DELIMITER)).collect(Collectors.toList());
    }

    public static String hashScopeIfNeeded(String scope) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scope) && !scope.startsWith(HASHED_PREFIX)) {
            byte[] sha2Bytes = Hashing.sha256().hashString((CharSequence)scope, Charsets.US_ASCII).asBytes();
            return HASHED_PREFIX + Hashing.sha256().hashBytes(sha2Bytes).toString();
        }
        return scope;
    }

    public static Set<String> scopeToGroups(String scope) throws TokenScopeException {
        return TokenScopeUtils.scopeToScopeContainer(scope).getGroups();
    }

    public static Set<String> scopeToRawGroups(String scope) throws TokenScopeException {
        return TokenScopeUtils.scopeToScopeContainerRaw(scope).getGroups();
    }

    public static Set<String> scopeToGroups(List<String> scopeList) throws TokenScopeException {
        return TokenScopeUtils.scopeToScopeContainer(scopeList).getGroups();
    }

    public static ScopeContainer scopeToScopeContainer(String scopeStr) throws TokenScopeException {
        return TokenScopeUtils.scopeToScopeContainer(TokenScopeUtils.scopeToList(scopeStr));
    }

    public static ScopeContainer scopeToScopeContainer(List<String> scopeList) throws TokenScopeException {
        ScopeContainer scopeContainer = new ScopeContainer();
        scopeList.stream().forEach(scopeContainer::add);
        return scopeContainer;
    }

    public static ScopeContainer scopeToScopeContainerRaw(String scope) throws TokenScopeException {
        ScopeContainer scopeContainer = new ScopeContainer();
        scopeContainer.addRaw(scope);
        return scopeContainer;
    }
}

