/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.util;

import com.google.common.hash.Hashing;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.Charsets;
import org.apache.commons.lang.StringUtils;
import org.jfrog.access.token.JwtAccessToken;
import org.jfrog.access.token.exception.TokenScopeException;

public abstract class TokenScopeUtils {
    public static final String SCOPE_TOKEN_DELIMITER = "(?!\\B\"[^\"]*) (?![^\"]*\"\\B)";
    public static final String HASHED_PREFIX = "HASHED:";

    public static List<String> scopeToList(String scope) throws TokenScopeException {
        if (StringUtils.isBlank((String)scope)) {
            return Collections.emptyList();
        }
        if (!JwtAccessToken.SCOPE_PATTERN.matcher(scope).matches()) {
            throw new TokenScopeException("scope is malformed: " + scope);
        }
        return Stream.of(scope.split(SCOPE_TOKEN_DELIMITER)).collect(Collectors.toList());
    }

    public static String hashScopeIfNeeded(String scope) {
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)scope) && !scope.startsWith(HASHED_PREFIX)) {
            byte[] sha2Bytes = Hashing.sha256().hashString((CharSequence)scope, Charsets.US_ASCII).asBytes();
            return HASHED_PREFIX + Hashing.sha256().hashBytes(sha2Bytes).toString();
        }
        return scope;
    }
}

