/*
 * Decompiled with CFR 0.152.
 */
package org.jfrog.access.client;

import java.security.cert.Certificate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.http.ssl.SSLContextBuilder;
import org.jfrog.access.client.AccessAuth;
import org.jfrog.access.client.AccessClient;
import org.jfrog.access.client.RootCertificateHolder;
import org.jfrog.access.common.ServiceId;
import org.jfrog.client.http.model.ProxyConfig;

public abstract class AccessClientBuilder {
    public static AccessClientBuilder newBuilder() {
        try {
            Class<?> builderClass = Class.forName(AccessClientBuilder.class.getName() + "Impl");
            return (AccessClientBuilder)builderClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create an AccessClientBuilder instance.", e);
        }
    }

    public abstract AccessClientBuilder serverUrl(String var1);

    public abstract String getServerUrl();

    public abstract AccessClientBuilder grpcUrl(String var1);

    public abstract String getGrpcUrl();

    public abstract AccessClientBuilder connectionTimeout(int var1);

    public abstract int getConnectionTimeout();

    public abstract AccessClientBuilder socketTimeout(int var1);

    public abstract int getSocketTimeout();

    public abstract AccessClientBuilder maxConnections(int var1);

    public abstract int getMaxConnections();

    public abstract AccessClientBuilder tokenVerificationResultCacheSize(long var1);

    public abstract long getTokenVerificationResultCacheSize();

    public abstract AccessClientBuilder tokenVerificationResultCacheExpiry(long var1);

    public abstract long getTokenVerificationResultCacheExpiry();

    public abstract AccessClientBuilder defaultAuth(AccessAuth var1);

    @Nullable
    public abstract AccessAuth getDefaultAuth();

    public abstract AccessClientBuilder serviceId(ServiceId var1);

    @Nullable
    public abstract ServiceId getServiceId();

    public abstract AccessClientBuilder rootCertificate(RootCertificateHolder var1);

    public abstract AccessClientBuilder rootCertificate(Certificate var1);

    @Nonnull
    public abstract RootCertificateHolder getRootCertificateHolder();

    public abstract AccessClientBuilder originUser(Supplier<String> var1);

    public abstract Supplier<String> getOriginUser();

    public abstract AccessClientBuilder originUserIp(Supplier<String> var1);

    public abstract Supplier<String> getOriginUserIp();

    public abstract AccessClientBuilder proxyConfig(ProxyConfig var1);

    public abstract ProxyConfig getProxyConfig();

    public abstract AccessClientBuilder sslContextBuilder(SSLContextBuilder var1);

    public abstract SSLContextBuilder getSslContextBuilder();

    public abstract AccessClientBuilder noHostVerification(boolean var1);

    public abstract boolean isNoHostVerification();

    public abstract boolean isForceRest();

    public abstract AccessClientBuilder forceRest(boolean var1);

    public abstract boolean isForceGrpc();

    public abstract AccessClientBuilder forceGrpc(boolean var1);

    public abstract AccessClient create();
}

