/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.validation;

import java.io.File;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.validation.KlibExtractAbiParameters;
import kotlinx.validation.api.klib.KlibDump;
import kotlinx.validation.api.klib.KlibDumpKt;
import kotlinx.validation.api.klib.KlibTarget;
import org.gradle.workers.WorkAction;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b \u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lkotlinx/validation/KlibExtractAbiWorker;", "Lorg/gradle/workers/WorkAction;", "Lkotlinx/validation/KlibExtractAbiParameters;", "()V", "execute", "", "binary-compatibility-validator"})
@SourceDebugExtension(value={"SMAP\nKotlinKlibExtractAbiTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinKlibExtractAbiTask.kt\nkotlinx/validation/KlibExtractAbiWorker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,112:1\n1549#2:113\n1620#2,3:114\n1549#2:117\n1620#2,3:118\n*E\n*S KotlinDebug\n*F\n+ 1 KotlinKlibExtractAbiTask.kt\nkotlinx/validation/KlibExtractAbiWorker\n*L\n99#1:113\n99#1,3:114\n108#1:117\n108#1,3:118\n*E\n"})
public abstract class KlibExtractAbiWorker
implements WorkAction<KlibExtractAbiParameters> {
    /*
     * WARNING - void declaration
     */
    public void execute() {
        void $this$mapTo$iv$iv;
        Object object;
        void $this$mapTo$iv$iv2;
        File inputFile = (File)((KlibExtractAbiParameters)this.getParameters()).getInputAbiFile().getAsFile().get();
        File rootDir = (File)((KlibExtractAbiParameters)this.getParameters()).getRootDir().getAsFile().get();
        if (!inputFile.exists()) {
            StringBuilder stringBuilder = new StringBuilder().append("File with project's API declarations '");
            Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
            Intrinsics.checkNotNullExpressionValue((Object)rootDir, (String)"rootDir");
            throw new IllegalStateException(stringBuilder.append(FilesKt.relativeTo((File)inputFile, (File)rootDir)).append("' does not exist.\nPlease ensure that ':apiDump' was executed in order to get API dump to compare the build against").toString().toString());
        }
        if (inputFile.length() == 0L) {
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(inputFile.toPath(), ((File)((KlibExtractAbiParameters)this.getParameters()).getOutputAbiFile().getAsFile().get()).toPath(), copyOptionArray);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
        KlibDump dump2 = KlibDump.Companion.from$default(KlibDump.Companion, inputFile, null, 2, null);
        Object object2 = ((KlibExtractAbiParameters)this.getParameters()).getTargetsToRemove().get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"parameters.targetsToRemove.get()");
        Iterable $this$map$iv = (Iterable)object2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p0;
            KlibTarget klibTarget = (KlibTarget)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(p0.getTargetName());
        }
        Set unsupportedTargets2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!((Collection)unsupportedTargets2).isEmpty()) {
            Object object3 = ((KlibExtractAbiParameters)this.getParameters()).getStrictValidation().get();
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"parameters.strictValidation.get()");
            if (((Boolean)object3).booleanValue()) {
                throw new IllegalStateException("Validation could not be performed as some targets (namely, " + ((KlibExtractAbiParameters)this.getParameters()).getTargetsToRemove() + ") are not available and the strictValidation mode was enabled.");
            }
        }
        $this$map$iv = unsupportedTargets2;
        KlibTarget.Companion companion = KlibTarget.Companion;
        object = dump2;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String bl = (String)item$iv$iv;
            Collection collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(companion.parse((String)p0));
        }
        ((KlibDump)object).remove((List)destination$iv$iv2);
        Object object4 = ((KlibExtractAbiParameters)this.getParameters()).getOutputAbiFile().getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"parameters.outputAbiFile.asFile.get()");
        KlibDumpKt.saveTo(dump2, (File)object4);
    }
}

