/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSession;
import org.jetbrains.kotlin.analysis.api.fir.KaFirSessionProviderKt;
import org.jetbrains.kotlin.analysis.api.fir.utils.KaFirCacheCleaner;
import org.jetbrains.kotlin.analysis.api.impl.base.sessions.KaBaseSessionProvider;
import org.jetbrains.kotlin.analysis.api.lifetime.KaLifetimeToken;
import org.jetbrains.kotlin.analysis.api.platform.KaCachedService;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProvider;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModuleKt;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.utils.errors.ExceptionAttachmentBuilderHelpersKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLResolutionFacade;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCacheStorage;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionInvalidationListener;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.structure.LLSessionStructureWriter;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.LLStatisticsService;
import org.jetbrains.kotlin.analysis.low.level.api.fir.statistics.domains.LLAnalysisSessionStatistics;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.application.PathManager;
import org.jetbrains.kotlin.com.intellij.openapi.progress.ProgressManager;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.LowMemoryWatcher;
import org.jetbrains.kotlin.com.intellij.openapi.util.registry.Registry;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AppExecutorUtil;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u00012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020\tH\u0016J\u0010\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\tH\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010+\u001a\u00020\nH\u0002J\u0018\u0010,\u001a\u00020\"2\u0006\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010,\u001a\u00020\"2\u0006\u0010+\u001a\u00020$2\u0006\u0010'\u001a\u00020\tH\u0016J\u0018\u0010-\u001a\u00020\"2\u0006\u0010+\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010-\u001a\u00020\"2\u0006\u0010+\u001a\u00020$2\u0006\u0010'\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020\"H\u0002J\b\u0010/\u001a\u00020\"H\u0002J\b\u00100\u001a\u00020\"H\u0016J\b\u00101\u001a\u00020\"H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000f\u001a\u00020\u00108BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0016\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R#\u0010\u0017\u001a\u0004\u0018\u00010\u00188BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001c\u0010\u0016\u0012\u0004\b\u0019\u0010\u0012\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0016\u001a\u0004\b\u001d\u0010\u001f\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/sessions/KaBaseSessionProvider;", "Lorg/jetbrains/kotlin/com/intellij/openapi/Disposable;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSession;", "lowMemoryWatcher", "Lorg/jetbrains/kotlin/com/intellij/openapi/util/LowMemoryWatcher;", "scheduledCacheMaintenance", "Ljava/util/concurrent/Future;", "cacheCleaner", "Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "getCacheCleaner$annotations", "()V", "getCacheCleaner", "()Lorg/jetbrains/kotlin/analysis/api/fir/utils/KaFirCacheCleaner;", "cacheCleaner$delegate", "Lkotlin/Lazy;", "analysisSessionStatistics", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "getAnalysisSessionStatistics$annotations", "getAnalysisSessionStatistics", "()Lorg/jetbrains/kotlin/analysis/low/level/api/fir/statistics/domains/LLAnalysisSessionStatistics;", "analysisSessionStatistics$delegate", "isSessionStructureLoggingEnabled", "", "()Z", "isSessionStructureLoggingEnabled$delegate", "performCacheMaintenance", "", "getAnalysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "useSiteElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "useSiteModule", "createAnalysisSession", "useSiteKtModule", "checkSessionValidity", "session", "beforeEnteringAnalysis", "afterLeavingAnalysis", "handleLowMemoryEvent", "logSessionStructure", "clearCaches", "dispose", "SessionInvalidationListener", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKaFirSessionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider\n+ 2 ExceptionAttachmentBuilder.kt\norg/jetbrains/kotlin/utils/exceptions/ExceptionAttachmentBuilderKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n118#2,11:274\n57#2:285\n129#2,3:286\n1586#3:289\n1661#3,3:290\n*S KotlinDebug\n*F\n+ 1 KaFirSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider\n*L\n138#1:274,11\n138#1:285\n138#1:286,3\n223#1:289\n223#1:290,3\n*E\n"})
public final class KaFirSessionProvider
extends KaBaseSessionProvider
implements Disposable {
    @NotNull
    private final Cache<KaModule, KaFirSession> cache;
    @NotNull
    private final LowMemoryWatcher lowMemoryWatcher;
    @NotNull
    private final Future<?> scheduledCacheMaintenance;
    @NotNull
    private final Lazy cacheCleaner$delegate;
    @NotNull
    private final Lazy analysisSessionStatistics$delegate;
    @NotNull
    private final Lazy isSessionStructureLoggingEnabled$delegate;

    public KaFirSessionProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        Cache cache = Caffeine.newBuilder().weakValues().build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"build(...)");
        this.cache = cache;
        this.cacheCleaner$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaFirSessionProvider.cacheCleaner_delegate$lambda$0(project));
        this.analysisSessionStatistics$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> KaFirSessionProvider.analysisSessionStatistics_delegate$lambda$0(project));
        this.isSessionStructureLoggingEnabled$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, KaFirSessionProvider::isSessionStructureLoggingEnabled_delegate$lambda$0);
        LowMemoryWatcher lowMemoryWatcher = LowMemoryWatcher.register(this::handleLowMemoryEvent);
        Intrinsics.checkNotNullExpressionValue((Object)lowMemoryWatcher, (String)"register(...)");
        this.lowMemoryWatcher = lowMemoryWatcher;
        ScheduledFuture<?> scheduledFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> KaFirSessionProvider._init_$lambda$0(this), 10L, 10L, TimeUnit.SECONDS);
        Intrinsics.checkNotNullExpressionValue(scheduledFuture, (String)"scheduleWithFixedDelay(...)");
        this.scheduledCacheMaintenance = scheduledFuture;
    }

    private final KaFirCacheCleaner getCacheCleaner() {
        Lazy lazy = this.cacheCleaner$delegate;
        return (KaFirCacheCleaner)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getCacheCleaner$annotations() {
    }

    private final LLAnalysisSessionStatistics getAnalysisSessionStatistics() {
        Lazy lazy = this.analysisSessionStatistics$delegate;
        return (LLAnalysisSessionStatistics)lazy.getValue();
    }

    @KaCachedService
    private static /* synthetic */ void getAnalysisSessionStatistics$annotations() {
    }

    private final boolean isSessionStructureLoggingEnabled() {
        Lazy lazy = this.isSessionStructureLoggingEnabled$delegate;
        return (Boolean)lazy.getValue();
    }

    private final void performCacheMaintenance() {
        this.cache.cleanUp();
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        KaModule module = KotlinProjectStructureProvider.Companion.getModule(this.getProject(), (PsiElement)useSiteElement, null);
        return this.getAnalysisSession(module);
    }

    @Override
    @NotNull
    public KaSession getAnalysisSession(@NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        this.checkUseSiteModule(useSiteModule);
        ProgressManager.checkCanceled();
        this.getCacheCleaner().enterAnalysis();
        try {
            if (useSiteModule instanceof KaDanglingFileModule && !KaModuleKt.isStable((KaDanglingFileModule)useSiteModule)) {
                return this.createAnalysisSession(useSiteModule);
            }
            KClass<? extends KaLifetimeToken> identifier = this.getTokenFactory().getIdentifier();
            KaFirSessionProviderKt.access$flushPendingChanges(identifier, this.getProject());
            KaFirSession kaFirSession = (KaFirSession)this.cache.get((Object)useSiteModule, arg_0 -> KaFirSessionProvider.getAnalysisSession$lambda$0((Function1)new Function1<KaModule, KaFirSession>((Object)this){

                public final KaFirSession invoke(KaModule p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return KaFirSessionProvider.access$createAnalysisSession((KaFirSessionProvider)this.receiver, p0);
                }
            }, arg_0));
            if (kaFirSession == null) {
                throw new IllegalStateException("`createAnalysisSession` must not return `null`.".toString());
            }
            KaFirSession session2 = kaFirSession;
            this.checkSessionValidity(session2);
            return session2;
        }
        catch (Throwable e) {
            this.getCacheCleaner().exitAnalysis();
            throw e;
        }
    }

    private final KaFirSession createAnalysisSession(KaModule useSiteKtModule) {
        LLResolutionFacade resolutionFacade = LowLevelFirApiFacadeKt.getResolutionFacade(useSiteKtModule, this.getProject());
        KaLifetimeToken validityToken = this.getTokenFactory().create(this.getProject(), resolutionFacade.getUseSiteFirSession().createValidityTracker());
        return KaFirSession.Companion.createAnalysisSessionByResolutionFacade$analysis_api_fir(resolutionFacade, validityToken);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkSessionValidity(KaFirSession session2) {
        boolean condition$iv = session2.getToken().isValid();
        String attachmentName$iv = "info.txt";
        boolean $i$f$requireWithAttachment = false;
        if (!condition$iv) {
            void $this$requireWithAttachment_u24lambda_u240$iv;
            void $this$buildAttachment$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            boolean bl = false;
            String string = "An analysis session acquired via `getAnalysisSession` must be valid.";
            KotlinIllegalArgumentExceptionWithAttachments exception$iv = new KotlinIllegalArgumentExceptionWithAttachments(string);
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = (KotlinExceptionWithAttachments)exception$iv;
            String name$iv$iv = attachmentName$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = name$iv$iv;
            void var12_14 = $this$buildAttachment$iv$iv;
            boolean bl2 = false;
            void $this$checkSessionValidity_u24lambda_u241 = $this$requireWithAttachment_u24lambda_u240$iv;
            boolean bl3 = false;
            ExceptionAttachmentBuilderHelpersKt.withKaModuleEntry((ExceptionAttachmentBuilder)$this$checkSessionValidity_u24lambda_u241, "module", session2.getUseSiteModule());
            $this$checkSessionValidity_u24lambda_u241.withEntry("firSessionIsValid", String.valueOf(session2.getFirSession$analysis_api_fir().isValid()));
            $this$checkSessionValidity_u24lambda_u241.withEntry("firSessionInvalidationInformation", session2.getFirSession$analysis_api_fir().getInvalidationInformation());
            var12_14.withAttachment(string2, (Object)exceptionAttachmentBuilder.buildString());
            throw exception$iv;
        }
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session2, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        try {
            LLAnalysisSessionStatistics lLAnalysisSessionStatistics = this.getAnalysisSessionStatistics();
            if (lLAnalysisSessionStatistics != null && (lLAnalysisSessionStatistics = lLAnalysisSessionStatistics.getAnalyzeCallCounter()) != null) {
                lLAnalysisSessionStatistics.add(1L);
            }
            super.beforeEnteringAnalysis(session2, useSiteElement);
        }
        catch (Throwable e) {
            this.getCacheCleaner().exitAnalysis();
            throw e;
        }
    }

    @Override
    public void beforeEnteringAnalysis(@NotNull KaSession session2, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        try {
            LLAnalysisSessionStatistics lLAnalysisSessionStatistics = this.getAnalysisSessionStatistics();
            if (lLAnalysisSessionStatistics != null && (lLAnalysisSessionStatistics = lLAnalysisSessionStatistics.getAnalyzeCallCounter()) != null) {
                lLAnalysisSessionStatistics.add(1L);
            }
            super.beforeEnteringAnalysis(session2, useSiteModule);
        }
        catch (Throwable e) {
            this.getCacheCleaner().exitAnalysis();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session2, @NotNull KtElement useSiteElement) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteElement, (String)"useSiteElement");
        try {
            super.afterLeavingAnalysis(session2, useSiteElement);
        }
        finally {
            this.getCacheCleaner().exitAnalysis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterLeavingAnalysis(@NotNull KaSession session2, @NotNull KaModule useSiteModule) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)useSiteModule, (String)"useSiteModule");
        try {
            super.afterLeavingAnalysis(session2, useSiteModule);
        }
        finally {
            this.getCacheCleaner().exitAnalysis();
        }
    }

    private final void handleLowMemoryEvent() {
        this.performCacheMaintenance();
        this.logSessionStructure();
        this.getCacheCleaner().scheduleCleanup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void logSessionStructure() {
        if (!this.isSessionStructureLoggingEnabled()) {
            return;
        }
        LLFirSessionCacheStorage sessionCacheStorage = LLFirSessionCache.Companion.getInstance(this.getProject()).getStorage();
        List analysisSessions = CollectionsKt.toList((Iterable)this.cache.asMap().values());
        Path path = PathManager.getLogDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getLogDir(...)");
        Path logDir = path;
        String timestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss-SSS"));
        Path logFile = logDir.resolve("session-structure-" + timestamp + ".graphml");
        Closeable closeable = Files.newBufferedWriter(logFile, new OpenOption[0]);
        Throwable throwable = null;
        try {
            Collection<LLFirSession> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            BufferedWriter writer = (BufferedWriter)closeable;
            boolean bl = false;
            Iterable iterable = analysisSessions;
            LLFirSessionCacheStorage lLFirSessionCacheStorage = sessionCacheStorage;
            LLSessionStructureWriter lLSessionStructureWriter = LLSessionStructureWriter.INSTANCE;
            boolean $i$f$map = false;
            void var14_16 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KaFirSession kaFirSession = (KaFirSession)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(it.getFirSession$analysis_api_fir());
            }
            collection = (List)destination$iv$iv;
            Intrinsics.checkNotNull((Object)writer);
            lLSessionStructureWriter.writeSessionStructure(lLFirSessionCacheStorage, (List<? extends LLFirSession>)collection, writer);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    public void clearCaches() {
        this.cache.invalidateAll();
    }

    @Override
    public void dispose() {
        this.lowMemoryWatcher.stop();
        this.scheduledCacheMaintenance.cancel(false);
    }

    private static final KaFirCacheCleaner cacheCleaner_delegate$lambda$0(Project $project) {
        return KaFirCacheCleaner.Companion.getInstance($project);
    }

    private static final LLAnalysisSessionStatistics analysisSessionStatistics_delegate$lambda$0(Project $project) {
        LLStatisticsService lLStatisticsService = LLStatisticsService.Companion.getInstance($project);
        return lLStatisticsService != null ? lLStatisticsService.getAnalysisSessions() : null;
    }

    private static final boolean isSessionStructureLoggingEnabled_delegate$lambda$0() {
        return Registry.is((String)"kotlin.analysis.sessionStructureLogging", (boolean)false);
    }

    private static final void _init_$lambda$0(KaFirSessionProvider this$0) {
        this$0.performCacheMaintenance();
    }

    private static final KaFirSession getAnalysisSession$lambda$0(Function1 $tmp0, Object p0) {
        return (KaFirSession)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ KaFirSession access$createAnalysisSession(KaFirSessionProvider $this, KaModule useSiteKtModule) {
        return $this.createAnalysisSession(useSiteKtModule);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSessionInvalidationListener;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "analysisSessionProvider", "Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "getAnalysisSessionProvider", "()Lorg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider;", "afterInvalidation", "", "modules", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "afterGlobalInvalidation", "analysis-api-fir"})
    @SourceDebugExtension(value={"SMAP\nKaFirSessionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaFirSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,273:1\n1915#2,2:274\n*S KotlinDebug\n*F\n+ 1 KaFirSessionProvider.kt\norg/jetbrains/kotlin/analysis/api/fir/KaFirSessionProvider$SessionInvalidationListener\n*L\n249#1:274,2\n*E\n"})
    public static final class SessionInvalidationListener
    implements LLFirSessionInvalidationListener {
        @NotNull
        private final Project project;

        public SessionInvalidationListener(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        private final KaFirSessionProvider getAnalysisSessionProvider() {
            KaSessionProvider kaSessionProvider = KaSessionProvider.Companion.getInstance(this.project);
            KaFirSessionProvider kaFirSessionProvider = kaSessionProvider instanceof KaFirSessionProvider ? (KaFirSessionProvider)kaSessionProvider : null;
            if (kaFirSessionProvider == null) {
                throw new IllegalStateException(("Expected the analysis session provider to be a `" + Reflection.getOrCreateKotlinClass(KaFirSessionProvider.class).getSimpleName() + "`.").toString());
            }
            return kaFirSessionProvider;
        }

        @Override
        public void afterInvalidation(@NotNull Set<? extends KaModule> modules) {
            Intrinsics.checkNotNullParameter(modules, (String)"modules");
            Cache cache = this.getAnalysisSessionProvider().cache;
            Iterable $this$forEach$iv = modules;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KaModule it = (KaModule)element$iv;
                boolean bl = false;
                cache.invalidate((Object)it);
            }
        }

        @Override
        public void afterGlobalInvalidation() {
            this.getAnalysisSessionProvider().clearCaches();
        }
    }
}

