/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.builder;

import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtBinaryModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilderDsl;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaLibraryModuleImpl;
import org.jetbrains.kotlin.com.intellij.core.CoreApplicationEnvironment;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.psi.search.GlobalSearchScope;

@KtModuleBuilderDsl
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtLibraryModuleBuilder;", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtBinaryModuleBuilder;", "coreApplicationEnvironment", "Lorg/jetbrains/kotlin/com/intellij/core/CoreApplicationEnvironment;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "isSdk", "", "<init>", "(Lcom/intellij/core/CoreApplicationEnvironment;Lcom/intellij/openapi/project/Project;Z)V", "libraryName", "", "getLibraryName", "()Ljava/lang/String;", "setLibraryName", "(Ljava/lang/String;)V", "librarySources", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "getLibrarySources", "()Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;", "setLibrarySources", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibrarySourceModule;)V", "build", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "analysis-api-standalone"})
public class KtLibraryModuleBuilder
extends KtBinaryModuleBuilder {
    @NotNull
    private final CoreApplicationEnvironment coreApplicationEnvironment;
    @NotNull
    private final Project project;
    private final boolean isSdk;
    public String libraryName;
    @Nullable
    private KaLibrarySourceModule librarySources;

    public KtLibraryModuleBuilder(@NotNull CoreApplicationEnvironment coreApplicationEnvironment, @NotNull Project project, boolean isSdk) {
        Intrinsics.checkNotNullParameter((Object)coreApplicationEnvironment, (String)"coreApplicationEnvironment");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.coreApplicationEnvironment = coreApplicationEnvironment;
        this.project = project;
        this.isSdk = isSdk;
    }

    @NotNull
    public final String getLibraryName() {
        String string = this.libraryName;
        if (string != null) {
            return string;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"libraryName");
        return null;
    }

    public final void setLibraryName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.libraryName = string;
    }

    @Nullable
    public final KaLibrarySourceModule getLibrarySources() {
        return this.librarySources;
    }

    public final void setLibrarySources(@Nullable KaLibrarySourceModule kaLibrarySourceModule) {
        this.librarySources = kaLibrarySourceModule;
    }

    @Override
    @NotNull
    public KaLibraryModule build() {
        List<Path> binaryRoots = this.getBinaryRoots();
        List<VirtualFile> binaryVirtualFiles = this.getBinaryVirtualFiles();
        GlobalSearchScope globalSearchScope = this.getContentScope();
        if (globalSearchScope == null) {
            globalSearchScope = StandaloneProjectFactory.INSTANCE.createSearchScopeByLibraryRoots((Collection<? extends Path>)binaryRoots, (Collection<? extends VirtualFile>)binaryVirtualFiles, this.coreApplicationEnvironment, this.project);
        }
        GlobalSearchScope contentScope = globalSearchScope;
        return new KaLibraryModuleImpl(this.getDirectRegularDependencies(), this.getDirectDependsOnDependencies(), this.getDirectFriendDependencies(), contentScope, this.getPlatform(), this.project, (Collection<? extends Path>)binaryRoots, (Collection<? extends VirtualFile>)binaryVirtualFiles, this.getLibraryName(), this.librarySources, this.isSdk);
    }
}

