/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.sir.providers.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.sir.SirDeclaration;
import org.jetbrains.kotlin.sir.SirDeclarationParent;
import org.jetbrains.kotlin.sir.SirElement;
import org.jetbrains.kotlin.sir.SirEnum;
import org.jetbrains.kotlin.sir.SirExtension;
import org.jetbrains.kotlin.sir.SirFunction;
import org.jetbrains.kotlin.sir.SirModule;
import org.jetbrains.kotlin.sir.SirNamedDeclaration;
import org.jetbrains.kotlin.sir.SirNominalType;
import org.jetbrains.kotlin.sir.SirOrigin;
import org.jetbrains.kotlin.sir.SirVariable;
import org.jetbrains.kotlin.sir.builder.SirTypealiasBuilder;
import org.jetbrains.kotlin.sir.providers.SirEnumGenerator;
import org.jetbrains.kotlin.sir.providers.SirSession;
import org.jetbrains.kotlin.sir.providers.SirTrampolineDeclarationsProvider;
import org.jetbrains.kotlin.sir.providers.impl.PackageFlatteningSirDeclarationProviderKt;
import org.jetbrains.kotlin.sir.providers.impl.nodes.SirTrampolineFunction;
import org.jetbrains.kotlin.sir.providers.impl.nodes.SirTrampolineVariable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\u000b*\u00020\nH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000b2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\f\u0010\u000f\u001a\u00020\u0010*\u00020\nH\u0002J\u000e\u0010\u0011\u001a\u0004\u0018\u00010\n*\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/sir/providers/impl/SirTrampolineDeclarationsProviderImpl;", "Lorg/jetbrains/kotlin/sir/providers/SirTrampolineDeclarationsProvider;", "sirSession", "Lorg/jetbrains/kotlin/sir/providers/SirSession;", "targetPackageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "<init>", "(Lorg/jetbrains/kotlin/sir/providers/SirSession;Lorg/jetbrains/kotlin/name/FqName;)V", "generatedDeclarations", "", "Lorg/jetbrains/kotlin/sir/SirDeclaration;", "", "trampolineDeclarations", "generateDeclarations", "declaration", "containingModule", "Lorg/jetbrains/kotlin/sir/SirModule;", "trampolineDeclaration", "sir-providers"})
@SourceDebugExtension(value={"SMAP\nPackageFlatteningSirDeclarationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PackageFlatteningSirDeclarationProvider.kt\norg/jetbrains/kotlin/sir/providers/impl/SirTrampolineDeclarationsProviderImpl\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 SirTypealiasBuilder.kt\norg/jetbrains/kotlin/sir/builder/SirTypealiasBuilderKt\n*L\n1#1,71:1\n384#2,3:72\n387#2,4:76\n1#3:75\n44#4:80\n*S KotlinDebug\n*F\n+ 1 PackageFlatteningSirDeclarationProvider.kt\norg/jetbrains/kotlin/sir/providers/impl/SirTrampolineDeclarationsProviderImpl\n*L\n24#1:72,3\n24#1:76,4\n53#1:80\n*E\n"})
public final class SirTrampolineDeclarationsProviderImpl
implements SirTrampolineDeclarationsProvider {
    @NotNull
    private final SirSession sirSession;
    @Nullable
    private final FqName targetPackageFqName;
    @NotNull
    private final Map<SirDeclaration, List<SirDeclaration>> generatedDeclarations;

    public SirTrampolineDeclarationsProviderImpl(@NotNull SirSession sirSession, @Nullable FqName targetPackageFqName) {
        Intrinsics.checkNotNullParameter((Object)sirSession, (String)"sirSession");
        this.sirSession = sirSession;
        this.targetPackageFqName = targetPackageFqName;
        this.generatedDeclarations = new LinkedHashMap();
    }

    @Override
    @NotNull
    public List<SirDeclaration> trampolineDeclarations(@NotNull SirDeclaration $this$trampolineDeclarations) {
        Intrinsics.checkNotNullParameter((Object)$this$trampolineDeclarations, (String)"<this>");
        return this.generateDeclarations($this$trampolineDeclarations);
    }

    private final List<SirDeclaration> generateDeclarations(SirDeclaration declaration) {
        Map<SirDeclaration, List<SirDeclaration>> $this$getOrPut$iv = this.generatedDeclarations;
        boolean $i$f$getOrPut = false;
        List<SirDeclaration> value$iv = $this$getOrPut$iv.get(declaration);
        if (value$iv == null) {
            SirDeclaration sirDeclaration;
            SirEnum sirEnum;
            boolean bl = false;
            if (this.targetPackageFqName == null) {
                return CollectionsKt.emptyList();
            }
            SirSession $this$generateDeclarations_u24lambda_u243_u24lambda_u242 = this.sirSession;
            boolean bl2 = false;
            if (declaration instanceof SirEnum && PackageFlatteningSirDeclarationProviderKt.access$isNamespace((SirEnum)declaration, this.targetPackageFqName)) {
                sirEnum = (SirEnum)declaration;
            } else {
                SirEnumGenerator $this$generateDeclarations_u24lambda_u243_u24lambda_u242_u24lambda_u240 = $this$generateDeclarations_u24lambda_u243_u24lambda_u242.getEnumGenerator();
                boolean bl3 = false;
                sirEnum = $this$generateDeclarations_u24lambda_u243_u24lambda_u242_u24lambda_u240.sirPackageEnum(this.targetPackageFqName);
            }
            SirEnum targetEnum = sirEnum;
            SirDeclarationParent parent = declaration.getParent();
            boolean shouldExportToRoot = parent instanceof SirEnum ? Intrinsics.areEqual((Object)parent, (Object)targetEnum) : (parent instanceof SirExtension ? Intrinsics.areEqual((Object)((SirExtension)parent).getExtendedType(), (Object)new SirNominalType(targetEnum, null, null, null, 14, null)) : false);
            SirDeclaration it = sirDeclaration = declaration;
            boolean bl4 = false;
            SirDeclaration sirDeclaration2 = shouldExportToRoot ? sirDeclaration : null;
            return CollectionsKt.listOfNotNull((Object)(sirDeclaration2 != null ? this.trampolineDeclaration(sirDeclaration2) : null));
        }
        return value$iv;
    }

    private final SirModule containingModule(SirDeclaration $this$containingModule) {
        SirModule sirModule;
        SirDeclarationParent parent = $this$containingModule.getParent();
        if (parent instanceof SirModule) {
            sirModule = (SirModule)parent;
        } else if (parent instanceof SirDeclaration) {
            sirModule = this.containingModule((SirDeclaration)((Object)parent));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return sirModule;
    }

    private final SirDeclaration trampolineDeclaration(SirDeclaration $this$trampolineDeclaration) {
        SirDeclaration sirDeclaration;
        SirElement sirElement;
        SirElement sirElement2;
        SirDeclaration declaration = $this$trampolineDeclaration;
        if (declaration instanceof SirNamedDeclaration) {
            SirTypealiasBuilder sirTypealiasBuilder;
            boolean $i$f$buildTypealias = false;
            SirTypealiasBuilder $this$trampolineDeclaration_u24lambda_u244 = sirTypealiasBuilder = new SirTypealiasBuilder();
            boolean bl = false;
            $this$trampolineDeclaration_u24lambda_u244.setOrigin(new SirOrigin.Trampoline(declaration));
            $this$trampolineDeclaration_u24lambda_u244.setVisibility(((SirNamedDeclaration)declaration).getVisibility());
            $this$trampolineDeclaration_u24lambda_u244.setDocumentation(((SirNamedDeclaration)declaration).getDocumentation());
            $this$trampolineDeclaration_u24lambda_u244.setName(((SirNamedDeclaration)declaration).getName());
            $this$trampolineDeclaration_u24lambda_u244.setType(new SirNominalType((SirNamedDeclaration)declaration, null, null, null, 14, null));
            sirElement2 = sirTypealiasBuilder.build();
        } else {
            sirElement2 = declaration instanceof SirFunction ? (SirElement)new SirTrampolineFunction((SirFunction)declaration) : (sirElement = declaration instanceof SirVariable ? (SirElement)new SirTrampolineVariable((SirVariable)declaration) : null);
        }
        if (sirElement != null) {
            SirElement sirElement3 = sirElement;
            SirDeclaration it = (SirDeclaration)sirElement3;
            boolean bl = false;
            it.setParent(this.containingModule($this$trampolineDeclaration));
            sirDeclaration = (SirDeclaration)sirElement3;
        } else {
            sirDeclaration = null;
        }
        return sirDeclaration;
    }
}

