/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.resolve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.ISerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0015\u0010\u0019\u001a\u0004\u0018\u00010\u001a\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0013\u0010\"\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0018R\u0014\u0010$\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\fR\u0014\u0010&\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\f\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/ISerializableProperty;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isConstructorParameterWithDefault", "", "hasBackingField", "declaresDefaultValue", "<init>", "(Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;ZZZ)V", "getDescriptor", "()Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "()Z", "name", "", "getName", "()Ljava/lang/String;", "originalDescriptorName", "Lorg/jetbrains/kotlin/name/Name;", "getOriginalDescriptorName", "()Lorg/jetbrains/kotlin/name/Name;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "genericIndex", "", "getGenericIndex", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "getModule", "()Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "serializableWith", "getSerializableWith", "optional", "getOptional", "transient", "getTransient", "kotlinx-serialization-compiler-plugin.k1"})
public final class SerializableProperty
implements ISerializableProperty {
    @NotNull
    private final PropertyDescriptor descriptor;
    private final boolean isConstructorParameterWithDefault;
    @NotNull
    private final String name;
    @NotNull
    private final Name originalDescriptorName;
    @NotNull
    private final KotlinType type;
    @Nullable
    private final Integer genericIndex;
    @NotNull
    private final ModuleDescriptor module;
    @Nullable
    private final KotlinType serializableWith;
    private final boolean optional;
    private final boolean transient;

    public SerializableProperty(@NotNull PropertyDescriptor descriptor, boolean isConstructorParameterWithDefault, boolean hasBackingField, boolean declaresDefaultValue) {
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        this.descriptor = descriptor;
        this.isConstructorParameterWithDefault = isConstructorParameterWithDefault;
        String string = KSerializationUtilKt.getSerialNameValue(this.descriptor.getAnnotations());
        if (string == null) {
            String string2 = this.descriptor.getName().asString();
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        }
        this.name = string;
        Name name = this.descriptor.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
        this.originalDescriptorName = name;
        KotlinType kotlinType = this.descriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        this.type = kotlinType;
        this.genericIndex = KSerializationUtilKt.getGenericIndex(this.type);
        this.module = DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)this.descriptor));
        KotlinType kotlinType2 = KSerializationUtilKt.getSerializableWith((DeclarationDescriptor)this.descriptor);
        if (kotlinType2 == null) {
            ClassDescriptor classDescriptor = TypeUtilKt.analyzeSpecialSerializers(this.module, this.descriptor.getAnnotations());
            kotlinType2 = (KotlinType)(classDescriptor != null ? classDescriptor.getDefaultType() : null);
        }
        this.serializableWith = kotlinType2;
        this.optional = !KSerializationUtilKt.getSerialRequired(this.descriptor.getAnnotations()) && declaresDefaultValue;
        this.transient = KSerializationUtilKt.getSerialTransient(this.descriptor.getAnnotations()) || !hasBackingField;
    }

    @NotNull
    public final PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public boolean isConstructorParameterWithDefault() {
        return this.isConstructorParameterWithDefault;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public Name getOriginalDescriptorName() {
        return this.originalDescriptorName;
    }

    @NotNull
    public final KotlinType getType() {
        return this.type;
    }

    @Nullable
    public final Integer getGenericIndex() {
        return this.genericIndex;
    }

    @NotNull
    public final ModuleDescriptor getModule() {
        return this.module;
    }

    @Nullable
    public final KotlinType getSerializableWith() {
        return this.serializableWith;
    }

    @Override
    public boolean getOptional() {
        return this.optional;
    }

    @Override
    public boolean getTransient() {
        return this.transient;
    }
}

