/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.definitions;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.script.experimental.api.ScriptDiagnostic;
import kotlin.script.experimental.api.SourceCode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageLocation;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSourceLocation;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.scripting.resolve.ScriptReportSink;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u001c\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\b\u001a\u00020\t2\b\u0010\r\u001a\u0004\u0018\u00010\u000fH\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptReportSink;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptReportSink;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "<init>", "(Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;)V", "attachReports", "", "scriptFile", "Lorg/jetbrains/kotlin/com/intellij/openapi/vfs/VirtualFile;", "reports", "", "Lkotlin/script/experimental/api/ScriptDiagnostic;", "location", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageLocation;", "Lkotlin/script/experimental/api/SourceCode$Location;", "convertSeverity", "Lorg/jetbrains/kotlin/cli/common/messages/CompilerMessageSeverity;", "Lkotlin/script/experimental/api/ScriptDiagnostic$Severity;", "kotlin-scripting-compiler"})
@SourceDebugExtension(value={"SMAP\nCliScriptReportSink.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliScriptReportSink.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptReportSink\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,38:1\n1863#2,2:39\n*S KotlinDebug\n*F\n+ 1 CliScriptReportSink.kt\norg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptReportSink\n*L\n19#1:39,2\n*E\n"})
public final class CliScriptReportSink
implements ScriptReportSink {
    @NotNull
    private final MessageCollector messageCollector;

    public CliScriptReportSink(@NotNull MessageCollector messageCollector2) {
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        this.messageCollector = messageCollector2;
    }

    public void attachReports(@NotNull VirtualFile scriptFile, @NotNull List<ScriptDiagnostic> reports) {
        Intrinsics.checkNotNullParameter((Object)scriptFile, (String)"scriptFile");
        Intrinsics.checkNotNullParameter(reports, (String)"reports");
        Iterable $this$forEach$iv = reports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ScriptDiagnostic it = (ScriptDiagnostic)element$iv;
            boolean bl = false;
            this.messageCollector.report(this.convertSeverity(it.getSeverity()), it.getMessage(), (CompilerMessageSourceLocation)this.location(scriptFile, it.getLocation()));
        }
    }

    private final CompilerMessageLocation location(VirtualFile scriptFile, SourceCode.Location location) {
        if (location == null) {
            return CompilerMessageLocation.Companion.create(scriptFile.getPath());
        }
        return CompilerMessageLocation.Companion.create(scriptFile.getPath(), location.getStart().getLine(), location.getStart().getCol(), null);
    }

    private final CompilerMessageSeverity convertSeverity(ScriptDiagnostic.Severity $this$convertSeverity) {
        CompilerMessageSeverity compilerMessageSeverity;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$convertSeverity.ordinal()]) {
            case 1: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            case 2: {
                compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                break;
            }
            case 3: {
                compilerMessageSeverity = CompilerMessageSeverity.WARNING;
                break;
            }
            case 4: {
                compilerMessageSeverity = CompilerMessageSeverity.INFO;
                break;
            }
            case 5: {
                compilerMessageSeverity = CompilerMessageSeverity.LOGGING;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return compilerMessageSeverity;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ScriptDiagnostic.Severity.values().length];
            try {
                nArray[ScriptDiagnostic.Severity.FATAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.ERROR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.WARNING.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.INFO.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ScriptDiagnostic.Severity.DEBUG.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

