/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration;

import java.io.InputStream;
import java.io.PrintStream;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.IdeReplExceptionReporter;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.ReplExceptionReporter;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.ReplConfiguration;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.configuration.SnippetExecutionInterceptor;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.messages.IdeDiagnosticMessageHolder;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.reader.IdeReplCommandReader;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.reader.ReplCommandReader;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.reader.ReplSystemInWrapper;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.writer.IdeSystemOutWrapperReplWriter;
import org.jetbrains.kotlin.scripting.compiler.plugin.repl.writer.ReplWriter;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/IdeReplConfiguration;", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/ReplConfiguration;", "<init>", "()V", "allowIncompleteLines", "", "getAllowIncompleteLines", "()Z", "executionInterceptor", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/SnippetExecutionInterceptor;", "getExecutionInterceptor", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/configuration/SnippetExecutionInterceptor;", "createDiagnosticHolder", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/messages/IdeDiagnosticMessageHolder;", "writer", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "getWriter", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/writer/ReplWriter;", "exceptionReporter", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplExceptionReporter;", "getExceptionReporter", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/ReplExceptionReporter;", "commandReader", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/reader/ReplCommandReader;", "getCommandReader", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/reader/ReplCommandReader;", "sinWrapper", "Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/reader/ReplSystemInWrapper;", "getSinWrapper", "()Lorg/jetbrains/kotlin/scripting/compiler/plugin/repl/reader/ReplSystemInWrapper;", "kotlin-scripting-compiler"})
public final class IdeReplConfiguration
implements ReplConfiguration {
    @NotNull
    private final SnippetExecutionInterceptor executionInterceptor = new SnippetExecutionInterceptor(this){
        final /* synthetic */ IdeReplConfiguration this$0;
        {
            this.this$0 = $receiver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T> T execute(Function0<? extends T> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            try {
                this.this$0.getSinWrapper().setReplScriptExecuting(true);
                Object object = block.invoke();
                return (T)object;
            }
            finally {
                this.this$0.getSinWrapper().setReplScriptExecuting(false);
            }
        }
    };
    @NotNull
    private final ReplWriter writer;
    @NotNull
    private final ReplExceptionReporter exceptionReporter;
    @NotNull
    private final ReplCommandReader commandReader;
    @NotNull
    private final ReplSystemInWrapper sinWrapper;

    public IdeReplConfiguration() {
        PrintStream printStream = System.out;
        Intrinsics.checkNotNullExpressionValue((Object)printStream, (String)"out");
        IdeSystemOutWrapperReplWriter soutWrapper = new IdeSystemOutWrapperReplWriter(printStream);
        System.setOut(soutWrapper);
        InputStream inputStream = System.in;
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"in");
        this.sinWrapper = new ReplSystemInWrapper(inputStream, soutWrapper);
        System.setIn(this.sinWrapper);
        this.writer = soutWrapper;
        this.exceptionReporter = new IdeReplExceptionReporter(this.getWriter());
        this.commandReader = new IdeReplCommandReader();
    }

    @Override
    public boolean getAllowIncompleteLines() {
        return false;
    }

    @Override
    @NotNull
    public SnippetExecutionInterceptor getExecutionInterceptor() {
        return this.executionInterceptor;
    }

    @Override
    @NotNull
    public IdeDiagnosticMessageHolder createDiagnosticHolder() {
        return new IdeDiagnosticMessageHolder();
    }

    @Override
    @NotNull
    public ReplWriter getWriter() {
        return this.writer;
    }

    @Override
    @NotNull
    public ReplExceptionReporter getExceptionReporter() {
        return this.exceptionReporter;
    }

    @Override
    @NotNull
    public ReplCommandReader getCommandReader() {
        return this.commandReader;
    }

    @NotNull
    public final ReplSystemInWrapper getSinWrapper() {
        return this.sinWrapper;
    }
}

