/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl;

import java.lang.annotation.Annotation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.PublishedApi;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KAnnotatedElement;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.KVariance;
import kotlin.reflect.full.KCallables;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.full.KTypes;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataFrameKt;
import org.jetbrains.kotlinx.dataframe.annotations.ColumnName;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.ColumnsSelectionDsl;
import org.jetbrains.kotlinx.dataframe.columns.ColumnPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnWithPath;
import org.jetbrains.kotlinx.dataframe.columns.ColumnsResolver;
import org.jetbrains.kotlinx.dataframe.columns.UnresolvedColumnsPolicy;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.ConstructorsKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u008a\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0017\n\u0002\u0010\n\n\u0002\u0010\u0015\n\u0002\u0010\u0016\n\u0002\u0010\t\n\u0002\u0010\u0014\n\u0002\u0010\u0007\n\u0002\u0010\u0013\n\u0002\u0010\u0006\n\u0002\u0010\u0019\n\u0002\u0010\f\n\u0002\u0010\u0011\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u001a\u008e\u0001\u0010\u0000\u001a'\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\b\u0012\u0004\u0012\u0002H\u0002`\u0007\"\u0004\b\u0000\u0010\u0002*+\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0001j\n\u0012\u0004\u0012\u0002H\u0002\u0018\u0001`\u00072+\u0010\b\u001a'\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\u0004\u0012\u00020\u00060\u0001j\b\u0012\u0004\u0012\u0002H\u0002`\u0007H\u0080\u0004\u001a3\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\n\"\u0004\b\u0000\u0010\u0002*\u0002H\u00022\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u0002H\u0002\u0012\u0006\u0012\u0004\u0018\u0001H\u00020\u0001H\u0000\u00a2\u0006\u0002\u0010\f\u001a&\u0010\r\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\u001e\u0010\u0011\u001a\u0002H\u0002\"\n\b\u0000\u0010\u0002\u0018\u0001*\u00020\u0012*\u00020\u0010H\u0080\b\u00a2\u0006\u0002\u0010\u0013\u001a-\u0010\u0014\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00102\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0017H\u0000\u00a2\u0006\u0002\u0010\u0018\u001a\u0012\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e*\u00020\u001aH\u0000\u001a\u0018\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00100\u000e*\b\u0012\u0004\u0012\u00020\u00060\u000eH\u0000\u001a&\u0010\u001b\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\n2\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00020\nH\u0000\u001a\u0018\u0010\u001c\u001a\u00020\u0010\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\nH\u0000\u001a\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\n\u001a\u0018\u0010\u001e\u001a\u00020\u0006\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\nH\u0001\u001a\b\u0010\u001f\u001a\u00020 H\u0001\u001a#\u0010!\u001a\u0004\u0018\u0001H\u0002\"\b\b\u0000\u0010\u0002*\u00020\"*\b\u0012\u0004\u0012\u0002H\u00020\u0017H\u0001\u00a2\u0006\u0002\u0010#\u001a!\u0010$\u001a\u0002H\u0002\"\b\b\u0000\u0010\u0002*\u00020\"*\b\u0012\u0004\u0012\u0002H\u00020\u0017H\u0001\u00a2\u0006\u0002\u0010#\u001a#\u0010%\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u00022\f\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u00020'H\u0000\u00a2\u0006\u0002\u0010(\u001a*\u0010)\u001a\u00020**\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\n2\u0006\u0010+\u001a\u00020\u00062\n\b\u0002\u0010,\u001a\u0004\u0018\u00010*H\u0000\u001a\u001e\u0010)\u001a\u00020**\n\u0012\u0006\u0012\u0004\u0018\u00010*0\n2\b\b\u0002\u0010-\u001a\u00020\u0006H\u0000\u001a\u0082\u0001\u0010.\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00/0\u000e\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H\u0002012\u0006\u00102\u001a\u0002032N\u00104\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000206\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000206\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00705j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H0`9\u00a2\u0006\u0002\b8H\u0000\u001a\u0082\u0001\u0010:\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00;0\u000e\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H\u0002012\u0006\u00102\u001a\u0002032N\u00104\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000206\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000206\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00705j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H0`9\u00a2\u0006\u0002\b8H\u0000\u001a|\u0010<\u001a\b\u0012\u0004\u0012\u00020 0\u000e\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u00100*\b\u0012\u0004\u0012\u0002H\u0002012\u0006\u00102\u001a\u0002032N\u00104\u001aJ\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000206\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u0002H\u000206\u00a2\u0006\f\b\u0003\u0012\b\b\u0004\u0012\u0004\b\b(\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002H00705j\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H0`9\u00a2\u0006\u0002\b8H\u0000\u001a$\u0010=\u001a\u00020\u0010\"\u000e\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H00>*\n\u0012\u0006\u0012\u0004\u0018\u0001H00?H\u0000\u001a$\u0010@\u001a\u00020\u0010\"\u000e\b\u0000\u00100*\b\u0012\u0004\u0012\u0002H00>*\n\u0012\u0006\u0012\u0004\u0018\u0001H00?H\u0000\u001a\u001c\u0010A\u001a\u00020*2\n\u0010B\u001a\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010+\u001a\u00020\u0006H\u0000\u001a\u001d\u0010A\u001a\u00020**\u0006\u0012\u0002\b\u00030\u00172\u0006\u0010+\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\bC\u001a\u0014\u0010D\u001a\u00020\u0006*\u00020*2\u0006\u0010E\u001a\u00020*H\u0000\u001a\u0018\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020GH\u0001\u001a\u0018\u0010F\u001a\u00020K2\u0006\u0010H\u001a\u00020L2\u0006\u0010J\u001a\u00020KH\u0001\u001a\u0018\u0010F\u001a\u00020M2\u0006\u0010H\u001a\u00020\u00102\u0006\u0010J\u001a\u00020MH\u0001\u001a\u0018\u0010F\u001a\u00020N2\u0006\u0010H\u001a\u00020O2\u0006\u0010J\u001a\u00020NH\u0001\u001a\u0018\u0010F\u001a\u00020P2\u0006\u0010H\u001a\u00020Q2\u0006\u0010J\u001a\u00020PH\u0001\u001a\u0018\u0010F\u001a\u00020R2\u0006\u0010H\u001a\u00020S2\u0006\u0010J\u001a\u00020RH\u0001\u001a\u0018\u0010F\u001a\u00020\u001a2\u0006\u0010H\u001a\u00020\u00062\u0006\u0010J\u001a\u00020\u001aH\u0001\u001a\u0018\u0010F\u001a\u00020T2\u0006\u0010H\u001a\u00020U2\u0006\u0010J\u001a\u00020TH\u0001\u001a4\u0010F\u001a\b\u0012\u0004\u0012\u0002H00V\"\u0006\b\u0000\u00100\u0018\u00012\u0006\u0010H\u001a\u0002H02\u000e\u0010J\u001a\n\u0012\u0006\b\u0001\u0012\u0002H00VH\u0081\b\u00a2\u0006\u0002\u0010W\u001a2\u0010X\u001a\b\u0012\u0004\u0012\u0002H00\n\"\u0006\b\u0000\u00100\u0018\u00012\u0006\u0010H\u001a\u0002H02\f\u0010J\u001a\b\u0012\u0004\u0012\u0002H00\nH\u0081\b\u00a2\u0006\u0002\u0010Y\u001a2\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u0002010?\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u0002012\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00100?H\u0000\u001a2\u0010Z\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00020\u000e0?\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020\u00100?H\u0000\u001a\u0019\u0010\\\u001a\u0004\u0018\u0001H\u0002\"\u0004\b\u0000\u0010\u0002*\u0002H\u0002H\u0000\u00a2\u0006\u0002\u0010]\u001a&\u0010^\u001a\b\u0012\u0004\u0012\u0002H\u00020\u000e\"\u0004\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u000e2\u0006\u0010_\u001a\u00020\u0010H\u0000\u001a;\u0010`\u001a\u00020\u0006\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020>*\u0002H\u00022\u0006\u0010a\u001a\u0002H\u00022\u0006\u0010b\u001a\u0002H\u00022\b\b\u0002\u0010c\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010d\u001a\u001e\u0010i\u001a\u00020j*\u00020j2\b\b\u0002\u0010k\u001a\u00020f2\b\b\u0002\u0010l\u001a\u00020j\u001a \u0010m\u001a\b\u0012\u0004\u0012\u00020j0\u000e*\b\u0012\u0004\u0012\u00020j0\u000e2\u0006\u0010n\u001a\u00020oH\u0002\u001a\u0012\u0010p\u001a\u00020j*\b\u0012\u0004\u0012\u00020j0\u000eH\u0002\u001a\f\u0010s\u001a\u00020j*\u00020jH\u0000\u001a\u0010\u0010t\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030uH\u0000\u001a\u0010\u0010t\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030vH\u0000\u001a\u0010\u0010t\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030wH\u0000\"\u0014\u0010e\u001a\u00020fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bg\u0010h\"\u0014\u0010q\u001a\u00020fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\br\u0010h\"\u001c\u0010x\u001a\u00020j*\u0006\u0012\u0002\b\u00030u8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010z\"\u001c\u0010x\u001a\u00020j*\u0006\u0012\u0002\b\u00030v8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010{\"\u001c\u0010x\u001a\u00020j*\u0006\u0012\u0002\b\u00030w8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\by\u0010|\"#\u0010}\u001a\u00020j*\u0006\u0012\u0002\b\u00030u8@X\u0081\u0004\u00a2\u0006\r\u0012\u0004\b~\u0010\u007f\u001a\u0005\b\u0080\u0001\u0010z\"$\u0010}\u001a\u00020j*\u0006\u0012\u0002\b\u00030v8@X\u0081\u0004\u00a2\u0006\u000e\u0012\u0005\b~\u0010\u0081\u0001\u001a\u0005\b\u0080\u0001\u0010{\"$\u0010}\u001a\u00020j*\u0006\u0012\u0002\b\u00030w8@X\u0081\u0004\u00a2\u0006\u000e\u0012\u0005\b~\u0010\u0082\u0001\u001a\u0005\b\u0080\u0001\u0010|\u00a8\u0006\u0083\u0001"}, d2={"and", "Lkotlin/Function1;", "T", "Lkotlin/ParameterName;", "name", "it", "", "Lorg/jetbrains/kotlinx/dataframe/Predicate;", "other", "toIterable", "", "getNext", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)Ljava/lang/Iterable;", "removeAt", "", "index", "", "cast", "", "(I)Ljava/lang/Object;", "convert", "src", "tartypeOf", "Lkotlin/reflect/KClass;", "(ILkotlin/reflect/KClass;)Ljava/lang/Object;", "getTrueIndices", "", "equalsByElement", "rollingHash", "asList", "anyNull", "emptyPath", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnPath;", "zeroOrNull", "", "(Lkotlin/reflect/KClass;)Ljava/lang/Number;", "zero", "catchSilent", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "commonType", "Lkotlin/reflect/KType;", "nullable", "upperBound", "useStar", "getColumnsImpl", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "C", "Lorg/jetbrains/kotlinx/dataframe/DataFrame;", "unresolvedColumnsPolicy", "Lorg/jetbrains/kotlinx/dataframe/columns/UnresolvedColumnsPolicy;", "selector", "Lkotlin/Function2;", "Lorg/jetbrains/kotlinx/dataframe/api/ColumnsSelectionDsl;", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnsResolver;", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/ColumnsSelector;", "getColumnsWithPaths", "Lorg/jetbrains/kotlinx/dataframe/columns/ColumnWithPath;", "getColumnPaths", "indexOfMin", "", "Lkotlin/sequences/Sequence;", "indexOfMax", "createStarProjectedType", "klass", "createStarProjectedTypeExt", "isSubtypeWithNullabilityOf", "type", "headPlusArray", "", "head", "", "cols", "", "", "", "", "", "", "", "", "", "", "", "", "(Ljava/lang/Object;[Ljava/lang/Object;)[Ljava/lang/Object;", "headPlusIterable", "(Ljava/lang/Object;Ljava/lang/Iterable;)Ljava/lang/Iterable;", "splitByIndices", "startIndices", "asNullable", "(Ljava/lang/Object;)Ljava/lang/Object;", "last", "count", "between", "left", "right", "includeBoundaries", "(Ljava/lang/Comparable;Ljava/lang/Comparable;Ljava/lang/Comparable;Z)Z", "CAMEL_DEFAULT_DELIMITERS_REGEX", "Lkotlin/text/Regex;", "getCAMEL_DEFAULT_DELIMITERS_REGEX", "()Lkotlin/text/Regex;", "toCamelCaseByDelimiters", "", "delimiters", "numberSeparator", "joinNumbers", "separator", "", "joinToCamelCaseString", "CAMEL_LETTERS_REGEX", "getCAMEL_LETTERS_REGEX", "toSnakeCase", "isGetterLike", "Lkotlin/reflect/KFunction;", "Lkotlin/reflect/KProperty;", "Lkotlin/reflect/KCallable;", "getterName", "getGetterName", "(Lkotlin/reflect/KFunction;)Ljava/lang/String;", "(Lkotlin/reflect/KProperty;)Ljava/lang/String;", "(Lkotlin/reflect/KCallable;)Ljava/lang/String;", "columnName", "getColumnName$annotations", "(Lkotlin/reflect/KFunction;)V", "getColumnName", "(Lkotlin/reflect/KProperty;)V", "(Lkotlin/reflect/KCallable;)V", "core"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 6 KAnnotatedElements.kt\nkotlin/reflect/full/KAnnotatedElements\n*L\n1#1,521:1\n1755#2,3:522\n1755#2,3:525\n1557#2:528\n1628#2,3:529\n1557#2:532\n1628#2,3:533\n1734#2,3:536\n1557#2:539\n1628#2,3:540\n827#2:543\n855#2,2:544\n1557#2:546\n1628#2,3:547\n1557#2:550\n1628#2,3:551\n774#2:559\n865#2,2:560\n1557#2:562\n1628#2,3:563\n1567#2:570\n1598#2,4:571\n295#2,2:576\n295#2,2:579\n295#2,2:582\n1#3:554\n37#4,2:555\n1088#5,2:557\n1069#5,2:566\n1069#5,2:568\n20#6:575\n20#6:578\n20#6:581\n*S KotlinDebug\n*F\n+ 1 Utils.kt\norg/jetbrains/kotlinx/dataframe/impl/UtilsKt\n*L\n119#1:522,3\n163#1:525,3\n171#1:528\n171#1:529,3\n176#1:532\n176#1:533,3\n177#1:536,3\n183#1:539\n183#1:540,3\n184#1:543\n184#1:544,2\n213#1:546\n213#1:547,3\n223#1:550\n223#1:551,3\n402#1:559\n402#1:560,2\n403#1:562\n403#1:563,3\n439#1:570\n439#1:571,4\n502#1:576,2\n507#1:579,2\n519#1:582,2\n312#1:555,2\n398#1:557,2\n418#1:566,2\n420#1:568,2\n502#1:575\n507#1:578\n519#1:581\n*E\n"})
public final class UtilsKt {
    @NotNull
    private static final Regex CAMEL_DEFAULT_DELIMITERS_REGEX = new Regex("[^\\p{L}0-9]+|(?<=[\\p{Ll}])(?=[\\p{Lu}])|(?<=[\\p{Lu}])(?=[\\p{Lu}][\\p{Ll}])|(?<=\\d)(?=[\\p{L}])|(?<=[\\p{L}])(?=\\d)");
    @NotNull
    private static final Regex CAMEL_LETTERS_REGEX = new Regex("(?<=[a-zA-Z])[A-Z]");

    @NotNull
    public static final <T> Function1<T, Boolean> and(@Nullable Function1<? super T, Boolean> $this$and, @NotNull Function1<? super T, Boolean> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Function1<? super T, Boolean> function1 = $this$and;
        return function1 == null ? other : arg_0 -> UtilsKt.and$lambda$0(function1, other, arg_0);
    }

    @NotNull
    public static final <T> Iterable<T> toIterable(T $this$toIterable, @NotNull Function1<? super T, ? extends T> getNext) {
        Intrinsics.checkNotNullParameter(getNext, (String)"getNext");
        return new Iterable<T>(getNext, $this$toIterable){
            final /* synthetic */ Function1 $getNext$inlined;
            final /* synthetic */ Object $this_toIterable$inlined;
            {
                this.$getNext$inlined = function1;
                this.$this_toIterable$inlined = object;
            }

            public Iterator<T> iterator() {
                boolean bl = false;
                return new Iterator<T>(this.$getNext$inlined, this.$this_toIterable$inlined){
                    private T current;
                    private boolean beforeStart;
                    private T next;
                    final /* synthetic */ Function1<T, T> $getNext;
                    final /* synthetic */ T $this_toIterable;
                    {
                        this.$getNext = $getNext;
                        this.$this_toIterable = $receiver;
                        this.beforeStart = true;
                    }

                    public final T getCurrent() {
                        return this.current;
                    }

                    public final void setCurrent(T t) {
                        this.current = t;
                    }

                    public final boolean getBeforeStart() {
                        return this.beforeStart;
                    }

                    public final void setBeforeStart(boolean bl) {
                        this.beforeStart = bl;
                    }

                    public final T getNext() {
                        return this.next;
                    }

                    public final void setNext(T t) {
                        this.next = t;
                    }

                    public boolean hasNext() {
                        if (this.beforeStart) {
                            return true;
                        }
                        if (this.next == null) {
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            this.next = this.$getNext.invoke(t);
                        }
                        return this.next != null;
                    }

                    public T next() {
                        if (this.beforeStart) {
                            this.current = this.$this_toIterable;
                            this.beforeStart = false;
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            return t;
                        }
                        Object object = this.next;
                        if (object == null) {
                            T t = this.current;
                            Intrinsics.checkNotNull(t);
                            object = this.$getNext.invoke(t);
                        }
                        this.current = object;
                        this.next = null;
                        T t = this.current;
                        Intrinsics.checkNotNull(t);
                        return t;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    @NotNull
    public static final <T> List<T> removeAt(@NotNull List<? extends T> $this$removeAt, int index) {
        Intrinsics.checkNotNullParameter($this$removeAt, (String)"<this>");
        return CollectionsKt.plus((Collection)$this$removeAt.subList(0, index), (Iterable)$this$removeAt.subList(index + 1, $this$removeAt.size()));
    }

    public static final /* synthetic */ <T> T cast(int $this$cast) {
        boolean $i$f$cast = false;
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return UtilsKt.convert($this$cast, Reflection.getOrCreateKotlinClass(Object.class));
    }

    @NotNull
    public static final <T> T convert(int src, @NotNull KClass<T> tartypeOf) {
        Object object;
        Intrinsics.checkNotNullParameter(tartypeOf, (String)"tartypeOf");
        KClass<T> kClass = tartypeOf;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = (double)src;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = (long)src;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = Float.valueOf(src);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = BigDecimal.valueOf(src);
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal, (String)"valueOf(...)");
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.convert");
            object = bigDecimal;
        } else {
            throw new NotImplementedError("Casting int to " + tartypeOf + " is not supported");
        }
        return (T)object;
    }

    @NotNull
    public static final List<Integer> getTrueIndices(@NotNull boolean[] $this$getTrueIndices) {
        Intrinsics.checkNotNullParameter((Object)$this$getTrueIndices, (String)"<this>");
        ArrayList<Integer> res = new ArrayList<Integer>($this$getTrueIndices.length);
        int n = $this$getTrueIndices.length;
        for (int i = 0; i < n; ++i) {
            if (!$this$getTrueIndices[i]) continue;
            res.add(i);
        }
        return res;
    }

    @NotNull
    public static final List<Integer> getTrueIndices(@NotNull List<Boolean> $this$getTrueIndices) {
        Intrinsics.checkNotNullParameter($this$getTrueIndices, (String)"<this>");
        ArrayList<Integer> res = new ArrayList<Integer>($this$getTrueIndices.size());
        int n = ((Collection)$this$getTrueIndices).size();
        for (int i = 0; i < n; ++i) {
            if (!$this$getTrueIndices.get(i).booleanValue()) continue;
            res.add(i);
        }
        return res;
    }

    public static final <T> boolean equalsByElement(@NotNull Iterable<? extends T> $this$equalsByElement, @NotNull Iterable<? extends T> other) {
        Intrinsics.checkNotNullParameter($this$equalsByElement, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Iterator<T> iterator1 = $this$equalsByElement.iterator();
        Iterator<T> iterator2 = other.iterator();
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (Intrinsics.areEqual(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }

    public static final <T> int rollingHash(@NotNull Iterable<? extends T> $this$rollingHash) {
        Intrinsics.checkNotNullParameter($this$rollingHash, (String)"<this>");
        Iterator<T> i = $this$rollingHash.iterator();
        int hash = 0;
        while (i.hasNext()) {
            T t = i.next();
            hash = 31 * hash + (t != null ? t.hashCode() : 5);
        }
        return hash;
    }

    @NotNull
    public static final <T> List<T> asList(@NotNull Iterable<? extends T> $this$asList) {
        Intrinsics.checkNotNullParameter($this$asList, (String)"<this>");
        return $this$asList instanceof List ? (List)$this$asList : CollectionsKt.toList($this$asList);
    }

    @PublishedApi
    public static final <T> boolean anyNull(@NotNull Iterable<? extends T> $this$anyNull) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$anyNull, (String)"<this>");
            Iterable<T> $this$any$iv = $this$anyNull;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<T> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    T element$iv;
                    T it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!(it == null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @PublishedApi
    @NotNull
    public static final ColumnPath emptyPath() {
        return new ColumnPath(CollectionsKt.emptyList());
    }

    @PublishedApi
    @Nullable
    public static final <T extends Number> T zeroOrNull(@NotNull KClass<T> $this$zeroOrNull) {
        Number number;
        Intrinsics.checkNotNullParameter($this$zeroOrNull, (String)"<this>");
        KClass<T> kClass = $this$zeroOrNull;
        if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            number = 0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            number = (byte)0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            number = (short)0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            number = 0L;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            number = 0.0;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            number = Float.valueOf(0.0f);
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigDecimal.class))) {
            BigDecimal bigDecimal = BigDecimal.ZERO;
            Intrinsics.checkNotNull((Object)bigDecimal, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.zeroOrNull");
            number = bigDecimal;
        } else if (Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(BigInteger.class))) {
            BigInteger bigInteger = BigInteger.ZERO;
            Intrinsics.checkNotNull((Object)bigInteger, (String)"null cannot be cast to non-null type T of org.jetbrains.kotlinx.dataframe.impl.UtilsKt.zeroOrNull");
            number = bigInteger;
        } else {
            Integer n;
            number = Intrinsics.areEqual(kClass, (Object)Reflection.getOrCreateKotlinClass(Number.class)) ? ((n = Integer.valueOf(0)) instanceof Number ? (Number)n : null) : null;
        }
        return (T)number;
    }

    @PublishedApi
    @NotNull
    public static final <T extends Number> T zero(@NotNull KClass<T> $this$zero) {
        Intrinsics.checkNotNullParameter($this$zero, (String)"<this>");
        T t = UtilsKt.zeroOrNull($this$zero);
        if (t == null) {
            throw new NotImplementedError("Zero value for " + $this$zero + " is not supported");
        }
        return t;
    }

    @Nullable
    public static final <T> T catchSilent(@NotNull Function0<? extends T> body) {
        Object object;
        Intrinsics.checkNotNullParameter(body, (String)"body");
        try {
            object = body.invoke();
        }
        catch (Throwable throwable) {
            object = null;
        }
        return (T)object;
    }

    @NotNull
    public static final KType commonType(@NotNull Iterable<? extends KClass<?>> $this$commonType, boolean nullable, @Nullable KType upperBound) {
        Intrinsics.checkNotNullParameter($this$commonType, (String)"<this>");
        return TypeUtilsKt.createType((Iterable)TypeUtilsKt.commonParents($this$commonType), nullable, upperBound);
    }

    public static /* synthetic */ KType commonType$default(Iterable iterable, boolean bl, KType kType, int n, Object object) {
        if ((n & 2) != 0) {
            kType = null;
        }
        return UtilsKt.commonType(iterable, bl, kType);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KType commonType(@NotNull Iterable<? extends KType> $this$commonType, boolean useStar) {
        KType kType;
        Object it;
        boolean bl;
        List distinct;
        block17: {
            Intrinsics.checkNotNullParameter($this$commonType, (String)"<this>");
            distinct = CollectionsKt.distinct($this$commonType);
            Iterable $this$any$iv = distinct;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    it = (KType)element$iv;
                    boolean bl2 = false;
                    KType kType2 = it;
                    if (!(kType2 != null ? kType2.isMarkedNullable() : true)) continue;
                    bl = true;
                    break block17;
                }
                bl = false;
            }
        }
        boolean nullable = bl;
        if (distinct.isEmpty() || distinct.contains(null)) {
            kType = KTypes.withNullability((KType)Reflection.typeOf(Object.class), (boolean)nullable);
        } else if (distinct.size() == 1) {
            Object object = CollectionsKt.single((List)distinct);
            Intrinsics.checkNotNull((Object)object);
            kType = (KType)object;
        } else {
            boolean bl3;
            List projections;
            KClass<?> kClass;
            Object object;
            block18: {
                KType it2;
                Iterable $this$mapTo$iv$iv;
                Iterable $this$map$iv = distinct;
                boolean $i$f$map = false;
                it = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    KType kType3 = (KType)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl4 = false;
                    void v4 = it2;
                    Intrinsics.checkNotNull((Object)v4);
                    object.add(KTypesJvm.getJvmErasure((KType)v4));
                }
                KClass<?> kClass2 = TypeUtilsKt.commonParent((List)destination$iv$iv);
                if (kClass2 == null) {
                    return KTypes.withNullability((KType)Reflection.typeOf(Object.class), (boolean)nullable);
                }
                kClass = kClass2;
                $this$map$iv = distinct;
                $i$f$map = false;
                $this$mapTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it2 = (KType)item$iv$iv;
                    object = destination$iv$iv;
                    boolean bl5 = false;
                    KType kType4 = it2;
                    Intrinsics.checkNotNull((Object)kType4);
                    object.add(TypeUtilsKt.replaceGenericTypeParametersWithUpperbound(TypeUtilsKt.projectUpTo(kType4, kClass)));
                }
                projections = (List)destination$iv$iv;
                Iterable $this$all$iv = projections;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl3 = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        KType it3 = (KType)element$iv;
                        boolean bl6 = false;
                        if (Intrinsics.areEqual((Object)KTypesJvm.getJvmErasure((KType)it3), kClass)) continue;
                        bl3 = false;
                        break block18;
                    }
                    bl3 = true;
                }
            }
            if (!bl3) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            int n = kClass.getTypeParameters().size();
            ArrayList arrayList = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                KType commonType;
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                KType it4;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                void i2;
                int n2;
                int bl6 = n2 = i;
                object = arrayList;
                boolean bl7 = false;
                KTypeParameter typeParameter = (KTypeParameter)kClass.getTypeParameters().get((int)i2);
                Iterable bl5 = projections;
                boolean $i$f$map = false;
                void var16_28 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    KType kType5 = (KType)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl8 = false;
                    collection.add(((KTypeProjection)it4.getArguments().get((int)i2)).getType());
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$filterNot = false;
                $this$mapTo$iv$iv = $this$filterNot$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    it4 = (KType)element$iv$iv;
                    boolean bl9 = false;
                    if (distinct.contains(it4)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List projectionTypes = (List)destination$iv$iv;
                ((ArrayList)object).add(projectionTypes.isEmpty() && typeParameter.getVariance() == KVariance.IN ? (useStar ? KTypeProjection.Companion.getSTAR() : KTypeProjection.Companion.invariant(TypeUtilsKt.nothingType(false))) : (Intrinsics.areEqual((Object)(commonType = UtilsKt.commonType(projectionTypes, useStar)), (Object)Reflection.nullableTypeOf(Object.class)) && useStar ? KTypeProjection.Companion.getSTAR() : new KTypeProjection(typeParameter.getVariance(), commonType)));
            }
            List arguments = arrayList;
            kType = KClassifiers.createType$default((KClassifier)((KClassifier)kClass), (List)arguments, (boolean)nullable, null, (int)4, null);
        }
        return kType;
    }

    public static /* synthetic */ KType commonType$default(Iterable iterable, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return UtilsKt.commonType(iterable, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> List<DataColumn<C>> getColumnsImpl(@NotNull DataFrame<? extends T> $this$getColumnsImpl, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getColumnsImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Iterable $this$map$iv = UtilsKt.getColumnsWithPaths($this$getColumnsImpl, unresolvedColumnsPolicy, selector);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnWithPath columnWithPath = (ColumnWithPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getData());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final <T, C> List<ColumnWithPath<C>> getColumnsWithPaths(@NotNull DataFrame<? extends T> $this$getColumnsWithPaths, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        Intrinsics.checkNotNullParameter($this$getColumnsWithPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        return org.jetbrains.kotlinx.dataframe.impl.columns.UtilsKt.resolve(ConstructorsKt.toColumnSet(selector), $this$getColumnsWithPaths, unresolvedColumnsPolicy);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T, C> List<ColumnPath> getColumnPaths(@NotNull DataFrame<? extends T> $this$getColumnPaths, @NotNull UnresolvedColumnsPolicy unresolvedColumnsPolicy, @NotNull Function2<? super ColumnsSelectionDsl<? extends T>, ? super ColumnsSelectionDsl<? extends T>, ? extends ColumnsResolver<? extends C>> selector) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$getColumnPaths, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)unresolvedColumnsPolicy), (String)"unresolvedColumnsPolicy");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        Iterable $this$map$iv = UtilsKt.getColumnsWithPaths($this$getColumnPaths, unresolvedColumnsPolicy, selector);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ColumnWithPath columnWithPath = (ColumnWithPath)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPath());
        }
        return (List)destination$iv$iv;
    }

    public static final <C extends Comparable<? super C>> int indexOfMin(@NotNull Sequence<? extends C> $this$indexOfMin) {
        Intrinsics.checkNotNullParameter($this$indexOfMin, (String)"<this>");
        Iterator iterator2 = $this$indexOfMin.iterator();
        if (!iterator2.hasNext()) {
            return -1;
        }
        Comparable value = (Comparable)iterator2.next();
        int index = 0;
        while (value == null) {
            if (!iterator2.hasNext()) {
                return -1;
            }
            value = (Comparable)iterator2.next();
            ++index;
        }
        Comparable min = value;
        int minIndex = index;
        if (!iterator2.hasNext()) {
            return minIndex;
        }
        do {
            Comparable v = (Comparable)iterator2.next();
            ++index;
            if (v == null || min.compareTo(v) <= 0) continue;
            min = v;
            minIndex = index;
        } while (iterator2.hasNext());
        return minIndex;
    }

    public static final <C extends Comparable<? super C>> int indexOfMax(@NotNull Sequence<? extends C> $this$indexOfMax) {
        Intrinsics.checkNotNullParameter($this$indexOfMax, (String)"<this>");
        Iterator iterator2 = $this$indexOfMax.iterator();
        if (!iterator2.hasNext()) {
            return -1;
        }
        Comparable value = (Comparable)iterator2.next();
        int index = 0;
        while (value == null) {
            if (!iterator2.hasNext()) {
                return -1;
            }
            value = (Comparable)iterator2.next();
            ++index;
        }
        Comparable max = value;
        int maxIndex = index;
        if (!iterator2.hasNext()) {
            return maxIndex;
        }
        do {
            Comparable v = (Comparable)iterator2.next();
            ++index;
            if (v == null || max.compareTo(v) >= 0) continue;
            max = v;
            maxIndex = index;
        } while (iterator2.hasNext());
        return maxIndex;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final KType createStarProjectedType(@NotNull KClass<?> klass, boolean nullable) {
        Object object;
        Intrinsics.checkNotNullParameter(klass, (String)"klass");
        if (Intrinsics.areEqual(klass, (Object)Reflection.getOrCreateKotlinClass(Void.class))) {
            object = TypeUtilsKt.nothingType(nullable);
        } else {
            void var2_2;
            KType it = KClassifiers.getStarProjectedType((KClassifier)((KClassifier)klass));
            boolean bl = false;
            object = nullable ? KTypes.withNullability((KType)it, (boolean)true) : var2_2;
        }
        return object;
    }

    @JvmName(name="createStarProjectedTypeExt")
    @NotNull
    public static final KType createStarProjectedTypeExt(@NotNull KClass<?> $this$createStarProjectedType, boolean nullable) {
        Intrinsics.checkNotNullParameter($this$createStarProjectedType, (String)"<this>");
        return UtilsKt.createStarProjectedType($this$createStarProjectedType, nullable);
    }

    public static final boolean isSubtypeWithNullabilityOf(@NotNull KType $this$isSubtypeWithNullabilityOf, @NotNull KType type) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeWithNullabilityOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return KTypes.isSubtypeOf((KType)$this$isSubtypeWithNullabilityOf, (KType)type) && (!$this$isSubtypeWithNullabilityOf.isMarkedNullable() || type.isMarkedNullable());
    }

    @PublishedApi
    @NotNull
    public static final byte[] headPlusArray(byte head, @NotNull byte[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        byte[] byArray = new byte[]{head};
        return ArraysKt.plus((byte[])byArray, (byte[])cols);
    }

    @PublishedApi
    @NotNull
    public static final short[] headPlusArray(short head, @NotNull short[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        short[] sArray = new short[]{head};
        return ArraysKt.plus((short[])sArray, (short[])cols);
    }

    @PublishedApi
    @NotNull
    public static final int[] headPlusArray(int head, @NotNull int[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        int[] nArray = new int[]{head};
        return ArraysKt.plus((int[])nArray, (int[])cols);
    }

    @PublishedApi
    @NotNull
    public static final long[] headPlusArray(long head, @NotNull long[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        long[] lArray = new long[]{head};
        return ArraysKt.plus((long[])lArray, (long[])cols);
    }

    @PublishedApi
    @NotNull
    public static final float[] headPlusArray(float head, @NotNull float[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        float[] fArray = new float[]{head};
        return ArraysKt.plus((float[])fArray, (float[])cols);
    }

    @PublishedApi
    @NotNull
    public static final double[] headPlusArray(double head, @NotNull double[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        double[] dArray = new double[]{head};
        return ArraysKt.plus((double[])dArray, (double[])cols);
    }

    @PublishedApi
    @NotNull
    public static final boolean[] headPlusArray(boolean head, @NotNull boolean[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        boolean[] blArray = new boolean[]{head};
        return ArraysKt.plus((boolean[])blArray, (boolean[])cols);
    }

    @PublishedApi
    @NotNull
    public static final char[] headPlusArray(char head, @NotNull char[] cols) {
        Intrinsics.checkNotNullParameter((Object)cols, (String)"cols");
        char[] cArray = new char[]{head};
        return ArraysKt.plus((char[])cArray, (char[])cols);
    }

    @PublishedApi
    public static final /* synthetic */ <C> C[] headPlusArray(C head, C[] cols) {
        Intrinsics.checkNotNullParameter(cols, (String)"cols");
        boolean $i$f$headPlusArray = false;
        Collection $this$toTypedArray$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf(head), (Iterable)ArraysKt.toList((Object[])cols));
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Intrinsics.reifiedOperationMarker((int)0, (String)"C?");
        return thisCollection$iv.toArray(new Object[0]);
    }

    @PublishedApi
    public static final /* synthetic */ <C> Iterable<C> headPlusIterable(C head, Iterable<? extends C> cols) {
        Intrinsics.checkNotNullParameter(cols, (String)"cols");
        boolean $i$f$headPlusIterable = false;
        return CollectionsKt.plus((Collection)CollectionsKt.listOf(head), cols);
    }

    @NotNull
    public static final <T> Sequence<DataFrame<T>> splitByIndices(@NotNull DataFrame<? extends T> $this$splitByIndices, @NotNull Sequence<Integer> startIndices) {
        Intrinsics.checkNotNullParameter($this$splitByIndices, (String)"<this>");
        Intrinsics.checkNotNullParameter(startIndices, (String)"startIndices");
        return SequencesKt.zipWithNext((Sequence)SequencesKt.plus(startIndices, (Object)DataFrameKt.getNrow($this$splitByIndices)), (arg_0, arg_1) -> UtilsKt.splitByIndices$lambda$13($this$splitByIndices, arg_0, arg_1));
    }

    @NotNull
    public static final <T> Sequence<List<T>> splitByIndices(@NotNull List<? extends T> $this$splitByIndices, @NotNull Sequence<Integer> startIndices) {
        Intrinsics.checkNotNullParameter($this$splitByIndices, (String)"<this>");
        Intrinsics.checkNotNullParameter(startIndices, (String)"startIndices");
        return SequencesKt.zipWithNext((Sequence)SequencesKt.plus(startIndices, (Object)$this$splitByIndices.size()), (arg_0, arg_1) -> UtilsKt.splitByIndices$lambda$14($this$splitByIndices, arg_0, arg_1));
    }

    @Nullable
    public static final <T> T asNullable(T $this$asNullable) {
        return $this$asNullable;
    }

    @NotNull
    public static final <T> List<T> last(@NotNull List<? extends T> $this$last, int count) {
        Intrinsics.checkNotNullParameter($this$last, (String)"<this>");
        return $this$last.subList($this$last.size() - count, $this$last.size());
    }

    public static final <T extends Comparable<? super T>> boolean between(@NotNull T $this$between, @NotNull T left, @NotNull T right, boolean includeBoundaries) {
        Intrinsics.checkNotNullParameter($this$between, (String)"<this>");
        Intrinsics.checkNotNullParameter(left, (String)"left");
        Intrinsics.checkNotNullParameter(right, (String)"right");
        return includeBoundaries ? (0 <= $this$between.compareTo(left) ? $this$between.compareTo(right) <= 0 : false) : $this$between.compareTo(left) > 0 && $this$between.compareTo(right) < 0;
    }

    public static /* synthetic */ boolean between$default(Comparable comparable, Comparable comparable2, Comparable comparable3, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return UtilsKt.between(comparable, comparable2, comparable3, bl);
    }

    @NotNull
    public static final Regex getCAMEL_DEFAULT_DELIMITERS_REGEX() {
        return CAMEL_DEFAULT_DELIMITERS_REGEX;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toCamelCaseByDelimiters(@NotNull String $this$toCamelCaseByDelimiters, @NotNull Regex delimiters, @NotNull String numberSeparator) {
        String string;
        boolean bl;
        int $i$f$any;
        CharSequence $this$any$iv;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$toCamelCaseByDelimiters, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)delimiters, (String)"delimiters");
            Intrinsics.checkNotNullParameter((Object)numberSeparator, (String)"numberSeparator");
            $this$any$iv = $this$toCamelCaseByDelimiters;
            $i$f$any = 0;
            for (int i = 0; i < $this$any$iv.length(); ++i) {
                char element$iv;
                char it = element$iv = $this$any$iv.charAt(i);
                boolean bl2 = false;
                if (!(Character.isLetter(it) || Character.isDigit(it))) continue;
                bl = true;
                break block5;
            }
            bl = false;
        }
        if (!bl) {
            string = $this$toCamelCaseByDelimiters;
        } else {
            void $this$mapTo$iv$iv;
            String it;
            Iterable $this$filterTo$iv$iv;
            $this$any$iv = $this$toCamelCaseByDelimiters;
            $i$f$any = 0;
            Iterable $this$filter$iv = delimiters.split($this$any$iv, $i$f$any);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (String)element$iv$iv;
                boolean bl3 = false;
                boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl5 = false;
                String string2 = it.toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                collection.add(string2);
            }
            string = UtilsKt.joinToCamelCaseString(UtilsKt.joinNumbers((List)destination$iv$iv, numberSeparator));
        }
        return string;
    }

    public static /* synthetic */ String toCamelCaseByDelimiters$default(String string, Regex regex, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            regex = CAMEL_DEFAULT_DELIMITERS_REGEX;
        }
        if ((n & 2) != 0) {
            string2 = "_";
        }
        return UtilsKt.toCamelCaseByDelimiters(string, regex, string2);
    }

    private static final List<String> joinNumbers(List<String> $this$joinNumbers, CharSequence separator) {
        List result = new ArrayList();
        for (int i = 0; i < $this$joinNumbers.size(); ++i) {
            boolean bl;
            boolean bl2;
            String current;
            block5: {
                current = $this$joinNumbers.get(i);
                CharSequence $this$all$iv = current;
                boolean $i$f$all = false;
                for (int j = 0; j < $this$all$iv.length(); ++j) {
                    char element$iv;
                    char it = element$iv = $this$all$iv.charAt(j);
                    boolean bl3 = false;
                    if (Character.isDigit(it)) continue;
                    bl2 = false;
                    break block5;
                }
                bl2 = true;
            }
            if (bl2) {
                Object[] $i$f$all = new String[]{current};
                List numberGroup = CollectionsKt.mutableListOf((Object[])$i$f$all);
                while (i + 1 < $this$joinNumbers.size()) {
                    boolean bl4;
                    block6: {
                        CharSequence $this$all$iv = $this$joinNumbers.get(i + 1);
                        boolean $i$f$all2 = false;
                        for (int j = 0; j < $this$all$iv.length(); ++j) {
                            char element$iv;
                            char it = element$iv = $this$all$iv.charAt(j);
                            boolean bl5 = false;
                            if (Character.isDigit(it)) continue;
                            bl4 = false;
                            break block6;
                        }
                        bl4 = true;
                    }
                    if (!bl4) break;
                    numberGroup.add($this$joinNumbers.get(i + 1));
                    ++i;
                }
                bl = result.add(CollectionsKt.joinToString$default((Iterable)numberGroup, (CharSequence)separator, null, null, (int)0, null, null, (int)62, null));
                continue;
            }
            bl = result.add(current);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final String joinToCamelCaseString(List<String> $this$joinToCamelCaseString) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = $this$joinToCamelCaseString;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            String string;
            void word;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (index == false) {
                String string3 = word.toLowerCase(Locale.ROOT);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            } else {
                void var13_13 = word;
                if (((CharSequence)var13_13).length() > 0) {
                    char it = var13_13.charAt(0);
                    boolean bl2 = false;
                    char c = Character.toUpperCase(it);
                    String string4 = var13_13;
                    int n3 = 1;
                    String string5 = string4.substring(n3);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                    string4 = string5;
                    string = c + string4;
                } else {
                    string = var13_13;
                }
            }
            collection.add(string);
        }
        return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public static final Regex getCAMEL_LETTERS_REGEX() {
        return CAMEL_LETTERS_REGEX;
    }

    @NotNull
    public static final String toSnakeCase(@NotNull String $this$toSnakeCase) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toSnakeCase, (String)"<this>");
        if (new Regex("[A-Z_]+").matches((CharSequence)$this$toSnakeCase)) {
            string = $this$toSnakeCase;
        } else {
            String string2 = StringsKt.replace$default((String)CAMEL_LETTERS_REGEX.replace((CharSequence)$this$toSnakeCase, UtilsKt::toSnakeCase$lambda$22), (String)" ", (String)"_", (boolean)false, (int)4, null).toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        }
        return string;
    }

    public static final boolean isGetterLike(@NotNull KFunction<?> $this$isGetterLike) {
        Intrinsics.checkNotNullParameter($this$isGetterLike, (String)"<this>");
        return (StringsKt.startsWith$default((String)$this$isGetterLike.getName(), (String)"get", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)$this$isGetterLike.getName(), (String)"is", (boolean)false, (int)2, null)) && KCallables.getValueParameters((KCallable)((KCallable)$this$isGetterLike)).isEmpty() && $this$isGetterLike.getTypeParameters().isEmpty();
    }

    public static final boolean isGetterLike(@NotNull KProperty<?> $this$isGetterLike) {
        Intrinsics.checkNotNullParameter($this$isGetterLike, (String)"<this>");
        return true;
    }

    public static final boolean isGetterLike(@NotNull KCallable<?> $this$isGetterLike) {
        Intrinsics.checkNotNullParameter($this$isGetterLike, (String)"<this>");
        KCallable<?> kCallable = $this$isGetterLike;
        return kCallable instanceof KProperty ? UtilsKt.isGetterLike((KProperty)$this$isGetterLike) : (kCallable instanceof KFunction ? UtilsKt.isGetterLike((KFunction)$this$isGetterLike) : false);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getGetterName(@NotNull KFunction<?> $this$getterName) {
        String string;
        Intrinsics.checkNotNullParameter($this$getterName, (String)"<this>");
        String string2 = StringsKt.removePrefix((String)StringsKt.removePrefix((String)$this$getterName.getName(), (CharSequence)"get"), (CharSequence)"is");
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            String string3 = String.valueOf((char)it);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string2;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string2;
        }
        return string;
    }

    @NotNull
    public static final String getGetterName(@NotNull KProperty<?> $this$getterName) {
        Intrinsics.checkNotNullParameter($this$getterName, (String)"<this>");
        return $this$getterName.getName();
    }

    @NotNull
    public static final String getGetterName(@NotNull KCallable<?> $this$getterName) {
        Intrinsics.checkNotNullParameter($this$getterName, (String)"<this>");
        KCallable<?> kCallable = $this$getterName;
        return kCallable instanceof KFunction ? UtilsKt.getGetterName((KFunction)$this$getterName) : (kCallable instanceof KProperty ? UtilsKt.getGetterName((KProperty)$this$getterName) : $this$getterName.getName());
    }

    @NotNull
    public static final String getColumnName(@NotNull KFunction<?> $this$columnName) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter($this$columnName, (String)"<this>");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$columnName;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof ColumnName)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (ColumnName)((Annotation)v0)) == null || (object = object.name()) == null) {
            object = UtilsKt.getGetterName($this$columnName);
        }
        return object;
    }

    @PublishedApi
    public static /* synthetic */ void getColumnName$annotations(KFunction kFunction) {
    }

    @NotNull
    public static final String getColumnName(@NotNull KProperty<?> $this$columnName) {
        Object object;
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter($this$columnName, (String)"<this>");
            KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$columnName;
            boolean $i$f$findAnnotation = false;
            Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                Annotation it$iv = (Annotation)element$iv$iv;
                boolean bl = false;
                if (!(it$iv instanceof ColumnName)) continue;
                v0 = element$iv$iv;
                break block2;
            }
            v0 = null;
        }
        if ((object = (ColumnName)((Annotation)v0)) == null || (object = object.name()) == null) {
            object = UtilsKt.getGetterName($this$columnName);
        }
        return object;
    }

    @PublishedApi
    public static /* synthetic */ void getColumnName$annotations(KProperty kProperty) {
    }

    @NotNull
    public static final String getColumnName(@NotNull KCallable<?> $this$columnName) {
        Object object;
        Intrinsics.checkNotNullParameter($this$columnName, (String)"<this>");
        KCallable<?> kCallable = $this$columnName;
        if (kCallable instanceof KFunction) {
            object = UtilsKt.getColumnName((KFunction)$this$columnName);
        } else if (kCallable instanceof KProperty) {
            object = UtilsKt.getColumnName((KProperty)$this$columnName);
        } else {
            Object v1;
            block6: {
                KAnnotatedElement $this$findAnnotation$iv = (KAnnotatedElement)$this$columnName;
                boolean $i$f$findAnnotation = false;
                Iterable $this$firstOrNull$iv$iv = $this$findAnnotation$iv.getAnnotations();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv$iv : $this$firstOrNull$iv$iv) {
                    Annotation it$iv = (Annotation)element$iv$iv;
                    boolean bl = false;
                    if (!(it$iv instanceof ColumnName)) continue;
                    v1 = element$iv$iv;
                    break block6;
                }
                v1 = null;
            }
            if ((object = (ColumnName)((Annotation)v1)) == null || (object = object.name()) == null) {
                object = UtilsKt.getGetterName($this$columnName);
            }
        }
        return object;
    }

    @PublishedApi
    public static /* synthetic */ void getColumnName$annotations(KCallable kCallable) {
    }

    private static final boolean and$lambda$0(Function1 $this_and, Function1 $other, Object it) {
        return (Boolean)$this_and.invoke(it) != false && (Boolean)$other.invoke(it) != false;
    }

    private static final DataFrame splitByIndices$lambda$13(DataFrame $this_splitByIndices, int start, int endExclusive) {
        return start == endExclusive ? CastKt.cast(DataFrame.Companion.empty$default(DataFrame.Companion, 0, 1, null)) : $this_splitByIndices.get(RangesKt.until((int)start, (int)endExclusive));
    }

    private static final List splitByIndices$lambda$14(List $this_splitByIndices, int start, int endExclusive) {
        return $this_splitByIndices.subList(start, endExclusive);
    }

    private static final CharSequence toSnakeCase$lambda$22(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return '_' + it.getValue();
    }
}

