/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.ULong;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KType;
import kotlin.reflect.full.KClassifiers;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.columns.BaseColumnKt;
import org.jetbrains.kotlinx.dataframe.impl.NumberTypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.UnifiedNumberTypeOptions;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.Aggregator;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.AggregatorBase;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.AggregatorProvider;
import org.jetbrains.kotlinx.dataframe.impl.aggregation.aggregators.TwoStepNumbersAggregatorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\b\b\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001!B\u0093\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012<\u0010\u0006\u001a8\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\u0004\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\t\u0012\b\b\u0004\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007j\u0002`\r\u0012D\u0010\u000e\u001a@\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\u0004\u0012\u0004\b\b(\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0007j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u0000`\u0011\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J%\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0014\u0010\u0015\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00160\u000fH\u0016\u00a2\u0006\u0002\u0010\u0017J \u0010\u0018\u001a\u0004\u0018\u00010\b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u001a2\u0006\u0010\u001b\u001a\u00020\u000bH\u0016J%\u0010\u0014\u001a\u0004\u0018\u00018\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u0006\u0010\n\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\u001dJ-\u0010\u001e\u001a\u0004\u0018\u00018\u00002\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u001aH\u0016\u00a2\u0006\u0002\u0010 \u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/TwoStepNumbersAggregator;", "Return", "", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/AggregatorBase;", "name", "", "getReturnTypeOrNull", "Lkotlin/Function2;", "Lkotlin/reflect/KType;", "Lkotlin/ParameterName;", "type", "", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnTypeOrNull;", "aggregator", "", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/Aggregate;", "<init>", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "aggregate", "columns", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "(Ljava/lang/Iterable;)Ljava/lang/Number;", "calculateReturnTypeOrNull", "colTypes", "", "colsEmpty", "values", "(Ljava/lang/Iterable;Lkotlin/reflect/KType;)Ljava/lang/Number;", "aggregateCalculatingType", "valueTypes", "(Ljava/lang/Iterable;Ljava/util/Set;)Ljava/lang/Number;", "Factory", "core"})
@SourceDebugExtension(value={"SMAP\nTwoStepNumbersAggregator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TwoStepNumbersAggregator.kt\norg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/TwoStepNumbersAggregator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n1611#2,9:191\n1863#2:200\n1864#2:202\n1620#2:203\n1557#2:204\n1628#2,3:205\n1#3:201\n*S KotlinDebug\n*F\n+ 1 TwoStepNumbersAggregator.kt\norg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/TwoStepNumbersAggregator\n*L\n66#1:191,9\n66#1:200\n66#1:202\n66#1:203\n93#1:204\n93#1:205,3\n66#1:201\n*E\n"})
public final class TwoStepNumbersAggregator<Return extends Number>
extends AggregatorBase<Number, Return> {
    public TwoStepNumbersAggregator(@NotNull String name, @NotNull Function2<? super KType, ? super Boolean, ? extends KType> getReturnTypeOrNull, @NotNull Function2<? super Iterable<? extends Number>, ? super KType, ? extends Return> aggregator) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(getReturnTypeOrNull, (String)"getReturnTypeOrNull");
        Intrinsics.checkNotNullParameter(aggregator, (String)"aggregator");
        super(name, getReturnTypeOrNull, aggregator);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Return aggregate(@NotNull Iterable<? extends DataColumn<? extends Number>> columns2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(columns2, (String)"columns");
        Iterable<? extends DataColumn<? extends Number>> $this$mapNotNull$iv = columns2;
        boolean $i$f$mapNotNull = false;
        Iterable<? extends DataColumn<? extends Number>> iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair pair;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DataColumn col = (DataColumn)element$iv$iv;
            boolean bl2 = false;
            if ((Number)this.aggregate(col) == null) {
                pair = null;
            } else {
                Number value;
                KType kType = this.calculateReturnTypeOrNull(KTypes.withNullability((KType)col.type(), (boolean)false), BaseColumnKt.isEmpty(col));
                if (kType == null) {
                    kType = KClassifiers.getStarProjectedType((KClassifier)((KClassifier)Reflection.getOrCreateKotlinClass(value.getClass())));
                }
                KType type = kType;
                pair = TuplesKt.to((Object)value, (Object)type);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Pair pair = CollectionsKt.unzip((Iterable)((List)destination$iv$iv));
        List values = (List)pair.component1();
        List types = (List)pair.component2();
        return (Return)this.aggregateCalculatingType((Iterable)values, CollectionsKt.toSet((Iterable)types));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public KType calculateReturnTypeOrNull(@NotNull Set<? extends KType> colTypes, boolean colsEmpty) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(colTypes, (String)"colTypes");
        Iterable $this$map$iv = colTypes;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void type;
            KType kType = (KType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.calculateReturnTypeOrNull(KTypes.withNullability((KType)type, (boolean)false), colsEmpty));
        }
        List typesAfterStepOne = (List)destination$iv$iv;
        if (UtilsKt.anyNull(typesAfterStepOne)) {
            return null;
        }
        KType commonType = KTypes.withNullability((KType)NumberTypeUtilsKt.unifiedNumberType(CollectionsKt.toSet((Iterable)typesAfterStepOne), UnifiedNumberTypeOptions.Companion.getPRIMITIVES_ONLY()), (boolean)false);
        return commonType;
    }

    @Override
    @Nullable
    public Return aggregate(@NotNull Iterable<? extends Number> values, @NotNull KType type) {
        Number number;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!KTypes.isSubtypeOf((KType)type, (KType)Reflection.nullableTypeOf(Number.class))) {
            boolean bl = false;
            String string = Reflection.getOrCreateKotlinClass(TwoStepNumbersAggregator.class).getSimpleName() + ": Type " + type + " is not a subtype of Number?";
            throw new IllegalArgumentException(string.toString());
        }
        KType kType = KTypes.withNullability((KType)type, (boolean)false);
        if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Number.class))) {
            number = (Number)Aggregator.aggregateCalculatingType$default(this, values, null, 2, null);
        } else if (Intrinsics.areEqual((Object)kType, (Object)TypeUtilsKt.getNothingType())) {
            number = (Number)super.aggregate(values, type);
        } else {
            if (!NumberTypeUtilsKt.getPrimitiveNumberTypes().contains(kType)) {
                throw new IllegalArgumentException("Cannot calculate " + this.getName() + " of " + RenderingKt.renderType(type) + ", only primitive numbers are supported.");
            }
            number = (Number)super.aggregate(values, type);
        }
        return (Return)number;
    }

    @Override
    @Nullable
    public Return aggregateCalculatingType(@NotNull Iterable<? extends Number> values, @Nullable Set<? extends KType> valueTypes) {
        Set<? extends KType> valueTypes2;
        KType commonType;
        Intrinsics.checkNotNullParameter(values, (String)"values");
        Set<? extends KType> set = valueTypes;
        if (set == null) {
            set = TypeUtilsKt.types(values);
        }
        if (Intrinsics.areEqual((Object)(commonType = KTypes.withNullability((KType)NumberTypeUtilsKt.unifiedNumberType((Iterable<? extends KType>)(valueTypes2 = set), UnifiedNumberTypeOptions.Companion.getPRIMITIVES_ONLY()), (boolean)false)), (Object)Reflection.typeOf(Double.TYPE)) && (valueTypes2.contains(Reflection.typeOf(ULong.class)) || valueTypes2.contains(Reflection.typeOf(Long.TYPE)))) {
            TwoStepNumbersAggregatorKt.access$getLogger$p().warn(TwoStepNumbersAggregator::aggregateCalculatingType$lambda$3);
        }
        if (!NumberTypeUtilsKt.getPrimitiveNumberTypes().contains(commonType) && !Intrinsics.areEqual((Object)commonType, (Object)TypeUtilsKt.getNothingType())) {
            throw new IllegalArgumentException("Cannot calculate " + this.getName() + " of " + RenderingKt.renderType(commonType) + ", only primitive numbers are supported.");
        }
        return (Return)((Number)super.aggregate(NumberTypeUtilsKt.convertToUnifiedNumberType$default(values, null, commonType, 1, null), commonType));
    }

    private static final Object aggregateCalculatingType$lambda$3() {
        return "Number unification of Long -> Double happened during aggregation. Loss of precision may have occurred.";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\n\b\u0001\u0010\u0001 \u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003B\u008b\u0001\u0012<\u0010\u0005\u001a8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\r\u0012D\u0010\u000e\u001a@\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0006j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u0001`\u0011\u00a2\u0006\u0002\b\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u00042\u0006\u0010\t\u001a\u00020\u0015H\u0096\u0001RD\u0010\u0005\u001a8\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\f\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006j\u0002`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000RL\u0010\u000e\u001a@\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u000f\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\b\u0012\b\b\t\u0012\u0004\b\b(\n\u0012\u0006\u0012\u0004\u0018\u00018\u00010\u0006j\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00028\u0001`\u0011\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/TwoStepNumbersAggregator$Factory;", "Return", "", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/AggregatorProvider;", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/TwoStepNumbersAggregator;", "getReturnTypeOrNull", "Lkotlin/Function2;", "Lkotlin/reflect/KType;", "Lkotlin/ParameterName;", "name", "type", "", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnTypeOrNull;", "aggregate", "", "Lkotlin/ExtensionFunctionType;", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/Aggregate;", "<init>", "(Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function2;)V", "create", "", "core"})
    public static final class Factory<Return extends Number>
    implements AggregatorProvider<TwoStepNumbersAggregator<? extends Return>> {
        private final /* synthetic */ AggregatorProvider<TwoStepNumbersAggregator<Return>> $$delegate_0;
        @NotNull
        private final Function2<KType, Boolean, KType> getReturnTypeOrNull;
        @NotNull
        private final Function2<Iterable<? extends Number>, KType, Return> aggregate;

        public Factory(@NotNull Function2<? super KType, ? super Boolean, ? extends KType> getReturnTypeOrNull, @NotNull Function2<? super Iterable<? extends Number>, ? super KType, ? extends Return> aggregate) {
            Intrinsics.checkNotNullParameter(getReturnTypeOrNull, (String)"getReturnTypeOrNull");
            Intrinsics.checkNotNullParameter(aggregate, (String)"aggregate");
            this.$$delegate_0 = arg_0 -> Factory.__delegate_0$lambda$0(getReturnTypeOrNull, aggregate, arg_0);
            this.getReturnTypeOrNull = getReturnTypeOrNull;
            this.aggregate = aggregate;
        }

        @Override
        @NotNull
        public TwoStepNumbersAggregator<Return> create(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return (TwoStepNumbersAggregator)this.$$delegate_0.create(name);
        }

        private static final TwoStepNumbersAggregator __delegate_0$lambda$0(Function2 $getReturnTypeOrNull, Function2 $aggregate, String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new TwoStepNumbersAggregator(name, (Function2<? super KType, ? super Boolean, ? extends KType>)((Function2<KType, Boolean, KType>)((Function2<? super KType, ? super Boolean, ? extends KType>)$getReturnTypeOrNull)), $aggregate);
        }
    }
}

