package org.jetbrains.kotlinx.dataframe.plugin.impl.api

import org.jetbrains.kotlinx.dataframe.plugin.impl.*

class FillNulls0 : AbstractInterpreter<FillNullsApproximation>() {
    val Arguments.receiver: PluginDataFrameSchema by dataFrame()
    val Arguments.columns: ColumnsResolver by arg()

    override fun Arguments.interpret(): FillNullsApproximation {
        return FillNullsApproximation(receiver, columns)
    }
}

class FillNullsApproximation(val schema: PluginDataFrameSchema, val columns: ColumnsResolver) : UpdateApproximation

class UpdateWith0 : AbstractSchemaModificationInterpreter() {
    val Arguments.receiver: UpdateApproximation by arg()
    val Arguments.expression: TypeApproximation by type()

    override fun Arguments.interpret(): PluginDataFrameSchema {
        return when (val receiver = receiver) {
            is FillNullsApproximation -> convertImpl(
                receiver.schema,
                receiver.columns.resolve(receiver.schema).map { it.path.path },
                expression
            )
            is UpdateApproximationImpl -> convertImpl(
                receiver.schema,
                receiver.columns.resolve(receiver.schema).map { it.path.path },
                expression
            )
        }
    }
}
