/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KTypes;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.impl.NumberTypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.math.IndexedComparable;
import org.jetbrains.kotlinx.dataframe.math.QuantileEstimationMethod;
import org.jetbrains.kotlinx.dataframe.math.QuantileKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a<\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u001aA\u0010\u0013\u001a\u00020\u0014\"\u0012\b\u0000\u0010\u0002*\f\u0012\u0006\u0012\u0004\b\u0002H\u0002\u0018\u00010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0000\u00f8\u0001\u0000\"H\u0010\u000b\u001a6\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\r\u0012\b\b\u000e\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\b0\fj\u0002`\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0015"}, d2={"percentileOrNull", "", "T", "", "Lkotlin/sequences/Sequence;", "percentile", "", "type", "Lkotlin/reflect/KType;", "skipNaN", "", "percentileConversion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnType;", "getPercentileConversion", "()Lkotlin/jvm/functions/Function2;", "indexOfPercentile", "", "core"})
@SourceDebugExtension(value={"SMAP\npercentile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 percentile.kt\norg/jetbrains/kotlinx/dataframe/math/PercentileKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 Nulls.kt\norg/jetbrains/kotlinx/dataframe/api/NullsKt\n*L\n1#1,142:1\n209#2,4:143\n213#2,4:148\n107#3:147\n*S KotlinDebug\n*F\n+ 1 percentile.kt\norg/jetbrains/kotlinx/dataframe/math/PercentileKt\n*L\n131#1:143,4\n131#1:148,4\n131#1:147\n*E\n"})
public final class PercentileKt {
    @NotNull
    private static final Function2<KType, Boolean, KType> percentileConversion = PercentileKt::percentileConversion$lambda$1;

    @Nullable
    public static final <T extends Comparable<? super T>> Object percentileOrNull(@NotNull Sequence<? extends T> $this$percentileOrNull, double percentile, @NotNull KType type, boolean skipNaN) {
        Intrinsics.checkNotNullParameter($this$percentileOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (!(0.0 <= percentile ? percentile <= 100.0 : false)) {
            throw new IllegalStateException("Percentile must be in range [0, 100]".toString());
        }
        if (type.isMarkedNullable()) {
            throw new IllegalStateException(("Encountered nullable type " + RenderingKt.renderType(type) + " in percentile function. This should not occur.").toString());
        }
        if (Intrinsics.areEqual((Object)type, (Object)TypeUtilsKt.getNothingType())) {
            return null;
        }
        if (!TypeUtilsKt.isIntraComparable(type)) {
            throw new IllegalStateException(("Unable to compute the percentile for " + RenderingKt.renderType(type) + ". Only primitive numbers or self-comparables are supported.").toString());
        }
        if (Intrinsics.areEqual((Object)type, (Object)Reflection.typeOf(BigDecimal.class)) || Intrinsics.areEqual((Object)type, (Object)Reflection.typeOf(BigInteger.class))) {
            throw new IllegalArgumentException("Cannot calculate the percentile for big numbers in DataFrame. Only primitive numbers are supported.");
        }
        double p = percentile / 100.0;
        Pair pair = NumberTypeUtilsKt.isPrimitiveNumber(type) ? TuplesKt.to((Object)SequencesKt.map($this$percentileOrNull, PercentileKt::percentileOrNull$lambda$0), (Object)QuantileEstimationMethod.Interpolating.R8.INSTANCE) : TuplesKt.to($this$percentileOrNull, (Object)QuantileEstimationMethod.Selecting.R3.INSTANCE);
        Sequence values = (Sequence)pair.component1();
        QuantileEstimationMethod method = (QuantileEstimationMethod)pair.component2();
        return QuantileKt.quantileOrNull((Sequence<? extends Object>)values, p, type, skipNaN, method, "percentile");
    }

    @NotNull
    public static final Function2<KType, Boolean, KType> getPercentileConversion() {
        return percentileConversion;
    }

    public static final <T extends Comparable<? super T>> int indexOfPercentile(@NotNull Sequence<? extends T> $this$indexOfPercentile, double percentile, @NotNull KType type, boolean skipNaN) {
        Intrinsics.checkNotNullParameter($this$indexOfPercentile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KType nonNullType = KTypes.withNullability((KType)type, (boolean)false);
        if (!(0.0 <= percentile ? percentile <= 100.0 : false)) {
            throw new IllegalStateException("Percentile must be in range [0, 100]".toString());
        }
        if (Intrinsics.areEqual((Object)nonNullType, (Object)TypeUtilsKt.getNothingType())) {
            return -1;
        }
        if (!TypeUtilsKt.isIntraComparable(nonNullType)) {
            throw new IllegalStateException(("Unable to compute the percentile for " + RenderingKt.renderType(type) + ". Only primitive numbers or self-comparables are supported.").toString());
        }
        if (Intrinsics.areEqual((Object)nonNullType, (Object)Reflection.typeOf(BigDecimal.class)) || Intrinsics.areEqual((Object)nonNullType, (Object)Reflection.typeOf(BigInteger.class))) {
            throw new IllegalArgumentException("Cannot calculate the percentile for big numbers in DataFrame. Only primitive numbers are supported.");
        }
        Sequence indexedSequence = SequencesKt.mapIndexedNotNull($this$indexOfPercentile, PercentileKt::indexOfPercentile$lambda$2);
        QuantileEstimationMethod.Selecting.R3 method = QuantileEstimationMethod.Companion.getR3();
        double p = percentile / 100.0;
        double indexEstimation = QuantileKt.quantileIndexEstimation((Sequence<? extends Object>)indexedSequence, p, Reflection.typeOf(IndexedComparable.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.nothingType((KType)Reflection.typeOf(Void.class)))), skipNaN, method, "percentile");
        if (Double.isNaN(indexEstimation)) {
            int n;
            block10: {
                Sequence<? extends T> $this$indexOfFirst$iv = $this$indexOfPercentile;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Comparable it = (Comparable)item$iv;
                    boolean bl = false;
                    Comparable $this$isNaN$iv = it;
                    boolean $i$f$isNaN = false;
                    boolean bl2 = $this$isNaN$iv instanceof Double && Double.isNaN(((Number)((Object)$this$isNaN$iv)).doubleValue()) || $this$isNaN$iv instanceof Float && Float.isNaN(((Number)((Object)$this$isNaN$iv)).floatValue());
                    if (bl2) {
                        n = index$iv;
                        break block10;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }
        if (indexEstimation < 0.0) {
            return -1;
        }
        if (!(indexEstimation == Math.rint(indexEstimation))) {
            boolean bl = false;
            String string = "percentile expected a whole number index from quantileIndexEstimation but was " + indexEstimation;
            throw new IllegalArgumentException(string.toString());
        }
        IndexedComparable percentileResult = (IndexedComparable)QuantileKt.quickSelect(SequencesKt.toList((Sequence)indexedSequence), (int)indexEstimation);
        return percentileResult.getIndex();
    }

    private static final double percentileOrNull$lambda$0(Comparable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Number)((Object)it)).doubleValue();
    }

    private static final KType percentileConversion$lambda$1(KType type, boolean isEmpty) {
        KType kType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (NumberTypeUtilsKt.isPrimitiveNumber(type)) {
            kType = Reflection.typeOf(Double.TYPE);
        } else if (TypeUtilsKt.isIntraComparable(type)) {
            kType = type;
        } else {
            throw new IllegalStateException(("Can not calculate percentile for type " + RenderingKt.renderType(type)).toString());
        }
        return KTypes.withNullability((KType)kType, (boolean)isEmpty);
    }

    private static final IndexedComparable indexOfPercentile$lambda$2(int i, Comparable it) {
        return it == null ? null : new IndexedComparable<Comparable>(i, it);
    }
}

