/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.PublishedApi;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.full.KTypes;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.impl.NumberTypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.math.IndexedComparable;
import org.jetbrains.kotlinx.dataframe.math.QuantileEstimationMethod;
import org.jetbrains.kotlinx.dataframe.math.QuantileKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a4\u0010\u0000\u001a\u0004\u0018\u00010\u0001\"\u000e\b\u0000\u0010\u0002*\b\u0012\u0004\u0012\u0002H\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0001\u001a9\u0010\u0011\u001a\u00020\u0012\"\u0012\b\u0000\u0010\u0002*\f\u0012\u0006\u0012\u0004\b\u0002H\u0002\u0018\u00010\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00f8\u0001\u0000\"H\u0010\t\u001a6\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u0005\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0004\u0012\u00020\u00060\nj\u0002`\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0013"}, d2={"medianOrNull", "", "T", "", "Lkotlin/sequences/Sequence;", "type", "Lkotlin/reflect/KType;", "skipNaN", "", "medianConversion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnType;", "getMedianConversion", "()Lkotlin/jvm/functions/Function2;", "indexOfMedian", "", "core"})
@SourceDebugExtension(value={"SMAP\nmedian.kt\nKotlin\n*S Kotlin\n*F\n+ 1 median.kt\norg/jetbrains/kotlinx/dataframe/math/MedianKt\n+ 2 Nulls.kt\norg/jetbrains/kotlinx/dataframe/api/NullsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,155:1\n107#2:156\n107#2:161\n209#3,4:157\n213#3,4:162\n*S KotlinDebug\n*F\n+ 1 median.kt\norg/jetbrains/kotlinx/dataframe/math/MedianKt\n*L\n120#1:156\n144#1:161\n144#1:157,4\n144#1:162,4\n*E\n"})
public final class MedianKt {
    @NotNull
    private static final Function2<KType, Boolean, KType> medianConversion = MedianKt::medianConversion$lambda$1;

    @PublishedApi
    @Nullable
    public static final <T extends Comparable<? super T>> Object medianOrNull(@NotNull Sequence<? extends T> $this$medianOrNull, @NotNull KType type, boolean skipNaN) {
        Intrinsics.checkNotNullParameter($this$medianOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (type.isMarkedNullable()) {
            throw new IllegalStateException(("Encountered nullable type " + RenderingKt.renderType(type) + " in median function. This should not occur.").toString());
        }
        if (Intrinsics.areEqual((Object)type, (Object)TypeUtilsKt.getNothingType())) {
            return null;
        }
        if (!TypeUtilsKt.isIntraComparable(type)) {
            throw new IllegalStateException(("Unable to compute the median for " + RenderingKt.renderType(type) + ". Only primitive numbers or self-comparables are supported.").toString());
        }
        if (Intrinsics.areEqual((Object)type, (Object)Reflection.typeOf(BigDecimal.class)) || Intrinsics.areEqual((Object)type, (Object)Reflection.typeOf(BigInteger.class))) {
            throw new IllegalArgumentException("Cannot calculate the median for big numbers in DataFrame. Only primitive numbers are supported.");
        }
        double p = 0.5;
        Pair pair = NumberTypeUtilsKt.isPrimitiveNumber(type) ? TuplesKt.to((Object)SequencesKt.map($this$medianOrNull, MedianKt::medianOrNull$lambda$0), (Object)QuantileEstimationMethod.Interpolating.R8.INSTANCE) : TuplesKt.to($this$medianOrNull, (Object)QuantileEstimationMethod.Selecting.R3.INSTANCE);
        Sequence values = (Sequence)pair.component1();
        QuantileEstimationMethod method = (QuantileEstimationMethod)pair.component2();
        return QuantileKt.quantileOrNull((Sequence<? extends Object>)values, p, type, skipNaN, method, "median");
    }

    @NotNull
    public static final Function2<KType, Boolean, KType> getMedianConversion() {
        return medianConversion;
    }

    public static final <T extends Comparable<? super T>> int indexOfMedian(@NotNull Sequence<? extends T> $this$indexOfMedian, @NotNull KType type, boolean skipNaN) {
        Intrinsics.checkNotNullParameter($this$indexOfMedian, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KType nonNullType = KTypes.withNullability((KType)type, (boolean)false);
        if (Intrinsics.areEqual((Object)nonNullType, (Object)TypeUtilsKt.getNothingType())) {
            return -1;
        }
        if (!TypeUtilsKt.isIntraComparable(nonNullType)) {
            throw new IllegalStateException(("Unable to compute the median for " + RenderingKt.renderType(type) + ". Only primitive numbers or self-comparables are supported.").toString());
        }
        if (Intrinsics.areEqual((Object)nonNullType, (Object)Reflection.typeOf(BigDecimal.class)) || Intrinsics.areEqual((Object)nonNullType, (Object)Reflection.typeOf(BigInteger.class))) {
            throw new IllegalArgumentException("Cannot calculate the median for big numbers in DataFrame. Only primitive numbers are supported.");
        }
        if (TypeUtilsKt.getCanBeNaN(nonNullType) && !skipNaN) {
            Iterator iterator2 = $this$indexOfMedian.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                Comparable it;
                int i = n++;
                Comparable $this$isNaN$iv = it = (Comparable)iterator2.next();
                boolean $i$f$isNaN = false;
                if (!($this$isNaN$iv instanceof Double && Double.isNaN(((Number)((Object)$this$isNaN$iv)).doubleValue()) || $this$isNaN$iv instanceof Float && Float.isNaN(((Number)((Object)$this$isNaN$iv)).floatValue()))) continue;
                return i;
            }
        }
        Sequence indexedSequence = SequencesKt.mapIndexedNotNull($this$indexOfMedian, MedianKt::indexOfMedian$lambda$2);
        QuantileEstimationMethod.Selecting.R3 method = QuantileEstimationMethod.Companion.getR3();
        double p = 0.5;
        double indexEstimation = QuantileKt.quantileIndexEstimation((Sequence<? extends Object>)indexedSequence, p, Reflection.typeOf(IndexedComparable.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.nothingType((KType)Reflection.typeOf(Void.class)))), skipNaN, method, "median");
        if (Double.isNaN(indexEstimation)) {
            int n;
            block11: {
                Sequence<? extends T> $this$indexOfFirst$iv = $this$indexOfMedian;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                for (Object item$iv : $this$indexOfFirst$iv) {
                    if (index$iv < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Comparable it = (Comparable)item$iv;
                    boolean bl = false;
                    Comparable $this$isNaN$iv = it;
                    boolean $i$f$isNaN = false;
                    boolean bl2 = $this$isNaN$iv instanceof Double && Double.isNaN(((Number)((Object)$this$isNaN$iv)).doubleValue()) || $this$isNaN$iv instanceof Float && Float.isNaN(((Number)((Object)$this$isNaN$iv)).floatValue());
                    if (bl2) {
                        n = index$iv;
                        break block11;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            return n;
        }
        if (indexEstimation < 0.0) {
            return -1;
        }
        if (!(indexEstimation == Math.rint(indexEstimation))) {
            boolean bl = false;
            String string = "median expected a whole number index from quantileIndexEstimation but was " + indexEstimation;
            throw new IllegalArgumentException(string.toString());
        }
        IndexedComparable medianResult = (IndexedComparable)QuantileKt.quickSelect(SequencesKt.toList((Sequence)indexedSequence), (int)indexEstimation);
        return medianResult.getIndex();
    }

    private static final double medianOrNull$lambda$0(Comparable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Number)((Object)it)).doubleValue();
    }

    private static final KType medianConversion$lambda$1(KType type, boolean isEmpty) {
        KType kType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (NumberTypeUtilsKt.isPrimitiveNumber(type)) {
            kType = Reflection.typeOf(Double.TYPE);
        } else if (TypeUtilsKt.isIntraComparable(type)) {
            kType = type;
        } else {
            throw new IllegalStateException(("Can not calculate median for type " + RenderingKt.renderType(type)).toString());
        }
        return KTypes.withNullability((KType)kType, (boolean)isEmpty);
    }

    private static final IndexedComparable indexOfMedian$lambda$2(int i, Comparable it) {
        return it == null ? null : new IndexedComparable<Comparable>(i, it);
    }
}

