/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.full.KTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlinx.dataframe.DataColumn;
import org.jetbrains.kotlinx.dataframe.DataFrame;
import org.jetbrains.kotlinx.dataframe.DataRow;
import org.jetbrains.kotlinx.dataframe.api.AllKt;
import org.jetbrains.kotlinx.dataframe.api.AsIterableKt;
import org.jetbrains.kotlinx.dataframe.api.CastKt;
import org.jetbrains.kotlinx.dataframe.api.Infer;
import org.jetbrains.kotlinx.dataframe.api.IsEmptyKt;
import org.jetbrains.kotlinx.dataframe.impl.NumberTypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.RenderingKt;
import org.jetbrains.kotlinx.dataframe.impl.TypeUtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.UnifiedNumberTypeOptions;
import org.jetbrains.kotlinx.dataframe.impl.UtilsKt;
import org.jetbrains.kotlinx.dataframe.impl.columns.DataColumnInternalKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0004\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a,\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a%\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\b\u0012\u0004\u0012\u00020\u00070\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\b\u001a'\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00070\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\t\u001a%\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\n0\u0001*\b\u0012\u0004\u0012\u00020\n0\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u000b\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\n0\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u001d\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\b\u0012\u0004\u0012\u00020\f0\u0001H\u0001\u00a2\u0006\u0002\b\r\u001a)\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\r\u001a\u001d\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\b\u0012\u0004\u0012\u00020\u000e0\u0001H\u0001\u00a2\u0006\u0002\b\u000f\u001a)\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0010\u001a\u001d\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\f0\u0001*\b\u0012\u0004\u0012\u00020\u00110\u0001H\u0001\u00a2\u0006\u0002\b\u0012\u001a)\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0013\u001a\u001d\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00140\u0001*\b\u0012\u0004\u0012\u00020\u00140\u0001H\u0001\u00a2\u0006\u0002\b\u0015\u001a)\u0010\u0000\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0001*\n\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0001\u00a2\u0006\u0002\b\u0016\"E\u0010\u0017\u001a6\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b\u0019\u0012\b\b\u001a\u0012\u0004\b\b(\u001b\u0012\u0004\u0012\u00020\u00040\u0018j\u0002`\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"cumSumImpl", "Lorg/jetbrains/kotlinx/dataframe/DataColumn;", "", "type", "Lkotlin/reflect/KType;", "skipNA", "", "", "doubleCumsum", "cumsumDoubleNullable", "", "floatCumsum", "", "intCumsum", "", "byteCumsum", "cumsumByteNullable", "", "shortCumsum", "cumsumShortNullable", "", "longCumsum", "cumsumLongNullable", "cumSumTypeConversion", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "emptyInput", "Lorg/jetbrains/kotlinx/dataframe/impl/aggregation/aggregators/CalculateReturnType;", "getCumSumTypeConversion", "()Lkotlin/jvm/functions/Function2;", "core"})
@SourceDebugExtension(value={"SMAP\ncumsum.kt\nKotlin\n*S Kotlin\n*F\n+ 1 cumsum.kt\norg/jetbrains/kotlinx/dataframe/math/CumsumKt\n+ 2 typeConversions.kt\norg/jetbrains/kotlinx/dataframe/api/TypeConversionsKt\n+ 3 map.kt\norg/jetbrains/kotlinx/dataframe/api/MapKt\n+ 4 Nulls.kt\norg/jetbrains/kotlinx/dataframe/api/NullsKt\n*L\n1#1,312:1\n327#2,6:313\n38#3,3:319\n38#3,2:322\n40#3:341\n38#3,3:342\n38#3,2:345\n40#3:364\n38#3,3:365\n38#3,3:368\n38#3,3:371\n38#3,3:374\n38#3,3:377\n38#3,3:380\n38#3,3:383\n38#3,3:386\n122#4,17:324\n122#4,17:347\n*S KotlinDebug\n*F\n+ 1 cumsum.kt\norg/jetbrains/kotlinx/dataframe/math/CumsumKt\n*L\n75#1:313,6\n89#1:319,3\n110#1:322,2\n110#1:341\n131#1:342,3\n151#1:345,2\n151#1:364\n171#1:365,3\n181#1:368,3\n201#1:371,3\n211#1:374,3\n231#1:377,3\n241#1:380,3\n261#1:383,3\n271#1:386,3\n112#1:324,17\n153#1:347,17\n*E\n"})
public final class CumsumKt {
    @NotNull
    private static final Function2<KType, Boolean, KType> cumSumTypeConversion = CumsumKt::cumSumTypeConversion$lambda$13;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataColumn<Number> cumSumImpl(@NotNull DataColumn<? extends Number> $this$cumSumImpl, @NotNull KType type, boolean skipNA) {
        DataColumn<Number> dataColumn;
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KType kType = type;
        if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Double.TYPE))) {
            dataColumn = CumsumKt.doubleCumsum(CastKt.cast($this$cumSumImpl), skipNA);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(Double.class))) {
            dataColumn = CumsumKt.cumsumDoubleNullable(CastKt.cast($this$cumSumImpl), skipNA);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Float.TYPE))) {
            dataColumn = CumsumKt.floatCumsum(CastKt.cast($this$cumSumImpl), skipNA);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(Float.class))) {
            dataColumn = CumsumKt.cumSumImpl(CastKt.cast($this$cumSumImpl), skipNA);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Integer.TYPE))) {
            dataColumn = CumsumKt.intCumsum(CastKt.cast($this$cumSumImpl));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Byte.TYPE))) {
            dataColumn = CumsumKt.byteCumsum(CastKt.cast($this$cumSumImpl));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Short.TYPE))) {
            dataColumn = CumsumKt.shortCumsum(CastKt.cast($this$cumSumImpl));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(Integer.class))) {
            dataColumn = CumsumKt.intCumsum(CastKt.cast($this$cumSumImpl), skipNA);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(Byte.class))) {
            dataColumn = CumsumKt.cumsumByteNullable(CastKt.cast($this$cumSumImpl), skipNA);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(Short.class))) {
            dataColumn = CumsumKt.cumsumShortNullable(CastKt.cast($this$cumSumImpl), skipNA);
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Long.TYPE))) {
            dataColumn = CumsumKt.longCumsum(CastKt.cast($this$cumSumImpl));
        } else if (Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(Long.class))) {
            dataColumn = CumsumKt.cumsumLongNullable(CastKt.cast($this$cumSumImpl), skipNA);
        } else {
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigInteger.class)) || Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(BigInteger.class)) || Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(BigDecimal.class)) || Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(BigDecimal.class))) {
                throw new IllegalArgumentException("Cannot calculate the cumSum for big numbers in DataFrame. Only primitive numbers are supported.");
            }
            if (Intrinsics.areEqual((Object)kType, (Object)Reflection.nullableTypeOf(Number.class)) || Intrinsics.areEqual((Object)kType, (Object)Reflection.typeOf(Number.class))) {
                void $this$toColumn_u24default$iv;
                Set types = CollectionsKt.toSet((Iterable)TypeUtilsKt.types(AsIterableKt.asIterable($this$cumSumImpl)));
                KType kType2 = NumberTypeUtilsKt.unifiedNumberTypeOrNull(types, UnifiedNumberTypeOptions.Companion.getPRIMITIVES_ONLY());
                if (kType2 == null) {
                    throw new IllegalStateException(("Couldn't unify the numbers of types " + CollectionsKt.joinToString$default((Iterable)types, null, null, null, (int)0, null, CumsumKt::cumSumImpl$lambda$0, (int)31, null) + " of column " + $this$cumSumImpl.name() + " in cumSum. Please manually convert the numbers in column " + $this$cumSumImpl.name() + " to the same primitive number type before using cumSum.").toString());
                }
                KType unifiedType = kType2;
                Iterable<Number> iterable = NumberTypeUtilsKt.convertNullableIterableToUnifiedNumberType(AsIterableKt.asIterable($this$cumSumImpl), UnifiedNumberTypeOptions.Companion.getPRIMITIVES_ONLY(), unifiedType);
                String name$iv = $this$cumSumImpl.name();
                Infer infer$iv = Infer.Nulls;
                boolean $i$f$toColumn = false;
                dataColumn = CumsumKt.cumSumImpl(DataColumnInternalKt.forceResolve(infer$iv == Infer.Type ? DataColumn.Companion.createByInference$default(DataColumn.Companion, name$iv, UtilsKt.asList($this$toColumn_u24default$iv), null, null, 12, null) : DataColumn.Companion.createByType(name$iv, UtilsKt.asList($this$toColumn_u24default$iv), Reflection.nullableTypeOf(Number.class), infer$iv)), unifiedType, skipNA);
            } else if (Intrinsics.areEqual((Object)kType, (Object)TypeUtilsKt.getNothingType()) || Intrinsics.areEqual((Object)kType, (Object)TypeUtilsKt.getNullableNothingType())) {
                dataColumn = $this$cumSumImpl;
            } else {
                throw new IllegalStateException(("CumSum for type " + $this$cumSumImpl.type() + " is not supported").toString());
            }
        }
        return dataColumn;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="doubleCumsum")
    @NotNull
    public static final DataColumn<Double> doubleCumsum(@NotNull DataColumn<Double> $this$cumSumImpl, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        double sum = 0.0;
        boolean fillNaN = false;
        DataColumn<Double> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = $this$map_u24default$iv.size();
        Object[] objectArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            void it;
            int n2 = i;
            double d2 = ((Number)$this$map_u24default$iv.get(n2)).doubleValue();
            int n3 = n2;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            if (Double.isNaN((double)it)) {
                if (!skipNA) {
                    fillNaN = true;
                }
                d = Double.NaN;
            } else {
                d = fillNaN ? Double.NaN : (sum += it);
            }
            Double d3 = d;
            objectArray2[n3] = d3;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.typeOf(Double.TYPE), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cumsumDoubleNullable")
    @NotNull
    public static final DataColumn<Double> cumsumDoubleNullable(@NotNull DataColumn<Double> $this$cumSumImpl, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        double sum = 0.0;
        boolean fillNaN = false;
        DataColumn<Double> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = $this$map_u24default$iv.size();
        Object[] objectArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            double d;
            void it;
            int n2 = i;
            Double d2 = (Double)$this$map_u24default$iv.get(n2);
            int n3 = n2;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            void $this$isNA$iv = it;
            boolean $i$f$isNaWithContract = false;
            void $this$isNA$iv$iv = $this$isNA$iv;
            boolean $i$f$isNA = false;
            void var16_17 = $this$isNA$iv$iv;
            boolean bl2 = var16_17 == null ? true : (var16_17 instanceof Double ? Double.isNaN(((Number)$this$isNA$iv$iv).doubleValue()) : (var16_17 instanceof Float ? Float.isNaN(((Number)$this$isNA$iv$iv).floatValue()) : (var16_17 instanceof DataRow ? AllKt.allNA((DataRow)$this$isNA$iv$iv) : (var16_17 instanceof DataFrame ? IsEmptyKt.isEmpty((DataFrame)$this$isNA$iv$iv) : false))));
            if (bl2) {
                if (!skipNA) {
                    fillNaN = true;
                }
                d = Double.NaN;
            } else {
                d = fillNaN ? Double.NaN : (sum += it.doubleValue());
            }
            Double d3 = d;
            objectArray2[n3] = d3;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.typeOf(Double.TYPE), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="floatCumsum")
    @NotNull
    public static final DataColumn<Float> floatCumsum(@NotNull DataColumn<Float> $this$cumSumImpl, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        float sum = 0.0f;
        boolean fillNaN = false;
        DataColumn<Float> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = $this$map_u24default$iv.size();
        Object[] objectArray = new Float[n];
        for (int i = 0; i < n; ++i) {
            float f;
            void it;
            int n2 = i;
            float f2 = ((Number)$this$map_u24default$iv.get(n2)).floatValue();
            int n3 = n2;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            if (Float.isNaN((float)it)) {
                if (!skipNA) {
                    fillNaN = true;
                }
                f = Float.NaN;
            } else {
                f = fillNaN ? Float.NaN : (sum += it);
            }
            Float f3 = Float.valueOf(f);
            objectArray2[n3] = f3;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.typeOf(Float.TYPE), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final DataColumn<Float> cumSumImpl(@NotNull DataColumn<Float> $this$cumSumImpl, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        float sum = 0.0f;
        boolean fillNaN = false;
        DataColumn<Float> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = $this$map_u24default$iv.size();
        Object[] objectArray = new Float[n];
        for (int i = 0; i < n; ++i) {
            float f;
            void it;
            int n2 = i;
            Float f2 = (Float)$this$map_u24default$iv.get(n2);
            int n3 = n2;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            void $this$isNA$iv = it;
            boolean $i$f$isNaWithContract = false;
            void $this$isNA$iv$iv = $this$isNA$iv;
            boolean $i$f$isNA = false;
            void var17_17 = $this$isNA$iv$iv;
            boolean bl2 = var17_17 == null ? true : (var17_17 instanceof Double ? Double.isNaN(((Number)$this$isNA$iv$iv).doubleValue()) : (var17_17 instanceof Float ? Float.isNaN(((Number)$this$isNA$iv$iv).floatValue()) : (var17_17 instanceof DataRow ? AllKt.allNA((DataRow)$this$isNA$iv$iv) : (var17_17 instanceof DataFrame ? IsEmptyKt.isEmpty((DataFrame)$this$isNA$iv$iv) : false))));
            if (bl2) {
                if (!skipNA) {
                    fillNaN = true;
                }
                f = Float.NaN;
            } else {
                f = fillNaN ? Float.NaN : (sum += it.floatValue());
            }
            Float f3 = Float.valueOf(f);
            objectArray2[n3] = f3;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.typeOf(Float.TYPE), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="intCumsum")
    @NotNull
    public static final DataColumn<Integer> intCumsum(@NotNull DataColumn<Integer> $this$cumSumImpl) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        int sum = 0;
        DataColumn<Integer> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = 0;
        int n2 = $this$map_u24default$iv.size();
        Object[] objectArray = new Integer[n2];
        while (n < n2) {
            void it;
            int n3 = n++;
            int n4 = ((Number)$this$map_u24default$iv.get(n3)).intValue();
            int n5 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            Integer n6 = sum += it;
            objectArray2[n5] = n6;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.typeOf(Integer.TYPE), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="intCumsum")
    @NotNull
    public static final DataColumn<Integer> intCumsum(@NotNull DataColumn<Integer> $this$cumSumImpl, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        int sum = 0;
        boolean fillNull = false;
        DataColumn<Integer> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = $this$map_u24default$iv.size();
        Object[] objectArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            Integer n2;
            void it;
            int n3 = i;
            Integer n4 = (Integer)$this$map_u24default$iv.get(n3);
            int n5 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            if (it == null) {
                if (!skipNA) {
                    fillNull = true;
                }
                n2 = null;
            } else {
                n2 = fillNull ? null : Integer.valueOf(sum += it.intValue());
            }
            Integer n6 = n2;
            objectArray2[n5] = n6;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(Integer.class), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="byteCumsum")
    @NotNull
    public static final DataColumn<Integer> byteCumsum(@NotNull DataColumn<Byte> $this$cumSumImpl) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        int sum = 0;
        DataColumn<Byte> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = 0;
        int n2 = $this$map_u24default$iv.size();
        Object[] objectArray = new Integer[n2];
        while (n < n2) {
            void it;
            int n3 = n++;
            byte by2 = ((Number)$this$map_u24default$iv.get(n3)).byteValue();
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            Integer n5 = sum += it;
            objectArray2[n4] = n5;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.typeOf(Integer.TYPE), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cumsumByteNullable")
    @NotNull
    public static final DataColumn<Integer> cumsumByteNullable(@NotNull DataColumn<Byte> $this$cumSumImpl, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        int sum = 0;
        boolean fillNull = false;
        DataColumn<Byte> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = $this$map_u24default$iv.size();
        Object[] objectArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            Integer n2;
            void it;
            int n3 = i;
            Byte by2 = (Byte)$this$map_u24default$iv.get(n3);
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            if (it == null) {
                if (!skipNA) {
                    fillNull = true;
                }
                n2 = null;
            } else {
                n2 = fillNull ? null : Integer.valueOf(sum += it.byteValue());
            }
            Integer n5 = n2;
            objectArray2[n4] = n5;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(Integer.class), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="shortCumsum")
    @NotNull
    public static final DataColumn<Integer> shortCumsum(@NotNull DataColumn<Short> $this$cumSumImpl) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        int sum = 0;
        DataColumn<Short> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = 0;
        int n2 = $this$map_u24default$iv.size();
        Object[] objectArray = new Integer[n2];
        while (n < n2) {
            void it;
            int n3 = n++;
            short s = ((Number)$this$map_u24default$iv.get(n3)).shortValue();
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            Integer n5 = sum += it;
            objectArray2[n4] = n5;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.typeOf(Integer.TYPE), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cumsumShortNullable")
    @NotNull
    public static final DataColumn<Integer> cumsumShortNullable(@NotNull DataColumn<Short> $this$cumSumImpl, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        int sum = 0;
        boolean fillNull = false;
        DataColumn<Short> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = $this$map_u24default$iv.size();
        Object[] objectArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            Integer n2;
            void it;
            int n3 = i;
            Short s = (Short)$this$map_u24default$iv.get(n3);
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            if (it == null) {
                if (!skipNA) {
                    fillNull = true;
                }
                n2 = null;
            } else {
                n2 = fillNull ? null : Integer.valueOf(sum += it.shortValue());
            }
            Integer n5 = n2;
            objectArray2[n4] = n5;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(Integer.class), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="longCumsum")
    @NotNull
    public static final DataColumn<Long> longCumsum(@NotNull DataColumn<Long> $this$cumSumImpl) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        long sum = 0L;
        DataColumn<Long> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = 0;
        int n2 = $this$map_u24default$iv.size();
        Object[] objectArray = new Long[n2];
        while (n < n2) {
            void it;
            int n3 = n++;
            long l = ((Number)$this$map_u24default$iv.get(n3)).longValue();
            int n4 = n3;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            Long l2 = sum += it;
            objectArray2[n4] = l2;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.typeOf(Long.TYPE), infer$iv);
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cumsumLongNullable")
    @NotNull
    public static final DataColumn<Long> cumsumLongNullable(@NotNull DataColumn<Long> $this$cumSumImpl, boolean skipNA) {
        Intrinsics.checkNotNullParameter($this$cumSumImpl, (String)"<this>");
        long sum = 0L;
        boolean fillNull = false;
        DataColumn<Long> $this$map_u24default$iv = $this$cumSumImpl;
        Infer infer$iv = Infer.Nulls;
        boolean $i$f$map = false;
        int n = $this$map_u24default$iv.size();
        Object[] objectArray = new Long[n];
        for (int i = 0; i < n; ++i) {
            Long l;
            void it;
            int n2 = i;
            Long l2 = (Long)$this$map_u24default$iv.get(n2);
            int n3 = n2;
            Object[] objectArray2 = objectArray;
            boolean bl = false;
            if (it == null) {
                if (!skipNA) {
                    fillNull = true;
                }
                l = null;
            } else {
                l = fillNull ? null : Long.valueOf(sum += it.longValue());
            }
            Long l3 = l;
            objectArray2[n3] = l3;
        }
        List newValues$iv = ArraysKt.asList((Object[])objectArray);
        return DataColumn.Companion.createByType($this$map_u24default$iv.name(), newValues$iv, Reflection.nullableTypeOf(Long.class), infer$iv);
    }

    @NotNull
    public static final Function2<KType, Boolean, KType> getCumSumTypeConversion() {
        return cumSumTypeConversion;
    }

    private static final CharSequence cumSumImpl$lambda$0(KType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RenderingKt.renderType(it);
    }

    private static final KType cumSumTypeConversion$lambda$13(KType type, boolean bl) {
        KType kType;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        KType type2 = KTypes.withNullability((KType)type, (boolean)false);
        if (Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Short.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Byte.TYPE))) {
            kType = KTypes.withNullability((KType)Reflection.typeOf(Integer.TYPE), (boolean)type2.isMarkedNullable());
        } else if (Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Integer.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Long.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Number.class))) {
            kType = type2;
        } else if (Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Double.TYPE)) || Intrinsics.areEqual((Object)type2, (Object)Reflection.typeOf(Float.TYPE))) {
            kType = KTypes.withNullability((KType)type2, (boolean)false);
        } else if (Intrinsics.areEqual((Object)type2, (Object)TypeUtilsKt.getNothingType())) {
            kType = type2;
        } else {
            throw new IllegalStateException(("Unable to compute the cumSum for " + RenderingKt.renderType(type2) + ", Only primitive numbers are supported.").toString());
        }
        return kType;
    }
}

