/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeConfiguration;
import androidx.compose.compiler.plugins.kotlin.ComposeIrGenerationExtension;
import androidx.compose.compiler.plugins.kotlin.FeatureFlag;
import androidx.compose.compiler.plugins.kotlin.FeatureFlags;
import androidx.compose.compiler.plugins.kotlin.ModuleMetrics;
import androidx.compose.compiler.plugins.kotlin.analysis.FqNameMatcher;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityConfigParser;
import androidx.compose.compiler.plugins.kotlin.analysis.StabilityInferencer;
import androidx.compose.compiler.plugins.kotlin.k1.ComposableCallChecker;
import androidx.compose.compiler.plugins.kotlin.k1.ComposableDeclarationChecker;
import androidx.compose.compiler.plugins.kotlin.k1.ComposableTargetChecker;
import androidx.compose.compiler.plugins.kotlin.k1.ComposeDescriptorSerializerContext;
import androidx.compose.compiler.plugins.kotlin.k1.ComposeDiagnosticSuppressor;
import androidx.compose.compiler.plugins.kotlin.k1.ComposeTypeResolutionInterceptorExtension;
import androidx.compose.compiler.plugins.kotlin.k2.ComposeFirExtensionRegistrar;
import androidx.compose.compiler.plugins.kotlin.lower.ClassStabilityFieldSerializationPlugin;
import androidx.compose.compiler.plugins.kotlin.lower.hiddenfromobjc.AddHiddenFromObjCSerializationPlugin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.com.intellij.mock.MockProject;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.compiler.plugin.ComponentRegistrar;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.IrVerificationMode;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.extensions.internal.TypeResolutionInterceptor;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrarAdapter;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;
import org.jetbrains.kotlin.serialization.DescriptorSerializerPlugin;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposePluginRegistrar;", "Lorg/jetbrains/kotlin/compiler/plugin/ComponentRegistrar;", "<init>", "()V", "supportsK2", "", "getSupportsK2", "()Z", "registerProjectComponents", "", "project", "Lorg/jetbrains/kotlin/com/intellij/mock/MockProject;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "compiler-hosted"})
public final class ComposePluginRegistrar
implements ComponentRegistrar {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean getSupportsK2() {
        return true;
    }

    public void registerProjectComponents(@NotNull MockProject project, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        if (Companion.checkCompilerVersion(configuration)) {
            boolean usesK2 = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)configuration).getLanguageVersion().getUsesK2();
            ComposeDescriptorSerializerContext descriptorSerializerContext = usesK2 ? null : new ComposeDescriptorSerializerContext(null, null, 3, null);
            Companion.registerCommonExtensions((Project)project, descriptorSerializerContext);
            IrGenerationExtension.Companion.registerExtension((Project)project, (Object)androidx.compose.compiler.plugins.kotlin.ComposePluginRegistrar$Companion.createComposeIrExtension$default(Companion, configuration, descriptorSerializerContext, null, 4, null));
            if (!usesK2) {
                Project project2 = (Project)project;
                ComposeDescriptorSerializerContext composeDescriptorSerializerContext = descriptorSerializerContext;
                Intrinsics.checkNotNull((Object)composeDescriptorSerializerContext);
                Companion.registerNativeExtensions(project2, composeDescriptorSerializerContext);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\rJ\u0016\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ2\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0016\b\u0002\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0013\u00a8\u0006\u0016"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposePluginRegistrar$Companion;", "", "<init>", "()V", "checkCompilerVersion", "", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "registerCommonExtensions", "", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "composeDescriptorSerializerContext", "Landroidx/compose/compiler/plugins/kotlin/k1/ComposeDescriptorSerializerContext;", "registerNativeExtensions", "createComposeIrExtension", "Landroidx/compose/compiler/plugins/kotlin/ComposeIrGenerationExtension;", "descriptorSerializerContext", "moduleMetricsFactory", "Lkotlin/Function1;", "Landroidx/compose/compiler/plugins/kotlin/analysis/StabilityInferencer;", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;", "compiler-hosted"})
    @SourceDebugExtension(value={"SMAP\nComposePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposePlugin.kt\nandroidx/compose/compiler/plugins/kotlin/ComposePluginRegistrar$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,741:1\n1#2:742\n1557#3:743\n1628#3,3:744\n*S KotlinDebug\n*F\n+ 1 ComposePlugin.kt\nandroidx/compose/compiler/plugins/kotlin/ComposePluginRegistrar$Companion\n*L\n716#1:743\n716#1:744,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean checkCompilerVersion(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            MessageCollector msgCollector = CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration);
            String suppressKotlinVersionCheck = (String)configuration.get(ComposeConfiguration.INSTANCE.getSUPPRESS_KOTLIN_VERSION_COMPATIBILITY_CHECK());
            if (suppressKotlinVersionCheck != null) {
                MessageCollector.report$default((MessageCollector)msgCollector, (CompilerMessageSeverity)CompilerMessageSeverity.WARNING, (String)"suppressKotlinVersionCompatibilityCheck flag is deprecated for Compose compiler bundled with Kotlin releases.", null, (int)4, null);
            }
            Object object = configuration.get(ComposeConfiguration.INSTANCE.getDECOYS_ENABLED_KEY(), (Object)false);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            boolean decoysEnabled = (Boolean)object;
            if (decoysEnabled) {
                MessageCollector.report$default((MessageCollector)msgCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)"Decoys generation should be disabled for Compose Multiplatform projects", null, (int)4, null);
                return false;
            }
            return true;
        }

        public final void registerCommonExtensions(@NotNull Project project, @Nullable ComposeDescriptorSerializerContext composeDescriptorSerializerContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableCallChecker());
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableDeclarationChecker());
            StorageComponentContainerContributor.Companion.registerExtension(project, (Object)new ComposableTargetChecker());
            DiagnosticSuppressor.Companion.registerExtension(project, (Object)new ComposeDiagnosticSuppressor());
            TypeResolutionInterceptor.Companion.registerExtension(project, (Object)new ComposeTypeResolutionInterceptorExtension());
            ComposeDescriptorSerializerContext composeDescriptorSerializerContext2 = composeDescriptorSerializerContext;
            DescriptorSerializerPlugin.Companion.registerExtension(project, (Object)new ClassStabilityFieldSerializationPlugin(composeDescriptorSerializerContext2 != null ? composeDescriptorSerializerContext2.getClassStabilityInferredCollection() : null));
            FirExtensionRegistrarAdapter.Companion.registerExtension(project, (Object)new ComposeFirExtensionRegistrar());
        }

        public static /* synthetic */ void registerCommonExtensions$default(Companion companion, Project project, ComposeDescriptorSerializerContext composeDescriptorSerializerContext, int n, Object object) {
            if ((n & 2) != 0) {
                composeDescriptorSerializerContext = null;
            }
            companion.registerCommonExtensions(project, composeDescriptorSerializerContext);
        }

        public final void registerNativeExtensions(@NotNull Project project, @NotNull ComposeDescriptorSerializerContext composeDescriptorSerializerContext) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)composeDescriptorSerializerContext, (String)"composeDescriptorSerializerContext");
            DescriptorSerializerPlugin.Companion.registerExtension(project, (Object)new AddHiddenFromObjCSerializationPlugin(composeDescriptorSerializerContext.getHideFromObjCDeclarationsSet()));
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ComposeIrGenerationExtension createComposeIrExtension(@NotNull CompilerConfiguration configuration, @Nullable ComposeDescriptorSerializerContext descriptorSerializerContext, @Nullable Function1<? super StabilityInferencer, ? extends ModuleMetrics> moduleMetricsFactory) {
            Collection collection;
            Set matchers;
            CharSequence charSequence;
            CharSequence charSequence2;
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            boolean liveLiteralsEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_ENABLED_KEY());
            boolean liveLiteralsV2Enabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_V2_ENABLED_KEY());
            boolean generateFunctionKeyMetaClasses = configuration.getBoolean(ComposeConfiguration.INSTANCE.getGENERATE_FUNCTION_KEY_META_CLASSES_KEY());
            boolean sourceInformationEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getSOURCE_INFORMATION_ENABLED_KEY());
            Object object = configuration.get(ComposeConfiguration.INSTANCE.getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_KEY(), (Object)FeatureFlag.IntrinsicRemember.getDefault());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
            boolean intrinsicRememberEnabled = (Boolean)object;
            Object object2 = configuration.get(ComposeConfiguration.INSTANCE.getNON_SKIPPING_GROUP_OPTIMIZATION_ENABLED_KEY(), (Object)FeatureFlag.OptimizeNonSkippingGroups.getDefault());
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"get(...)");
            boolean nonSkippingGroupOptimizationEnabled = (Boolean)object2;
            boolean decoysEnabled = configuration.getBoolean(ComposeConfiguration.INSTANCE.getDECOYS_ENABLED_KEY());
            CharSequence charSequence3 = (CharSequence)configuration.get(ComposeConfiguration.INSTANCE.getMETRICS_DESTINATION_KEY(), (Object)"");
            if (StringsKt.isBlank((CharSequence)charSequence3)) {
                boolean bl = false;
                charSequence2 = null;
            } else {
                charSequence2 = charSequence3;
            }
            String metricsDestination = (String)charSequence2;
            CharSequence bl = (CharSequence)configuration.get(ComposeConfiguration.INSTANCE.getREPORTS_DESTINATION_KEY(), (Object)"");
            if (StringsKt.isBlank((CharSequence)bl)) {
                boolean bl2 = false;
                charSequence = null;
            } else {
                charSequence = bl;
            }
            String reportsDestination = (String)charSequence;
            Object object3 = configuration.get(CommonConfigurationKeys.VERIFY_IR, (Object)IrVerificationMode.NONE);
            Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"get(...)");
            IrVerificationMode irVerificationMode = (IrVerificationMode)object3;
            boolean useK2 = CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)configuration).getLanguageVersion().getUsesK2();
            Object object4 = configuration.get(ComposeConfiguration.INSTANCE.getSTRONG_SKIPPING_ENABLED_KEY(), (Object)FeatureFlag.StrongSkipping.getDefault());
            Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"get(...)");
            boolean strongSkippingEnabled = (Boolean)object4;
            List list = configuration.getList(ComposeConfiguration.INSTANCE.getSTABILITY_CONFIG_PATH_KEY());
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getList(...)");
            List stabilityConfigPaths = list;
            Object object5 = configuration.get(ComposeConfiguration.INSTANCE.getTRACE_MARKERS_ENABLED_KEY(), (Object)true);
            Intrinsics.checkNotNullExpressionValue((Object)object5, (String)"get(...)");
            boolean traceMarkersEnabled = (Boolean)object5;
            boolean skipIrLoweringIfRuntimeNotFound = configuration.getBoolean(ComposeConfiguration.INSTANCE.getSKIP_IR_LOWERING_IF_RUNTIME_NOT_FOUND_KEY());
            Object object6 = configuration.get(ComposeConfiguration.INSTANCE.getFEATURE_FLAGS(), (Object)CollectionsKt.emptyList());
            Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"get(...)");
            FeatureFlags featureFlags = new FeatureFlags((List)object6);
            featureFlags.validateFeatureFlags(configuration);
            featureFlags.setFeature(FeatureFlag.IntrinsicRemember, intrinsicRememberEnabled);
            featureFlags.setFeature(FeatureFlag.StrongSkipping, strongSkippingEnabled);
            featureFlags.setFeature(FeatureFlag.OptimizeNonSkippingGroups, nonSkippingGroupOptimizationEnabled);
            Set stableTypeMatchers = new LinkedHashSet();
            int n = ((Collection)stabilityConfigPaths).size();
            for (int i = 0; i < n; ++i) {
                Set set;
                String path = (String)stabilityConfigPaths.get(i);
                try {
                    set = StabilityConfigParser.Companion.fromFile(path).getStableTypeMatchers();
                }
                catch (Exception e) {
                    MessageCollector messageCollector = CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration);
                    String string = e.getMessage();
                    if (string == null) {
                        string = "Error parsing stability configuration at " + path;
                    }
                    MessageCollector.report$default((MessageCollector)messageCollector, (CompilerMessageSeverity)CompilerMessageSeverity.ERROR, (String)string, null, (int)4, null);
                    set = SetsKt.emptySet();
                }
                matchers = set;
                stableTypeMatchers.addAll(matchers);
            }
            Set set = (Set)configuration.get(ComposeConfiguration.INSTANCE.getTEST_STABILITY_CONFIG_KEY());
            if (set != null) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                matchers = set;
                boolean $i$f$map = false;
                void e = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string = (String)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    collection2.add(new FqNameMatcher((String)it));
                }
                collection = (List)destination$iv$iv;
            } else {
                collection = SetsKt.emptySet();
            }
            Collection testingMatchers = collection;
            stableTypeMatchers.addAll(testingMatchers);
            return new ComposeIrGenerationExtension(liveLiteralsEnabled, liveLiteralsV2Enabled, generateFunctionKeyMetaClasses, sourceInformationEnabled, traceMarkersEnabled, decoysEnabled, metricsDestination, reportsDestination, irVerificationMode, useK2, stableTypeMatchers, moduleMetricsFactory, descriptorSerializerContext, featureFlags, skipIrLoweringIfRuntimeNotFound, CommonConfigurationKeysKt.getMessageCollector((CompilerConfiguration)configuration));
        }

        public static /* synthetic */ ComposeIrGenerationExtension createComposeIrExtension$default(Companion companion, CompilerConfiguration compilerConfiguration, ComposeDescriptorSerializerContext composeDescriptorSerializerContext, Function1 function1, int n, Object object) {
            if ((n & 2) != 0) {
                composeDescriptorSerializerContext = null;
            }
            if ((n & 4) != 0) {
                function1 = null;
            }
            return companion.createComposeIrExtension(compilerConfiguration, composeDescriptorSerializerContext, (Function1<? super StabilityInferencer, ? extends ModuleMetrics>)function1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

