/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeClassIds;
import androidx.compose.compiler.plugins.kotlin.IncompatibleComposeRuntimeVersionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\b\u001a\u00020\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0011"}, d2={"Landroidx/compose/compiler/plugins/kotlin/VersionChecker;", "", "context", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "check", "", "noRuntimeOnClasspathError", "", "outdatedRuntimeWithUnknownVersionNumber", "outdatedRuntime", "actualVersion", "", "Companion", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nVersionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionChecker.kt\nandroidx/compose/compiler/plugins/kotlin/VersionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,228:1\n1611#2,9:229\n1863#2:238\n1864#2:240\n1620#2:241\n295#2,2:242\n1#3:239\n*S KotlinDebug\n*F\n+ 1 VersionChecker.kt\nandroidx/compose/compiler/plugins/kotlin/VersionChecker\n*L\n177#1:229,9\n177#1:238\n177#1:240\n177#1:241\n178#1:242,2\n177#1:239\n*E\n"})
public final class VersionChecker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IrPluginContext context;
    @NotNull
    private static final Map<Integer, String> runtimeVersionToMavenVersionTable;
    private static final int minimumRuntimeVersionInt = 3300;
    @NotNull
    public static final String compilerVersion = "1.5.11";

    public VersionChecker(@NotNull IrPluginContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    @NotNull
    public final IrPluginContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    public final void check() {
        IrConst versionExpr;
        IrExpressionBody irExpressionBody;
        Object v0;
        Iterable iterable;
        block8: {
            void $this$firstOrNull$iv;
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            if (!JvmPlatformKt.isJvm((TargetPlatform)this.context.getPlatform())) {
                return;
            }
            IrClassSymbol versionClass = this.context.referenceClass(ComposeClassIds.INSTANCE.getComposeVersion());
            if (versionClass == null) {
                IrClassSymbol composerClass = this.context.referenceClass(ComposeClassIds.INSTANCE.getComposer());
                if (composerClass != null) {
                    this.outdatedRuntimeWithUnknownVersionNumber();
                    throw null;
                }
                this.noRuntimeOnClasspathError();
                throw null;
            }
            iterable = ((IrClass)versionClass.getOwner()).getDeclarations();
            boolean $i$f$mapNotNull = false;
            Iterator iterator = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                IrProperty it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                IrDeclaration it = (IrDeclaration)element$iv$iv;
                boolean bl2 = false;
                if ((it instanceof IrProperty ? (IrProperty)it : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                IrProperty it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName().asString(), (Object)"version")) continue;
                v0 = element$iv;
                break block8;
            }
            v0 = null;
        }
        IrProperty irProperty = v0;
        IrExpression irExpression = irProperty != null && (iterable = irProperty.getBackingField()) != null && (irExpressionBody = iterable.getInitializer()) != null ? irExpressionBody.getExpression() : null;
        IrConst irConst = versionExpr = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        if (versionExpr == null || !Intrinsics.areEqual((Object)versionExpr.getKind(), (Object)IrConstKind.Int.INSTANCE)) {
            this.outdatedRuntimeWithUnknownVersionNumber();
            throw null;
        }
        Object object = versionExpr.getValue();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.Int");
        int versionInt = (Integer)object;
        if (versionInt < 3300) {
            String string = runtimeVersionToMavenVersionTable.get(versionInt);
            if (string == null) {
                string = "<unknown>";
            }
            this.outdatedRuntime(string);
            throw null;
        }
    }

    private final Void noRuntimeOnClasspathError() {
        throw new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                The Compose Compiler requires the Compose Runtime to be on the class path, but\n                none could be found. The compose compiler plugin you are using (version\n                1.5.11) expects a minimum runtime version of " + VersionChecker.Companion.getMinimumRuntimeVersion() + ".\n            ")), (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    private final Void outdatedRuntimeWithUnknownVersionNumber() {
        throw new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                You are using an outdated version of Compose Runtime that is not compatible with\n                the version of the Compose Compiler plugin you have installed. The compose\n                compiler plugin you are using (version 1.5.11) expects a minimum runtime\n                version of " + VersionChecker.Companion.getMinimumRuntimeVersion() + ".\n            ")), (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    private final Void outdatedRuntime(String actualVersion) {
        throw new IncompatibleComposeRuntimeVersionException(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                You are using an outdated version of Compose Runtime that is not compatible with\n                the version of the Compose Compiler plugin you have installed. The compose\n                compiler plugin you are using (version 1.5.11) expects a minimum runtime\n                version of " + VersionChecker.Companion.getMinimumRuntimeVersion() + ". The version of the runtime on the classpath\n                currently is " + actualVersion + ".\n            ")), (char)'\n', (char)' ', (boolean)false, (int)4, null));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)1600, (Object)"0.1.0-dev16"), TuplesKt.to((Object)1700, (Object)"1.0.0-alpha06"), TuplesKt.to((Object)1800, (Object)"1.0.0-alpha07"), TuplesKt.to((Object)1900, (Object)"1.0.0-alpha08"), TuplesKt.to((Object)2000, (Object)"1.0.0-alpha09"), TuplesKt.to((Object)2100, (Object)"1.0.0-alpha10"), TuplesKt.to((Object)2200, (Object)"1.0.0-alpha11"), TuplesKt.to((Object)2300, (Object)"1.0.0-alpha12"), TuplesKt.to((Object)2400, (Object)"1.0.0-alpha13"), TuplesKt.to((Object)2500, (Object)"1.0.0-beta04"), TuplesKt.to((Object)2600, (Object)"1.0.0-beta05"), TuplesKt.to((Object)2700, (Object)"1.0.0-beta06"), TuplesKt.to((Object)2800, (Object)"1.0.0-beta07"), TuplesKt.to((Object)2900, (Object)"1.0.0-beta08"), TuplesKt.to((Object)3000, (Object)"1.0.0-beta09"), TuplesKt.to((Object)3100, (Object)"1.0.0-rc01"), TuplesKt.to((Object)3200, (Object)"1.0.0-rc02"), TuplesKt.to((Object)3300, (Object)"1.0.0"), TuplesKt.to((Object)3301, (Object)"1.0.1"), TuplesKt.to((Object)3302, (Object)"1.0.2"), TuplesKt.to((Object)3303, (Object)"1.0.3"), TuplesKt.to((Object)3304, (Object)"1.0.4"), TuplesKt.to((Object)3305, (Object)"1.0.5"), TuplesKt.to((Object)4000, (Object)"1.1.0-alpha01"), TuplesKt.to((Object)4100, (Object)"1.1.0-alpha02"), TuplesKt.to((Object)4200, (Object)"1.1.0-alpha03"), TuplesKt.to((Object)4300, (Object)"1.1.0-alpha04"), TuplesKt.to((Object)4400, (Object)"1.1.0-alpha05"), TuplesKt.to((Object)4500, (Object)"1.1.0-alpha06"), TuplesKt.to((Object)4600, (Object)"1.1.0-beta01"), TuplesKt.to((Object)4700, (Object)"1.1.0-beta02"), TuplesKt.to((Object)4800, (Object)"1.1.0-beta03"), TuplesKt.to((Object)4900, (Object)"1.1.0-beta04"), TuplesKt.to((Object)5000, (Object)"1.1.0-rc01"), TuplesKt.to((Object)5001, (Object)"1.1.0-rc02"), TuplesKt.to((Object)5002, (Object)"1.1.0-rc03"), TuplesKt.to((Object)5003, (Object)"1.1.0"), TuplesKt.to((Object)5004, (Object)"1.1.1"), TuplesKt.to((Object)6000, (Object)"1.2.0-alpha01"), TuplesKt.to((Object)6100, (Object)"1.2.0-alpha02"), TuplesKt.to((Object)6200, (Object)"1.2.0-alpha03"), TuplesKt.to((Object)6300, (Object)"1.2.0-alpha04"), TuplesKt.to((Object)6400, (Object)"1.2.0-alpha05"), TuplesKt.to((Object)6500, (Object)"1.2.0-alpha06"), TuplesKt.to((Object)6600, (Object)"1.2.0-alpha07"), TuplesKt.to((Object)6700, (Object)"1.2.0-alpha08"), TuplesKt.to((Object)6800, (Object)"1.2.0-beta01"), TuplesKt.to((Object)6900, (Object)"1.2.0-beta02"), TuplesKt.to((Object)7000, (Object)"1.2.0-beta03"), TuplesKt.to((Object)7100, (Object)"1.2.0-rc01"), TuplesKt.to((Object)7101, (Object)"1.2.0-rc02"), TuplesKt.to((Object)7102, (Object)"1.2.0-rc03"), TuplesKt.to((Object)7103, (Object)"1.2.0"), TuplesKt.to((Object)7104, (Object)"1.2.1"), TuplesKt.to((Object)7105, (Object)"1.2.2"), TuplesKt.to((Object)8000, (Object)"1.3.0-alpha01"), TuplesKt.to((Object)8100, (Object)"1.3.0-alpha02"), TuplesKt.to((Object)8200, (Object)"1.3.0-alpha03"), TuplesKt.to((Object)8300, (Object)"1.3.0-beta01"), TuplesKt.to((Object)8400, (Object)"1.3.0-beta02"), TuplesKt.to((Object)8500, (Object)"1.3.0-beta03"), TuplesKt.to((Object)8600, (Object)"1.3.0-rc01"), TuplesKt.to((Object)8601, (Object)"1.3.0-rc02"), TuplesKt.to((Object)8602, (Object)"1.3.0"), TuplesKt.to((Object)8603, (Object)"1.3.1"), TuplesKt.to((Object)8604, (Object)"1.3.2"), TuplesKt.to((Object)8605, (Object)"1.3.3"), TuplesKt.to((Object)8606, (Object)"1.3.4"), TuplesKt.to((Object)9000, (Object)"1.4.0-alpha01"), TuplesKt.to((Object)9001, (Object)"1.4.0-alpha02"), TuplesKt.to((Object)9100, (Object)"1.4.0-alpha03"), TuplesKt.to((Object)9200, (Object)"1.4.0-alpha04"), TuplesKt.to((Object)9300, (Object)"1.4.0-alpha05"), TuplesKt.to((Object)9400, (Object)"1.4.0-alpha06"), TuplesKt.to((Object)9500, (Object)"1.4.0-beta01"), TuplesKt.to((Object)9600, (Object)"1.4.0-beta02"), TuplesKt.to((Object)9700, (Object)"1.4.0-rc01"), TuplesKt.to((Object)9701, (Object)"1.4.0-rc02"), TuplesKt.to((Object)9701, (Object)"1.5.0-alpha01"), TuplesKt.to((Object)9801, (Object)"1.5.0-alpha02"), TuplesKt.to((Object)9901, (Object)"1.5.0-alpha03"), TuplesKt.to((Object)10000, (Object)"1.5.0-alpha04"), TuplesKt.to((Object)10100, (Object)"1.5.0-alpha05"), TuplesKt.to((Object)10200, (Object)"1.5.0-beta01"), TuplesKt.to((Object)10300, (Object)"1.5.0-beta02"), TuplesKt.to((Object)10400, (Object)"1.5.0-beta03"), TuplesKt.to((Object)10401, (Object)"1.5.0-rc01"), TuplesKt.to((Object)10402, (Object)"1.5.0"), TuplesKt.to((Object)10403, (Object)"1.5.1"), TuplesKt.to((Object)11000, (Object)"1.6.0-alpha01"), TuplesKt.to((Object)11100, (Object)"1.6.0-alpha02"), TuplesKt.to((Object)11200, (Object)"1.6.0-alpha03"), TuplesKt.to((Object)11300, (Object)"1.6.0-alpha04"), TuplesKt.to((Object)11400, (Object)"1.6.0-alpha05"), TuplesKt.to((Object)11500, (Object)"1.6.0-alpha06"), TuplesKt.to((Object)11600, (Object)"1.6.0-alpha07"), TuplesKt.to((Object)11700, (Object)"1.6.0-alpha08"), TuplesKt.to((Object)11800, (Object)"1.6.0-beta01"), TuplesKt.to((Object)12000, (Object)"1.7.0-alpha01"), TuplesKt.to((Object)12100, (Object)"1.7.0-alpha02"), TuplesKt.to((Object)12200, (Object)"1.7.0-alpha03"), TuplesKt.to((Object)12300, (Object)"1.7.0-alpha04"), TuplesKt.to((Object)12400, (Object)"1.7.0-alpha05"), TuplesKt.to((Object)12500, (Object)"1.7.0-alpha06")};
        runtimeVersionToMavenVersionTable = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Landroidx/compose/compiler/plugins/kotlin/VersionChecker$Companion;", "", "<init>", "()V", "runtimeVersionToMavenVersionTable", "", "", "", "minimumRuntimeVersionInt", "compilerVersion", "minimumRuntimeVersion", "getMinimumRuntimeVersion", "()Ljava/lang/String;", "compiler-hosted"})
    public static final class Companion {
        private Companion() {
        }

        private final String getMinimumRuntimeVersion() {
            String string = (String)runtimeVersionToMavenVersionTable.get(3300);
            if (string == null) {
                string = "unknown";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

