/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.KtSamResolver;
import org.jetbrains.kotlin.analysis.api.fir.KtFirAnalysisSession;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirAnalysisSessionComponent;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirSamResolver;
import org.jetbrains.kotlin.analysis.api.fir.symbols.KtFirSamConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.fir.symbols.pointers.PointerUtilsKt;
import org.jetbrains.kotlin.analysis.api.lifetime.KtLifetimeToken;
import org.jetbrains.kotlin.analysis.api.symbols.KtClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KtSamConstructorSymbol;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirAbstractBodyResolveTransformerDispatcher;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirBodyResolveTransformer;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0011B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0006X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver;", "Lorg/jetbrains/kotlin/analysis/api/components/KtSamResolver;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirAnalysisSessionComponent;", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "token", "Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;)V", "getAnalysisSession", "()Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "getToken", "()Lorg/jetbrains/kotlin/analysis/api/lifetime/KtLifetimeToken;", "getSamConstructor", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSamConstructorSymbol;", "ktClassLikeSymbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtClassLikeSymbol;", "LocalSamResolver", "analysis-api-fir"})
public final class KtFirSamResolver
extends KtSamResolver
implements KtFirAnalysisSessionComponent {
    @NotNull
    private final KtFirAnalysisSession analysisSession;
    @NotNull
    private final KtLifetimeToken token;

    public KtFirSamResolver(@NotNull KtFirAnalysisSession analysisSession, @NotNull KtLifetimeToken token) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.analysisSession = analysisSession;
        this.token = token;
    }

    @Override
    @NotNull
    public KtFirAnalysisSession getAnalysisSession() {
        return this.analysisSession;
    }

    @Override
    @NotNull
    protected KtLifetimeToken getToken() {
        return this.token;
    }

    @Override
    @Nullable
    public KtSamConstructorSymbol getSamConstructor(@NotNull KtClassLikeSymbol ktClassLikeSymbol) {
        KtFirSamConstructorSymbol ktFirSamConstructorSymbol;
        Intrinsics.checkNotNullParameter((Object)ktClassLikeSymbol, (String)"ktClassLikeSymbol");
        ClassId classId = ktClassLikeSymbol.getClassIdIfNonLocal();
        if (classId == null) {
            return null;
        }
        ClassId classId2 = classId;
        FirClassLikeDeclaration firClassLikeDeclaration = PointerUtilsKt.getClassLikeSymbol(this.getAnalysisSession(), classId2);
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return null;
        }
        FirRegularClass owner = firRegularClass;
        LocalSamResolver resolver = new LocalSamResolver(this.getAnalysisSession(), this.getAnalysisSession().getUseSiteSession$analysis_api_fir());
        FirSimpleFunction firSimpleFunction = resolver.getSamConstructor(owner);
        if (firSimpleFunction != null) {
            FirSimpleFunction it = firSimpleFunction;
            boolean bl = false;
            ktFirSamConstructorSymbol = this.getAnalysisSession().getFirSymbolBuilder$analysis_api_fir().getFunctionLikeBuilder().buildSamConstructorSymbol(it.getSymbol());
        } else {
            ktFirSamConstructorSymbol = null;
        }
        return ktFirSamConstructorSymbol;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u000b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver;", "", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;", "firSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/fir/KtFirAnalysisSession;Lorg/jetbrains/kotlin/fir/FirSession;)V", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "stubBodyResolveTransformer", "org/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver$stubBodyResolveTransformer$1", "Lorg/jetbrains/kotlin/analysis/api/fir/components/KtFirSamResolver$LocalSamResolver$stubBodyResolveTransformer$1;", "bodyResolveComponents", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirAbstractBodyResolveTransformer$BodyResolveTransformerComponents;", "getSamConstructor", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "analysis-api-fir"})
    private static final class LocalSamResolver {
        @NotNull
        private final FirSession firSession;
        @NotNull
        private final ScopeSession scopeSession;
        @NotNull
        private final stubBodyResolveTransformer.1 stubBodyResolveTransformer;
        @NotNull
        private final FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents bodyResolveComponents;

        public LocalSamResolver(@NotNull KtFirAnalysisSession analysisSession, @NotNull FirSession firSession) {
            Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
            Intrinsics.checkNotNullParameter((Object)firSession, (String)"firSession");
            this.firSession = firSession;
            this.scopeSession = analysisSession.getScopeSessionFor(this.firSession);
            FirSession firSession2 = this.firSession;
            FirResolvePhase firResolvePhase = FirResolvePhase.BODY_RESOLVE;
            ScopeSession scopeSession = this.scopeSession;
            this.stubBodyResolveTransformer = new FirBodyResolveTransformer(firSession2, firResolvePhase, scopeSession){};
            this.bodyResolveComponents = new FirAbstractBodyResolveTransformer.BodyResolveTransformerComponents(this.firSession, this.scopeSession, (FirAbstractBodyResolveTransformerDispatcher)this.stubBodyResolveTransformer, this.stubBodyResolveTransformer.getContext());
        }

        @Nullable
        public final FirSimpleFunction getSamConstructor(@NotNull FirRegularClass firClass) {
            Intrinsics.checkNotNullParameter((Object)firClass, (String)"firClass");
            FirSimpleFunction firSimpleFunction = this.bodyResolveComponents.getSamResolver().getSamConstructor((FirClassLikeDeclaration)firClass);
            if (firSimpleFunction == null) {
                return null;
            }
            FirSimpleFunction samConstructor = firSimpleFunction;
            if (!Intrinsics.areEqual((Object)samConstructor.getOrigin(), (Object)FirDeclarationOrigin.SamConstructor.INSTANCE)) {
                return null;
            }
            return samConstructor;
        }
    }
}

