/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyAnnotationTransformerData;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyAnnotationTransformerScope;
import org.jetbrains.kotlin.analysis.low.level.api.fir.lazy.resolve.FirLazyBodiesCalculator;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationsPlatformSpecificSupportComponentKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirErrorAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirLazyBlock;
import org.jetbrains.kotlin.fir.expressions.FirLazyExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirLazyDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.CustomAnnotationTypeAttributeKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\"\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\u0005\u001a\u0002H\u0006\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u0002H\u00062\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyAnnotationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyAnnotationTransformerData;", "<init>", "()V", "transformElement", "E", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/lazy/resolve/FirLazyAnnotationTransformerData;)Lorg/jetbrains/kotlin/fir/FirElement;", "canBeCompilerAnnotation", "", "annotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "transformErrorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "transformResolvedTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitTypeAnnotations", "", "transformAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformErrorAnnotationCall", "errorAnnotationCall", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorAnnotationCall;", "transformExpression", "expression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "transformBlock", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "transformDelegatedConstructorCall", "delegatedConstructorCall", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "low-level-api-fir"})
abstract class FirLazyAnnotationTransformer
extends FirTransformer<FirLazyAnnotationTransformerData> {
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @NotNull FirLazyAnnotationTransformerData data) {
        Intrinsics.checkNotNullParameter(element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        element.transformChildren((FirTransformer)this, (Object)data);
        return element;
    }

    private final boolean canBeCompilerAnnotation(FirAnnotationCall annotationCall, FirSession session2) {
        FirTypeRef annotationTypeRef = annotationCall.getAnnotationTypeRef();
        if (!(annotationTypeRef instanceof FirUserTypeRef)) {
            return false;
        }
        if (!((Collection)FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations((FirSession)session2).getAnnotations()).isEmpty()) {
            return true;
        }
        Name name = ((FirQualifierPart)CollectionsKt.last((List)((FirUserTypeRef)annotationTypeRef).getQualifier())).getName();
        return FirAnnotationsPlatformSpecificSupportComponentKt.getAnnotationPlatformSupport((FirSession)session2).getRequiredAnnotationsShortClassNames().contains(name);
    }

    @NotNull
    public FirTypeRef transformErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef, @NotNull FirLazyAnnotationTransformerData data) {
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.visitTypeAnnotations((FirResolvedTypeRef)errorTypeRef, data);
        return super.transformErrorTypeRef(errorTypeRef, (Object)data);
    }

    @NotNull
    public FirTypeRef transformResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef, @NotNull FirLazyAnnotationTransformerData data) {
        Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.visitTypeAnnotations(resolvedTypeRef, data);
        return super.transformResolvedTypeRef(resolvedTypeRef, (Object)data);
    }

    private final void visitTypeAnnotations(FirResolvedTypeRef resolvedTypeRef, FirLazyAnnotationTransformerData data) {
        ConeTypeUtilsKt.forEachType((ConeKotlinType)FirTypeUtilsKt.getConeType((FirTypeRef)((FirTypeRef)resolvedTypeRef)), (Function1)((Function1)new Function1<ConeKotlinType, Unit>(this, data){
            final /* synthetic */ FirLazyAnnotationTransformer this$0;
            final /* synthetic */ FirLazyAnnotationTransformerData $data;
            {
                this.this$0 = $receiver;
                this.$data = $data;
                super(1);
            }

            public final void invoke(ConeKotlinType coneType) {
                Intrinsics.checkNotNullParameter((Object)coneType, (String)"coneType");
                for (FirAnnotation typeArgumentAnnotation : CustomAnnotationTypeAttributeKt.getCustomAnnotations((ConeKotlinType)coneType)) {
                    typeArgumentAnnotation.accept((FirVisitor)this.this$0, (Object)this.$data);
                }
            }
        }));
    }

    @NotNull
    public FirStatement transformAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirLazyAnnotationTransformerData data) {
        boolean shouldCalculate;
        Intrinsics.checkNotNullParameter((Object)annotationCall, (String)"annotationCall");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean bl = shouldCalculate = data.getCompilerAnnotationsOnly() == FirLazyAnnotationTransformerScope.ALL_ANNOTATIONS || this.canBeCompilerAnnotation(annotationCall, data.getSession());
        if (shouldCalculate && FirLazyBodiesCalculator.INSTANCE.needCalculatingAnnotationCall(annotationCall)) {
            FirArgumentList newArgumentList = FirLazyBodiesCalculator.INSTANCE.calculateLazyArgumentsForAnnotation(annotationCall, data.getSession());
            annotationCall.replaceArgumentList(newArgumentList);
        }
        super.transformAnnotationCall(annotationCall, (Object)data);
        return (FirStatement)annotationCall;
    }

    @NotNull
    public FirStatement transformErrorAnnotationCall(@NotNull FirErrorAnnotationCall errorAnnotationCall, @NotNull FirLazyAnnotationTransformerData data) {
        Intrinsics.checkNotNullParameter((Object)errorAnnotationCall, (String)"errorAnnotationCall");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.transformAnnotationCall((FirAnnotationCall)errorAnnotationCall, data);
        return (FirStatement)errorAnnotationCall;
    }

    @NotNull
    public FirStatement transformExpression(@NotNull FirExpression expression, @NotNull FirLazyAnnotationTransformerData data) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (expression instanceof FirLazyExpression) {
            return (FirStatement)expression;
        }
        return super.transformExpression(expression, (Object)data);
    }

    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @NotNull FirLazyAnnotationTransformerData data) {
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (block instanceof FirLazyBlock) {
            return (FirStatement)block;
        }
        return super.transformBlock(block, (Object)data);
    }

    @NotNull
    public FirStatement transformDelegatedConstructorCall(@NotNull FirDelegatedConstructorCall delegatedConstructorCall, @NotNull FirLazyAnnotationTransformerData data) {
        Intrinsics.checkNotNullParameter((Object)delegatedConstructorCall, (String)"delegatedConstructorCall");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (delegatedConstructorCall instanceof FirLazyDelegatedConstructorCall) {
            return (FirStatement)delegatedConstructorCall;
        }
        return super.transformDelegatedConstructorCall(delegatedConstructorCall, (Object)data);
    }
}

