/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationWithFile;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirClassWithSpecificMembersResolveTarget;
import org.jetbrains.kotlin.analysis.low.level.api.fir.diagnostics.FileStructureElementDiagnosticRetrieverKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ClassDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationBaseStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootScriptStructureElement;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirElementWithResolveState;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory;", "", "<init>", "()V", "createFileStructureElement", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "lazyResolveClassWithGeneratedMembers", "", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "low-level-api-fir"})
public final class FileElementFactory {
    @NotNull
    public static final FileElementFactory INSTANCE = new FileElementFactory();

    private FileElementFactory() {
    }

    @NotNull
    public final FileStructureElement createFileStructureElement(@NotNull FirDeclaration firDeclaration, @NotNull FirFile firFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
        DeclarationBaseStructureElement declarationBaseStructureElement;
        Intrinsics.checkNotNullParameter((Object)firDeclaration, (String)"firDeclaration");
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
        if (firDeclaration instanceof FirRegularClass) {
            this.lazyResolveClassWithGeneratedMembers((FirRegularClass)firDeclaration, moduleComponents);
            declarationBaseStructureElement = new ClassDeclarationStructureElement(firFile, (FirRegularClass)firDeclaration, moduleComponents);
        } else {
            declarationBaseStructureElement = firDeclaration instanceof FirScript ? (DeclarationBaseStructureElement)new RootScriptStructureElement(firFile, (FirScript)firDeclaration, moduleComponents) : (DeclarationBaseStructureElement)new DeclarationStructureElement(firFile, firDeclaration, moduleComponents);
        }
        return declarationBaseStructureElement;
    }

    private final void lazyResolveClassWithGeneratedMembers(FirRegularClass firClass, LLFirModuleResolveComponents moduleComponents) {
        List list;
        List $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (FirDeclaration member : firClass.getDeclarations()) {
            if (member instanceof FirSimpleFunction) {
                KtSourceElement ktSourceElement = ((FirSimpleFunction)member).getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DataClassGeneratedMembers.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member);
                    continue;
                }
            }
            KtSourceElement ktSourceElement = member.getSource();
            if (Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumGeneratedDeclaration.INSTANCE)) {
                $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member);
                continue;
            }
            if (FileStructureElementDiagnosticRetrieverKt.isImplicitConstructor((FirElement)member)) {
                $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member);
                continue;
            }
            if (member instanceof FirField) {
                KtSourceElement ktSourceElement2 = ((FirField)member).getSource();
                if (Intrinsics.areEqual((Object)(ktSourceElement2 != null ? ktSourceElement2.getKind() : null), (Object)KtFakeSourceElementKind.ClassDelegationField.INSTANCE)) {
                    $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member);
                    continue;
                }
            }
            if (!(member instanceof FirDanglingModifierList)) continue;
            $this$lazyResolveClassWithGeneratedMembers_u24lambda_u240.add(member);
        }
        List classMembersToResolve = CollectionsKt.build((List)list);
        FirDesignationWithFile firClassDesignation = FirDesignationKt.collectDesignationWithFile((FirElementWithResolveState)firClass);
        LLFirClassWithSpecificMembersResolveTarget designationWithMembers = new LLFirClassWithSpecificMembersResolveTarget(firClassDesignation.getFirFile(), firClassDesignation.getPath(), firClass, classMembersToResolve);
        moduleComponents.getFirModuleLazyDeclarationResolver().lazyResolveTarget(designationWithMembers, FirResolvePhase.BODY_RESOLVE, null);
    }
}

