/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3;

import java.io.File;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.processing.Processor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.base.kapt3.KaptFlag;
import org.jetbrains.kotlin.base.kapt3.KaptOptions;
import org.jetbrains.kotlin.cli.jvm.plugins.ServiceLoaderLite;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.kapt3.AbstractKapt3Extension;
import org.jetbrains.kotlin.kapt3.base.LoadedProcessors;
import org.jetbrains.kotlin.kapt3.base.ProcessorLoader;
import org.jetbrains.kotlin.kapt3.util.MessageCollectorBackedKaptLogger;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingTrace;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ0\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0014R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/kapt3/ClasspathBasedKapt3Extension;", "Lorg/jetbrains/kotlin/kapt3/AbstractKapt3Extension;", "options", "Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;", "logger", "Lorg/jetbrains/kotlin/kapt3/util/MessageCollectorBackedKaptLogger;", "compilerConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "(Lorg/jetbrains/kotlin/base/kapt3/KaptOptions;Lorg/jetbrains/kotlin/kapt3/util/MessageCollectorBackedKaptLogger;Lorg/jetbrains/kotlin/config/CompilerConfiguration;)V", "analyzePartially", "", "getAnalyzePartially", "()Z", "processorLoader", "Lorg/jetbrains/kotlin/kapt3/base/ProcessorLoader;", "analysisCompleted", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "project", "Lorg/jetbrains/kotlin/com/intellij/openapi/project/Project;", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "bindingTrace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "files", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "clearJavacZipCaches", "", "loadProcessors", "Lorg/jetbrains/kotlin/kapt3/base/LoadedProcessors;", "kotlin-annotation-processing"})
public final class ClasspathBasedKapt3Extension
extends AbstractKapt3Extension {
    @Nullable
    private ProcessorLoader processorLoader;

    public ClasspathBasedKapt3Extension(@NotNull KaptOptions options, @NotNull MessageCollectorBackedKaptLogger logger, @NotNull CompilerConfiguration compilerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)compilerConfiguration, (String)"compilerConfiguration");
        super(options, logger, compilerConfiguration);
    }

    @Override
    public boolean getAnalyzePartially() {
        return this.getOptions().get(KaptFlag.USE_LIGHT_ANALYSIS) && super.getAnalyzePartially();
    }

    @Override
    @NotNull
    protected LoadedProcessors loadProcessors() {
        KaptOptions kaptOptions = this.getOptions();
        MessageCollectorBackedKaptLogger messageCollectorBackedKaptLogger = this.getLogger();
        ProcessorLoader efficientProcessorLoader2 = new ProcessorLoader(kaptOptions, messageCollectorBackedKaptLogger){

            @NotNull
            public List<Processor> doLoadProcessors(@NotNull LinkedHashSet<File> classpath, @NotNull URLClassLoader classLoader) {
                Intrinsics.checkNotNullParameter(classpath, (String)"classpath");
                Intrinsics.checkNotNullParameter((Object)classLoader, (String)"classLoader");
                return ServiceLoaderLite.INSTANCE.loadImplementations(Processor.class, classLoader);
            }
        };
        this.processorLoader = efficientProcessorLoader2;
        return ProcessorLoader.loadProcessors$default(efficientProcessorLoader2, null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public AnalysisResult analysisCompleted(@NotNull Project project, @NotNull ModuleDescriptor module, @NotNull BindingTrace bindingTrace, @NotNull Collection<? extends KtFile> files) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)bindingTrace, (String)"bindingTrace");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        try {
            AnalysisResult analysisResult = super.analysisCompleted(project, module, bindingTrace, files);
            return analysisResult;
        }
        finally {
            ProcessorLoader processorLoader = this.processorLoader;
            if (processorLoader != null) {
                processorLoader.close();
            }
            this.clearJavacZipCaches();
        }
    }

    private final void clearJavacZipCaches() {
        try {
            Class<?> zipFileIndexCacheClass = Class.forName("com.sun.tools.javac.file.ZipFileIndexCache");
            Object zipFileIndexCacheInstance = zipFileIndexCacheClass.getMethod("getSharedInstance", new Class[0]).invoke(null, new Object[0]);
            zipFileIndexCacheClass.getMethod("clearCache", new Class[0]).invoke(zipFileIndexCacheInstance, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

