/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.kapt3.base.incremental;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.kapt3.base.incremental.Changes;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalAptCache;
import org.jetbrains.kotlin.kapt3.base.incremental.IncrementalProcessor;
import org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache;
import org.jetbrains.kotlin.kapt3.base.incremental.SourceFileStructure;
import org.jetbrains.kotlin.kapt3.base.incremental.SourcesToReprocess;

@Metadata(mv={1, 5, 0}, k=1, xi=50, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0011\u001a\u00020\u0012H\u0016J$\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00030\u001d2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00150\u001dJ\b\u0010\u001f\u001a\u00020\u0006H\u0002J\b\u0010 \u001a\u00020\rH\u0002J\u001c\u0010!\u001a\u00020\u00122\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\u0006\u0010%\u001a\u00020\tR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCacheManager;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "aptCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalAptCache;", "aptCacheFile", "closed", "", "getFile", "()Ljava/io/File;", "javaCache", "Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "getJavaCache$kotlin_annotation_processing_base", "()Lorg/jetbrains/kotlin/kapt3/base/incremental/JavaClassCache;", "javaCacheFile", "close", "", "getAllImpactedTypes", "", "", "changes", "Lorg/jetbrains/kotlin/kapt3/base/incremental/Changes;", "aggregatingGeneratedTypes", "", "invalidateAndGetDirtyFiles", "Lorg/jetbrains/kotlin/kapt3/base/incremental/SourcesToReprocess;", "changedSources", "", "dirtyClasspathJvmNames", "maybeGetAptCacheFromFile", "maybeGetJavaCacheFromFile", "updateCache", "processors", "", "Lorg/jetbrains/kotlin/kapt3/base/incremental/IncrementalProcessor;", "failedToAnalyzeSources", "kotlin-annotation-processing-base"})
public final class JavaClassCacheManager
implements Closeable {
    @NotNull
    private final File file;
    @NotNull
    private final File javaCacheFile;
    @NotNull
    private final JavaClassCache javaCache;
    @NotNull
    private final File aptCacheFile;
    @NotNull
    private final IncrementalAptCache aptCache;
    private boolean closed;

    public JavaClassCacheManager(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.javaCacheFile = FilesKt.resolve((File)this.file, (String)"java-cache.bin");
        this.javaCache = this.maybeGetJavaCacheFromFile();
        this.aptCacheFile = FilesKt.resolve((File)this.file, (String)"apt-cache.bin");
        this.aptCache = this.maybeGetAptCacheFromFile();
    }

    @NotNull
    public final File getFile() {
        return this.file;
    }

    @NotNull
    public final JavaClassCache getJavaCache$kotlin_annotation_processing_base() {
        return this.javaCache;
    }

    public final void updateCache(@NotNull List<IncrementalProcessor> processors, boolean failedToAnalyzeSources) {
        Intrinsics.checkNotNullParameter(processors, (String)"processors");
        if (!this.aptCache.updateCache(processors, failedToAnalyzeSources)) {
            this.javaCache.invalidateAll$kotlin_annotation_processing_base();
            return;
        }
        Iterable $this$forEach$iv = processors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IncrementalProcessor processor = (IncrementalProcessor)element$iv;
            boolean bl = false;
            Map<File, String> $this$forEach$iv2 = processor.getGeneratedClassFilesToTypes();
            boolean $i$f$forEach2 = false;
            Map<File, String> map = $this$forEach$iv2;
            boolean bl2 = false;
            Iterator<Map.Entry<File, String>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<File, String> element$iv2;
                Map.Entry<File, String> $dstr$classFile$type = element$iv2 = iterator.next();
                boolean bl3 = false;
                Map.Entry<File, String> entry = $dstr$classFile$type;
                boolean bl4 = false;
                File classFile = entry.getKey();
                Map.Entry<File, String> entry2 = $dstr$classFile$type;
                boolean bl5 = false;
                String type = entry2.getValue();
                Serializable serializable = classFile.toURI();
                Intrinsics.checkNotNullExpressionValue((Object)serializable, (String)"classFile.toURI()");
                serializable = new SourceFileStructure((URI)serializable);
                boolean bl6 = false;
                boolean bl7 = false;
                Serializable it = serializable;
                boolean bl8 = false;
                ((SourceFileStructure)it).addDeclaredType(type);
                Serializable typeInformation = serializable;
                this.getJavaCache$kotlin_annotation_processing_base().addSourceStructure((SourceFileStructure)typeInformation);
            }
        }
    }

    @NotNull
    public final SourcesToReprocess invalidateAndGetDirtyFiles(@NotNull Collection<? extends File> changedSources, @NotNull Collection<String> dirtyClasspathJvmNames) {
        List classNamesToReprocess;
        Set sourcesToReprocess;
        Set<String> impactedTypes;
        block16: {
            HashSet<String> dirtyClasspathFqNames;
            block15: {
                boolean bl;
                Object object;
                Set<String> isolatingGeneratedTypes2;
                Set<String> aggregatingGeneratedTypes2;
                block14: {
                    block13: {
                        Intrinsics.checkNotNullParameter(changedSources, (String)"changedSources");
                        Intrinsics.checkNotNullParameter(dirtyClasspathJvmNames, (String)"dirtyClasspathJvmNames");
                        if (!this.aptCache.isIncremental()) {
                            return SourcesToReprocess.FullRebuild.INSTANCE;
                        }
                        dirtyClasspathFqNames = new HashSet<String>(dirtyClasspathJvmNames.size());
                        Iterable $this$forEach$iv = dirtyClasspathJvmNames;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            dirtyClasspathFqNames.add(StringsKt.replace$default((String)StringsKt.replace$default((String)it, (String)"$", (String)".", (boolean)false, (int)4, null), (String)"/", (String)".", (boolean)false, (int)4, null));
                        }
                        Changes changes = new Changes(changedSources, CollectionsKt.toSet((Iterable)dirtyClasspathFqNames));
                        aggregatingGeneratedTypes2 = this.aptCache.getAggregatingGeneratedTypes((Function1<? super Collection<? extends File>, ? extends Set<String>>)((Function1)new Function1<Collection<? extends File>, Set<? extends String>>(this.javaCache){

                            @NotNull
                            public final Set<String> invoke(@NotNull Collection<? extends File> p0) {
                                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                                return ((JavaClassCache)this.receiver).getTypesForFiles(p0);
                            }

                            @NotNull
                            public final String getSignature() {
                                return "getTypesForFiles(Ljava/util/Collection;)Ljava/util/Set;";
                            }

                            @NotNull
                            public final String getName() {
                                return "getTypesForFiles";
                            }

                            @NotNull
                            public final KDeclarationContainer getOwner() {
                                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
                            }
                        }));
                        impactedTypes = this.getAllImpactedTypes(changes, aggregatingGeneratedTypes2);
                        isolatingGeneratedTypes2 = this.aptCache.getIsolatingGeneratedTypes((Function1<? super Collection<? extends File>, ? extends Set<String>>)((Function1)new Function1<Collection<? extends File>, Set<? extends String>>(this.javaCache){

                            @NotNull
                            public final Set<String> invoke(@NotNull Collection<? extends File> p0) {
                                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                                return ((JavaClassCache)this.receiver).getTypesForFiles(p0);
                            }

                            @NotNull
                            public final String getSignature() {
                                return "getTypesForFiles(Ljava/util/Collection;)Ljava/util/Set;";
                            }

                            @NotNull
                            public final String getName() {
                                return "getTypesForFiles";
                            }

                            @NotNull
                            public final KDeclarationContainer getOwner() {
                                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
                            }
                        }));
                        sourcesToReprocess = CollectionsKt.toMutableSet((Iterable)changedSources);
                        boolean bl3 = false;
                        classNamesToReprocess = new ArrayList();
                        object = changedSources;
                        bl = false;
                        if (!object.isEmpty()) break block13;
                        object = impactedTypes;
                        bl = false;
                        if (!(!object.isEmpty())) break block14;
                    }
                    for (String aggregatingOrigin : this.aptCache.getAggregatingOrigins()) {
                        if (impactedTypes.contains(aggregatingOrigin)) continue;
                        File originSource = this.javaCache.getSourceForType(aggregatingOrigin);
                        if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)originSource), (Object)"java")) {
                            sourcesToReprocess.add(originSource);
                            continue;
                        }
                        if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)originSource), (Object)"class")) continue;
                        classNamesToReprocess.add(aggregatingOrigin);
                    }
                }
                for (String impactedType : impactedTypes) {
                    String isolatingOrigin2;
                    if (!isolatingGeneratedTypes2.contains(impactedType) && !aggregatingGeneratedTypes2.contains(impactedType)) {
                        sourcesToReprocess.add(this.javaCache.getSourceForType(impactedType));
                        continue;
                    }
                    if (!isolatingGeneratedTypes2.contains(impactedType) || impactedTypes.contains(isolatingOrigin2 = this.aptCache.getOriginForGeneratedIsolatingType(impactedType, (Function1<? super String, ? extends File>)((Function1)new Function1<String, File>(this.javaCache){

                        @NotNull
                        public final File invoke(@NotNull String p0) {
                            Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                            return ((JavaClassCache)this.receiver).getSourceForType(p0);
                        }

                        @NotNull
                        public final String getSignature() {
                            return "getSourceForType(Ljava/lang/String;)Ljava/io/File;";
                        }

                        @NotNull
                        public final String getName() {
                            return "getSourceForType";
                        }

                        @NotNull
                        public final KDeclarationContainer getOwner() {
                            return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
                        }
                    }))) || dirtyClasspathFqNames.contains(isolatingOrigin2)) continue;
                    File originSource = this.javaCache.getSourceForType(isolatingOrigin2);
                    if (Intrinsics.areEqual((Object)FilesKt.getExtension((File)originSource), (Object)"java")) {
                        sourcesToReprocess.add(originSource);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)FilesKt.getExtension((File)originSource), (Object)"class")) continue;
                    classNamesToReprocess.add(isolatingOrigin2);
                }
                object = sourcesToReprocess;
                bl = false;
                if (!object.isEmpty()) break block15;
                object = classNamesToReprocess;
                bl = false;
                if (!(!object.isEmpty())) break block16;
            }
            this.javaCache.invalidateDataForTypes(impactedTypes);
            this.aptCache.invalidateAggregating();
            this.aptCache.invalidateIsolatingForOriginTypes(SetsKt.plus(impactedTypes, (Iterable)dirtyClasspathFqNames));
        }
        return new SourcesToReprocess.Incremental(CollectionsKt.toList((Iterable)sourcesToReprocess), impactedTypes, classNamesToReprocess);
    }

    private final Set<String> getAllImpactedTypes(Changes changes, Set<String> aggregatingGeneratedTypes2) {
        boolean bl;
        List<String> list;
        Set<String> impactedTypes;
        block3: {
            block2: {
                impactedTypes = this.javaCache.getAllImpactedTypes(changes);
                impactedTypes.addAll((Collection<String>)this.aptCache.getIsolatingGeneratedTypesForOrigins(changes.getDirtyFqNamesFromClasspath(), (Function1<? super Collection<? extends File>, ? extends Set<String>>)((Function1)new Function1<Collection<? extends File>, Set<? extends String>>(this.javaCache){

                    @NotNull
                    public final Set<String> invoke(@NotNull Collection<? extends File> p0) {
                        Intrinsics.checkNotNullParameter(p0, (String)"p0");
                        return ((JavaClassCache)this.receiver).getTypesForFiles(p0);
                    }

                    @NotNull
                    public final String getSignature() {
                        return "getTypesForFiles(Ljava/util/Collection;)Ljava/util/Set;";
                    }

                    @NotNull
                    public final String getName() {
                        return "getTypesForFiles";
                    }

                    @NotNull
                    public final KDeclarationContainer getOwner() {
                        return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
                    }
                })));
                list = changes.getSourceChanges();
                bl = false;
                if (!list.isEmpty()) break block2;
                list = (List<String>)((Object)impactedTypes);
                bl = false;
                if (!(!list.isEmpty())) break block3;
            }
            impactedTypes.addAll((Collection<String>)aggregatingGeneratedTypes2);
        }
        list = this.aptCache.getIsolatingGeneratedTypesForOrigins(impactedTypes, (Function1<? super Collection<? extends File>, ? extends Set<String>>)((Function1)new Function1<Collection<? extends File>, Set<? extends String>>(this.javaCache){

            @NotNull
            public final Set<String> invoke(@NotNull Collection<? extends File> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                return ((JavaClassCache)this.receiver).getTypesForFiles(p0);
            }

            @NotNull
            public final String getSignature() {
                return "getTypesForFiles(Ljava/util/Collection;)Ljava/util/Set;";
            }

            @NotNull
            public final String getName() {
                return "getTypesForFiles";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(JavaClassCache.class);
            }
        }));
        bl = false;
        boolean bl2 = false;
        List<String> it = list;
        boolean bl3 = false;
        impactedTypes.addAll((Collection<String>)it);
        return impactedTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IncrementalAptCache maybeGetAptCacheFromFile() {
        IncrementalAptCache incrementalAptCache;
        if (this.aptCacheFile.exists()) {
            Object object;
            try {
                IncrementalAptCache incrementalAptCache2;
                object = this.aptCacheFile;
                boolean bl = false;
                object = new ObjectInputStream(new BufferedInputStream(new FileInputStream((File)object)));
                bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl3 = false;
                    Object object2 = it.readObject();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.kapt3.base.incremental.IncrementalAptCache");
                    }
                    incrementalAptCache2 = (IncrementalAptCache)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = incrementalAptCache2;
            }
            catch (Throwable e) {
                object = new IncrementalAptCache();
            }
            incrementalAptCache = object;
        } else {
            incrementalAptCache = new IncrementalAptCache();
        }
        return incrementalAptCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JavaClassCache maybeGetJavaCacheFromFile() {
        JavaClassCache javaClassCache;
        if (this.javaCacheFile.exists()) {
            Object object;
            try {
                JavaClassCache javaClassCache2;
                object = this.javaCacheFile;
                boolean bl = false;
                object = new ObjectInputStream(new BufferedInputStream(new FileInputStream((File)object)));
                bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    ObjectInputStream it = (ObjectInputStream)object;
                    boolean bl3 = false;
                    Object object2 = it.readObject();
                    if (object2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.kapt3.base.incremental.JavaClassCache");
                    }
                    javaClassCache2 = (JavaClassCache)object2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
                object = javaClassCache2;
            }
            catch (Throwable e) {
                object = new JavaClassCache();
            }
            javaClassCache = object;
        } else {
            javaClassCache = new JavaClassCache();
        }
        return javaClassCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ObjectOutputStream it2;
        if (this.closed) {
            return;
        }
        File file = this.javaCacheFile;
        boolean bl = false;
        boolean bl2 = false;
        File $this$close_u24lambda_u2d8 = file;
        boolean bl3 = false;
        $this$close_u24lambda_u2d8.delete();
        $this$close_u24lambda_u2d8.getParentFile().mkdirs();
        Object object = $this$close_u24lambda_u2d8;
        boolean bl4 = false;
        object = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((File)object)));
        bl4 = false;
        boolean bl5 = false;
        Throwable throwable = null;
        try {
            it2 = (ObjectOutputStream)object;
            boolean bl6 = false;
            it2.writeObject(this.getJavaCache$kotlin_annotation_processing_base());
            it2 = Unit.INSTANCE;
        }
        catch (Throwable it2) {
            throwable = it2;
            throw it2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        file = this.aptCacheFile;
        bl = false;
        bl2 = false;
        File $this$close_u24lambda_u2d10 = file;
        boolean bl7 = false;
        $this$close_u24lambda_u2d10.delete();
        $this$close_u24lambda_u2d10.getParentFile().mkdirs();
        object = $this$close_u24lambda_u2d10;
        bl4 = false;
        object = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream((File)object)));
        bl4 = false;
        boolean bl8 = false;
        Throwable throwable2 = null;
        try {
            it2 = (ObjectOutputStream)object;
            boolean bl9 = false;
            it2.writeObject(this.aptCache);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable2 = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
        }
        this.closed = true;
    }
}

