/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.caches;

import java.util.Iterator;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.ValueWithCleanup;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableSoftValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.CleanableWeakValueReferenceCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.cleanable.ValueReferenceCleaner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J \u0010\u000b\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J \u0010\f\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J \u0010\r\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J \u0010\u000e\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J \u0010\u000f\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J \u0010\u0010\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J \u0010\u0011\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J \u0010\u0012\u001a\u00020\u00052\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\nH\u0007J5\u0010\u0013\u001a\u00020\u0005*\u0012\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u0002`\n2\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\u0015\"\u00020\tH\u0002\u00a2\u0006\u0002\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableValueReferenceCacheTest;", "", "<init>", "()V", "removeCleansUpValues", "", "cache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithCleanup;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/Cache;", "putCleansUpValues", "putAvoidsSameValueCleanup", "computeAddsValues", "computeCleansUpValues", "computeAvoidsSameValueCleanup", "computeIfAbsentAddsValues", "computeIfAbsentKeepsExistingValues", "clearCleansUpValues", "setUp", "values", "", "(Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;[Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithCleanup;)V", "Companion", "tests-jdk11_test"})
@SourceDebugExtension(value={"SMAP\nCleanableValueReferenceCacheTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanableValueReferenceCacheTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableValueReferenceCacheTest\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,232:1\n14048#2,2:233\n1915#3,2:235\n*S KotlinDebug\n*F\n+ 1 CleanableValueReferenceCacheTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableValueReferenceCacheTest\n*L\n221#1:233,2\n225#1:235,2\n*E\n"})
public final class CleanableValueReferenceCacheTest {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void removeCleansUpValues(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2};
        this.setUp(cache, valueWithCleanupArray);
        ValueWithCleanup removedValue1 = (ValueWithCleanup)cache.remove((Object)"v1");
        Assertions.assertNull((Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)removedValue1);
        Assertions.assertTrue((boolean)value1.isCleanedUp());
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        ValueWithCleanup removedValue2 = (ValueWithCleanup)cache.remove((Object)"v2");
        Assertions.assertNull((Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)removedValue2);
        Assertions.assertTrue((boolean)value2.isCleanedUp());
    }

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void putCleansUpValues(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2};
        this.setUp(cache, valueWithCleanupArray);
        ValueWithCleanup valueReplacement1 = new ValueWithCleanup("vr1");
        ValueWithCleanup valueReplacement2 = new ValueWithCleanup("vr2");
        ValueWithCleanup oldValue1 = (ValueWithCleanup)cache.put((Object)"v1", (Object)valueReplacement1);
        Assertions.assertSame((Object)valueReplacement1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)oldValue1);
        Assertions.assertTrue((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement1.isCleanedUp());
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        ValueWithCleanup oldValue2 = (ValueWithCleanup)cache.put((Object)"v2", (Object)valueReplacement2);
        Assertions.assertSame((Object)valueReplacement2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)oldValue2);
        Assertions.assertTrue((boolean)value2.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement2.isCleanedUp());
    }

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void putAvoidsSameValueCleanup(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1};
        this.setUp(cache, valueWithCleanupArray);
        ValueWithCleanup oldValue = (ValueWithCleanup)cache.put((Object)"v1", (Object)value1);
        Assertions.assertSame((Object)value1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)oldValue);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
    }

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void computeAddsValues(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1};
        this.setUp(cache, valueWithCleanupArray);
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup newValue = (ValueWithCleanup)cache.compute((Object)"v2", (arg_0, arg_1) -> CleanableValueReferenceCacheTest.computeAddsValues$lambda$0(value2, arg_0, arg_1));
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)newValue);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)value2.isCleanedUp());
    }

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void computeCleansUpValues(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2};
        this.setUp(cache, valueWithCleanupArray);
        ValueWithCleanup valueReplacement1 = new ValueWithCleanup("vr1");
        ValueWithCleanup valueReplacement2 = null;
        ValueWithCleanup newValue1 = (ValueWithCleanup)cache.compute((Object)"v1", (arg_0, arg_1) -> CleanableValueReferenceCacheTest.computeCleansUpValues$lambda$0(value1, valueReplacement1, arg_0, arg_1));
        Assertions.assertSame((Object)valueReplacement1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)valueReplacement1, (Object)newValue1);
        Assertions.assertTrue((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement1.isCleanedUp());
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        ValueWithCleanup newValue2 = (ValueWithCleanup)cache.compute((Object)"v2", (arg_0, arg_1) -> CleanableValueReferenceCacheTest.computeCleansUpValues$lambda$1(value2, valueReplacement2, arg_0, arg_1));
        Assertions.assertSame(valueReplacement2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame(valueReplacement2, (Object)newValue2);
        Assertions.assertTrue((boolean)value2.isCleanedUp());
    }

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void computeAvoidsSameValueCleanup(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1};
        this.setUp(cache, valueWithCleanupArray);
        ValueWithCleanup newValue = (ValueWithCleanup)cache.compute((Object)"v1", (arg_0, arg_1) -> CleanableValueReferenceCacheTest.computeAvoidsSameValueCleanup$lambda$0(value1, arg_0, arg_1));
        Assertions.assertSame((Object)value1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)newValue);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
    }

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void computeIfAbsentAddsValues(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1};
        this.setUp(cache, valueWithCleanupArray);
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup newValue = (ValueWithCleanup)cache.computeIfAbsent((Object)"v2", arg_0 -> CleanableValueReferenceCacheTest.computeIfAbsentAddsValues$lambda$0(value2, arg_0));
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)newValue);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)value2.isCleanedUp());
    }

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void computeIfAbsentKeepsExistingValues(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2};
        this.setUp(cache, valueWithCleanupArray);
        ValueWithCleanup valueReplacement1 = new ValueWithCleanup("vr1");
        ValueWithCleanup valueReplacement2 = new ValueWithCleanup("vr2");
        ValueWithCleanup currentValue1 = (ValueWithCleanup)cache.computeIfAbsent((Object)"v1", arg_0 -> CleanableValueReferenceCacheTest.computeIfAbsentKeepsExistingValues$lambda$0(valueReplacement1, arg_0));
        Assertions.assertSame((Object)value1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)currentValue1);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement1.isCleanedUp());
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        ValueWithCleanup currentValue2 = (ValueWithCleanup)cache.computeIfAbsent((Object)"v2", arg_0 -> CleanableValueReferenceCacheTest.computeIfAbsentKeepsExistingValues$lambda$1(valueReplacement2, arg_0));
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)currentValue2);
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement2.isCleanedUp());
    }

    @ParameterizedTest
    @MethodSource(value={"createCaches"})
    public final void clearCleansUpValues(@NotNull CleanableValueReferenceCache<String, ValueWithCleanup> cache) {
        Intrinsics.checkNotNullParameter(cache, (String)"cache");
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup value3 = new ValueWithCleanup("v3");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2, value3};
        this.setUp(cache, valueWithCleanupArray);
        CleanableValueReferenceCache.clear$default(cache, null, (int)1, null);
        Assertions.assertTrue((boolean)cache.isEmpty());
        Assertions.assertTrue((boolean)value1.isCleanedUp());
        Assertions.assertTrue((boolean)value2.isCleanedUp());
        Assertions.assertTrue((boolean)value3.isCleanedUp());
    }

    private final void setUp(CleanableValueReferenceCache<String, ValueWithCleanup> $this$setUp, ValueWithCleanup ... values) {
        Object $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        int n = ((ValueWithCleanup[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            ValueWithCleanup element$iv;
            ValueWithCleanup value = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            $this$setUp.put((Object)value.getName(), (Object)value);
        }
        $this$forEach$iv = $this$setUp.getKeys();
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            String key = (String)element$iv;
            boolean bl = false;
            ValueWithCleanup value = (ValueWithCleanup)$this$setUp.get((Object)key);
            Assertions.assertNotNull((Object)value);
            ValueWithCleanup valueWithCleanup = value;
            Intrinsics.checkNotNull((Object)valueWithCleanup);
            Assertions.assertFalse((boolean)valueWithCleanup.isCleanedUp());
        }
    }

    private static final ValueWithCleanup computeAddsValues$lambda$0(ValueWithCleanup $value2, String string, ValueWithCleanup oldValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Assertions.assertNull((Object)oldValue);
        return $value2;
    }

    private static final ValueWithCleanup computeCleansUpValues$lambda$0(ValueWithCleanup $value1, ValueWithCleanup $valueReplacement1, String string, ValueWithCleanup oldValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Assertions.assertSame((Object)$value1, (Object)oldValue);
        return $valueReplacement1;
    }

    private static final ValueWithCleanup computeCleansUpValues$lambda$1(ValueWithCleanup $value2, ValueWithCleanup $valueReplacement2, String string, ValueWithCleanup oldValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Assertions.assertSame((Object)$value2, (Object)oldValue);
        return $valueReplacement2;
    }

    private static final ValueWithCleanup computeAvoidsSameValueCleanup$lambda$0(ValueWithCleanup $value1, String string, ValueWithCleanup oldValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Assertions.assertSame((Object)$value1, (Object)oldValue);
        return $value1;
    }

    private static final ValueWithCleanup computeIfAbsentAddsValues$lambda$0(ValueWithCleanup $value2, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $value2;
    }

    private static final ValueWithCleanup computeIfAbsentKeepsExistingValues$lambda$0(ValueWithCleanup $valueReplacement1, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $valueReplacement1;
    }

    private static final ValueWithCleanup computeIfAbsentKeepsExistingValues$lambda$1(ValueWithCleanup $valueReplacement2, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $valueReplacement2;
    }

    @JvmStatic
    private static final Stream<CleanableValueReferenceCache<String, ValueWithCleanup>> createCaches() {
        return CleanableValueReferenceCacheTest.Companion.createCaches();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u0002`\t0\u0005H\u0003\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableValueReferenceCacheTest$Companion;", "", "<init>", "()V", "createCaches", "Ljava/util/stream/Stream;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/cleanable/CleanableValueReferenceCache;", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithCleanup;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/Cache;", "tests-jdk11_test"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private final Stream<CleanableValueReferenceCache<String, ValueWithCleanup>> createCaches() {
            CleanableValueReferenceCache[] cleanableValueReferenceCacheArray = new CleanableValueReferenceCache[]{new CleanableWeakValueReferenceCache(null, null, Companion::createCaches$lambda$0, 3, null), new CleanableSoftValueReferenceCache(null, null, Companion::createCaches$lambda$1, 3, null)};
            Stream<CleanableValueReferenceCache<String, ValueWithCleanup>> stream = Stream.of(cleanableValueReferenceCacheArray);
            Intrinsics.checkNotNullExpressionValue(stream, (String)"of(...)");
            return stream;
        }

        private static final ValueReferenceCleaner createCaches$lambda$0(ValueWithCleanup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getCleanupMarker();
        }

        private static final ValueReferenceCleaner createCaches$lambda$1(ValueWithCleanup it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getCleanupMarker();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

