/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.impl.base.test.cases.types.typeCreation;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.types.typeCreation.AbstractTypeCreatorDslTest;
import org.jetbrains.kotlin.analysis.api.symbols.KaClassLikeSymbol;
import org.jetbrains.kotlin.analysis.api.types.KaType;
import org.jetbrains.kotlin.analysis.api.types.KaTypeProjection;
import org.jetbrains.kotlin.analysis.api.types.typeCreation.KaClassTypeBuilder;
import org.jetbrains.kotlin.analysis.api.types.typeCreation.KaTypeCreator;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.Variance;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\n\u001a\u00020\u0007J\u0006\u0010\u000b\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007J\u0006\u0010\u000e\u001a\u00020\u0007J\u0006\u0010\u000f\u001a\u00020\u0007J\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0007J\u0006\u0010\u0012\u001a\u00020\u0007J\u0006\u0010\u0013\u001a\u00020\u0007J\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\u0015\u001a\u00020\u0007J\u0006\u0010\u0016\u001a\u00020\u0007J\u0006\u0010\u0017\u001a\u00020\u0007J\u0006\u0010\u0018\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0007\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/types/typeCreation/ClassTypeCreatorDslTestCases;", "Lorg/jetbrains/kotlin/analysis/api/impl/base/test/cases/types/typeCreation/AbstractTypeCreatorDslTest$TestCases;", "session", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "caretToType", "", "", "Lorg/jetbrains/kotlin/analysis/api/types/KaType;", "<init>", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Ljava/util/Map;)V", "testIntTypeMarkNullable", "testUserType", "testLocalUserType", "testBoxedArrayWithStringTypeArgument", "testMoreTypeArgumentsThanExpected", "testLessTypeArgumentsThanExpected", "testNonExistingClassId", "testUserGenericTypeWithStarProjection", "testNonExistingClassIdWithAnnotations", "testUserTypeWithAnnotations", "testWithAnnotationRequiringArguments", "testWithGenericAnnotation", "testGenericTypeAliasWithIntArgument", "testGenericTypeAliasWithNoArguments", "testTypeAlias", "testTypeAliasWithNestedTypeAliases", "testListWithTypeAliasArgument", "analysis-api-impl-base_testFixtures"})
public final class ClassTypeCreatorDslTestCases
extends AbstractTypeCreatorDslTest.TestCases {
    public ClassTypeCreatorDslTestCases(@NotNull KaSession session, @NotNull Map<String, ? extends KaType> caretToType) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter(caretToType, (String)"caretToType");
        super(session, caretToType, null);
    }

    @NotNull
    public final KaType testIntTypeMarkNullable() {
        KaClassLikeSymbol intTypeSymbol = this.getClassLikeSymbolByCaret("int");
        return this.getSession().getTypeCreator().classType(intTypeSymbol, ClassTypeCreatorDslTestCases::testIntTypeMarkNullable$lambda$0);
    }

    @NotNull
    public final KaType testUserType() {
        KaClassLikeSymbol userTypeSymbol = this.getClassLikeSymbolByCaret("type");
        return KaTypeCreator.classType$default((KaTypeCreator)this.getSession().getTypeCreator(), (KaClassLikeSymbol)userTypeSymbol, null, (int)2, null);
    }

    @NotNull
    public final KaType testLocalUserType() {
        KaClassLikeSymbol userTypeSymbol = this.getClassLikeSymbolByCaret("type");
        return KaTypeCreator.classType$default((KaTypeCreator)this.getSession().getTypeCreator(), (KaClassLikeSymbol)userTypeSymbol, null, (int)2, null);
    }

    @NotNull
    public final KaType testBoxedArrayWithStringTypeArgument() {
        KaClassLikeSymbol arrayTypeSymbol = this.getClassLikeSymbolByCaret("array");
        KaType stringType = this.getTypeByCaret("string");
        return this.getSession().getTypeCreator().classType(arrayTypeSymbol, arg_0 -> ClassTypeCreatorDslTestCases.testBoxedArrayWithStringTypeArgument$lambda$0(stringType, arg_0));
    }

    @NotNull
    public final KaType testMoreTypeArgumentsThanExpected() {
        KaClassLikeSymbol arrayTypeSymbol = this.getClassLikeSymbolByCaret("array");
        KaType stringType = this.getTypeByCaret("string");
        return this.getSession().getTypeCreator().classType(arrayTypeSymbol, arg_0 -> ClassTypeCreatorDslTestCases.testMoreTypeArgumentsThanExpected$lambda$0(stringType, arg_0));
    }

    @NotNull
    public final KaType testLessTypeArgumentsThanExpected() {
        KaClassLikeSymbol arrayTypeSymbol = this.getClassLikeSymbolByCaret("array");
        return KaTypeCreator.classType$default((KaTypeCreator)this.getSession().getTypeCreator(), (KaClassLikeSymbol)arrayTypeSymbol, null, (int)2, null);
    }

    @NotNull
    public final KaType testNonExistingClassId() {
        KaTypeCreator kaTypeCreator = this.getSession().getTypeCreator();
        Name name = Name.identifier((String)"MyClass");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return KaTypeCreator.classType$default((KaTypeCreator)kaTypeCreator, (ClassId)new ClassId(FqName.ROOT, name), null, (int)2, null);
    }

    @NotNull
    public final KaType testUserGenericTypeWithStarProjection() {
        KaClassLikeSymbol userTypeSymbol = this.getClassLikeSymbolByCaret("type");
        return this.getSession().getTypeCreator().classType(userTypeSymbol, ClassTypeCreatorDslTestCases::testUserGenericTypeWithStarProjection$lambda$0);
    }

    @NotNull
    public final KaType testNonExistingClassIdWithAnnotations() {
        ClassId annotationClassId1 = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"MyAnno1", (boolean)false, (int)2, null);
        ClassId annotationClassId2 = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"MyAnno2", (boolean)false, (int)2, null);
        ClassId annotationClassId3 = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"MyAnno3", (boolean)false, (int)2, null);
        KaTypeCreator kaTypeCreator = this.getSession().getTypeCreator();
        Name name = Name.identifier((String)"MyClass");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        return kaTypeCreator.classType(new ClassId(FqName.ROOT, name), arg_0 -> ClassTypeCreatorDslTestCases.testNonExistingClassIdWithAnnotations$lambda$0(annotationClassId1, annotationClassId2, annotationClassId3, arg_0));
    }

    @NotNull
    public final KaType testUserTypeWithAnnotations() {
        ClassId annotationClassId1 = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"MyAnno1", (boolean)false, (int)2, null);
        ClassId annotationClassId2 = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"MyAnno2", (boolean)false, (int)2, null);
        ClassId annotationClassId3 = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"MyAnno3", (boolean)false, (int)2, null);
        KaClassLikeSymbol userTypeSymbol = this.getClassLikeSymbolByCaret("type");
        return this.getSession().getTypeCreator().classType(userTypeSymbol, arg_0 -> ClassTypeCreatorDslTestCases.testUserTypeWithAnnotations$lambda$0(annotationClassId1, annotationClassId2, annotationClassId3, arg_0));
    }

    @NotNull
    public final KaType testWithAnnotationRequiringArguments() {
        ClassId annotationClassId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"MyAnno", (boolean)false, (int)2, null);
        KaClassLikeSymbol userTypeSymbol = this.getClassLikeSymbolByCaret("type");
        return this.getSession().getTypeCreator().classType(userTypeSymbol, arg_0 -> ClassTypeCreatorDslTestCases.testWithAnnotationRequiringArguments$lambda$0(annotationClassId, arg_0));
    }

    @NotNull
    public final KaType testWithGenericAnnotation() {
        ClassId annotationClassId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"MyAnno", (boolean)false, (int)2, null);
        KaClassLikeSymbol userTypeSymbol = this.getClassLikeSymbolByCaret("type");
        return this.getSession().getTypeCreator().classType(userTypeSymbol, arg_0 -> ClassTypeCreatorDslTestCases.testWithGenericAnnotation$lambda$0(annotationClassId, arg_0));
    }

    @NotNull
    public final KaType testGenericTypeAliasWithIntArgument() {
        KaClassLikeSymbol alias = this.getClassLikeSymbolByCaret("alias");
        KaType argument = this.getTypeByCaret("argument");
        return this.getSession().getTypeCreator().classType(alias, arg_0 -> ClassTypeCreatorDslTestCases.testGenericTypeAliasWithIntArgument$lambda$0(argument, arg_0));
    }

    @NotNull
    public final KaType testGenericTypeAliasWithNoArguments() {
        KaClassLikeSymbol alias = this.getClassLikeSymbolByCaret("alias");
        return KaTypeCreator.classType$default((KaTypeCreator)this.getSession().getTypeCreator(), (KaClassLikeSymbol)alias, null, (int)2, null);
    }

    @NotNull
    public final KaType testTypeAlias() {
        KaClassLikeSymbol alias = this.getClassLikeSymbolByCaret("alias");
        return KaTypeCreator.classType$default((KaTypeCreator)this.getSession().getTypeCreator(), (KaClassLikeSymbol)alias, null, (int)2, null);
    }

    @NotNull
    public final KaType testTypeAliasWithNestedTypeAliases() {
        KaClassLikeSymbol alias = this.getClassLikeSymbolByCaret("alias");
        return KaTypeCreator.classType$default((KaTypeCreator)this.getSession().getTypeCreator(), (KaClassLikeSymbol)alias, null, (int)2, null);
    }

    @NotNull
    public final KaType testListWithTypeAliasArgument() {
        KaType alias = this.getTypeByCaret("alias");
        return this.getSession().getTypeCreator().classType(StandardClassIds.INSTANCE.getList(), arg_0 -> ClassTypeCreatorDslTestCases.testListWithTypeAliasArgument$lambda$0(alias, arg_0));
    }

    private static final Unit testIntTypeMarkNullable$lambda$0(KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.setMarkedNullable(true);
        return Unit.INSTANCE;
    }

    private static final KaType testBoxedArrayWithStringTypeArgument$lambda$0$0(KaType $stringType) {
        return $stringType;
    }

    private static final Unit testBoxedArrayWithStringTypeArgument$lambda$0(KaType $stringType, KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.typeArgument(Variance.IN_VARIANCE, () -> ClassTypeCreatorDslTestCases.testBoxedArrayWithStringTypeArgument$lambda$0$0($stringType));
        return Unit.INSTANCE;
    }

    private static final KaType testMoreTypeArgumentsThanExpected$lambda$0$0(KaType $stringType) {
        return $stringType;
    }

    private static final KaType testMoreTypeArgumentsThanExpected$lambda$0$1(KaType $stringType) {
        return $stringType;
    }

    private static final Unit testMoreTypeArgumentsThanExpected$lambda$0(KaType $stringType, KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.typeArgument(Variance.IN_VARIANCE, () -> ClassTypeCreatorDslTestCases.testMoreTypeArgumentsThanExpected$lambda$0$0($stringType));
        $this$classType.typeArgument(Variance.OUT_VARIANCE, () -> ClassTypeCreatorDslTestCases.testMoreTypeArgumentsThanExpected$lambda$0$1($stringType));
        $this$classType.invariantTypeArgument($stringType);
        return Unit.INSTANCE;
    }

    private static final Unit testUserGenericTypeWithStarProjection$lambda$0(KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.typeArgument((KaTypeProjection)$this$classType.starTypeProjection());
        return Unit.INSTANCE;
    }

    private static final Unit testNonExistingClassIdWithAnnotations$lambda$0(ClassId $annotationClassId1, ClassId $annotationClassId2, ClassId $annotationClassId3, KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.annotation($annotationClassId1);
        $this$classType.annotation($annotationClassId2);
        $this$classType.annotation($annotationClassId3);
        return Unit.INSTANCE;
    }

    private static final Unit testUserTypeWithAnnotations$lambda$0(ClassId $annotationClassId1, ClassId $annotationClassId2, ClassId $annotationClassId3, KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.annotation($annotationClassId1);
        $this$classType.annotation($annotationClassId2);
        $this$classType.annotation($annotationClassId3);
        return Unit.INSTANCE;
    }

    private static final Unit testWithAnnotationRequiringArguments$lambda$0(ClassId $annotationClassId, KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.annotation($annotationClassId);
        return Unit.INSTANCE;
    }

    private static final Unit testWithGenericAnnotation$lambda$0(ClassId $annotationClassId, KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.annotation($annotationClassId);
        return Unit.INSTANCE;
    }

    private static final Unit testGenericTypeAliasWithIntArgument$lambda$0(KaType $argument, KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.invariantTypeArgument($argument);
        return Unit.INSTANCE;
    }

    private static final Unit testListWithTypeAliasArgument$lambda$0(KaType $alias, KaClassTypeBuilder $this$classType) {
        Intrinsics.checkNotNullParameter((Object)$this$classType, (String)"$this$classType");
        $this$classType.invariantTypeArgument($alias);
        return Unit.INSTANCE;
    }
}

