/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.directives;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinCodeFragmentContextModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalScriptModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalSourceModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalSourceOutOfBlockModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationEventKind;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationEventKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleOutOfBlockModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationEvent;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationKind;
import org.jetbrains.kotlin.analysis.api.platform.modification.UtilsKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryFallbackDependenciesModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibrarySourceModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.test.framework.directives.ModificationEventDirectiveTarget;
import org.jetbrains.kotlin.analysis.test.framework.directives.ModificationEventDirectives;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModuleStructure;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.testFramework.UtilKt;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0014\u0010\n\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0010H\u0002\u001a\u0018\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u001a\"\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0017H\u0002\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0018"}, d2={"publishModificationEventByDirective", "", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "isOptional", "", "publishWildcardModificationEventByDirectiveIfPresent", "modificationEventKind", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinModificationEventKind;", "publishWildcardModificationEventsByDirective", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModuleStructure;", "publishModificationEvent", "modificationEventDirectiveTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventDirectiveTarget;", "getModificationEventDirectiveTarget", "(Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;)Lorg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventDirectiveTarget;", "getFallbackDependenciesModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "publishGlobalModificationEvent", "project", "Lcom/intellij/openapi/project/Project;", "publishModificationEventByKind", "ktModule", "errorModuleRequired", "", "analysis-test-framework_testFixtures"})
@SourceDebugExtension(value={"SMAP\nModificationEventDirectives.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModificationEventDirectives.kt\norg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventDirectivesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,188:1\n1914#2,2:189\n671#2,11:191\n*S KotlinDebug\n*F\n+ 1 ModificationEventDirectives.kt\norg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventDirectivesKt\n*L\n116#1:189,2\n145#1:191,11\n*E\n"})
public final class ModificationEventDirectivesKt {
    public static final void publishModificationEventByDirective(@NotNull KtTestModule $this$publishModificationEventByDirective, boolean isOptional) {
        Intrinsics.checkNotNullParameter((Object)$this$publishModificationEventByDirective, (String)"<this>");
        List modificationEventKinds = $this$publishModificationEventByDirective.getTestModule().getDirectives().get(ModificationEventDirectives.INSTANCE.getMODIFICATION_EVENT());
        switch (modificationEventKinds.size()) {
            case 0: {
                if (isOptional) {
                    return;
                }
                throw new IllegalStateException(("Expected a `" + ModificationEventDirectives.INSTANCE.getMODIFICATION_EVENT().getName() + "` to be present in the test module `" + $this$publishModificationEventByDirective + "`.").toString());
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException(("The test module `" + $this$publishModificationEventByDirective + "` must not specify multiple modification events.").toString());
            }
        }
        KotlinModificationEventKind modificationEventKind = (KotlinModificationEventKind)CollectionsKt.single((List)modificationEventKinds);
        ModificationEventDirectivesKt.publishModificationEvent($this$publishModificationEventByDirective, modificationEventKind);
    }

    public static /* synthetic */ void publishModificationEventByDirective$default(KtTestModule ktTestModule, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        ModificationEventDirectivesKt.publishModificationEventByDirective(ktTestModule, bl);
    }

    public static final void publishWildcardModificationEventByDirectiveIfPresent(@NotNull KtTestModule $this$publishWildcardModificationEventByDirectiveIfPresent, @NotNull KotlinModificationEventKind modificationEventKind) {
        Intrinsics.checkNotNullParameter((Object)$this$publishWildcardModificationEventByDirectiveIfPresent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modificationEventKind, (String)"modificationEventKind");
        if ($this$publishWildcardModificationEventByDirectiveIfPresent.getTestModule().getDirectives().contains((Directive)ModificationEventDirectives.INSTANCE.getWILDCARD_MODIFICATION_EVENT())) {
            ModificationEventDirectivesKt.publishModificationEvent($this$publishWildcardModificationEventByDirectiveIfPresent, modificationEventKind);
        }
    }

    public static final void publishWildcardModificationEventsByDirective(@NotNull KtTestModuleStructure $this$publishWildcardModificationEventsByDirective, @NotNull KotlinModificationEventKind modificationEventKind) {
        Intrinsics.checkNotNullParameter((Object)$this$publishWildcardModificationEventsByDirective, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modificationEventKind, (String)"modificationEventKind");
        if (KotlinModificationEventKt.isModuleLevel((KotlinModificationEventKind)modificationEventKind)) {
            Iterable $this$forEach$iv = $this$publishWildcardModificationEventsByDirective.getMainModules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtTestModule ktTestModule = (KtTestModule)element$iv;
                boolean bl = false;
                ModificationEventDirectivesKt.publishWildcardModificationEventByDirectiveIfPresent(ktTestModule, modificationEventKind);
            }
        } else {
            if (!$this$publishWildcardModificationEventsByDirective.getTestModuleStructure().getAllDirectives().contains((Directive)ModificationEventDirectives.INSTANCE.getWILDCARD_MODIFICATION_EVENT())) {
                return;
            }
            ModificationEventDirectivesKt.publishGlobalModificationEvent(modificationEventKind, $this$publishWildcardModificationEventsByDirective.getProject());
        }
    }

    private static final void publishModificationEvent(KtTestModule $this$publishModificationEvent, KotlinModificationEventKind modificationEventKind) {
        KaModule kaModule;
        switch (WhenMappings.$EnumSwitchMapping$0[ModificationEventDirectivesKt.getModificationEventDirectiveTarget($this$publishModificationEvent).ordinal()]) {
            case 1: {
                kaModule = $this$publishModificationEvent.getKtModule();
                break;
            }
            case 2: {
                kaModule = ModificationEventDirectivesKt.getFallbackDependenciesModule($this$publishModificationEvent.getKtModule());
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KaModule targetModule = kaModule;
        ModificationEventDirectivesKt.publishModificationEventByKind(modificationEventKind, targetModule.getProject(), targetModule);
    }

    private static final ModificationEventDirectiveTarget getModificationEventDirectiveTarget(KtTestModule $this$modificationEventDirectiveTarget) {
        ModificationEventDirectiveTarget modificationEventDirectiveTarget = (ModificationEventDirectiveTarget)((Object)DirectiveKt.singleOrZeroValue((RegisteredDirectives)$this$modificationEventDirectiveTarget.getTestModule().getDirectives(), ModificationEventDirectives.INSTANCE.getMODIFICATION_EVENT_TARGET()));
        if (modificationEventDirectiveTarget == null) {
            modificationEventDirectiveTarget = ModificationEventDirectiveTarget.SELF;
        }
        return modificationEventDirectiveTarget;
    }

    /*
     * WARNING - void declaration
     */
    private static final KaModule getFallbackDependenciesModule(KaModule $this$getFallbackDependenciesModule) {
        Object object;
        block4: {
            void var3_5;
            if (!($this$getFallbackDependenciesModule instanceof KaLibraryModule || $this$getFallbackDependenciesModule instanceof KaLibrarySourceModule)) {
                boolean $i$a$-require-ModificationEventDirectivesKt$getFallbackDependenciesModule$22 = false;
                String $i$a$-require-ModificationEventDirectivesKt$getFallbackDependenciesModule$22 = "The MODIFICATION_EVENT_TARGET=FALLBACK_DEPENDENCIES directive can only be applied to a library module or library source module, but the module '" + $this$getFallbackDependenciesModule + "' is of type `" + Reflection.getOrCreateKotlinClass($this$getFallbackDependenciesModule.getClass()).getSimpleName() + "`.";
                throw new IllegalArgumentException($i$a$-require-ModificationEventDirectivesKt$getFallbackDependenciesModule$22.toString());
            }
            Iterable $this$singleOrNull$iv = $this$getFallbackDependenciesModule.getDirectRegularDependencies();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                KaModule it = (KaModule)element$iv;
                boolean bl = false;
                if (!(it instanceof KaLibraryFallbackDependenciesModule)) continue;
                if (found$iv) {
                    object = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : var3_5;
        }
        KaModule kaModule = (KaModule)object;
        if (kaModule == null) {
            throw new IllegalStateException(("Expected a single fallback dependencies module for the module '" + $this$getFallbackDependenciesModule + "'.").toString());
        }
        return kaModule;
    }

    private static final void publishGlobalModificationEvent(KotlinModificationEventKind modificationEventKind, Project project) {
        if (!KotlinModificationEventKt.isGlobalLevel((KotlinModificationEventKind)modificationEventKind)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ModificationEventDirectivesKt.publishModificationEventByKind(modificationEventKind, project, null);
    }

    private static final void publishModificationEventByKind(KotlinModificationEventKind modificationEventKind, Project project, KaModule ktModule) {
        KotlinModificationEvent kotlinModificationEvent;
        switch (WhenMappings.$EnumSwitchMapping$1[modificationEventKind.ordinal()]) {
            case 1: {
                KaModule kaModule = ktModule;
                if (kaModule == null) {
                    ModificationEventDirectivesKt.errorModuleRequired();
                    throw new KotlinNothingValueException();
                }
                kotlinModificationEvent = (KotlinModificationEvent)new KotlinModuleStateModificationEvent(kaModule, KotlinModuleStateModificationKind.UPDATE);
                break;
            }
            case 2: {
                KaModule kaModule = ktModule;
                if (kaModule == null) {
                    ModificationEventDirectivesKt.errorModuleRequired();
                    throw new KotlinNothingValueException();
                }
                kotlinModificationEvent = (KotlinModificationEvent)new KotlinModuleOutOfBlockModificationEvent(kaModule);
                break;
            }
            case 3: {
                kotlinModificationEvent = (KotlinModificationEvent)KotlinGlobalModuleStateModificationEvent.INSTANCE;
                break;
            }
            case 4: {
                kotlinModificationEvent = (KotlinModificationEvent)KotlinGlobalSourceModuleStateModificationEvent.INSTANCE;
                break;
            }
            case 5: {
                kotlinModificationEvent = (KotlinModificationEvent)KotlinGlobalScriptModuleStateModificationEvent.INSTANCE;
                break;
            }
            case 6: {
                kotlinModificationEvent = (KotlinModificationEvent)KotlinGlobalSourceOutOfBlockModificationEvent.INSTANCE;
                break;
            }
            case 7: {
                KaModule kaModule = ktModule;
                if (kaModule == null) {
                    ModificationEventDirectivesKt.errorModuleRequired();
                    throw new KotlinNothingValueException();
                }
                kotlinModificationEvent = (KotlinModificationEvent)new KotlinCodeFragmentContextModificationEvent(kaModule);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KotlinModificationEvent modificationEvent = kotlinModificationEvent;
        UtilKt.runWriteAction(() -> ModificationEventDirectivesKt.publishModificationEventByKind$lambda$0(project, modificationEvent));
    }

    private static final Void errorModuleRequired() {
        throw new IllegalStateException("Cannot publish a module-level modification event without a module.".toString());
    }

    private static final Unit publishModificationEventByKind$lambda$0(Project $project, KotlinModificationEvent $modificationEvent) {
        UtilsKt.publishModificationEvent((Project)$project, (KotlinModificationEvent)$modificationEvent);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ModificationEventDirectiveTarget.values().length];
            try {
                nArray[ModificationEventDirectiveTarget.SELF.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModificationEventDirectiveTarget.FALLBACK_DEPENDENCIES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[KotlinModificationEventKind.values().length];
            try {
                nArray[KotlinModificationEventKind.MODULE_STATE_MODIFICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.MODULE_OUT_OF_BLOCK_MODIFICATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.GLOBAL_MODULE_STATE_MODIFICATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.GLOBAL_SOURCE_MODULE_STATE_MODIFICATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.GLOBAL_SCRIPT_MODULE_STATE_MODIFICATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.GLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.CODE_FRAGMENT_CONTEXT_MODIFICATION.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

