/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.targets;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.KotlinDeserializedDeclarationsOrigin;
import org.jetbrains.kotlin.analysis.api.platform.KotlinPlatformSettings;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProvider;
import org.jetbrains.kotlin.analysis.api.platform.declarations.KotlinDeclarationProviderFactoryKt;
import org.jetbrains.kotlin.analysis.test.framework.targets.TestSymbolTarget;
import org.jetbrains.kotlin.analysis.test.framework.targets.TestSymbolTargetResolver;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtScript;
import org.jetbrains.kotlin.psi.KtTypeParameter;
import org.jetbrains.kotlin.psi.KtTypeParameterListOwner;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0012H\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0014H\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0016H\u0014J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/targets/KtElementTestSymbolTargetResolver;", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver;", "Lorg/jetbrains/kotlin/psi/KtElement;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "declarationProvider", "Lorg/jetbrains/kotlin/analysis/api/platform/declarations/KotlinDeclarationProvider;", "resolveClassTarget", "", "target", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ClassTarget;", "resolveClasses", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "resolveScriptTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ScriptTarget;", "resolveTypeAliasTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeAliasTarget;", "resolveCallableTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$CallableTarget;", "resolveTypeParameterTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$TypeParameterTarget;", "owner", "resolveValueParameterTarget", "Lorg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTarget$ValueParameterTarget;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKtElementTestSymbolTargetResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtElementTestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/KtElementTestSymbolTargetResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/TestSymbolTargetResolver\n*L\n1#1,102:1\n1#2:103\n67#3,4:104\n67#3,4:108\n*S KotlinDebug\n*F\n+ 1 KtElementTestSymbolTargetResolver.kt\norg/jetbrains/kotlin/analysis/test/framework/targets/KtElementTestSymbolTargetResolver\n*L\n91#1:104,4\n97#1:108,4\n*E\n"})
public final class KtElementTestSymbolTargetResolver
extends TestSymbolTargetResolver<KtElement> {
    @NotNull
    private final KotlinDeclarationProvider declarationProvider;

    public KtElementTestSymbolTargetResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
        this.declarationProvider = KotlinDeclarationProviderFactoryKt.createDeclarationProvider((Project)project, (GlobalSearchScope)globalSearchScope, null);
        if (!(KotlinPlatformSettings.Companion.getInstance(project).getDeserializedDeclarationsOrigin() == KotlinDeserializedDeclarationsOrigin.STUBS)) {
            boolean bl = false;
            String string = '`' + Reflection.getOrCreateKotlinClass(KtElementTestSymbolTargetResolver.class).getSimpleName() + "` currently relies on stub-indexed binary libraries. See the class's KDoc for more information.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    protected List<KtElement> resolveClassTarget(@NotNull TestSymbolTarget.ClassTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return this.resolveClasses(target.getClassId());
    }

    private final List<KtClassOrObject> resolveClasses(ClassId classId) {
        Collection collection = this.declarationProvider.getAllClassesByClassId(classId);
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(("Cannot find a class `" + classId + "`.").toString());
        }
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @NotNull
    protected List<KtElement> resolveScriptTarget(@NotNull TestSymbolTarget.ScriptTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        KtScript ktScript = target.getFile().getScript();
        if (ktScript == null) {
            throw new IllegalStateException(("The file `" + target.getFile().getName() + "` is not a script.").toString());
        }
        KtScript ktScript2 = ktScript;
        return CollectionsKt.listOf((Object)ktScript2);
    }

    @Override
    @NotNull
    protected List<KtElement> resolveTypeAliasTarget(@NotNull TestSymbolTarget.TypeAliasTarget target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Collection collection = this.declarationProvider.getAllTypeAliasesByClassId(target.getClassId());
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(("Cannot find a type alias `" + target.getClassId() + "`.").toString());
        }
        return CollectionsKt.toList((Iterable)collection);
    }

    @Override
    @NotNull
    protected List<KtElement> resolveCallableTarget(@NotNull TestSymbolTarget.CallableTarget target) {
        List list;
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        CallableId callableId = target.getCallableId();
        ClassId classId = callableId.getClassId();
        if (classId == null) {
            collection = CollectionsKt.createListBuilder();
            List $this$resolveCallableTarget_u24lambda_u240 = collection;
            boolean bl = false;
            $this$resolveCallableTarget_u24lambda_u240.addAll(this.declarationProvider.getTopLevelFunctions(callableId));
            $this$resolveCallableTarget_u24lambda_u240.addAll(this.declarationProvider.getTopLevelProperties(callableId));
            list = CollectionsKt.build((List)collection);
        } else {
            List list2;
            List<KtClassOrObject> classes = this.resolveClasses(classId);
            String string = callableId.getCallableName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            String callableName = string;
            List $this$resolveCallableTarget_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (KtClassOrObject ktClass : classes) {
                for (KtDeclaration member : ktClass.getDeclarations()) {
                    if (!(member instanceof KtCallableDeclaration) && !(member instanceof KtEnumEntry) || !Intrinsics.areEqual((Object)((KtTypeParameterListOwner)member).getName(), (Object)callableName)) continue;
                    $this$resolveCallableTarget_u24lambda_u241.add(member);
                }
            }
            list = CollectionsKt.build((List)list2);
        }
        List callables = list;
        collection = callables;
        if (collection.isEmpty()) {
            boolean bl = false;
            throw new IllegalStateException(("Cannot find a callable `" + callableId + "`.").toString());
        }
        return (List)collection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected KtElement resolveTypeParameterTarget(@NotNull TestSymbolTarget.TypeParameterTarget target, @NotNull KtElement owner) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            TestSymbolTargetResolver testSymbolTargetResolver = this;
            Object object = target;
            KtElement owner$iv = owner;
            boolean $i$f$requireSpecificOwner = false;
            if (!(owner$iv instanceof KtTypeParameterListOwner)) {
                void target$iv;
                boolean $i$a$-require-TestSymbolTargetResolver$requireSpecificOwner$1$iv22 = false;
                String $i$a$-require-TestSymbolTargetResolver$requireSpecificOwner$1$iv22 = "Expected a `" + Reflection.getOrCreateKotlinClass(KtTypeParameterListOwner.class).getSimpleName() + "` owner for `" + target$iv + "`, but found: " + owner$iv + '.';
                throw new IllegalArgumentException($i$a$-require-TestSymbolTargetResolver$requireSpecificOwner$1$iv22.toString());
            }
            List list = ((KtTypeParameterListOwner)owner).getTypeParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTypeParameters(...)");
            object = list;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                KtTypeParameter it = (KtTypeParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)target.getName().asString())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    protected KtElement resolveValueParameterTarget(@NotNull TestSymbolTarget.ValueParameterTarget target, @NotNull KtElement owner) {
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            TestSymbolTargetResolver testSymbolTargetResolver = this;
            Object object = target;
            KtElement owner$iv = owner;
            boolean $i$f$requireSpecificOwner = false;
            if (!(owner$iv instanceof KtCallableDeclaration)) {
                void target$iv;
                boolean $i$a$-require-TestSymbolTargetResolver$requireSpecificOwner$1$iv22 = false;
                String $i$a$-require-TestSymbolTargetResolver$requireSpecificOwner$1$iv22 = "Expected a `" + Reflection.getOrCreateKotlinClass(KtCallableDeclaration.class).getSimpleName() + "` owner for `" + target$iv + "`, but found: " + owner$iv + '.';
                throw new IllegalArgumentException($i$a$-require-TestSymbolTargetResolver$requireSpecificOwner$1$iv22.toString());
            }
            List list = ((KtCallableDeclaration)owner).getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getValueParameters(...)");
            object = list;
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                KtParameter it = (KtParameter)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)target.getName().asString())) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        return v1;
    }
}

