/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractLLSourceStubBasedResolutionTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder")
@TestDataPath(value="$PROJECT_ROOT")
public class LLSourceStubBasedResolutionTestGenerated
extends AbstractLLSourceStubBasedResolutionTest {
    @Test
    public void testAllFilesPresentInRawBuilder() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Nested
    @TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Expressions {
        @Test
        public void testAllFilesPresentInExpressions() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="annotated.kt")
        public void testAnnotated() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/annotated.kt");
        }

        @Test
        @TestMetadata(value="arrayAccess.kt")
        public void testArrayAccess() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/arrayAccess.kt");
        }

        @Test
        @TestMetadata(value="arrayAssignment.kt")
        public void testArrayAssignment() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/arrayAssignment.kt");
        }

        @Test
        @TestMetadata(value="branches.kt")
        public void testBranches() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/branches.kt");
        }

        @Test
        @TestMetadata(value="callableReferences.kt")
        public void testCallableReferences() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/callableReferences.kt");
        }

        @Test
        @TestMetadata(value="calls.kt")
        public void testCalls() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/calls.kt");
        }

        @Test
        @TestMetadata(value="cascadeIf.kt")
        public void testCascadeIf() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/cascadeIf.kt");
        }

        @Test
        @TestMetadata(value="classReference.kt")
        public void testClassReference() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/classReference.kt");
        }

        @Test
        @TestMetadata(value="collectionLiterals.kt")
        public void testCollectionLiterals() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/collectionLiterals.kt");
        }

        @Test
        @TestMetadata(value="destructuring.kt")
        public void testDestructuring() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/destructuring.kt");
        }

        @Test
        @TestMetadata(value="for.kt")
        public void testFor() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/for.kt");
        }

        @Test
        @TestMetadata(value="genericCalls.kt")
        public void testGenericCalls() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/genericCalls.kt");
        }

        @Test
        @TestMetadata(value="in.kt")
        public void testIn() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/in.kt");
        }

        @Test
        @TestMetadata(value="inBrackets.kt")
        public void testInBrackets() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/inBrackets.kt");
        }

        @Test
        @TestMetadata(value="init.kt")
        public void testInit() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/init.kt");
        }

        @Test
        @TestMetadata(value="invalidWhen.kt")
        public void testInvalidWhen() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/invalidWhen.kt");
        }

        @Test
        @TestMetadata(value="labelForInfix.kt")
        public void testLabelForInfix() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/labelForInfix.kt");
        }

        @Test
        @TestMetadata(value="lambda.kt")
        public void testLambda() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/lambda.kt");
        }

        @Test
        @TestMetadata(value="lambdaAndAnonymousFunction.kt")
        public void testLambdaAndAnonymousFunction() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/lambdaAndAnonymousFunction.kt");
        }

        @Test
        @TestMetadata(value="localDeclarationWithExpression.kt")
        public void testLocalDeclarationWithExpression() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/localDeclarationWithExpression.kt");
        }

        @Test
        @TestMetadata(value="locals.kt")
        public void testLocals() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/locals.kt");
        }

        @Test
        @TestMetadata(value="modifications.kt")
        public void testModifications() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/modifications.kt");
        }

        @Test
        @TestMetadata(value="namedArgument.kt")
        public void testNamedArgument() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/namedArgument.kt");
        }

        @Test
        @TestMetadata(value="nullability.kt")
        public void testNullability() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/nullability.kt");
        }

        @Test
        @TestMetadata(value="parenthesizedSafeCallsAndOperators.kt")
        public void testParenthesizedSafeCallsAndOperators() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/parenthesizedSafeCallsAndOperators.kt");
        }

        @Test
        @TestMetadata(value="qualifierWithTypeArguments.kt")
        public void testQualifierWithTypeArguments() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/qualifierWithTypeArguments.kt");
        }

        @Test
        @TestMetadata(value="safeCallsImplicitWithInvoke.kt")
        public void testSafeCallsImplicitWithInvoke() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/safeCallsImplicitWithInvoke.kt");
        }

        @Test
        @TestMetadata(value="safeCallsWithAssignment.kt")
        public void testSafeCallsWithAssignment() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/safeCallsWithAssignment.kt");
        }

        @Test
        @TestMetadata(value="safeCallsWithAugmentedAssignment.kt")
        public void testSafeCallsWithAugmentedAssignment() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/safeCallsWithAugmentedAssignment.kt");
        }

        @Test
        @TestMetadata(value="safeCallsWithUnaryOperators.kt")
        public void testSafeCallsWithUnaryOperators() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/safeCallsWithUnaryOperators.kt");
        }

        @Test
        @TestMetadata(value="simpleReturns.kt")
        public void testSimpleReturns() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/simpleReturns.kt");
        }

        @Test
        @TestMetadata(value="super.kt")
        public void testSuper() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/super.kt");
        }

        @Test
        @TestMetadata(value="suspendLambda.kt")
        public void testSuspendLambda() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/suspendLambda.kt");
        }

        @Test
        @TestMetadata(value="these.kt")
        public void testThese() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/these.kt");
        }

        @Test
        @TestMetadata(value="try.kt")
        public void testTry() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/try.kt");
        }

        @Test
        @TestMetadata(value="typeOperators.kt")
        public void testTypeOperators() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/typeOperators.kt");
        }

        @Test
        @TestMetadata(value="unary.kt")
        public void testUnary() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/unary.kt");
        }

        @Test
        @TestMetadata(value="variables.kt")
        public void testVariables() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/variables.kt");
        }

        @Test
        @TestMetadata(value="whenGuards.kt")
        public void testWhenGuards() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/whenGuards.kt");
        }

        @Test
        @TestMetadata(value="while.kt")
        public void testWhile() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/while.kt");
        }

        @Nested
        @TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/invalidCode")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InvalidCode {
            @Test
            public void testAllFilesPresentInInvalidCode() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/invalidCode"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="longStringTemplateEntryInvalidCharacters.kt")
            public void testLongStringTemplateEntryInvalidCharacters() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/invalidCode/longStringTemplateEntryInvalidCharacters.kt");
            }

            @Test
            @TestMetadata(value="longStringTemplateEntryWithTwoExpressions.kt")
            public void testLongStringTemplateEntryWithTwoExpressions() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/expressions/invalidCode/longStringTemplateEntryWithTwoExpressions.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Declarations {
        @Test
        public void testAllFilesPresentInDeclarations() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="annotation.kt")
        public void testAnnotation() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotation.kt");
        }

        @Test
        @TestMetadata(value="annotationArguments.kt")
        public void testAnnotationArguments() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationArguments.kt");
        }

        @Test
        @TestMetadata(value="annotationOnContextParameters.kt")
        public void testAnnotationOnContextParameters() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationOnContextParameters.kt");
        }

        @Test
        @TestMetadata(value="annotationOnDelegatedInterface.kt")
        public void testAnnotationOnDelegatedInterface() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationOnDelegatedInterface.kt");
        }

        @Test
        @TestMetadata(value="annotationOnField.kt")
        public void testAnnotationOnField() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationOnField.kt");
        }

        @Test
        @TestMetadata(value="annotationOnProperty.kt")
        public void testAnnotationOnProperty() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationOnProperty.kt");
        }

        @Test
        @TestMetadata(value="annotationOnReceiver.kt")
        public void testAnnotationOnReceiver() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationOnReceiver.kt");
        }

        @Test
        @TestMetadata(value="annotationOnSuperType.kt")
        public void testAnnotationOnSuperType() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationOnSuperType.kt");
        }

        @Test
        @TestMetadata(value="annotationOnSuperTypeCall.kt")
        public void testAnnotationOnSuperTypeCall() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationOnSuperTypeCall.kt");
        }

        @Test
        @TestMetadata(value="annotationOnTypeParameterInWhereClause.kt")
        public void testAnnotationOnTypeParameterInWhereClause() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationOnTypeParameterInWhereClause.kt");
        }

        @Test
        @TestMetadata(value="annotationsOnNullableParenthesizedTypes.kt")
        public void testAnnotationsOnNullableParenthesizedTypes() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationsOnNullableParenthesizedTypes.kt");
        }

        @Test
        @TestMetadata(value="annotationsOnParenthesizedTypes.kt")
        public void testAnnotationsOnParenthesizedTypes() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/annotationsOnParenthesizedTypes.kt");
        }

        @Test
        @TestMetadata(value="anonymousObjectWithAnnotation.kt")
        public void testAnonymousObjectWithAnnotation() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/anonymousObjectWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="classLevelDestructuringWithAnnotation.kt")
        public void testClassLevelDestructuringWithAnnotation() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/classLevelDestructuringWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="classWithWrongSuperCall.kt")
        public void testClassWithWrongSuperCall() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/classWithWrongSuperCall.kt");
        }

        @Test
        @TestMetadata(value="complexTypes.kt")
        public void testComplexTypes() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/complexTypes.kt");
        }

        @Test
        @TestMetadata(value="constructorInObject.kt")
        public void testConstructorInObject() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/constructorInObject.kt");
        }

        @Test
        @TestMetadata(value="constructorOfAnonymousObject.kt")
        public void testConstructorOfAnonymousObject() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/constructorOfAnonymousObject.kt");
        }

        @Test
        @TestMetadata(value="constructorWithAnnotations.kt")
        public void testConstructorWithAnnotations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/constructorWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="constructorWithLocalDeclarations.kt")
        public void testConstructorWithLocalDeclarations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/constructorWithLocalDeclarations.kt");
        }

        @Test
        @TestMetadata(value="contextParameterDefaultValue.kt")
        public void testContextParameterDefaultValue() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contextParameterDefaultValue.kt");
        }

        @Test
        @TestMetadata(value="contextParameters.kt")
        public void testContextParameters() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contextParameters.kt");
        }

        @Test
        @TestMetadata(value="contextReceivers.kt")
        public void testContextReceivers() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contextReceivers.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationOnMemberClass.kt")
        public void testDanglingAnnotationOnMemberClass() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingAnnotationOnMemberClass.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationOnMemberFunction.kt")
        public void testDanglingAnnotationOnMemberFunction() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingAnnotationOnMemberFunction.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationOnMemberProperty.kt")
        public void testDanglingAnnotationOnMemberProperty() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingAnnotationOnMemberProperty.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationOnTopLevelClass.kt")
        public void testDanglingAnnotationOnTopLevelClass() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingAnnotationOnTopLevelClass.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationOnTopLevelFunction.kt")
        public void testDanglingAnnotationOnTopLevelFunction() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingAnnotationOnTopLevelFunction.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationOnTopLevelProperty.kt")
        public void testDanglingAnnotationOnTopLevelProperty() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingAnnotationOnTopLevelProperty.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationsClassLevel.kt")
        public void testDanglingAnnotationsClassLevel() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingAnnotationsClassLevel.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationsFileLevel.kt")
        public void testDanglingAnnotationsFileLevel() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingAnnotationsFileLevel.kt");
        }

        @Test
        @TestMetadata(value="danglingConstrants.kt")
        public void testDanglingConstrants() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingConstrants.kt");
        }

        @Test
        @TestMetadata(value="danglingModifierInsideEnumEntry.kt")
        public void testDanglingModifierInsideEnumEntry() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/danglingModifierInsideEnumEntry.kt");
        }

        @Test
        @TestMetadata(value="dataClassWithAnnotations.kt")
        public void testDataClassWithAnnotations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/dataClassWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="delegatedFieldNestedName.kt")
        public void testDelegatedFieldNestedName() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/delegatedFieldNestedName.kt");
        }

        @Test
        @TestMetadata(value="delegates.kt")
        public void testDelegates() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/delegates.kt");
        }

        @Test
        @TestMetadata(value="delegatesWithAnnotations.kt")
        public void testDelegatesWithAnnotations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/delegatesWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="derivedClass.kt")
        public void testDerivedClass() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/derivedClass.kt");
        }

        @Test
        @TestMetadata(value="emptyAnonymousObject.kt")
        public void testEmptyAnonymousObject() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/emptyAnonymousObject.kt");
        }

        @Test
        @TestMetadata(value="enumEntryWithAnnotations.kt")
        public void testEnumEntryWithAnnotations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/enumEntryWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="enums.kt")
        public void testEnums() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/enums.kt");
        }

        @Test
        @TestMetadata(value="enums2.kt")
        public void testEnums2() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/enums2.kt");
        }

        @Test
        @TestMetadata(value="enums3.kt")
        public void testEnums3() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/enums3.kt");
        }

        @Test
        @TestMetadata(value="expectActual.kt")
        public void testExpectActual() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/expectActual.kt");
        }

        @Test
        @TestMetadata(value="expectClassesAndFunctions.kt")
        public void testExpectClassesAndFunctions() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/expectClassesAndFunctions.kt");
        }

        @Test
        @TestMetadata(value="expectNestedAnnotationClassWithConstructorParameter.kt")
        public void testExpectNestedAnnotationClassWithConstructorParameter() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/expectNestedAnnotationClassWithConstructorParameter.kt");
        }

        @Test
        @TestMetadata(value="expectNestedClassMembers.kt")
        public void testExpectNestedClassMembers() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/expectNestedClassMembers.kt");
        }

        @Test
        @TestMetadata(value="expectNestedEnumClassGeneratedMembers.kt")
        public void testExpectNestedEnumClassGeneratedMembers() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/expectNestedEnumClassGeneratedMembers.kt");
        }

        @Test
        @TestMetadata(value="external.kt")
        public void testExternal() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/external.kt");
        }

        @Test
        @TestMetadata(value="F.kt")
        public void testF() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/F.kt");
        }

        @Test
        @TestMetadata(value="fileAnnotations.kt")
        public void testFileAnnotations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/fileAnnotations.kt");
        }

        @Test
        @TestMetadata(value="fileAnnotationsWithoutPackage.kt")
        public void testFileAnnotationsWithoutPackage() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/fileAnnotationsWithoutPackage.kt");
        }

        @Test
        @TestMetadata(value="functionTypes.kt")
        public void testFunctionTypes() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/functionTypes.kt");
        }

        @Test
        @TestMetadata(value="functionWithAnnotations.kt")
        public void testFunctionWithAnnotations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/functionWithAnnotations.kt");
        }

        @Test
        @TestMetadata(value="genericFunctions.kt")
        public void testGenericFunctions() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/genericFunctions.kt");
        }

        @Test
        @TestMetadata(value="genericProperty.kt")
        public void testGenericProperty() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/genericProperty.kt");
        }

        @Test
        @TestMetadata(value="importAlias.kt")
        public void testImportAlias() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/importAlias.kt");
        }

        @Test
        @TestMetadata(value="incompletePropertyWithDelegate.kt")
        public void testIncompletePropertyWithDelegate() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/incompletePropertyWithDelegate.kt");
        }

        @Test
        @TestMetadata(value="initBlockWithDeclarations.kt")
        public void testInitBlockWithDeclarations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/initBlockWithDeclarations.kt");
        }

        @Test
        @TestMetadata(value="initWithLocalDeclarations.kt")
        public void testInitWithLocalDeclarations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/initWithLocalDeclarations.kt");
        }

        @Test
        @TestMetadata(value="invalidDestructing.kt")
        public void testInvalidDestructing() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidDestructing.kt");
        }

        @Test
        @TestMetadata(value="kotlinAny.kt")
        public void testKotlinAny() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/kotlinAny.kt");
        }

        @Test
        @TestMetadata(value="kotlinAnyNonTopLevel.kt")
        public void testKotlinAnyNonTopLevel() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/kotlinAnyNonTopLevel.kt");
        }

        @Test
        @TestMetadata(value="localAnnotations.kt")
        public void testLocalAnnotations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/localAnnotations.kt");
        }

        @Test
        @TestMetadata(value="localDeclarationsInEnumEntry.kt")
        public void testLocalDeclarationsInEnumEntry() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/localDeclarationsInEnumEntry.kt");
        }

        @Test
        @TestMetadata(value="localImplicitType.kt")
        public void testLocalImplicitType() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/localImplicitType.kt");
        }

        @Test
        @TestMetadata(value="multiDeclarations.kt")
        public void testMultiDeclarations() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/multiDeclarations.kt");
        }

        @Test
        @TestMetadata(value="nestedClass.kt")
        public void testNestedClass() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/nestedClass.kt");
        }

        @Test
        @TestMetadata(value="NestedOfAliasedType.kt")
        public void testNestedOfAliasedType() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/NestedOfAliasedType.kt");
        }

        @Test
        @TestMetadata(value="NestedSuperType.kt")
        public void testNestedSuperType() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/NestedSuperType.kt");
        }

        @Test
        @TestMetadata(value="noPrimaryConstructor.kt")
        public void testNoPrimaryConstructor() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noPrimaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorWithoutConstructorKeyword.kt")
        public void testPrimaryConstructorWithoutConstructorKeyword() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/primaryConstructorWithoutConstructorKeyword.kt");
        }

        @Test
        @TestMetadata(value="propertyWithBackingField.kt")
        public void testPropertyWithBackingField() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/propertyWithBackingField.kt");
        }

        @Test
        @TestMetadata(value="propertyWithBackingFieldDifferentTypes.kt")
        public void testPropertyWithBackingFieldDifferentTypes() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/propertyWithBackingFieldDifferentTypes.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructor.kt")
        public void testSecondaryConstructor() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/secondaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="simpleClass.kt")
        public void testSimpleClass() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/simpleClass.kt");
        }

        @Test
        @TestMetadata(value="simpleFun.kt")
        public void testSimpleFun() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/simpleFun.kt");
        }

        @Test
        @TestMetadata(value="simpleTypeAlias.kt")
        public void testSimpleTypeAlias() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/simpleTypeAlias.kt");
        }

        @Test
        @TestMetadata(value="splitModifierList.kt")
        public void testSplitModifierList() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/splitModifierList.kt");
        }

        @Test
        @TestMetadata(value="suspendFunctionTypes.kt")
        public void testSuspendFunctionTypes() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/suspendFunctionTypes.kt");
        }

        @Test
        @TestMetadata(value="targetAnnotationWithDifferentValues.kt")
        public void testTargetAnnotationWithDifferentValues() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/targetAnnotationWithDifferentValues.kt");
        }

        @Test
        @TestMetadata(value="topLevelDestructuringWithAnnotation.kt")
        public void testTopLevelDestructuringWithAnnotation() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/topLevelDestructuringWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="topLevelDestructuringWithoutInitializer.kt")
        public void testTopLevelDestructuringWithoutInitializer() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/topLevelDestructuringWithoutInitializer.kt");
        }

        @Test
        @TestMetadata(value="typeAliasWithGeneric.kt")
        public void testTypeAliasWithGeneric() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/typeAliasWithGeneric.kt");
        }

        @Test
        @TestMetadata(value="typeParameterVsNested.kt")
        public void testTypeParameterVsNested() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/typeParameterVsNested.kt");
        }

        @Test
        @TestMetadata(value="typeParameters.kt")
        public void testTypeParameters() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/typeParameters.kt");
        }

        @Test
        @TestMetadata(value="userAny.kt")
        public void testUserAny() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/userAny.kt");
        }

        @Test
        @TestMetadata(value="where.kt")
        public void testWhere() {
            LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/where.kt");
        }

        @Nested
        @TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType")
        @TestDataPath(value="$PROJECT_ROOT")
        public class NoParameterType {
            @Test
            public void testAllFilesPresentInNoParameterType() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="noParameterTypRefInCatch.kt")
            public void testNoParameterTypRefInCatch() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInCatch.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInFuncionalType.kt")
            public void testNoParameterTypRefInFuncionalType() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInFuncionalType.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInFunction.kt")
            public void testNoParameterTypRefInFunction() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInFunction.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInLambda.kt")
            public void testNoParameterTypRefInLambda() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInLambda.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInPrimaryConstructor.kt")
            public void testNoParameterTypRefInPrimaryConstructor() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInPrimaryConstructor.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInPrimaryConstructorWithVararg.kt")
            public void testNoParameterTypRefInPrimaryConstructorWithVararg() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInPrimaryConstructorWithVararg.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInPrimaryConsturctorVal.kt")
            public void testNoParameterTypRefInPrimaryConsturctorVal() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInPrimaryConsturctorVal.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInPrimaryConsturctorValWithVararg.kt")
            public void testNoParameterTypRefInPrimaryConsturctorValWithVararg() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInPrimaryConsturctorValWithVararg.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInSecondaryConstructor.kt")
            public void testNoParameterTypRefInSecondaryConstructor() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInSecondaryConstructor.kt");
            }

            @Test
            @TestMetadata(value="noParameterTypRefInSetter.kt")
            public void testNoParameterTypRefInSetter() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/noParameterTypRefInSetter.kt");
            }

            @Test
            @TestMetadata(value="uncompletedTypRefInPrimaryConstructorWithVararg.kt")
            public void testUncompletedTypRefInPrimaryConstructorWithVararg() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/uncompletedTypRefInPrimaryConstructorWithVararg.kt");
            }

            @Test
            @TestMetadata(value="uncompletedTypRefInPrimaryConsturctorValWithVararg.kt")
            public void testUncompletedTypRefInPrimaryConsturctorValWithVararg() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/noParameterType/uncompletedTypRefInPrimaryConsturctorValWithVararg.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InvalidCode {
            @Test
            public void testAllFilesPresentInInvalidCode() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="annotationArgumentLocalDeclarations.kt")
            public void testAnnotationArgumentLocalDeclarations() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode/annotationArgumentLocalDeclarations.kt");
            }

            @Test
            @TestMetadata(value="contextParameterOnErrorPrimaryConstructor.kt")
            public void testContextParameterOnErrorPrimaryConstructor() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode/contextParameterOnErrorPrimaryConstructor.kt");
            }

            @Test
            @TestMetadata(value="danglingContextParameter.kt")
            public void testDanglingContextParameter() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode/danglingContextParameter.kt");
            }

            @Test
            @TestMetadata(value="danglingContextParameterAndAnnotations.kt")
            public void testDanglingContextParameterAndAnnotations() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode/danglingContextParameterAndAnnotations.kt");
            }

            @Test
            @TestMetadata(value="destructuringInsideCallChain.kt")
            public void testDestructuringInsideCallChain() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode/destructuringInsideCallChain.kt");
            }

            @Test
            @TestMetadata(value="duplicatedContextParameter.kt")
            public void testDuplicatedContextParameter() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode/duplicatedContextParameter.kt");
            }

            @Test
            @TestMetadata(value="setterWithNoBodyAndDifferentValueParameterType.kt")
            public void testSetterWithNoBodyAndDifferentValueParameterType() {
                LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/invalidCode/setterWithNoBodyAndDifferentValueParameterType.kt");
            }
        }

        @Nested
        @TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Contracts {
            @Test
            public void testAllFilesPresentInContracts() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Nested
            @TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts/oldSyntax")
            @TestDataPath(value="$PROJECT_ROOT")
            public class OldSyntax {
                @Test
                public void testAllFilesPresentInOldSyntax() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts/oldSyntax"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="contractDescription.kt")
                public void testContractDescription() {
                    LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts/oldSyntax/contractDescription.kt");
                }
            }

            @Nested
            @TestMetadata(value="compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts/newSyntax")
            @TestDataPath(value="$PROJECT_ROOT")
            public class NewSyntax {
                @Test
                public void testAllFilesPresentInNewSyntax() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts/newSyntax"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="functionWithBothOldAndNewSyntaxContractDescription.kt")
                public void testFunctionWithBothOldAndNewSyntaxContractDescription() {
                    LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts/newSyntax/functionWithBothOldAndNewSyntaxContractDescription.kt");
                }

                @Test
                @TestMetadata(value="propertyAccessorsContractDescription.kt")
                public void testPropertyAccessorsContractDescription() {
                    LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts/newSyntax/propertyAccessorsContractDescription.kt");
                }

                @Test
                @TestMetadata(value="simpleFunctionsContractDescription.kt")
                public void testSimpleFunctionsContractDescription() {
                    LLSourceStubBasedResolutionTestGenerated.this.runTest("compiler/fir/raw-fir/psi2fir/testData/rawBuilder/declarations/contracts/newSyntax/simpleFunctionsContractDescription.kt");
                }
            }
        }
    }
}

