/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.annotations.KaAnnotation;
import org.jetbrains.kotlin.analysis.api.symbols.DebugSymbolRenderer;
import org.jetbrains.kotlin.analysis.api.symbols.markers.KaAnnotatedSymbol;
import org.jetbrains.kotlin.analysis.utils.printer.PrettyPrinter;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u0000 \u0014*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0003\u0012\u0013\u0014B\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J \u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0019\u0010\r\u001a\u00028\u0000*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&\u00a2\u0006\u0002\u0010\u000eJ\u0019\u0010\u000f\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\u0010\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u0011\u0082\u0001\u0002\u0015\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery;", "O", "", "<init>", "()V", "performAndRender", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol;", "intermediateStep", "Lkotlin/Function0;", "", "perform", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol;)Ljava/lang/Object;", "renderOutput", "output", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Ljava/lang/Object;)Ljava/lang/String;", "Contains", "CollectionQuery", "Companion", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$Contains;", "low-level-api-fir_test"})
abstract class AnnotationQuery<O> {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private AnnotationQuery() {
    }

    @NotNull
    public final String performAndRender(@NotNull KaSession $this$performAndRender, @NotNull KaAnnotatedSymbol symbol, @NotNull Function0<Unit> intermediateStep) {
        Intrinsics.checkNotNullParameter((Object)$this$performAndRender, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter(intermediateStep, (String)"intermediateStep");
        O output = this.perform($this$performAndRender, symbol);
        intermediateStep.invoke();
        return this.renderOutput($this$performAndRender, output);
    }

    @NotNull
    public abstract O perform(@NotNull KaSession var1, @NotNull KaAnnotatedSymbol var2);

    @NotNull
    public abstract String renderOutput(@NotNull KaSession var1, @NotNull O var2);

    public /* synthetic */ AnnotationQuery(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0003:\u0002\u000e\u000fB\t\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004J\u0019\u0010\u000b\u001a\u00020\b*\u00020\t2\u0006\u0010\f\u001a\u00028\u0001H&\u00a2\u0006\u0002\u0010\r\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery;", "O", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery;", "", "<init>", "()V", "renderOutput", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "output", "renderElementOutput", "element", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Ljava/lang/Object;)Ljava/lang/String;", "AnnotationQuery", "ClassIds", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$AnnotationQuery;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$ClassIds;", "low-level-api-fir_test"})
    @SourceDebugExtension(value={"SMAP\nAbstractLazyAnnotationsResolveTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractLazyAnnotationsResolveTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery\n+ 2 PrettyPrinter.kt\norg/jetbrains/kotlin/analysis/utils/printer/PrettyPrinterKt\n+ 3 PrettyPrinter.kt\norg/jetbrains/kotlin/analysis/utils/printer/PrettyPrinter\n*L\n1#1,213:1\n212#2:214\n92#3,17:215\n*S KotlinDebug\n*F\n+ 1 AbstractLazyAnnotationsResolveTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery\n*L\n157#1:214\n163#1:215,17\n*E\n"})
    public static abstract class CollectionQuery<O>
    extends org.jetbrains.kotlin.analysis.low.level.api.fir.AnnotationQuery<Collection<? extends O>> {
        private CollectionQuery() {
            super(null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public final String renderOutput(@NotNull KaSession $this$renderOutput, @NotNull Collection<? extends O> output) {
            PrettyPrinter prettyPrinter;
            Intrinsics.checkNotNullParameter((Object)$this$renderOutput, (String)"<this>");
            Intrinsics.checkNotNullParameter(output, (String)"output");
            boolean $i$f$prettyPrint = false;
            PrettyPrinter $this$renderOutput_u24lambda_u241 = prettyPrinter = new PrettyPrinter(0, 1, null);
            boolean bl = false;
            if (output.isEmpty()) {
                $this$renderOutput_u24lambda_u241.append((CharSequence)"[]");
            } else {
                void collection$iv;
                void $this$iv;
                PrettyPrinter prettyPrinter2 = $this$renderOutput_u24lambda_u241;
                Iterable iterable = output;
                String separator$iv = "\n\n";
                String prefix$iv = "";
                String postfix$iv = "";
                boolean $i$f$printCollection = false;
                $this$iv.append((CharSequence)prefix$iv);
                Iterator iterator$iv = collection$iv.iterator();
                while (iterator$iv.hasNext()) {
                    void element;
                    Object t = iterator$iv.next();
                    void $this$renderOutput_u24lambda_u241_u24lambda_u240 = $this$iv;
                    boolean bl2 = false;
                    $this$renderOutput_u24lambda_u241_u24lambda_u240.append((CharSequence)this.renderElementOutput($this$renderOutput, element));
                    if (!iterator$iv.hasNext()) continue;
                    $this$iv.append((CharSequence)separator$iv);
                }
                $this$iv.append((CharSequence)postfix$iv);
            }
            return prettyPrinter.toString();
        }

        @NotNull
        public abstract String renderElementOutput(@NotNull KaSession var1, @NotNull O var2);

        public /* synthetic */ CollectionQuery(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\t\nB\t\b\u0004\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002\u0082\u0001\u0002\u000b\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$AnnotationQuery;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery;", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotation;", "<init>", "()V", "renderElementOutput", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "element", "Annotations", "Get", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$AnnotationQuery$Annotations;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$AnnotationQuery$Get;", "low-level-api-fir_test"})
        public static abstract class AnnotationQuery
        extends CollectionQuery<KaAnnotation> {
            private AnnotationQuery() {
                super(null);
            }

            @Override
            @NotNull
            public final String renderElementOutput(@NotNull KaSession $this$renderElementOutput, @NotNull KaAnnotation element) {
                Intrinsics.checkNotNullParameter((Object)$this$renderElementOutput, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return new DebugSymbolRenderer(false, false, false, false, 15, null).renderAnnotationApplication($this$renderElementOutput, element);
            }

            public /* synthetic */ AnnotationQuery(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$AnnotationQuery$Annotations;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$AnnotationQuery;", "<init>", "()V", "perform", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotation;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol;", "low-level-api-fir_test"})
            public static final class Annotations
            extends AnnotationQuery {
                @NotNull
                public static final Annotations INSTANCE = new Annotations();

                private Annotations() {
                    super(null);
                }

                @Override
                @NotNull
                public List<KaAnnotation> perform(@NotNull KaSession $this$perform, @NotNull KaAnnotatedSymbol symbol) {
                    Intrinsics.checkNotNullParameter((Object)$this$perform, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                    return (List)symbol.getAnnotations();
                }
            }

            @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$AnnotationQuery$Get;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$AnnotationQuery;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "perform", "", "Lorg/jetbrains/kotlin/analysis/api/annotations/KaAnnotation;", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol;", "low-level-api-fir_test"})
            public static final class Get
            extends AnnotationQuery {
                @NotNull
                private final ClassId classId;

                public Get(@NotNull ClassId classId) {
                    Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
                    super(null);
                    this.classId = classId;
                }

                @NotNull
                public final ClassId getClassId() {
                    return this.classId;
                }

                @Override
                @NotNull
                public List<KaAnnotation> perform(@NotNull KaSession $this$perform, @NotNull KaAnnotatedSymbol symbol) {
                    Intrinsics.checkNotNullParameter((Object)$this$perform, (String)"<this>");
                    Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                    return symbol.getAnnotations().get(this.classId);
                }
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\u000b*\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery$ClassIds;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$CollectionQuery;", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "()V", "perform", "", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol;", "renderElementOutput", "", "element", "low-level-api-fir_test"})
        public static final class ClassIds
        extends CollectionQuery<ClassId> {
            @NotNull
            public static final ClassIds INSTANCE = new ClassIds();

            private ClassIds() {
                super(null);
            }

            @Override
            @NotNull
            public Collection<ClassId> perform(@NotNull KaSession $this$perform, @NotNull KaAnnotatedSymbol symbol) {
                Intrinsics.checkNotNullParameter((Object)$this$perform, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
                return symbol.getAnnotations().getClassIds();
            }

            @Override
            @NotNull
            public String renderElementOutput(@NotNull KaSession $this$renderElementOutput, @NotNull ClassId element) {
                Intrinsics.checkNotNullParameter((Object)$this$renderElementOutput, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                return element.toString();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$Companion;", "", "<init>", "()V", "create", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery;", "query", "", "low-level-api-fir_test"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AnnotationQuery<?> create(@NotNull String query) {
            AnnotationQuery annotationQuery;
            Intrinsics.checkNotNullParameter((Object)query, (String)"query");
            String key = StringsKt.substringBefore$default((String)query, (String)":", null, (int)2, null);
            String value = ((Object)StringsKt.trim((CharSequence)StringsKt.substringAfter$default((String)query, (String)":", null, (int)2, null))).toString();
            switch (key) {
                case "contains": {
                    annotationQuery = new Contains(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)value, (boolean)false, (int)2, null));
                    break;
                }
                case "classIds": {
                    annotationQuery = CollectionQuery.ClassIds.INSTANCE;
                    break;
                }
                case "annotations": {
                    annotationQuery = CollectionQuery.AnnotationQuery.Annotations.INSTANCE;
                    break;
                }
                case "get": {
                    annotationQuery = new CollectionQuery.AnnotationQuery.Get(ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)value, (boolean)false, (int)2, null));
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unknown query: " + query).toString());
                }
            }
            return annotationQuery;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0019\u0010\t\u001a\u00020\u0002*\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\u00020\u000f*\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery$Contains;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/AnnotationQuery;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "perform", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "symbol", "Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol;", "(Lorg/jetbrains/kotlin/analysis/api/KaSession;Lorg/jetbrains/kotlin/analysis/api/symbols/markers/KaAnnotatedSymbol;)Ljava/lang/Boolean;", "renderOutput", "", "output", "low-level-api-fir_test"})
    public static final class Contains
    extends AnnotationQuery<Boolean> {
        @NotNull
        private final ClassId classId;

        public Contains(@NotNull ClassId classId) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            super(null);
            this.classId = classId;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Override
        @NotNull
        public Boolean perform(@NotNull KaSession $this$perform, @NotNull KaAnnotatedSymbol symbol) {
            Intrinsics.checkNotNullParameter((Object)$this$perform, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
            return symbol.getAnnotations().contains(this.classId);
        }

        @Override
        @NotNull
        public String renderOutput(@NotNull KaSession $this$renderOutput, boolean output) {
            Intrinsics.checkNotNullParameter((Object)$this$renderOutput, (String)"<this>");
            return String.valueOf(output);
        }
    }
}

