/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.TargetPlatformDirectives;
import org.jetbrains.kotlin.analysis.test.framework.services.TargetPlatformEnum;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatforms;
import org.jetbrains.kotlin.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.platform.konan.NativePlatforms;
import org.jetbrains.kotlin.platform.wasm.WasmPlatforms;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.DefaultsProviderKt;
import org.jetbrains.kotlin.test.services.TargetPlatformProvider;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/TargetPlatformProviderForAnalysisApiTests;", "Lorg/jetbrains/kotlin/test/services/TargetPlatformProvider;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "getTestServices", "()Lorg/jetbrains/kotlin/test/services/TestServices;", "getTargetPlatform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "module", "Lorg/jetbrains/kotlin/test/model/TestModule;", "parseModulePlatformByName", "moduleName", "", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nTargetPlatformSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TargetPlatformSupport.kt\norg/jetbrains/kotlin/analysis/test/framework/services/TargetPlatformProviderForAnalysisApiTests\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1563#2:88\n1634#2,3:89\n1460#2,5:92\n*S KotlinDebug\n*F\n+ 1 TargetPlatformSupport.kt\norg/jetbrains/kotlin/analysis/test/framework/services/TargetPlatformProviderForAnalysisApiTests\n*L\n60#1:88\n60#1:89,3\n69#1:92,5\n*E\n"})
public final class TargetPlatformProviderForAnalysisApiTests
extends TargetPlatformProvider {
    @NotNull
    private final TestServices testServices;

    public TargetPlatformProviderForAnalysisApiTests(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        this.testServices = testServices;
    }

    @NotNull
    public final TestServices getTestServices() {
        return this.testServices;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public TargetPlatform getTargetPlatform(@NotNull TestModule module) {
        TargetPlatform targetPlatform;
        Collection $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        List explicitlyDeclaredPlatforms = module.getDirectives().get(TargetPlatformDirectives.INSTANCE.getTARGET_PLATFORM());
        Iterable $this$map$iv = explicitlyDeclaredPlatforms;
        boolean $i$f$map2 = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TargetPlatformEnum targetPlatformEnum = (TargetPlatformEnum)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTargetPlatform());
        }
        List platforms = (List)destination$iv$iv;
        switch (platforms.size()) {
            case 0: {
                targetPlatform = this.parseModulePlatformByName(module.getName());
                if (targetPlatform != null) break;
                targetPlatform = DefaultsProviderKt.getDefaultsProvider((TestServices)this.testServices).getTargetPlatform();
                break;
            }
            case 1: {
                targetPlatform = (TargetPlatform)CollectionsKt.single((List)platforms);
                break;
            }
            default: {
                void destination$iv;
                void $this$flatMapTo$iv;
                if (explicitlyDeclaredPlatforms.contains((Object)TargetPlatformEnum.Common)) {
                    AssertionsKt.getAssertions((TestServices)this.testServices).fail(TargetPlatformProviderForAnalysisApiTests::getTargetPlatform$lambda$1);
                    throw new KotlinNothingValueException();
                }
                Iterable $i$f$map2 = platforms;
                $this$mapTo$iv$iv = new LinkedHashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    TargetPlatform it = (TargetPlatform)element$iv;
                    boolean bl = false;
                    Iterable list$iv = it.getComponentPlatforms();
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                Set set = (Set)destination$iv;
                targetPlatform = new TargetPlatform(set);
            }
        }
        return targetPlatform;
    }

    private final TargetPlatform parseModulePlatformByName(String moduleName) {
        TargetPlatform targetPlatform;
        String string = StringsKt.substringAfterLast((String)moduleName, (String)"-", (String)"").toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
        String nameSuffix = string;
        if (Intrinsics.areEqual((Object)nameSuffix, (Object)"COMMON")) {
            targetPlatform = CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
        } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"JVM")) {
            targetPlatform = JvmPlatforms.INSTANCE.getUnspecifiedJvmPlatform();
        } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"JS")) {
            targetPlatform = JsPlatforms.INSTANCE.getDefaultJsPlatform();
        } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"WASM")) {
            targetPlatform = WasmPlatforms.INSTANCE.getWasmJs();
        } else if (Intrinsics.areEqual((Object)nameSuffix, (Object)"NATIVE")) {
            targetPlatform = NativePlatforms.INSTANCE.getUnspecifiedNativePlatform();
        } else if (((CharSequence)nameSuffix).length() == 0) {
            targetPlatform = null;
        } else {
            throw new IllegalStateException("Can't determine platform by name " + nameSuffix);
        }
        return targetPlatform;
    }

    private static final String getTargetPlatform$lambda$1() {
        return "You can't specify `Common` platform in combination with others";
    }
}

