/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.directives;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.platform.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinCodeFragmentContextModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalSourceModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinGlobalSourceOutOfBlockModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationEventKind;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTopics;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModificationTopicsKt;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleOutOfBlockModificationListener;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationKind;
import org.jetbrains.kotlin.analysis.api.platform.modification.KotlinModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.test.framework.directives.ModificationEventDirectives;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModuleStructure;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.testFramework.UtilKt;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0012\u0010\b\u001a\u00020\u0001*\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0016\u0010\n\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f\u001a\"\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u001a\b\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"publishModificationEventByDirective", "", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "isOptional", "", "publishWildcardModificationEventByDirectiveIfPresent", "modificationEventKind", "Lorg/jetbrains/kotlin/analysis/api/platform/modification/KotlinModificationEventKind;", "publishWildcardModificationEventsByDirective", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModuleStructure;", "publishModificationEvent", "ktModule", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "publishGlobalModificationEvent", "project", "Lcom/intellij/openapi/project/Project;", "publishModificationEventByKind", "errorModuleRequired", "", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nModificationEventDirectives.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModificationEventDirectives.kt\norg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventDirectivesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n1869#2,2:147\n*S KotlinDebug\n*F\n+ 1 ModificationEventDirectives.kt\norg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventDirectivesKt\n*L\n85#1:147,2\n*E\n"})
public final class ModificationEventDirectivesKt {
    public static final void publishModificationEventByDirective(@NotNull KtTestModule $this$publishModificationEventByDirective, boolean isOptional) {
        Intrinsics.checkNotNullParameter((Object)$this$publishModificationEventByDirective, (String)"<this>");
        List modificationEventKinds = $this$publishModificationEventByDirective.getTestModule().getDirectives().get(ModificationEventDirectives.INSTANCE.getMODIFICATION_EVENT());
        switch (modificationEventKinds.size()) {
            case 0: {
                if (isOptional) {
                    return;
                }
                throw new IllegalStateException(("Expected a `" + ModificationEventDirectives.INSTANCE.getMODIFICATION_EVENT().getName() + "` to be present in the test module `" + $this$publishModificationEventByDirective + "`.").toString());
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException(("The test module `" + $this$publishModificationEventByDirective + "` must not specify multiple modification events.").toString());
            }
        }
        KotlinModificationEventKind modificationEventKind = (KotlinModificationEventKind)CollectionsKt.single((List)modificationEventKinds);
        ModificationEventDirectivesKt.publishModificationEvent(modificationEventKind, $this$publishModificationEventByDirective.getKtModule());
    }

    public static /* synthetic */ void publishModificationEventByDirective$default(KtTestModule ktTestModule, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        ModificationEventDirectivesKt.publishModificationEventByDirective(ktTestModule, bl);
    }

    public static final void publishWildcardModificationEventByDirectiveIfPresent(@NotNull KtTestModule $this$publishWildcardModificationEventByDirectiveIfPresent, @NotNull KotlinModificationEventKind modificationEventKind) {
        Intrinsics.checkNotNullParameter((Object)$this$publishWildcardModificationEventByDirectiveIfPresent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modificationEventKind, (String)"modificationEventKind");
        if (!$this$publishWildcardModificationEventByDirectiveIfPresent.getTestModule().getDirectives().contains((Directive)ModificationEventDirectives.INSTANCE.getWILDCARD_MODIFICATION_EVENT())) {
            return;
        }
        ModificationEventDirectivesKt.publishModificationEvent(modificationEventKind, $this$publishWildcardModificationEventByDirectiveIfPresent.getKtModule());
    }

    public static final void publishWildcardModificationEventsByDirective(@NotNull KtTestModuleStructure $this$publishWildcardModificationEventsByDirective, @NotNull KotlinModificationEventKind modificationEventKind) {
        Intrinsics.checkNotNullParameter((Object)$this$publishWildcardModificationEventsByDirective, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)modificationEventKind, (String)"modificationEventKind");
        if (KotlinModificationTopicsKt.isModuleLevel((KotlinModificationEventKind)modificationEventKind)) {
            Iterable $this$forEach$iv = $this$publishWildcardModificationEventsByDirective.getMainModules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtTestModule ktTestModule = (KtTestModule)element$iv;
                boolean bl = false;
                ModificationEventDirectivesKt.publishWildcardModificationEventByDirectiveIfPresent(ktTestModule, modificationEventKind);
            }
        } else {
            if (!$this$publishWildcardModificationEventsByDirective.getTestModuleStructure().getAllDirectives().contains((Directive)ModificationEventDirectives.INSTANCE.getWILDCARD_MODIFICATION_EVENT())) {
                return;
            }
            ModificationEventDirectivesKt.publishGlobalModificationEvent(modificationEventKind, $this$publishWildcardModificationEventsByDirective.getProject());
        }
    }

    public static final void publishModificationEvent(@NotNull KotlinModificationEventKind modificationEventKind, @NotNull KaModule ktModule) {
        Intrinsics.checkNotNullParameter((Object)modificationEventKind, (String)"modificationEventKind");
        Intrinsics.checkNotNullParameter((Object)ktModule, (String)"ktModule");
        ModificationEventDirectivesKt.publishModificationEventByKind(modificationEventKind, ktModule.getProject(), ktModule);
    }

    public static final void publishGlobalModificationEvent(@NotNull KotlinModificationEventKind modificationEventKind, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)modificationEventKind, (String)"modificationEventKind");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!KotlinModificationTopicsKt.isGlobalLevel((KotlinModificationEventKind)modificationEventKind)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ModificationEventDirectivesKt.publishModificationEventByKind(modificationEventKind, project, null);
    }

    private static final void publishModificationEventByKind(KotlinModificationEventKind modificationEventKind, Project project, KaModule ktModule) {
        UtilKt.runWriteAction(() -> ModificationEventDirectivesKt.publishModificationEventByKind$lambda$1(modificationEventKind, project, ktModule));
    }

    private static final Void errorModuleRequired() {
        throw new IllegalStateException("Cannot publish a module-level modification event without a module.".toString());
    }

    private static final Unit publishModificationEventByKind$lambda$1(KotlinModificationEventKind $modificationEventKind, Project $project, KaModule $ktModule) {
        switch (WhenMappings.$EnumSwitchMapping$0[$modificationEventKind.ordinal()]) {
            case 1: {
                KaModule kaModule = $ktModule;
                if (kaModule == null) {
                    ModificationEventDirectivesKt.errorModuleRequired();
                    throw new KotlinNothingValueException();
                }
                ((KotlinModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinModificationTopics.INSTANCE.getMODULE_STATE_MODIFICATION())).onModification(kaModule, KotlinModuleStateModificationKind.UPDATE);
                break;
            }
            case 2: {
                KaModule kaModule = $ktModule;
                if (kaModule == null) {
                    ModificationEventDirectivesKt.errorModuleRequired();
                    throw new KotlinNothingValueException();
                }
                ((KotlinModuleOutOfBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinModificationTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION())).onModification(kaModule);
                break;
            }
            case 3: {
                ((KotlinGlobalModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinModificationTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION())).onModification();
                break;
            }
            case 4: {
                ((KotlinGlobalSourceModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinModificationTopics.INSTANCE.getGLOBAL_SOURCE_MODULE_STATE_MODIFICATION())).onModification();
                break;
            }
            case 5: {
                ((KotlinGlobalSourceOutOfBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinModificationTopics.INSTANCE.getGLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION())).onModification();
                break;
            }
            case 6: {
                KaModule kaModule = $ktModule;
                if (kaModule == null) {
                    ModificationEventDirectivesKt.errorModuleRequired();
                    throw new KotlinNothingValueException();
                }
                ((KotlinCodeFragmentContextModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinModificationTopics.INSTANCE.getCODE_FRAGMENT_CONTEXT_MODIFICATION())).onModification(kaModule);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[KotlinModificationEventKind.values().length];
            try {
                nArray[KotlinModificationEventKind.MODULE_STATE_MODIFICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.MODULE_OUT_OF_BLOCK_MODIFICATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.GLOBAL_MODULE_STATE_MODIFICATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.GLOBAL_SOURCE_MODULE_STATE_MODIFICATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.GLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[KotlinModificationEventKind.CODE_FRAGMENT_CONTEXT_MODIFICATION.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

