/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KaDanglingFileModuleImpl;
import org.jetbrains.kotlin.analysis.api.platform.projectStructure.KotlinProjectStructureProviderBaseKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileResolutionMode;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.AnalysisApiTestCodeFragmentDirectives;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.CodeFragmentKind;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModuleFactory;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkersSourceFilePreprocessorKt;
import org.jetbrains.kotlin.analysis.test.framework.services.TestForeignValueProviderService;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.psi.KtBlockCodeFragment;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpressionCodeFragment;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtTypeCodeFragment;
import org.jetbrains.kotlin.test.directives.model.DirectiveKt;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.SourceFileProviderKt;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtCodeFragmentTestModuleFactory;", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModuleFactory;", "<init>", "()V", "createModule", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "contextModule", "dependencyBinaryRoots", "", "Ljava/nio/file/Path;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "getResolutionMode", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaDanglingFileResolutionMode;", "testFile", "Lorg/jetbrains/kotlin/test/model/TestFile;", "findContextElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKtCodeFragmentTestModuleFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtCodeFragmentTestModuleFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtCodeFragmentTestModuleFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,143:1\n1#2:144\n808#3,11:145\n133#4:156\n*S KotlinDebug\n*F\n+ 1 KtCodeFragmentTestModuleFactory.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtCodeFragmentTestModuleFactory\n*L\n71#1:145,11\n106#1:156\n*E\n"})
public final class KtCodeFragmentTestModuleFactory
implements KtTestModuleFactory {
    @NotNull
    public static final KtCodeFragmentTestModuleFactory INSTANCE = new KtCodeFragmentTestModuleFactory();

    private KtCodeFragmentTestModuleFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KtTestModule createModule(@NotNull TestModule testModule, @Nullable KtTestModule contextModule, @NotNull Collection<? extends Path> dependencyBinaryRoots, @NotNull TestServices testServices, @NotNull Project project) {
        KtCodeFragment ktCodeFragment;
        KtFile ktFile;
        String codeFragmentImports;
        CodeFragmentKind codeFragmentKind;
        String fileText;
        String fileName;
        TestFile testFile;
        block11: {
            void $this$filterIsInstanceTo$iv$iv;
            void $this$filterIsInstance$iv;
            Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
            Intrinsics.checkNotNullParameter(dependencyBinaryRoots, (String)"dependencyBinaryRoots");
            Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (contextModule == null) {
                boolean $i$a$-requireNotNull-KtCodeFragmentTestModuleFactory$createModule$22 = false;
                String $i$a$-requireNotNull-KtCodeFragmentTestModuleFactory$createModule$22 = "Code fragment requires a context module";
                throw new IllegalArgumentException($i$a$-requireNotNull-KtCodeFragmentTestModuleFactory$createModule$22.toString());
            }
            TestFile testFile2 = (TestFile)CollectionsKt.singleOrNull((List)testModule.getFiles());
            if (testFile2 == null) {
                throw new IllegalStateException("A single file is expected for a code fragment module".toString());
            }
            testFile = testFile2;
            fileName = testFile.getName();
            fileText = SourceFileProviderKt.getSourceFileProvider((TestServices)testServices).getContentOfSourceFile(testFile);
            CodeFragmentKind codeFragmentKind2 = (CodeFragmentKind)((Object)DirectiveKt.singleOrZeroValue((RegisteredDirectives)testFile.getDirectives(), AnalysisApiTestCodeFragmentDirectives.INSTANCE.getCODE_FRAGMENT_KIND()));
            if (codeFragmentKind2 == null) {
                codeFragmentKind2 = CodeFragmentKind.BLOCK;
            }
            codeFragmentKind = codeFragmentKind2;
            String string = CollectionsKt.joinToString$default((Iterable)testFile.getDirectives().get(AnalysisApiTestCodeFragmentDirectives.INSTANCE.getCODE_FRAGMENT_IMPORT()), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
            Object it = string;
            boolean bl = false;
            String string2 = codeFragmentImports = ((CharSequence)it).length() > 0 ? string : null;
            if (codeFragmentKind == CodeFragmentKind.TYPE && codeFragmentImports != null) {
                throw new IllegalStateException("Imports cannot be configured for type code fragments".toString());
            }
            it = contextModule.getFiles();
            boolean $i$f$filterIsInstance = false;
            void var14_17 = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof KtFile)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            for (KtFile it2 : (Iterable)((List)destination$iv$iv)) {
                boolean bl2 = false;
                if ((it2 = INSTANCE.findContextElement(it2, testServices)) == null) continue;
                ktFile = it2;
                break block11;
            }
            ktFile = null;
        }
        KtFile contextElement = ktFile;
        switch (WhenMappings.$EnumSwitchMapping$0[codeFragmentKind.ordinal()]) {
            case 1: {
                ktCodeFragment = (KtCodeFragment)new KtExpressionCodeFragment(project, fileName, (CharSequence)fileText, codeFragmentImports, (PsiElement)contextElement);
                break;
            }
            case 2: {
                ktCodeFragment = (KtCodeFragment)new KtBlockCodeFragment(project, fileName, (CharSequence)fileText, codeFragmentImports, (PsiElement)contextElement);
                break;
            }
            case 3: {
                ktCodeFragment = (KtCodeFragment)new KtTypeCodeFragment(project, fileName, (CharSequence)fileText, (PsiElement)contextElement);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        KtCodeFragment codeFragment = ktCodeFragment;
        List foreignValues = testFile.getDirectives().get(AnalysisApiTestCodeFragmentDirectives.INSTANCE.getCODE_FRAGMENT_FOREIGN_VALUE());
        TestForeignValueProviderService.Companion.submitForeignValues(codeFragment, foreignValues);
        KaDanglingFileModuleImpl module = new KaDanglingFileModuleImpl((KtFile)codeFragment, contextModule.getKtModule(), this.getResolutionMode(testFile));
        KotlinProjectStructureProviderBaseKt.setForcedSpecialModule((KtCodeFragment)codeFragment, (KaDanglingFileModule)((KaDanglingFileModule)module));
        return new KtTestModule(TestModuleKind.CodeFragment, testModule, (KaModule)module, CollectionsKt.listOf((Object)codeFragment));
    }

    private final KaDanglingFileResolutionMode getResolutionMode(TestFile testFile) {
        KaDanglingFileResolutionMode kaDanglingFileResolutionMode;
        List directives = testFile.getDirectives().get(AnalysisApiTestCodeFragmentDirectives.INSTANCE.getCODE_FRAGMENT_RESOLUTION_MODE());
        switch (directives.size()) {
            case 0: {
                kaDanglingFileResolutionMode = KaDanglingFileResolutionMode.PREFER_SELF;
                break;
            }
            case 1: {
                kaDanglingFileResolutionMode = (KaDanglingFileResolutionMode)CollectionsKt.single((List)directives);
                break;
            }
            default: {
                throw new IllegalStateException(("Expected 0 or 1 `" + AnalysisApiTestCodeFragmentDirectives.INSTANCE.getCODE_FRAGMENT_RESOLUTION_MODE() + "` directives, got: " + directives.size()).toString());
            }
        }
        return kaDanglingFileResolutionMode;
    }

    /*
     * WARNING - void declaration
     */
    private final KtElement findContextElement(KtFile file, TestServices testServices) {
        KtElement ktElement;
        Integer n = ExpressionMarkersSourceFilePreprocessorKt.getExpressionMarkerProvider(testServices).getCaretPositionOrNull((PsiFile)file, "context");
        if (n == null) {
            return null;
        }
        int offset = n;
        PsiElement psiElement = file.findElementAt(offset);
        if (psiElement != null) {
            void $this$getParentOfType$iv;
            PsiElement psiElement2 = psiElement;
            boolean strict$iv = false;
            boolean $i$f$getParentOfType = false;
            ktElement = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, KtElement.class, (boolean)strict$iv);
        } else {
            ktElement = null;
        }
        return ktElement;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CodeFragmentKind.values().length];
            try {
                nArray[CodeFragmentKind.EXPRESSION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentKind.BLOCK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CodeFragmentKind.TYPE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

