/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractDecompiledClassTest;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.TestData;
import org.jetbrains.kotlin.test.KotlinTestWithEnvironment;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\u00052\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractPsiStubElementTypeConsistencyTest;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractDecompiledClassTest;", "<init>", "()V", "runTest", "", "testDirectory", "", "doTest", "testData", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/TestData;", "useStringTable", "", "checkPsiElementTypeConsistency", "stubElement", "Lcom/intellij/psi/stubs/StubElement;", "decompiler-to-file-stubs_test"})
@SourceDebugExtension(value={"SMAP\nAbstractPsiStubElementTypeConsistencyTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractPsiStubElementTypeConsistencyTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractPsiStubElementTypeConsistencyTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1863#2,2:49\n*S KotlinDebug\n*F\n+ 1 AbstractPsiStubElementTypeConsistencyTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractPsiStubElementTypeConsistencyTest\n*L\n45#1:49,2\n*E\n"})
public abstract class AbstractPsiStubElementTypeConsistencyTest
extends AbstractDecompiledClassTest {
    public final void runTest(@NotNull String testDirectory) {
        Intrinsics.checkNotNullParameter((Object)testDirectory, (String)"testDirectory");
        Path testDirectoryPath = Paths.get(testDirectory, new String[0]);
        Intrinsics.checkNotNull((Object)testDirectoryPath);
        TestData testData = TestData.Companion.createFromDirectory(testDirectoryPath);
        testData.withFirIgnoreDirective(() -> AbstractPsiStubElementTypeConsistencyTest.runTest$lambda$0(this, testData));
    }

    private final void doTest(TestData testData, boolean useStringTable) {
        VirtualFile classFile = this.getClassFileToDecompile$decompiler_to_file_stubs_test(testData, useStringTable);
        KotlinClsStubBuilder kotlinClsStubBuilder = new KotlinClsStubBuilder();
        FileContent fileContent = FileContentImpl.createByFile((VirtualFile)classFile);
        Intrinsics.checkNotNullExpressionValue((Object)fileContent, (String)"createByFile(...)");
        PsiFileStub psiFileStub = kotlinClsStubBuilder.buildFileStub(fileContent);
        if (psiFileStub == null) {
            throw new IllegalStateException(("Couldn't build a file stub for the file: " + classFile).toString());
        }
        PsiFileStub fileStub = psiFileStub;
        this.checkPsiElementTypeConsistency((StubElement)fileStub);
    }

    private final void checkPsiElementTypeConsistency(StubElement<?> stubElement) {
        StubBasedPsiElement psi;
        PsiElement psiElement = stubElement.getPsi();
        StubBasedPsiElement stubBasedPsiElement = psi = psiElement instanceof StubBasedPsiElement ? (StubBasedPsiElement)psiElement : null;
        if (psi != null) {
            KotlinTestWithEnvironment.assertEquals((String)("Expected the PSI of `" + stubElement + "` to have the same element type. Instead got: `" + psi.getElementType() + "`."), (Object)stubElement.getStubType(), (Object)psi.getElementType());
        }
        List list = stubElement.getChildrenStubs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getChildrenStubs(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StubElement p0 = (StubElement)element$iv;
            boolean bl = false;
            this.checkPsiElementTypeConsistency(p0);
        }
    }

    private static final Unit runTest$lambda$0(AbstractPsiStubElementTypeConsistencyTest this$0, TestData $testData) {
        this$0.doTest($testData, true);
        this$0.doTest($testData, false);
        return Unit.INSTANCE;
    }
}

