/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.projectStructure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiJavaFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaDanglingFileModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaLibraryModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaNotUnderContentRootModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaScriptModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.api.standalone.base.projectStructure.StandaloneProjectFactory;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KtTestModule;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructure;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020\u0014J\u000e\u0010&\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00060\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000fR\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000fR\u0018\u0010\"\u001a\u00020#*\u00020\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%\u00a8\u0006*"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModuleStructure;", "", "testModuleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "mainModules", "", "Lorg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModule;", "binaryModules", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaLibraryModule;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestModuleStructure;Ljava/util/List;Ljava/lang/Iterable;)V", "getTestModuleStructure", "()Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "getMainModules", "()Ljava/util/List;", "getBinaryModules", "()Ljava/lang/Iterable;", "mainModulesByName", "", "", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "allMainKtFiles", "Lorg/jetbrains/kotlin/psi/KtFile;", "getAllMainKtFiles", "mainAndBinaryKtModules", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "getMainAndBinaryKtModules", "allSourceFiles", "Lcom/intellij/psi/PsiFileSystemItem;", "getAllSourceFiles", "canContainSourceFiles", "", "getCanContainSourceFiles", "(Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;)Z", "getKtTestModule", "moduleName", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nKtTestModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtTestModule.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModuleStructure\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1202#2,2:90\n1230#2,4:92\n1368#2:96\n1454#2,5:97\n1628#2,3:102\n774#2:105\n865#2,2:106\n1368#2:108\n1454#2,5:109\n808#2,11:114\n*S KotlinDebug\n*F\n+ 1 KtTestModule.kt\norg/jetbrains/kotlin/analysis/test/framework/projectStructure/KtTestModuleStructure\n*L\n53#1:90,2\n53#1:92,4\n57#1:96\n57#1:97,5\n61#1:102,3\n68#1:105\n68#1:106,2\n69#1:108\n69#1:109,5\n72#1:114,11\n*E\n"})
public final class KtTestModuleStructure {
    @NotNull
    private final TestModuleStructure testModuleStructure;
    @NotNull
    private final List<KtTestModule> mainModules;
    @NotNull
    private final Iterable<KaLibraryModule> binaryModules;
    @NotNull
    private final Map<String, KtTestModule> mainModulesByName;

    /*
     * WARNING - void declaration
     */
    public KtTestModuleStructure(@NotNull TestModuleStructure testModuleStructure, @NotNull List<KtTestModule> mainModules, @NotNull Iterable<? extends KaLibraryModule> binaryModules) {
        void $this$associateByTo$iv$iv;
        void $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)testModuleStructure, (String)"testModuleStructure");
        Intrinsics.checkNotNullParameter(mainModules, (String)"mainModules");
        Intrinsics.checkNotNullParameter(binaryModules, (String)"binaryModules");
        this.testModuleStructure = testModuleStructure;
        this.mainModules = mainModules;
        this.binaryModules = binaryModules;
        Iterable iterable = this.mainModules;
        KtTestModuleStructure ktTestModuleStructure = this;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_8 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            KtTestModule ktTestModule = (KtTestModule)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getTestModule().getName(), element$iv$iv);
        }
        ktTestModuleStructure.mainModulesByName = destination$iv$iv;
    }

    @NotNull
    public final TestModuleStructure getTestModuleStructure() {
        return this.testModuleStructure;
    }

    @NotNull
    public final List<KtTestModule> getMainModules() {
        return this.mainModules;
    }

    @NotNull
    public final Iterable<KaLibraryModule> getBinaryModules() {
        return this.binaryModules;
    }

    @NotNull
    public final Project getProject() {
        return ((KtTestModule)CollectionsKt.first(this.mainModules)).getKtModule().getProject();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KtFile> getAllMainKtFiles() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.mainModules;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            KtTestModule it = (KtTestModule)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getKtFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KaModule> getMainAndBinaryKtModules() {
        List list;
        List $this$_get_mainAndBinaryKtModules__u24lambda_u243 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable $this$mapTo$iv = this.mainModules;
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            KtTestModule ktTestModule = (KtTestModule)item$iv;
            Collection collection = $this$_get_mainAndBinaryKtModules__u24lambda_u243;
            boolean bl2 = false;
            collection.add(it.getKtModule());
        }
        CollectionsKt.addAll((Collection)$this$_get_mainAndBinaryKtModules__u24lambda_u243, this.binaryModules);
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiFileSystemItem> getAllSourceFiles() {
        void $this$filterIsInstanceTo$iv$iv;
        void $this$filterIsInstance$iv;
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv;
        KtTestModule it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        List list;
        List $this$_get_allSourceFiles__u24lambda_u246 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Iterable iterable = this.mainModules;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (KtTestModule)element$iv$iv;
            boolean bl2 = false;
            if (!this.getCanContainSourceFiles(it.getKtModule())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$filterTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            it = (KtTestModule)element$iv$iv;
            boolean bl3 = false;
            Iterable list$iv$iv = it.getFiles();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files = (List)destination$iv$iv;
        $this$_get_allSourceFiles__u24lambda_u246.addAll(files);
        $this$flatMap$iv = files;
        StandaloneProjectFactory standaloneProjectFactory = StandaloneProjectFactory.INSTANCE;
        List list2 = $this$_get_allSourceFiles__u24lambda_u246;
        boolean $i$f$filterIsInstance = false;
        $this$flatMapTo$iv$iv = $this$filterIsInstance$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof PsiJavaFile)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list3 = (List)destination$iv$iv;
        list2.addAll(standaloneProjectFactory.findJvmRootsForJavaFiles(list3));
        return CollectionsKt.build((List)list);
    }

    private final boolean getCanContainSourceFiles(KaModule $this$canContainSourceFiles) {
        KaModule kaModule = $this$canContainSourceFiles;
        return kaModule instanceof KaSourceModule || kaModule instanceof KaScriptModule || kaModule instanceof KaDanglingFileModule || kaModule instanceof KaNotUnderContentRootModule;
    }

    @NotNull
    public final KtTestModule getKtTestModule(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return (KtTestModule)MapsKt.getValue(this.mainModulesByName, (Object)moduleName);
    }

    @NotNull
    public final KtTestModule getKtTestModule(@NotNull TestModule testModule) {
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        KtTestModule ktTestModule = this.mainModulesByName.get(testModule.getName());
        if (ktTestModule == null) {
            ktTestModule = (KtTestModule)MapsKt.getValue(this.mainModulesByName, (Object)((TestFile)CollectionsKt.single((List)testModule.getFiles())).getName());
        }
        return ktTestModule;
    }
}

