/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.test.AssertionsKt;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.low.level.api.fir.providers.KmpModuleSorter;
import org.jetbrains.kotlin.analysis.test.framework.TestWithMockProject;
import org.jetbrains.kotlin.analysis.test.framework.projectStructure.KaSourceModuleImpl;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.platform.CommonPlatforms;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.junit.jupiter.api.Test;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\rH\u0002J@\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/KmpModuleSorterTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/TestWithMockProject;", "<init>", "()V", "testNonKmpDependencies", "", "testOnlyKmpDependencies", "testMixedKmpAndUsualDependenciesShuffled", "testDependsOnDependenciesFromSelfAndOtherProject", "testPartsOfTheGroupAreMergedCorrectly1", "testPartsOfTheGroupAreMergedCorrectly2", "buildDependenciesToTest", "", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaModule;", "module", "createKtModule", "name", "", "directRegularDependencies", "directDependsOnDependencies", "directFriendDependencies", "low-level-api-fir_test"})
public final class KmpModuleSorterTest
extends TestWithMockProject {
    @Test
    public final void testNonKmpDependencies() {
        KaModule a = KmpModuleSorterTest.createKtModule$default(this, "A", null, null, null, 14, null);
        KaModule b = KmpModuleSorterTest.createKtModule$default(this, "B", null, null, null, 14, null);
        KaModule c = KmpModuleSorterTest.createKtModule$default(this, "C", null, null, null, 14, null);
        Object[] objectArray = new KaModule[]{a, b, c};
        KaModule d = KmpModuleSorterTest.createKtModule$default(this, "D", CollectionsKt.listOf((Object[])objectArray), null, null, 12, null);
        objectArray = new KaModule[]{a, b, c};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), this.buildDependenciesToTest(d), null, (int)4, null);
    }

    @Test
    public final void testOnlyKmpDependencies() {
        KaModule p1CommonMain = KmpModuleSorterTest.createKtModule$default(this, "p1.commonMain", null, null, null, 14, null);
        KaModule p1NativeMain = KmpModuleSorterTest.createKtModule$default(this, "p1.nativeMain", null, CollectionsKt.listOf((Object)p1CommonMain), null, 10, null);
        KaModule p1IosMain = KmpModuleSorterTest.createKtModule$default(this, "p1.iosMain", null, CollectionsKt.listOf((Object)p1NativeMain), null, 10, null);
        Object[] objectArray = new KaModule[]{p1CommonMain, p1NativeMain, p1IosMain};
        KaModule p2IosMain = KmpModuleSorterTest.createKtModule$default(this, "p2.iosMain", CollectionsKt.listOf((Object[])objectArray), null, null, 12, null);
        objectArray = new KaModule[]{p1IosMain, p1NativeMain, p1CommonMain};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), this.buildDependenciesToTest(p2IosMain), null, (int)4, null);
    }

    @Test
    public final void testMixedKmpAndUsualDependenciesShuffled() {
        KaModule a = KmpModuleSorterTest.createKtModule$default(this, "A", null, null, null, 14, null);
        KaModule b1 = KmpModuleSorterTest.createKtModule$default(this, "B1", null, null, null, 14, null);
        KaModule b2 = KmpModuleSorterTest.createKtModule$default(this, "B2", null, CollectionsKt.listOf((Object)b1), null, 10, null);
        KaModule b3 = KmpModuleSorterTest.createKtModule$default(this, "B3", null, CollectionsKt.listOf((Object)b2), null, 10, null);
        KaModule c = KmpModuleSorterTest.createKtModule$default(this, "C", null, null, null, 14, null);
        KaModule d1 = KmpModuleSorterTest.createKtModule$default(this, "D1", null, null, null, 14, null);
        KaModule d2 = KmpModuleSorterTest.createKtModule$default(this, "D2", null, CollectionsKt.listOf((Object)d1), null, 10, null);
        Object[] objectArray = new KaModule[]{a, b2, c, b1, d2, b3, d1};
        KaModule p2IosMain = KmpModuleSorterTest.createKtModule$default(this, "p2.iosMain", CollectionsKt.listOf((Object[])objectArray), null, null, 12, null);
        objectArray = new KaModule[]{a, b3, c, b2, d2, b1, d1};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), this.buildDependenciesToTest(p2IosMain), null, (int)4, null);
    }

    @Test
    public final void testDependsOnDependenciesFromSelfAndOtherProject() {
        KaModule p1Common = KmpModuleSorterTest.createKtModule$default(this, "p1.common", null, null, null, 14, null);
        KaModule p1Intermediate = KmpModuleSorterTest.createKtModule$default(this, "p1.intermediate", null, CollectionsKt.listOf((Object)p1Common), null, 10, null);
        KaModule p1Platform = KmpModuleSorterTest.createKtModule$default(this, "p1.platform", null, CollectionsKt.listOf((Object)p1Intermediate), null, 10, null);
        KaModule p2Common = KmpModuleSorterTest.createKtModule$default(this, "p2.common", CollectionsKt.listOf((Object)p1Common), null, null, 12, null);
        List list = CollectionsKt.listOf((Object)p2Common);
        Object object = new KaModule[]{p1Common, p1Intermediate};
        Object[] objectArray = CollectionsKt.listOf((Object[])object);
        KaModule p2Intermediate = KmpModuleSorterTest.createKtModule$default(this, "p2.intermediate", (List)objectArray, list, null, 8, null);
        objectArray = CollectionsKt.listOf((Object)p2Intermediate);
        Object[] objectArray2 = new KaModule[]{p1Common, p1Intermediate, p1Platform};
        object = CollectionsKt.listOf((Object[])objectArray2);
        KaModule p2Platform = KmpModuleSorterTest.createKtModule$default(this, "p2.platform", (List)object, (List)objectArray, null, 8, null);
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object)p1Common), this.buildDependenciesToTest(p2Common), null, (int)4, null);
        objectArray = new KaModule[]{p1Intermediate, p1Common, p2Common};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), this.buildDependenciesToTest(p2Intermediate), null, (int)4, null);
        objectArray = new KaModule[]{p1Platform, p1Intermediate, p1Common, p2Intermediate, p2Common};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray), this.buildDependenciesToTest(p2Platform), null, (int)4, null);
    }

    @Test
    public final void testPartsOfTheGroupAreMergedCorrectly1() {
        KaModule m1 = KmpModuleSorterTest.createKtModule$default(this, "m1", null, null, null, 14, null);
        KaModule m2 = KmpModuleSorterTest.createKtModule$default(this, "m2", null, CollectionsKt.listOf((Object)m1), null, 10, null);
        KaModule m3 = KmpModuleSorterTest.createKtModule$default(this, "m3", null, CollectionsKt.listOf((Object)m2), null, 10, null);
        KaModule m4 = KmpModuleSorterTest.createKtModule$default(this, "m4", null, CollectionsKt.listOf((Object)m3), null, 10, null);
        Object[] objectArray = new KaModule[]{m1, m3, m4, m2};
        KaModule c = KmpModuleSorterTest.createKtModule$default(this, "c", CollectionsKt.listOf((Object[])objectArray), null, null, 12, null);
        Object[] objectArray2 = new KaModule[]{m2, m4, m3, m1};
        KaModule d = KmpModuleSorterTest.createKtModule$default(this, "d", CollectionsKt.listOf((Object[])objectArray2), null, null, 12, null);
        objectArray2 = new KaModule[]{m4, m3, m2, m1};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray2), this.buildDependenciesToTest(c), null, (int)4, null);
        objectArray2 = new KaModule[]{m4, m3, m2, m1};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray2), this.buildDependenciesToTest(d), null, (int)4, null);
    }

    @Test
    public final void testPartsOfTheGroupAreMergedCorrectly2() {
        KaModule m1 = KmpModuleSorterTest.createKtModule$default(this, "m1", null, null, null, 14, null);
        KaModule m2 = KmpModuleSorterTest.createKtModule$default(this, "m2", null, CollectionsKt.listOf((Object)m1), null, 10, null);
        KaModule m3 = KmpModuleSorterTest.createKtModule$default(this, "m3", null, CollectionsKt.listOf((Object)m2), null, 10, null);
        KaModule m4 = KmpModuleSorterTest.createKtModule$default(this, "m4", null, CollectionsKt.listOf((Object)m3), null, 10, null);
        KaModule m5 = KmpModuleSorterTest.createKtModule$default(this, "m5", null, CollectionsKt.listOf((Object)m4), null, 10, null);
        KaModule m6 = KmpModuleSorterTest.createKtModule$default(this, "m6", null, CollectionsKt.listOf((Object)m5), null, 10, null);
        Object[] objectArray = new KaModule[]{m3, m4, m6, m5, m2, m1};
        KaModule c = KmpModuleSorterTest.createKtModule$default(this, "c", CollectionsKt.listOf((Object[])objectArray), null, null, 12, null);
        Object[] objectArray2 = new KaModule[]{m1, m2, m5, m6, m4, m3};
        KaModule d = KmpModuleSorterTest.createKtModule$default(this, "d", CollectionsKt.listOf((Object[])objectArray2), null, null, 12, null);
        objectArray2 = new KaModule[]{m6, m5, m4, m3, m2, m1};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray2), this.buildDependenciesToTest(c), null, (int)4, null);
        objectArray2 = new KaModule[]{m6, m5, m4, m3, m2, m1};
        AssertionsKt.assertEquals$default((Object)CollectionsKt.listOf((Object[])objectArray2), this.buildDependenciesToTest(d), null, (int)4, null);
    }

    private final List<KaModule> buildDependenciesToTest(KaModule module) {
        Set set;
        Set $this$buildDependenciesToTest_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$buildDependenciesToTest_u24lambda_u240.addAll(module.getDirectRegularDependencies());
        $this$buildDependenciesToTest_u24lambda_u240.addAll(module.getDirectFriendDependencies());
        $this$buildDependenciesToTest_u24lambda_u240.addAll(module.getTransitiveDependsOnDependencies());
        Set dependenciesToSort = SetsKt.build((Set)set);
        return KmpModuleSorter.Companion.order(CollectionsKt.toList((Iterable)dependenciesToSort));
    }

    private final KaModule createKtModule(String name, List<? extends KaModule> directRegularDependencies, List<? extends KaModule> directDependsOnDependencies, List<? extends KaModule> directFriendDependencies) {
        KaSourceModuleImpl kaSourceModuleImpl;
        TargetPlatform targetPlatform = CommonPlatforms.INSTANCE.getDefaultCommonPlatform();
        LanguageVersionSettings languageVersionSettings = (LanguageVersionSettings)LanguageVersionSettingsImpl.DEFAULT;
        Project project = this.getProject();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.EMPTY_SCOPE;
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"EMPTY_SCOPE");
        KaSourceModuleImpl $this$createKtModule_u24lambda_u241 = kaSourceModuleImpl = new KaSourceModuleImpl(name, targetPlatform, languageVersionSettings, project, globalSearchScope);
        boolean bl = false;
        $this$createKtModule_u24lambda_u241.getDirectRegularDependencies().addAll((Collection<KaModule>)directRegularDependencies);
        $this$createKtModule_u24lambda_u241.getDirectFriendDependencies().addAll((Collection<KaModule>)directFriendDependencies);
        $this$createKtModule_u24lambda_u241.getDirectDependsOnDependencies().addAll((Collection<KaModule>)directDependsOnDependencies);
        return (KaModule)kaSourceModuleImpl;
    }

    static /* synthetic */ KaModule createKtModule$default(KmpModuleSorterTest kmpModuleSorterTest, String string, List list, List list2, List list3, int n, Object object) {
        if ((n & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        return kmpModuleSorterTest.createKtModule(string, list, list2, list3);
    }
}

