/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.caches;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.CleanableSoftValueCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.SoftValueCleaner;
import org.jetbrains.kotlin.analysis.low.level.api.fir.caches.ValueWithCleanup;
import org.jetbrains.kotlin.analysis.test.framework.utils.CommonTestUtilsKt;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007J\b\u0010\u000b\u001a\u00020\u0005H\u0007J\b\u0010\f\u001a\u00020\u0005H\u0007J\b\u0010\r\u001a\u00020\u0005H\u0007J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J-\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000f2\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0014\"\u00020\u0011H\u0002\u00a2\u0006\u0002\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCacheTest;", "", "<init>", "()V", "removeCleansUpValues", "", "putCleansUpValues", "putAvoidsSameValueCleanup", "computeAddsValues", "computeCleansUpValues", "computeAvoidsSameValueCleanup", "computeIfAbsentAddsValues", "computeIfAbsentKeepsExistingValues", "clearCleansUpValues", "createCache", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithCleanup;", "setUpCache", "values", "", "([Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/ValueWithCleanup;)Lorg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCache;", "tests-jdk11_test"})
@SourceDebugExtension(value={"SMAP\nCleanableSoftValueCacheTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CleanableSoftValueCacheTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCacheTest\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,218:1\n13409#2,2:219\n1863#3,2:221\n*S KotlinDebug\n*F\n+ 1 CleanableSoftValueCacheTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/caches/CleanableSoftValueCacheTest\n*L\n205#1:219,2\n209#1:221,2\n*E\n"})
public final class CleanableSoftValueCacheTest {
    @Test
    public final void removeCleansUpValues() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        ValueWithCleanup removedValue1 = (ValueWithCleanup)cache.remove((Object)"v1");
        Assertions.assertNull((Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)removedValue1);
        Assertions.assertTrue((boolean)value1.isCleanedUp());
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        ValueWithCleanup removedValue2 = (ValueWithCleanup)cache.remove((Object)"v2");
        Assertions.assertNull((Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)removedValue2);
        Assertions.assertTrue((boolean)value2.isCleanedUp());
    }

    @Test
    public final void putCleansUpValues() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        ValueWithCleanup valueReplacement1 = new ValueWithCleanup("vr1");
        ValueWithCleanup valueReplacement2 = new ValueWithCleanup("vr2");
        ValueWithCleanup oldValue1 = (ValueWithCleanup)cache.put((Object)"v1", (Object)valueReplacement1);
        Assertions.assertSame((Object)valueReplacement1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)oldValue1);
        Assertions.assertTrue((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement1.isCleanedUp());
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        ValueWithCleanup oldValue2 = (ValueWithCleanup)cache.put((Object)"v2", (Object)valueReplacement2);
        Assertions.assertSame((Object)valueReplacement2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)oldValue2);
        Assertions.assertTrue((boolean)value2.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement2.isCleanedUp());
    }

    @Test
    public final void putAvoidsSameValueCleanup() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        ValueWithCleanup oldValue = (ValueWithCleanup)cache.put((Object)"v1", (Object)value1);
        Assertions.assertSame((Object)value1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)oldValue);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
    }

    @Test
    public final void computeAddsValues() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup newValue = (ValueWithCleanup)cache.compute((Object)"v2", (arg_0, arg_1) -> CleanableSoftValueCacheTest.computeAddsValues$lambda$0(value2, arg_0, arg_1));
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)newValue);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)value2.isCleanedUp());
    }

    @Test
    public final void computeCleansUpValues() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        ValueWithCleanup valueReplacement1 = new ValueWithCleanup("vr1");
        ValueWithCleanup valueReplacement2 = null;
        ValueWithCleanup newValue1 = (ValueWithCleanup)cache.compute((Object)"v1", (arg_0, arg_1) -> CleanableSoftValueCacheTest.computeCleansUpValues$lambda$1(value1, valueReplacement1, arg_0, arg_1));
        Assertions.assertSame((Object)valueReplacement1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)valueReplacement1, (Object)newValue1);
        Assertions.assertTrue((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement1.isCleanedUp());
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        ValueWithCleanup newValue2 = (ValueWithCleanup)cache.compute((Object)"v2", (arg_0, arg_1) -> CleanableSoftValueCacheTest.computeCleansUpValues$lambda$2(value2, valueReplacement2, arg_0, arg_1));
        Assertions.assertSame(valueReplacement2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame(valueReplacement2, (Object)newValue2);
        Assertions.assertTrue((boolean)value2.isCleanedUp());
    }

    @Test
    public final void computeAvoidsSameValueCleanup() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        ValueWithCleanup newValue = (ValueWithCleanup)cache.compute((Object)"v1", (arg_0, arg_1) -> CleanableSoftValueCacheTest.computeAvoidsSameValueCleanup$lambda$3(value1, arg_0, arg_1));
        Assertions.assertSame((Object)value1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)newValue);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
    }

    @Test
    public final void computeIfAbsentAddsValues() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup newValue = (ValueWithCleanup)cache.computeIfAbsent((Object)"v2", arg_0 -> CleanableSoftValueCacheTest.computeIfAbsentAddsValues$lambda$4(value2, arg_0));
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)newValue);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)value2.isCleanedUp());
    }

    @Test
    public final void computeIfAbsentKeepsExistingValues() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        ValueWithCleanup valueReplacement1 = new ValueWithCleanup("vr1");
        ValueWithCleanup valueReplacement2 = new ValueWithCleanup("vr2");
        ValueWithCleanup currentValue1 = (ValueWithCleanup)cache.computeIfAbsent((Object)"v1", arg_0 -> CleanableSoftValueCacheTest.computeIfAbsentKeepsExistingValues$lambda$5(valueReplacement1, arg_0));
        Assertions.assertSame((Object)value1, (Object)cache.get((Object)"v1"));
        Assertions.assertSame((Object)value1, (Object)currentValue1);
        Assertions.assertFalse((boolean)value1.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement1.isCleanedUp());
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        ValueWithCleanup currentValue2 = (ValueWithCleanup)cache.computeIfAbsent((Object)"v2", arg_0 -> CleanableSoftValueCacheTest.computeIfAbsentKeepsExistingValues$lambda$6(valueReplacement2, arg_0));
        Assertions.assertSame((Object)value2, (Object)cache.get((Object)"v2"));
        Assertions.assertSame((Object)value2, (Object)currentValue2);
        Assertions.assertFalse((boolean)value2.isCleanedUp());
        Assertions.assertFalse((boolean)valueReplacement2.isCleanedUp());
    }

    @Test
    public final void clearCleansUpValues() {
        ValueWithCleanup value1 = new ValueWithCleanup("v1");
        ValueWithCleanup value2 = new ValueWithCleanup("v2");
        ValueWithCleanup value3 = new ValueWithCleanup("v3");
        ValueWithCleanup[] valueWithCleanupArray = new ValueWithCleanup[]{value1, value2, value3};
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.setUpCache(valueWithCleanupArray);
        CommonTestUtilsKt.withDummyApplication(() -> CleanableSoftValueCacheTest.clearCleansUpValues$lambda$7(cache));
        Assertions.assertTrue((boolean)cache.isEmpty());
        Assertions.assertTrue((boolean)value1.isCleanedUp());
        Assertions.assertTrue((boolean)value2.isCleanedUp());
        Assertions.assertTrue((boolean)value3.isCleanedUp());
    }

    private final CleanableSoftValueCache<String, ValueWithCleanup> createCache() {
        return new CleanableSoftValueCache(CleanableSoftValueCacheTest::createCache$lambda$8);
    }

    private final CleanableSoftValueCache<String, ValueWithCleanup> setUpCache(ValueWithCleanup ... values) {
        CleanableSoftValueCache<String, ValueWithCleanup> cache = this.createCache();
        Object $this$forEach$iv = values;
        boolean $i$f$forEach = false;
        int n = ((ValueWithCleanup[])$this$forEach$iv).length;
        for (int i = 0; i < n; ++i) {
            ValueWithCleanup element$iv;
            ValueWithCleanup value = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            cache.put((Object)value.getName(), (Object)value);
        }
        $this$forEach$iv = cache.getKeys();
        $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            String key = (String)element$iv;
            boolean bl = false;
            ValueWithCleanup value = (ValueWithCleanup)cache.get((Object)key);
            Assertions.assertNotNull((Object)value);
            ValueWithCleanup valueWithCleanup = value;
            Intrinsics.checkNotNull((Object)valueWithCleanup);
            Assertions.assertFalse((boolean)valueWithCleanup.isCleanedUp());
        }
        return cache;
    }

    private static final ValueWithCleanup computeAddsValues$lambda$0(ValueWithCleanup $value2, String string, ValueWithCleanup oldValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Assertions.assertNull((Object)oldValue);
        return $value2;
    }

    private static final ValueWithCleanup computeCleansUpValues$lambda$1(ValueWithCleanup $value1, ValueWithCleanup $valueReplacement1, String string, ValueWithCleanup oldValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Assertions.assertSame((Object)$value1, (Object)oldValue);
        return $valueReplacement1;
    }

    private static final ValueWithCleanup computeCleansUpValues$lambda$2(ValueWithCleanup $value2, ValueWithCleanup $valueReplacement2, String string, ValueWithCleanup oldValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Assertions.assertSame((Object)$value2, (Object)oldValue);
        return $valueReplacement2;
    }

    private static final ValueWithCleanup computeAvoidsSameValueCleanup$lambda$3(ValueWithCleanup $value1, String string, ValueWithCleanup oldValue) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Assertions.assertSame((Object)$value1, (Object)oldValue);
        return $value1;
    }

    private static final ValueWithCleanup computeIfAbsentAddsValues$lambda$4(ValueWithCleanup $value2, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $value2;
    }

    private static final ValueWithCleanup computeIfAbsentKeepsExistingValues$lambda$5(ValueWithCleanup $valueReplacement1, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $valueReplacement1;
    }

    private static final ValueWithCleanup computeIfAbsentKeepsExistingValues$lambda$6(ValueWithCleanup $valueReplacement2, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $valueReplacement2;
    }

    private static final Unit clearCleansUpValues$lambda$7(CleanableSoftValueCache $cache) {
        $cache.clear();
        return Unit.INSTANCE;
    }

    private static final SoftValueCleaner createCache$lambda$8(ValueWithCleanup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCleanupMarker();
    }
}

