/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services;

import com.intellij.mock.MockApplication;
import com.intellij.mock.MockProject;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtTestModuleProjectStructure;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.CompilerConfigurationProviderKt;
import org.jetbrains.kotlin.test.services.PreAnalysisHandler;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/ProjectStructureInitialisationPreAnalysisHandler;", "Lorg/jetbrains/kotlin/test/services/PreAnalysisHandler;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "configurator", "Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;)V", "preprocessModuleStructure", "", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "createAndRegisterKtModules", "project", "Lcom/intellij/mock/MockProject;", "checkAllModulesHaveTheSameProject", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nProjectStructureInitialisationPreAnalysisHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStructureInitialisationPreAnalysisHandler.kt\norg/jetbrains/kotlin/analysis/test/framework/services/ProjectStructureInitialisationPreAnalysisHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1734#2,3:49\n*S KotlinDebug\n*F\n+ 1 ProjectStructureInitialisationPreAnalysisHandler.kt\norg/jetbrains/kotlin/analysis/test/framework/services/ProjectStructureInitialisationPreAnalysisHandler\n*L\n46#1:49,3\n*E\n"})
public final class ProjectStructureInitialisationPreAnalysisHandler
extends PreAnalysisHandler {
    @NotNull
    private final AnalysisApiTestConfigurator configurator;

    public ProjectStructureInitialisationPreAnalysisHandler(@NotNull TestServices testServices, @NotNull AnalysisApiTestConfigurator configurator) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)configurator, (String)"configurator");
        super(testServices);
        this.configurator = configurator;
    }

    public void preprocessModuleStructure(@NotNull TestModuleStructure moduleStructure) {
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        this.checkAllModulesHaveTheSameProject(moduleStructure);
        AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.getTestServices()).initializeEnvironment();
        Project project = AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.getTestServices()).getProject();
        Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.mock.MockProject");
        MockProject project2 = (MockProject)project;
        Application application = AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.getTestServices()).getApplication();
        Intrinsics.checkNotNull((Object)application, (String)"null cannot be cast to non-null type com.intellij.mock.MockApplication");
        MockApplication application2 = (MockApplication)application;
        this.configurator.registerApplicationServices(application2, this.getTestServices());
        this.createAndRegisterKtModules(moduleStructure, project2);
        this.configurator.registerProjectExtensionPoints(project2, this.getTestServices());
        this.configurator.registerProjectServices(project2, this.getTestServices());
        AnalysisApiEnvironmentManagerKt.getEnvironmentManager(this.getTestServices()).initializeProjectStructure();
        this.configurator.registerProjectModelServices(project2, this.getTestServices());
    }

    private final void createAndRegisterKtModules(TestModuleStructure moduleStructure, MockProject project) {
        KtTestModuleProjectStructure ktModules = this.configurator.createModules(moduleStructure, this.getTestServices(), (Project)project);
        AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(this.getTestServices()).registerProjectStructure(ktModules);
    }

    private final void checkAllModulesHaveTheSameProject(TestModuleStructure moduleStructure) {
        boolean bl;
        block4: {
            List modules = moduleStructure.getModules();
            Project project = CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.getTestServices()).getProject((TestModule)CollectionsKt.first((List)moduleStructure.getModules()));
            Intrinsics.checkNotNull((Object)project, (String)"null cannot be cast to non-null type com.intellij.mock.MockProject");
            MockProject project2 = (MockProject)project;
            Iterable $this$all$iv = modules;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    TestModule it = (TestModule)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)CompilerConfigurationProviderKt.getCompilerConfigurationProvider((TestServices)this.getTestServices()).getProject(it), (Object)project2)) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        if (!bl) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
    }
}

