/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.directives;

import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.providers.KotlinMessageBusProviderKt;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinGlobalModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinGlobalSourceModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinGlobalSourceOutOfBlockModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinModuleOutOfBlockModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinModuleStateModificationKind;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinModuleStateModificationListener;
import org.jetbrains.kotlin.analysis.providers.topics.KotlinTopics;
import org.jetbrains.kotlin.analysis.test.framework.directives.ModificationEventDirectives;
import org.jetbrains.kotlin.analysis.test.framework.directives.ModificationEventKind;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.services.AnalysisApiEnvironmentManagerKt;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.testFramework.UtilKt;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u0001\u001a\u001a\u0010\u000b\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u001a\u0010\r\u001a\u00020\u0006*\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u001a\u0016\u0010\u0012\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014\u001a\"\u0010\u0015\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002\u001a\b\u0010\u0016\u001a\u00020\u0017H\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\u00a8\u0006\u0018"}, d2={"isModuleLevel", "", "Lorg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventKind;", "(Lorg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventKind;)Z", "isGlobalLevel", "publishModificationEventByDirective", "", "Lorg/jetbrains/kotlin/test/model/TestModule;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "isOptional", "publishWildcardModificationEventByDirectiveIfPresent", "modificationEventKind", "publishWildcardModificationEventsByDirective", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "publishModificationEvent", "ktModule", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "publishGlobalModificationEvent", "project", "Lcom/intellij/openapi/project/Project;", "publishModificationEventByKind", "errorModuleRequired", "", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nModificationEventDirectives.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModificationEventDirectives.kt\norg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventDirectivesKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1863#2,2:163\n*S KotlinDebug\n*F\n+ 1 ModificationEventDirectives.kt\norg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventDirectivesKt\n*L\n107#1:163,2\n*E\n"})
public final class ModificationEventDirectivesKt {
    public static final boolean isModuleLevel(@NotNull ModificationEventKind $this$isModuleLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isModuleLevel), (String)"<this>");
        return $this$isModuleLevel == ModificationEventKind.MODULE_STATE_MODIFICATION || $this$isModuleLevel == ModificationEventKind.MODULE_OUT_OF_BLOCK_MODIFICATION;
    }

    public static final boolean isGlobalLevel(@NotNull ModificationEventKind $this$isGlobalLevel) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$isGlobalLevel), (String)"<this>");
        return !ModificationEventDirectivesKt.isModuleLevel($this$isGlobalLevel);
    }

    public static final void publishModificationEventByDirective(@NotNull TestModule $this$publishModificationEventByDirective, @NotNull TestServices testServices, boolean isOptional) {
        Intrinsics.checkNotNullParameter((Object)$this$publishModificationEventByDirective, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List modificationEventKinds = $this$publishModificationEventByDirective.getDirectives().get(ModificationEventDirectives.INSTANCE.getMODIFICATION_EVENT());
        switch (modificationEventKinds.size()) {
            case 0: {
                if (isOptional) {
                    return;
                }
                throw new IllegalStateException(("Expected a `" + ModificationEventDirectives.INSTANCE.getMODIFICATION_EVENT().getName() + "` to be present in the test module `" + $this$publishModificationEventByDirective + "`.").toString());
            }
            case 1: {
                break;
            }
            default: {
                throw new IllegalStateException(("The test module `" + $this$publishModificationEventByDirective + "` must not specify multiple modification events.").toString());
            }
        }
        ModificationEventKind modificationEventKind = (ModificationEventKind)((Object)CollectionsKt.single((List)modificationEventKinds));
        ModificationEventDirectivesKt.publishModificationEvent(modificationEventKind, AnalysisApiKtModuleProviderImplKt.getKtModule($this$publishModificationEventByDirective, testServices));
    }

    public static /* synthetic */ void publishModificationEventByDirective$default(TestModule testModule, TestServices testServices, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        ModificationEventDirectivesKt.publishModificationEventByDirective(testModule, testServices, bl);
    }

    public static final void publishWildcardModificationEventByDirectiveIfPresent(@NotNull TestModule $this$publishWildcardModificationEventByDirectiveIfPresent, @NotNull ModificationEventKind modificationEventKind, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)$this$publishWildcardModificationEventByDirectiveIfPresent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)modificationEventKind), (String)"modificationEventKind");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        if (!$this$publishWildcardModificationEventByDirectiveIfPresent.getDirectives().contains((Directive)ModificationEventDirectives.INSTANCE.getWILDCARD_MODIFICATION_EVENT())) {
            return;
        }
        ModificationEventDirectivesKt.publishModificationEvent(modificationEventKind, AnalysisApiKtModuleProviderImplKt.getKtModule($this$publishWildcardModificationEventByDirectiveIfPresent, testServices));
    }

    public static final void publishWildcardModificationEventsByDirective(@NotNull TestModuleStructure $this$publishWildcardModificationEventsByDirective, @NotNull ModificationEventKind modificationEventKind, @NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)$this$publishWildcardModificationEventsByDirective, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)modificationEventKind), (String)"modificationEventKind");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        if (ModificationEventDirectivesKt.isModuleLevel(modificationEventKind)) {
            Iterable $this$forEach$iv = $this$publishWildcardModificationEventsByDirective.getModules();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                TestModule testModule = (TestModule)element$iv;
                boolean bl = false;
                ModificationEventDirectivesKt.publishWildcardModificationEventByDirectiveIfPresent(testModule, modificationEventKind, testServices);
            }
        } else {
            if (!$this$publishWildcardModificationEventsByDirective.getAllDirectives().contains((Directive)ModificationEventDirectives.INSTANCE.getWILDCARD_MODIFICATION_EVENT())) {
                return;
            }
            ModificationEventDirectivesKt.publishGlobalModificationEvent(modificationEventKind, AnalysisApiEnvironmentManagerKt.getEnvironmentManager(testServices).getProject());
        }
    }

    public static final void publishModificationEvent(@NotNull ModificationEventKind modificationEventKind, @NotNull KtModule ktModule) {
        Intrinsics.checkNotNullParameter((Object)((Object)modificationEventKind), (String)"modificationEventKind");
        Intrinsics.checkNotNullParameter((Object)ktModule, (String)"ktModule");
        ModificationEventDirectivesKt.publishModificationEventByKind(modificationEventKind, ktModule.getProject(), ktModule);
    }

    public static final void publishGlobalModificationEvent(@NotNull ModificationEventKind modificationEventKind, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)((Object)modificationEventKind), (String)"modificationEventKind");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!ModificationEventDirectivesKt.isGlobalLevel(modificationEventKind)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        ModificationEventDirectivesKt.publishModificationEventByKind(modificationEventKind, project, null);
    }

    private static final void publishModificationEventByKind(ModificationEventKind modificationEventKind, Project project, KtModule ktModule) {
        UtilKt.runWriteAction(() -> ModificationEventDirectivesKt.publishModificationEventByKind$lambda$1(modificationEventKind, project, ktModule));
    }

    private static final Void errorModuleRequired() {
        throw new IllegalStateException("Cannot publish a module-level modification event without a module.".toString());
    }

    private static final Unit publishModificationEventByKind$lambda$1(ModificationEventKind $modificationEventKind, Project $project, KtModule $ktModule) {
        Intrinsics.checkNotNullParameter((Object)((Object)$modificationEventKind), (String)"$modificationEventKind");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        switch (WhenMappings.$EnumSwitchMapping$0[$modificationEventKind.ordinal()]) {
            case 1: {
                KtModule ktModule = $ktModule;
                if (ktModule == null) {
                    ModificationEventDirectivesKt.errorModuleRequired();
                    throw null;
                }
                ((KotlinModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinTopics.INSTANCE.getMODULE_STATE_MODIFICATION())).onModification(ktModule, KotlinModuleStateModificationKind.UPDATE);
                break;
            }
            case 2: {
                KtModule ktModule = $ktModule;
                if (ktModule == null) {
                    ModificationEventDirectivesKt.errorModuleRequired();
                    throw null;
                }
                ((KotlinModuleOutOfBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinTopics.INSTANCE.getMODULE_OUT_OF_BLOCK_MODIFICATION())).onModification(ktModule);
                break;
            }
            case 3: {
                ((KotlinGlobalModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinTopics.INSTANCE.getGLOBAL_MODULE_STATE_MODIFICATION())).onModification();
                break;
            }
            case 4: {
                ((KotlinGlobalSourceModuleStateModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinTopics.INSTANCE.getGLOBAL_SOURCE_MODULE_STATE_MODIFICATION())).onModification();
                break;
            }
            case 5: {
                ((KotlinGlobalSourceOutOfBlockModificationListener)KotlinMessageBusProviderKt.getAnalysisMessageBus((Project)$project).syncPublisher(KotlinTopics.INSTANCE.getGLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION())).onModification();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ModificationEventKind.values().length];
            try {
                nArray[ModificationEventKind.MODULE_STATE_MODIFICATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModificationEventKind.MODULE_OUT_OF_BLOCK_MODIFICATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModificationEventKind.GLOBAL_MODULE_STATE_MODIFICATION.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModificationEventKind.GLOBAL_SOURCE_MODULE_STATE_MODIFICATION.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ModificationEventKind.GLOBAL_SOURCE_OUT_OF_BLOCK_MODIFICATION.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

