/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.sessions;

import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.sessions.LLFirSessionCache;
import org.jetbrains.kotlin.analysis.low.level.api.fir.test.configurators.AnalysisApiFirSourceTestConfigurator;
import org.jetbrains.kotlin.analysis.project.structure.KtModule;
import org.jetbrains.kotlin.analysis.test.framework.base.AbstractAnalysisApiBasedTest;
import org.jetbrains.kotlin.analysis.test.framework.directives.ModificationEventDirectivesKt;
import org.jetbrains.kotlin.analysis.test.framework.directives.ModificationEventKind;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.AnalysisApiKtModuleProviderImplKt;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.AssertionsService;
import org.jetbrains.kotlin.test.services.TestModuleStructure;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0002J&\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J\u001e\u0010\u0017\u001a\u00020\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u00162\u0006\u0010\f\u001a\u00020\rH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/AbstractSessionInvalidationTest;", "Lorg/jetbrains/kotlin/analysis/test/framework/base/AbstractAnalysisApiBasedTest;", "<init>", "()V", "modificationEventKind", "Lorg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventKind;", "getModificationEventKind", "()Lorg/jetbrains/kotlin/analysis/test/framework/directives/ModificationEventKind;", "doTestByModuleStructure", "", "moduleStructure", "Lorg/jetbrains/kotlin/test/services/TestModuleStructure;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "getSessionsFor", "", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/LLFirSession;", "modules", "Lorg/jetbrains/kotlin/analysis/project/structure/KtModule;", "checkInvalidatedModules", "testModuleStructure", "invalidatedSessions", "", "checkSessionsMarkedInvalid", "configurator", "Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "getConfigurator", "()Lorg/jetbrains/kotlin/analysis/test/framework/test/configurators/AnalysisApiTestConfigurator;", "low-level-api-fir_test"})
@SourceDebugExtension(value={"SMAP\nAbstractSessionInvalidationTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractSessionInvalidationTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/AbstractSessionInvalidationTest\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,114:1\n1557#2:115\n1628#2,3:116\n1557#2:119\n1628#2,3:120\n1557#2:123\n1628#2,3:124\n774#2:127\n865#2,2:128\n1863#2,2:130\n1863#2,2:132\n*S KotlinDebug\n*F\n+ 1 AbstractSessionInvalidationTest.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/sessions/AbstractSessionInvalidationTest\n*L\n49#1:115\n49#1:116,3\n57#1:119\n57#1:120,3\n60#1:123\n60#1:124,3\n61#1:127\n61#1:128,2\n70#1:130,2\n80#1:132,2\n*E\n"})
public abstract class AbstractSessionInvalidationTest
extends AbstractAnalysisApiBasedTest {
    @NotNull
    private final AnalysisApiTestConfigurator configurator = new AnalysisApiFirSourceTestConfigurator(false);

    @NotNull
    protected abstract ModificationEventKind getModificationEventKind();

    @Override
    protected void doTestByModuleStructure(@NotNull TestModuleStructure moduleStructure, @NotNull TestServices testServices) {
        Set set;
        Intrinsics.checkNotNullParameter((Object)moduleStructure, (String)"moduleStructure");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        List<KtModule> allKtModules = AnalysisApiKtModuleProviderImplKt.getKtModuleProvider(testServices).getModuleStructure().allKtModules();
        List<LLFirSession> sessionsBeforeModification = this.getSessionsFor(allKtModules);
        ModificationEventDirectivesKt.publishWildcardModificationEventsByDirective(moduleStructure, this.getModificationEventKind(), testServices);
        List<LLFirSession> sessionsAfterModification = this.getSessionsFor(allKtModules);
        Set $this$doTestByModuleStructure_u24lambda_u240 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$doTestByModuleStructure_u24lambda_u240.addAll((Collection)sessionsBeforeModification);
        $this$doTestByModuleStructure_u24lambda_u240.removeAll((Collection)sessionsAfterModification);
        Set invalidatedSessions = SetsKt.build((Set)set);
        this.checkInvalidatedModules(moduleStructure, invalidatedSessions, testServices);
        this.checkSessionsMarkedInvalid(invalidatedSessions, testServices);
    }

    /*
     * WARNING - void declaration
     */
    private final List<LLFirSession> getSessionsFor(List<? extends KtModule> modules) {
        void $this$mapTo$iv$iv;
        Project project = ((KtModule)CollectionsKt.first(modules)).getProject();
        LLFirSessionCache sessionCache = LLFirSessionCache.Companion.getInstance(project);
        Iterable $this$map$iv = modules;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtModule ktModule = (KtModule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(LLFirSessionCache.getSession$default((LLFirSessionCache)sessionCache, (KtModule)it, (boolean)false, (int)2, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkInvalidatedModules(TestModuleStructure testModuleStructure, Set<? extends LLFirSession> invalidatedSessions, TestServices testServices) {
        StringBuilder stringBuilder;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Iterable $this$map$iv2 = testModuleStructure.getModules();
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            TestModule testModule = (TestModule)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getName());
        }
        List testModuleNames = (List)destination$iv$iv;
        Iterable $i$f$map22 = invalidatedSessions;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LLFirSession bl = (LLFirSession)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(it.getKtModule().toString());
        }
        $this$map$iv = (List)destination$iv$iv2;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!testModuleNames.contains(it)) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List invalidatedModuleDescriptions = CollectionsKt.sorted((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv2)));
        StringBuilder $this$checkInvalidatedModules_u24lambda_u246 = stringBuilder = new StringBuilder();
        boolean bl = false;
        StringBuilder stringBuilder2 = $this$checkInvalidatedModules_u24lambda_u246.append("Module names of invalidated sessions:");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append(...)");
        Iterable $this$forEach$iv = invalidatedModuleDescriptions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl3 = false;
            StringBuilder stringBuilder3 = $this$checkInvalidatedModules_u24lambda_u246.append(it);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3.append('\n'), (String)"append(...)");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String actualText2 = string;
        AbstractAnalysisApiBasedTest abstractAnalysisApiBasedTest = this;
        AssertionsService assertionsService = AssertionsKt.getAssertions((TestServices)testServices);
        StringBuilder stringBuilder4 = new StringBuilder().append('.');
        String string2 = this.getModificationEventKind().name().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        AbstractAnalysisApiBasedTest.assertEqualsToTestDataFileSibling$default(abstractAnalysisApiBasedTest, assertionsService, actualText2, stringBuilder4.append(string2).append(".txt").toString(), null, 4, null);
    }

    private final void checkSessionsMarkedInvalid(Set<? extends LLFirSession> invalidatedSessions, TestServices testServices) {
        Iterable $this$forEach$iv = invalidatedSessions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LLFirSession session = (LLFirSession)element$iv;
            boolean bl = false;
            AssertionsKt.getAssertions((TestServices)testServices).assertFalse(session.isValid(), () -> AbstractSessionInvalidationTest.checkSessionsMarkedInvalid$lambda$8$lambda$7(session));
        }
    }

    @Override
    @NotNull
    public AnalysisApiTestConfigurator getConfigurator() {
        return this.configurator;
    }

    private static final String checkSessionsMarkedInvalid$lambda$8$lambda$7(LLFirSession $session) {
        Intrinsics.checkNotNullParameter((Object)$session, (String)"$session");
        return "The invalidated session `" + $session + "` should have been marked invalid.";
    }
}

