/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.standalone.fir.test.cases.generated.cases.references;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.references.AbstractReferenceResolveTest;
import org.jetbrains.kotlin.analysis.api.standalone.fir.test.configurators.AnalysisApiFirStandaloneModeTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/analysis-api/testData/referenceResolve")
@TestDataPath(value="$PROJECT_ROOT")
public class FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated
extends AbstractReferenceResolveTest {
    @Override
    @NotNull
    public AnalysisApiTestConfigurator getConfigurator() {
        AnalysisApiTestConfigurator analysisApiTestConfigurator = AnalysisApiFirStandaloneModeTestConfiguratorFactory.INSTANCE.createConfigurator(new AnalysisApiTestConfiguratorFactoryData(FrontendKind.Fir, TestModuleKind.Source, AnalysisSessionMode.Normal, AnalysisApiMode.Standalone));
        if (analysisApiTestConfigurator == null) {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.$$$reportNull$$$0(0);
        }
        return analysisApiTestConfigurator;
    }

    @Test
    public void testAllFilesPresentInReferenceResolve() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
    }

    @Test
    @TestMetadata(value="AnnotationForClass.kt")
    public void testAnnotationForClass() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationForClass.kt");
    }

    @Test
    @TestMetadata(value="AnnotationInsideFunction.kt")
    public void testAnnotationInsideFunction() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationInsideFunction.kt");
    }

    @Test
    @TestMetadata(value="AnnotationOnCallSite.kt")
    public void testAnnotationOnCallSite() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnCallSite.kt");
    }

    @Test
    @TestMetadata(value="AnnotationOnFile.kt")
    public void testAnnotationOnFile() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnFile.kt");
    }

    @Test
    @TestMetadata(value="AnnotationOnFile2.kt")
    public void testAnnotationOnFile2() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnFile2.kt");
    }

    @Test
    @TestMetadata(value="AnnotationOnFileWithImport.kt")
    public void testAnnotationOnFileWithImport() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationOnFileWithImport.kt");
    }

    @Test
    @TestMetadata(value="AnnotationTypeParameter.kt")
    public void testAnnotationTypeParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/AnnotationTypeParameter.kt");
    }

    @Test
    @TestMetadata(value="ClassInTypeConstraint.kt")
    public void testClassInTypeConstraint() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassInTypeConstraint.kt");
    }

    @Test
    @TestMetadata(value="ClassObjectClassLiteralReference.kt")
    public void testClassObjectClassLiteralReference() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassObjectClassLiteralReference.kt");
    }

    @Test
    @TestMetadata(value="ClassObjectClassLiteralReferenceWithField.kt")
    public void testClassObjectClassLiteralReferenceWithField() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassObjectClassLiteralReferenceWithField.kt");
    }

    @Test
    @TestMetadata(value="ClassQualifierForNestedClassConstructorCall.kt")
    public void testClassQualifierForNestedClassConstructorCall() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassQualifierForNestedClassConstructorCall.kt");
    }

    @Test
    @TestMetadata(value="ClassReferenceInImport.kt")
    public void testClassReferenceInImport() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ClassReferenceInImport.kt");
    }

    @Test
    @TestMetadata(value="CollectionStream.kt")
    public void testCollectionStream() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/CollectionStream.kt");
    }

    @Test
    @TestMetadata(value="CompanionObjectWithName1.kt")
    public void testCompanionObjectWithName1() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/CompanionObjectWithName1.kt");
    }

    @Test
    @TestMetadata(value="CompanionObjectWithName2.kt")
    public void testCompanionObjectWithName2() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/CompanionObjectWithName2.kt");
    }

    @Test
    @TestMetadata(value="CtrlClickResolve.kt")
    public void testCtrlClickResolve() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/CtrlClickResolve.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectAsExtensionReceiverForFunction.kt")
    public void testDefaultObjectAsExtensionReceiverForFunction() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsExtensionReceiverForFunction.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectAsExtensionReceiverForProperty.kt")
    public void testDefaultObjectAsExtensionReceiverForProperty() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsExtensionReceiverForProperty.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectAsReceiverForExtensionFunctionOnSuperType.kt")
    public void testDefaultObjectAsReceiverForExtensionFunctionOnSuperType() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsReceiverForExtensionFunctionOnSuperType.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectAsReceiverForMemberPropertyInSuperType.kt")
    public void testDefaultObjectAsReceiverForMemberPropertyInSuperType() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectAsReceiverForMemberPropertyInSuperType.kt");
    }

    @Test
    @TestMetadata(value="DefaultObjectInShortReferenceFormCall.kt")
    public void testDefaultObjectInShortReferenceFormCall() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DefaultObjectInShortReferenceFormCall.kt");
    }

    @Test
    @TestMetadata(value="Deprecated.kt")
    public void testDeprecated() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/Deprecated.kt");
    }

    @Test
    @TestMetadata(value="DestructuringDeclarationInInit.kt")
    public void testDestructuringDeclarationInInit() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/DestructuringDeclarationInInit.kt");
    }

    @Test
    @TestMetadata(value="EnumValues.kt")
    public void testEnumValues() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/EnumValues.kt");
    }

    @Test
    @TestMetadata(value="EqualsOperator.kt")
    public void testEqualsOperator() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/EqualsOperator.kt");
    }

    @Test
    @TestMetadata(value="EqualsOperatorNoInfix.kt")
    public void testEqualsOperatorNoInfix() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/EqualsOperatorNoInfix.kt");
    }

    @Test
    @TestMetadata(value="explicitFunctionalInterfaceInvoke_globalVal.kt")
    public void testExplicitFunctionalInterfaceInvoke_globalVal() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/explicitFunctionalInterfaceInvoke_globalVal.kt");
    }

    @Test
    @TestMetadata(value="explicitFunctionalInterfaceInvoke_parameter.kt")
    public void testExplicitFunctionalInterfaceInvoke_parameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/explicitFunctionalInterfaceInvoke_parameter.kt");
    }

    @Test
    @TestMetadata(value="explicitLambdaParameter.kt")
    public void testExplicitLambdaParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/explicitLambdaParameter.kt");
    }

    @Test
    @TestMetadata(value="ExternalCompanionObject.kt")
    public void testExternalCompanionObject() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ExternalCompanionObject.kt");
    }

    @Test
    @TestMetadata(value="functionCall.kt")
    public void testFunctionCall() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/functionCall.kt");
    }

    @Test
    @TestMetadata(value="GenericFunctionParameter.kt")
    public void testGenericFunctionParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/GenericFunctionParameter.kt");
    }

    @Test
    @TestMetadata(value="GenericTypeInFunctionParameter.kt")
    public void testGenericTypeInFunctionParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/GenericTypeInFunctionParameter.kt");
    }

    @Test
    @TestMetadata(value="implicitExtensionInvoke.kt")
    public void testImplicitExtensionInvoke() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/implicitExtensionInvoke.kt");
    }

    @Test
    @TestMetadata(value="implicitFunctionInvoke.kt")
    public void testImplicitFunctionInvoke() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/implicitFunctionInvoke.kt");
    }

    @Test
    @TestMetadata(value="implicitFunctionalInterfaceInvoke.kt")
    public void testImplicitFunctionalInterfaceInvoke() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/implicitFunctionalInterfaceInvoke.kt");
    }

    @Test
    @TestMetadata(value="implicitLambdaParameter.kt")
    public void testImplicitLambdaParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/implicitLambdaParameter.kt");
    }

    @Test
    @TestMetadata(value="importAlias.kt")
    public void testImportAlias() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/importAlias.kt");
    }

    @Test
    @TestMetadata(value="ImportFromRootScope.kt")
    public void testImportFromRootScope() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ImportFromRootScope.kt");
    }

    @Test
    @TestMetadata(value="InClassParameter.kt")
    public void testInClassParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InClassParameter.kt");
    }

    @Test
    @TestMetadata(value="InClassParameterField.kt")
    public void testInClassParameterField() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InClassParameterField.kt");
    }

    @Test
    @TestMetadata(value="InEnumEntry.kt")
    public void testInEnumEntry() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InEnumEntry.kt");
    }

    @Test
    @TestMetadata(value="InFunctionParameterType.kt")
    public void testInFunctionParameterType() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InFunctionParameterType.kt");
    }

    @Test
    @TestMetadata(value="InMethodParameter.kt")
    public void testInMethodParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InMethodParameter.kt");
    }

    @Test
    @TestMetadata(value="InMethodVarargParameter.kt")
    public void testInMethodVarargParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InMethodVarargParameter.kt");
    }

    @Test
    @TestMetadata(value="InOperator.kt")
    public void testInOperator() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InOperator.kt");
    }

    @Test
    @TestMetadata(value="InVaragReferenceInFunctionBody.kt")
    public void testInVaragReferenceInFunctionBody() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InVaragReferenceInFunctionBody.kt");
    }

    @Test
    @TestMetadata(value="InVaragReferenceInNamedParameter.kt")
    public void testInVaragReferenceInNamedParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/InVaragReferenceInNamedParameter.kt");
    }

    @Test
    @TestMetadata(value="JsAsDynamic.kt")
    public void testJsAsDynamic() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/JsAsDynamic.kt");
    }

    @Test
    @TestMetadata(value="KotlinPropertyAssignment.kt")
    public void testKotlinPropertyAssignment() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/KotlinPropertyAssignment.kt");
    }

    @Test
    @TestMetadata(value="KotlinPropertyWithGetterAndSetterAssignment.kt")
    public void testKotlinPropertyWithGetterAndSetterAssignment() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/KotlinPropertyWithGetterAndSetterAssignment.kt");
    }

    @Test
    @TestMetadata(value="LabelsReturn.kt")
    public void testLabelsReturn() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/LabelsReturn.kt");
    }

    @Test
    @TestMetadata(value="MultiDeclarationExtension.kt")
    public void testMultiDeclarationExtension() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/MultiDeclarationExtension.kt");
    }

    @Test
    @TestMetadata(value="MultiDeclarationMember.kt")
    public void testMultiDeclarationMember() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/MultiDeclarationMember.kt");
    }

    @Test
    @TestMetadata(value="NamedClassObject.kt")
    public void testNamedClassObject() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/NamedClassObject.kt");
    }

    @Test
    @TestMetadata(value="NotEqualsOperator.kt")
    public void testNotEqualsOperator() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/NotEqualsOperator.kt");
    }

    @Test
    @TestMetadata(value="NotInOperator.kt")
    public void testNotInOperator() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/NotInOperator.kt");
    }

    @Test
    @TestMetadata(value="PackageFromAnnotationOnFile.kt")
    public void testPackageFromAnnotationOnFile() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageFromAnnotationOnFile.kt");
    }

    @Test
    @TestMetadata(value="PackageFromAnnotationOnFileWithUnresolvedReference.kt")
    public void testPackageFromAnnotationOnFileWithUnresolvedReference() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageFromAnnotationOnFileWithUnresolvedReference.kt");
    }

    @Test
    @TestMetadata(value="PackageFromAnnotationOnFunction.kt")
    public void testPackageFromAnnotationOnFunction() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageFromAnnotationOnFunction.kt");
    }

    @Test
    @TestMetadata(value="PackageFromAnnotationOnFunctionWithUnresolvedReference.kt")
    public void testPackageFromAnnotationOnFunctionWithUnresolvedReference() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageFromAnnotationOnFunctionWithUnresolvedReference.kt");
    }

    @Test
    @TestMetadata(value="PackageReference.kt")
    public void testPackageReference() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageReference.kt");
    }

    @Test
    @TestMetadata(value="PackageReferenceInImport.kt")
    public void testPackageReferenceInImport() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PackageReferenceInImport.kt");
    }

    @Test
    @TestMetadata(value="parameterByName.kt")
    public void testParameterByName() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/parameterByName.kt");
    }

    @Test
    @TestMetadata(value="parameterByNameInSafeCall.kt")
    public void testParameterByNameInSafeCall() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/parameterByNameInSafeCall.kt");
    }

    @Test
    @TestMetadata(value="PlusAssignByHand.kt")
    public void testPlusAssignByHand() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignByHand.kt");
    }

    @Test
    @TestMetadata(value="PlusAssignOperator.kt")
    public void testPlusAssignOperator() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignOperator.kt");
    }

    @Test
    @TestMetadata(value="PlusAssignViaPlusOperator.kt")
    public void testPlusAssignViaPlusOperator() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/PlusAssignViaPlusOperator.kt");
    }

    @Test
    @TestMetadata(value="ReferenceInClassWhereConstraint.kt")
    public void testReferenceInClassWhereConstraint() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ReferenceInClassWhereConstraint.kt");
    }

    @Test
    @TestMetadata(value="ReferenceInFunWhereConstraint.kt")
    public void testReferenceInFunWhereConstraint() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ReferenceInFunWhereConstraint.kt");
    }

    @Test
    @TestMetadata(value="ResolveClass.kt")
    public void testResolveClass() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolveClass.kt");
    }

    @Test
    @TestMetadata(value="ResolvePackageInProperty.kt")
    public void testResolvePackageInProperty() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInProperty.kt");
    }

    @Test
    @TestMetadata(value="ResolvePackageInTheEndInProperty.kt")
    public void testResolvePackageInTheEndInProperty() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheEndInProperty.kt");
    }

    @Test
    @TestMetadata(value="ResolvePackageInTheMiddleInProperty.kt")
    public void testResolvePackageInTheMiddleInProperty() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheMiddleInProperty.kt");
    }

    @Test
    @TestMetadata(value="ResolvePackageInTheTypeNameInProperty.kt")
    public void testResolvePackageInTheTypeNameInProperty() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ResolvePackageInTheTypeNameInProperty.kt");
    }

    @Test
    @TestMetadata(value="RetentionValue.kt")
    public void testRetentionValue() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/RetentionValue.kt");
    }

    @Test
    @TestMetadata(value="SamAdapter.kt")
    public void testSamAdapter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SamAdapter.kt");
    }

    @Test
    @TestMetadata(value="SamConstructor.kt")
    public void testSamConstructor() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SamConstructor.kt");
    }

    @Test
    @TestMetadata(value="SamConstructorTypeArguments.kt")
    public void testSamConstructorTypeArguments() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SamConstructorTypeArguments.kt");
    }

    @Test
    @TestMetadata(value="SeveralOverrides.kt")
    public void testSeveralOverrides() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SeveralOverrides.kt");
    }

    @Test
    @TestMetadata(value="smartCastExpression.kt")
    public void testSmartCastExpression() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/smartCastExpression.kt");
    }

    @Test
    @TestMetadata(value="smartCastInvokeReceiver.kt")
    public void testSmartCastInvokeReceiver() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/smartCastInvokeReceiver.kt");
    }

    @Test
    @TestMetadata(value="SuperTypePrimaryConstructor.kt")
    public void testSuperTypePrimaryConstructor() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SuperTypePrimaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="SuperTypeSecondaryConstructor.kt")
    public void testSuperTypeSecondaryConstructor() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/SuperTypeSecondaryConstructor.kt");
    }

    @Test
    @TestMetadata(value="superWithLabel_caretAtLabel.kt")
    public void testSuperWithLabel_caretAtLabel() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/superWithLabel_caretAtLabel.kt");
    }

    @Test
    @TestMetadata(value="superWithLabel_caretAtSuper.kt")
    public void testSuperWithLabel_caretAtSuper() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/superWithLabel_caretAtSuper.kt");
    }

    @Test
    @TestMetadata(value="thisWithLabelToFunction_caretAtLabel.kt")
    public void testThisWithLabelToFunction_caretAtLabel() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToFunction_caretAtLabel.kt");
    }

    @Test
    @TestMetadata(value="thisWithLabelToFunction_caretAtThis.kt")
    public void testThisWithLabelToFunction_caretAtThis() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToFunction_caretAtThis.kt");
    }

    @Test
    @TestMetadata(value="thisWithLabelToProperty_caretAtLabel.kt")
    public void testThisWithLabelToProperty_caretAtLabel() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToProperty_caretAtLabel.kt");
    }

    @Test
    @TestMetadata(value="thisWithLabelToProperty_caretAtThis.kt")
    public void testThisWithLabelToProperty_caretAtThis() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/thisWithLabelToProperty_caretAtThis.kt");
    }

    @Test
    @TestMetadata(value="todo.kt")
    public void testTodo() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/todo.kt");
    }

    @Test
    @TestMetadata(value="TopLevelClassVsLocalClassConstructor.kt")
    public void testTopLevelClassVsLocalClassConstructor() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelClassVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="TopLevelClassVsLocalClassConstructor2.kt")
    public void testTopLevelClassVsLocalClassConstructor2() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelClassVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata(value="TopLevelCompanionObjectVsLocalClassConstructor.kt")
    public void testTopLevelCompanionObjectVsLocalClassConstructor() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="TopLevelCompanionObjectVsLocalClassConstructor2.kt")
    public void testTopLevelCompanionObjectVsLocalClassConstructor2() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata(value="TopLevelCompanionObjectVsLocalClassQualifier.kt")
    public void testTopLevelCompanionObjectVsLocalClassQualifier() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelCompanionObjectVsLocalClassQualifier.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassConstructor.kt")
    public void testTopLevelObjectVsLocalClassConstructor() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassConstructor2.kt")
    public void testTopLevelObjectVsLocalClassConstructor2() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor2.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassConstructor3.kt")
    public void testTopLevelObjectVsLocalClassConstructor3() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor3.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassConstructor4.kt")
    public void testTopLevelObjectVsLocalClassConstructor4() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassConstructor4.kt");
    }

    @Test
    @TestMetadata(value="TopLevelObjectVsLocalClassQualifier.kt")
    public void testTopLevelObjectVsLocalClassQualifier() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TopLevelObjectVsLocalClassQualifier.kt");
    }

    @Test
    @TestMetadata(value="TypeAlias.kt")
    public void testTypeAlias() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TypeAlias.kt");
    }

    @Test
    @TestMetadata(value="TypeAliasAsSupertypeConstructor.kt")
    public void testTypeAliasAsSupertypeConstructor() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TypeAliasAsSupertypeConstructor.kt");
    }

    @Test
    @TestMetadata(value="TypeAliasRHS.kt")
    public void testTypeAliasRHS() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/TypeAliasRHS.kt");
    }

    @Test
    @TestMetadata(value="ValueParameter.kt")
    public void testValueParameter() {
        this.runTest("analysis/analysis-api/testData/referenceResolve/ValueParameter.kt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/analysis/api/standalone/fir/test/cases/generated/cases/references/FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated", "getConfigurator"));
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/withErrors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WithErrors {
        @Test
        public void testAllFilesPresentInWithErrors() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="AnnotationParameter.kt")
        public void testAnnotationParameter() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/AnnotationParameter.kt");
        }

        @Test
        @TestMetadata(value="BuiltInImportsNoRuntime.kt")
        public void testBuiltInImportsNoRuntime() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/BuiltInImportsNoRuntime.kt");
        }

        @Test
        @TestMetadata(value="ByReturnExpression.kt")
        public void testByReturnExpression() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ByReturnExpression.kt");
        }

        @Test
        @TestMetadata(value="ClassNameBeforeDot.kt")
        public void testClassNameBeforeDot() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ClassNameBeforeDot.kt");
        }

        @Test
        @TestMetadata(value="ClassReferenceInIncorrectWhenClause.kt")
        public void testClassReferenceInIncorrectWhenClause() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ClassReferenceInIncorrectWhenClause.kt");
        }

        @Test
        @TestMetadata(value="ClassWithMultipleSuperTypeCalls.kt")
        public void testClassWithMultipleSuperTypeCalls() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ClassWithMultipleSuperTypeCalls.kt");
        }

        @Test
        @TestMetadata(value="CollectionLiteralLeft.kt")
        public void testCollectionLiteralLeft() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CollectionLiteralLeft.kt");
        }

        @Test
        @TestMetadata(value="CollectionLiteralRight.kt")
        public void testCollectionLiteralRight() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CollectionLiteralRight.kt");
        }

        @Test
        @TestMetadata(value="CoroutineSuspensionPoint.kt")
        public void testCoroutineSuspensionPoint() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/CoroutineSuspensionPoint.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotations.kt")
        public void testDanglingAnnotations() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/DanglingAnnotations.kt");
        }

        @Test
        @TestMetadata(value="DeprecatedHidden.kt")
        public void testDeprecatedHidden() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/DeprecatedHidden.kt");
        }

        @Test
        @TestMetadata(value="FakeJavaLang1.kt")
        public void testFakeJavaLang1() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang1.kt");
        }

        @Test
        @TestMetadata(value="FakeJavaLang2.kt")
        public void testFakeJavaLang2() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang2.kt");
        }

        @Test
        @TestMetadata(value="FakeJavaLang3.kt")
        public void testFakeJavaLang3() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang3.kt");
        }

        @Test
        @TestMetadata(value="FakeJavaLang4.kt")
        public void testFakeJavaLang4() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/FakeJavaLang4.kt");
        }

        @Test
        @TestMetadata(value="InObjectClassObject.kt")
        public void testInObjectClassObject() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InObjectClassObject.kt");
        }

        @Test
        @TestMetadata(value="InSecondClassObject.kt")
        public void testInSecondClassObject() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InSecondClassObject.kt");
        }

        @Test
        @TestMetadata(value="InvisibleMember.kt")
        public void testInvisibleMember() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/InvisibleMember.kt");
        }

        @Test
        @TestMetadata(value="NoSelectorInDotQualifiedCall.kt")
        public void testNoSelectorInDotQualifiedCall() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInDotQualifiedCall.kt");
        }

        @Test
        @TestMetadata(value="NoSelectorInDotQualifiedCall_ResolveInsideLambda.kt")
        public void testNoSelectorInDotQualifiedCall_ResolveInsideLambda() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInDotQualifiedCall_ResolveInsideLambda.kt");
        }

        @Test
        @TestMetadata(value="NoSelectorInSafeQualifiedCall.kt")
        public void testNoSelectorInSafeQualifiedCall() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/NoSelectorInSafeQualifiedCall.kt");
        }

        @Test
        @TestMetadata(value="PropertyPlaceInClassObjectInObject.kt")
        public void testPropertyPlaceInClassObjectInObject() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/PropertyPlaceInClassObjectInObject.kt");
        }

        @Test
        @TestMetadata(value="ResolveClassNameInCallExpression.kt")
        public void testResolveClassNameInCallExpression() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/ResolveClassNameInCallExpression.kt");
        }

        @Test
        @TestMetadata(value="TopLevelClassVsLocalClassQualifier.kt")
        public void testTopLevelClassVsLocalClassQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TopLevelClassVsLocalClassQualifier.kt");
        }

        @Test
        @TestMetadata(value="TopLevelDestructingDeclaration.kt")
        public void testTopLevelDestructingDeclaration() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TopLevelDestructingDeclaration.kt");
        }

        @Test
        @TestMetadata(value="TypeArgumentBeforeDot2.kt")
        public void testTypeArgumentBeforeDot2() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentBeforeDot2.kt");
        }

        @Test
        @TestMetadata(value="TypeArgumentUnresolvedClass.kt")
        public void testTypeArgumentUnresolvedClass() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentUnresolvedClass.kt");
        }

        @Test
        @TestMetadata(value="TypeArgumentUnresolvedConstructor.kt")
        public void testTypeArgumentUnresolvedConstructor() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentUnresolvedConstructor.kt");
        }

        @Test
        @TestMetadata(value="TypeArgumentWrongNumber.kt")
        public void testTypeArgumentWrongNumber() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/TypeArgumentWrongNumber.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArguments.kt")
        public void testWrongNumberOfTypeArguments() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArguments2.kt")
        public void testWrongNumberOfTypeArguments2() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments2.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArguments3.kt")
        public void testWrongNumberOfTypeArguments3() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments3.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArguments4.kt")
        public void testWrongNumberOfTypeArguments4() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArguments4.kt");
        }

        @Test
        @TestMetadata(value="WrongNumberOfTypeArgumentsInSupertype.kt")
        public void testWrongNumberOfTypeArgumentsInSupertype() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/WrongNumberOfTypeArgumentsInSupertype.kt");
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier")
        @TestDataPath(value="$PROJECT_ROOT")
        public class PartiallyUnresolvedTypeQualifier {
            @Test
            public void testAllFilesPresentInPartiallyUnresolvedTypeQualifier() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="ClassNameBeforeOneUnsresolvedClass.kt")
            public void testClassNameBeforeOneUnsresolvedClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeOneUnsresolvedClass.kt");
            }

            @Test
            @TestMetadata(value="ClassNameBeforeOneUnsresolvedClassWithDot.kt")
            public void testClassNameBeforeOneUnsresolvedClassWithDot() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeOneUnsresolvedClassWithDot.kt");
            }

            @Test
            @TestMetadata(value="ClassNameBeforeOneUnsresolvedClassWithTwoResolved.kt")
            public void testClassNameBeforeOneUnsresolvedClassWithTwoResolved() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeOneUnsresolvedClassWithTwoResolved.kt");
            }

            @Test
            @TestMetadata(value="ClassNameBeforeOneUnsresolvedClassWithTwoResolvedWithDot.kt")
            public void testClassNameBeforeOneUnsresolvedClassWithTwoResolvedWithDot() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeOneUnsresolvedClassWithTwoResolvedWithDot.kt");
            }

            @Test
            @TestMetadata(value="ClassNameBeforeTwoUnsresolvedClasses.kt")
            public void testClassNameBeforeTwoUnsresolvedClasses() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeTwoUnsresolvedClasses.kt");
            }

            @Test
            @TestMetadata(value="ClassNameBeforeTwoUnsresolvedClassesTwoResolved.kt")
            public void testClassNameBeforeTwoUnsresolvedClassesTwoResolved() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeTwoUnsresolvedClassesTwoResolved.kt");
            }

            @Test
            @TestMetadata(value="ClassNameBeforeTwoUnsresolvedClassesWithDot.kt")
            public void testClassNameBeforeTwoUnsresolvedClassesWithDot() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameBeforeTwoUnsresolvedClassesWithDot.kt");
            }

            @Test
            @TestMetadata(value="ClassNameSecondQualifierBeforeOneUnsresolvedClass.kt")
            public void testClassNameSecondQualifierBeforeOneUnsresolvedClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameSecondQualifierBeforeOneUnsresolvedClass.kt");
            }

            @Test
            @TestMetadata(value="ClassNameSecondQualifierBeforeOneUnsresolvedClassWithDot.kt")
            public void testClassNameSecondQualifierBeforeOneUnsresolvedClassWithDot() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameSecondQualifierBeforeOneUnsresolvedClassWithDot.kt");
            }

            @Test
            @TestMetadata(value="ClassNameSecondQualifierBeforeOneUnsresolvedClassWithTwoResolvedWithDot.kt")
            public void testClassNameSecondQualifierBeforeOneUnsresolvedClassWithTwoResolvedWithDot() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/withErrors/partiallyUnresolvedTypeQualifier/ClassNameSecondQualifierBeforeOneUnsresolvedClassWithTwoResolvedWithDot.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeParameter")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeParameter {
        @Test
        public void testAllFilesPresentInTypeParameter() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeParameter"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="multipleBounds.kt")
        public void testMultipleBounds() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/multipleBounds.kt");
        }

        @Test
        @TestMetadata(value="reifiedTypeParameterInBody.kt")
        public void testReifiedTypeParameterInBody() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reifiedTypeParameterInBody.kt");
        }

        @Test
        @TestMetadata(value="reified_argumentInFunctionalType.kt")
        public void testReified_argumentInFunctionalType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_argumentInFunctionalType.kt");
        }

        @Test
        @TestMetadata(value="reified_extensionReceiver.kt")
        public void testReified_extensionReceiver() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_extensionReceiver.kt");
        }

        @Test
        @TestMetadata(value="reified_returnType.kt")
        public void testReified_returnType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_returnType.kt");
        }

        @Test
        @TestMetadata(value="reified_valueParameter.kt")
        public void testReified_valueParameter() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_valueParameter.kt");
        }

        @Test
        @TestMetadata(value="reified_valueParameter_vararg.kt")
        public void testReified_valueParameter_vararg() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/reified_valueParameter_vararg.kt");
        }

        @Test
        @TestMetadata(value="TypeParameterInAnonymousObject.kt")
        public void testTypeParameterInAnonymousObject() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/TypeParameterInAnonymousObject.kt");
        }

        @Test
        @TestMetadata(value="TypeParameterInFunctionLiteral.kt")
        public void testTypeParameterInFunctionLiteral() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/TypeParameterInFunctionLiteral.kt");
        }

        @Test
        @TestMetadata(value="whereClause1.kt")
        public void testWhereClause1() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/whereClause1.kt");
        }

        @Test
        @TestMetadata(value="whereClause2.kt")
        public void testWhereClause2() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeParameter/whereClause2.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument")
    @TestDataPath(value="$PROJECT_ROOT")
    public class TypeArgument {
        @Test
        public void testAllFilesPresentInTypeArgument() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument/type")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Type {
            @Test
            public void testAllFilesPresentInType() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument/type"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="beforeDot.kt")
            public void testBeforeDot() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/type/beforeDot.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess")
        @TestDataPath(value="$PROJECT_ROOT")
        public class PropertyAccess {
            @Test
            public void testAllFilesPresentInPropertyAccess() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="localVariable1.kt")
            public void testLocalVariable1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/localVariable1.kt");
            }

            @Test
            @TestMetadata(value="localVariable2.kt")
            public void testLocalVariable2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/localVariable2.kt");
            }

            @Test
            @TestMetadata(value="parameter1.kt")
            public void testParameter1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/parameter1.kt");
            }

            @Test
            @TestMetadata(value="parameter2.kt")
            public void testParameter2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/parameter2.kt");
            }

            @Test
            @TestMetadata(value="property1.kt")
            public void testProperty1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/property1.kt");
            }

            @Test
            @TestMetadata(value="property2.kt")
            public void testProperty2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/property2.kt");
            }

            @Test
            @TestMetadata(value="propertyWithGetter1.kt")
            public void testPropertyWithGetter1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/propertyWithGetter1.kt");
            }

            @Test
            @TestMetadata(value="propertyWithGetter2.kt")
            public void testPropertyWithGetter2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/propertyWithGetter2.kt");
            }

            @Test
            @TestMetadata(value="unresolvedProperty.kt")
            public void testUnresolvedProperty() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/propertyAccess/unresolvedProperty.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall")
        @TestDataPath(value="$PROJECT_ROOT")
        public class FunctionCall {
            @Test
            public void testAllFilesPresentInFunctionCall() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="tooFewTypeArguments1.kt")
            public void testTooFewTypeArguments1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooFewTypeArguments1.kt");
            }

            @Test
            @TestMetadata(value="tooFewTypeArguments1a.kt")
            public void testTooFewTypeArguments1a() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooFewTypeArguments1a.kt");
            }

            @Test
            @TestMetadata(value="tooFewTypeArguments2.kt")
            public void testTooFewTypeArguments2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooFewTypeArguments2.kt");
            }

            @Test
            @TestMetadata(value="tooManyTypeArguments1.kt")
            public void testTooManyTypeArguments1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooManyTypeArguments1.kt");
            }

            @Test
            @TestMetadata(value="tooManyTypeArguments1a.kt")
            public void testTooManyTypeArguments1a() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooManyTypeArguments1a.kt");
            }

            @Test
            @TestMetadata(value="tooManyTypeArguments2.kt")
            public void testTooManyTypeArguments2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooManyTypeArguments2.kt");
            }

            @Test
            @TestMetadata(value="tooManyTypeArguments2a.kt")
            public void testTooManyTypeArguments2a() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/tooManyTypeArguments2a.kt");
            }

            @Test
            @TestMetadata(value="unresolvedCallee1.kt")
            public void testUnresolvedCallee1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/unresolvedCallee1.kt");
            }

            @Test
            @TestMetadata(value="unresolvedCallee2.kt")
            public void testUnresolvedCallee2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/unresolvedCallee2.kt");
            }

            @Test
            @TestMetadata(value="unresolvedCalleeWithArguments1.kt")
            public void testUnresolvedCalleeWithArguments1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/unresolvedCalleeWithArguments1.kt");
            }

            @Test
            @TestMetadata(value="unresolvedCalleeWithArguments2.kt")
            public void testUnresolvedCalleeWithArguments2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/unresolvedCalleeWithArguments2.kt");
            }

            @Test
            @TestMetadata(value="upperBound1.kt")
            public void testUpperBound1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/upperBound1.kt");
            }

            @Test
            @TestMetadata(value="upperBound2.kt")
            public void testUpperBound2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/functionCall/upperBound2.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/typeArgument/constant")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Constant {
            @Test
            public void testAllFilesPresentInConstant() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/typeArgument/constant"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="false.kt")
            public void testFalse() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/constant/false.kt");
            }

            @Test
            @TestMetadata(value="true.kt")
            public void testTrue() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/constant/true.kt");
            }

            @Test
            @TestMetadata(value="trueCall.kt")
            public void testTrueCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/typeArgument/constant/trueCall.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/qualifiedAccess")
    @TestDataPath(value="$PROJECT_ROOT")
    public class QualifiedAccess {
        @Test
        public void testAllFilesPresentInQualifiedAccess() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/qualifiedAccess"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="callableReference1.kt")
        public void testCallableReference1() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference1.kt");
        }

        @Test
        @TestMetadata(value="callableReference2.kt")
        public void testCallableReference2() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference2.kt");
        }

        @Test
        @TestMetadata(value="callableReference3.kt")
        public void testCallableReference3() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/callableReference3.kt");
        }

        @Test
        @TestMetadata(value="nullSafeCallExpression.kt")
        public void testNullSafeCallExpression() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/nullSafeCallExpression.kt");
        }

        @Test
        @TestMetadata(value="ResolveFirstPackageOfFullyQualifiedReference.kt")
        public void testResolveFirstPackageOfFullyQualifiedReference() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveFirstPackageOfFullyQualifiedReference.kt");
        }

        @Test
        @TestMetadata(value="ResolveFullyQualifiedCompanionObject.kt")
        public void testResolveFullyQualifiedCompanionObject() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveFullyQualifiedCompanionObject.kt");
        }

        @Test
        @TestMetadata(value="ResolveOuterClassOfFullyQualifiedReference.kt")
        public void testResolveOuterClassOfFullyQualifiedReference() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolveOuterClassOfFullyQualifiedReference.kt");
        }

        @Test
        @TestMetadata(value="ResolvePackageOfFullyQualifiedReference.kt")
        public void testResolvePackageOfFullyQualifiedReference() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/qualifiedAccess/ResolvePackageOfFullyQualifiedReference.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/packageReference")
    @TestDataPath(value="$PROJECT_ROOT")
    public class PackageReference {
        @Test
        public void testAllFilesPresentInPackageReference() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/packageReference"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="javaPackageFirstQualifier.kt")
        public void testJavaPackageFirstQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/packageReference/javaPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata(value="javaPackageSecondQualifier.kt")
        public void testJavaPackageSecondQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/packageReference/javaPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageFirstQualifier.kt")
        public void testKotlinPackageFirstQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/packageReference/kotlinPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageSecondQualifier.kt")
        public void testKotlinPackageSecondQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/packageReference/kotlinPackageSecondQualifier.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/nestedTypes")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NestedTypes {
        @Test
        public void testAllFilesPresentInNestedTypes() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/nestedTypes"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="ResolveCompanionInCompanionType.kt")
        public void testResolveCompanionInCompanionType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveCompanionInCompanionType.kt");
        }

        @Test
        @TestMetadata(value="ResolveEndOfPackageInType.kt")
        public void testResolveEndOfPackageInType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveEndOfPackageInType.kt");
        }

        @Test
        @TestMetadata(value="ResolveMiddleOfPackageInType.kt")
        public void testResolveMiddleOfPackageInType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveMiddleOfPackageInType.kt");
        }

        @Test
        @TestMetadata(value="ResolveNamedCompanionInCompanionType.kt")
        public void testResolveNamedCompanionInCompanionType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveNamedCompanionInCompanionType.kt");
        }

        @Test
        @TestMetadata(value="ResolveStartOfPackageInType.kt")
        public void testResolveStartOfPackageInType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveStartOfPackageInType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheEndOfType.kt")
        public void testResolveTypeInTheEndOfType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheEndOfType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheMiddleOfCompanionType.kt")
        public void testResolveTypeInTheMiddleOfCompanionType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfCompanionType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheMiddleOfFunctionalType.kt")
        public void testResolveTypeInTheMiddleOfFunctionalType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfFunctionalType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheMiddleOfNullableType.kt")
        public void testResolveTypeInTheMiddleOfNullableType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfNullableType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheMiddleOfType.kt")
        public void testResolveTypeInTheMiddleOfType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheMiddleOfType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheStartOfCompanionType.kt")
        public void testResolveTypeInTheStartOfCompanionType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheStartOfCompanionType.kt");
        }

        @Test
        @TestMetadata(value="ResolveTypeInTheStartOfType.kt")
        public void testResolveTypeInTheStartOfType() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/nestedTypes/ResolveTypeInTheStartOfType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kotlinPackage")
    @TestDataPath(value="$PROJECT_ROOT")
    public class KotlinPackage {
        @Test
        public void testAllFilesPresentInKotlinPackage() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kotlinPackage"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="kotlinPackageAllowed.kt")
        public void testKotlinPackageAllowed() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kotlinPackage/kotlinPackageAllowed.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageNotAllowed.kt")
        public void testKotlinPackageNotAllowed() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kotlinPackage/kotlinPackageNotAllowed.kt");
        }

        @Test
        @TestMetadata(value="kotlinxPackage.kt")
        public void testKotlinxPackage() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kotlinPackage/kotlinxPackage.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc")
    @TestDataPath(value="$PROJECT_ROOT")
    public class KDoc {
        @Test
        public void testAllFilesPresentInKDoc() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="errorInLatestQualifer.kt")
            public void testErrorInLatestQualifer() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/withErrors/errorInLatestQualifer.kt");
            }

            @Test
            @TestMetadata(value="invalidPropertyAccessOnFunction.kt")
            public void testInvalidPropertyAccessOnFunction() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/withErrors/invalidPropertyAccessOnFunction.kt");
            }

            @Test
            @TestMetadata(value="invalidPropertyAccessOnFunctionFromCompanionObject.kt")
            public void testInvalidPropertyAccessOnFunctionFromCompanionObject() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/withErrors/invalidPropertyAccessOnFunctionFromCompanionObject.kt");
            }

            @Test
            @TestMetadata(value="invalidPropertyAccessOnFunctionFromNonImportedCompanionObject.kt")
            public void testInvalidPropertyAccessOnFunctionFromNonImportedCompanionObject() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/withErrors/invalidPropertyAccessOnFunctionFromNonImportedCompanionObject.kt");
            }

            @Test
            @TestMetadata(value="invalidPropertyAccessOnFunctionFromSuperClass.kt")
            public void testInvalidPropertyAccessOnFunctionFromSuperClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/withErrors/invalidPropertyAccessOnFunctionFromSuperClass.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/thisQualifier")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ThisQualifier {
            @Test
            public void testAllFilesPresentInThisQualifier() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/thisQualifier"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="thisQualifierOnClass.kt")
            public void testThisQualifierOnClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/thisQualifier/thisQualifierOnClass.kt");
            }

            @Test
            @TestMetadata(value="thisQualifierOnFunction.kt")
            public void testThisQualifierOnFunction() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/thisQualifier/thisQualifierOnFunction.kt");
            }

            @Test
            @TestMetadata(value="thisQualifierOnFunctionNoExtensionReceiver.kt")
            public void testThisQualifierOnFunctionNoExtensionReceiver() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/thisQualifier/thisQualifierOnFunctionNoExtensionReceiver.kt");
            }

            @Test
            @TestMetadata(value="thisQualifierOnProperty.kt")
            public void testThisQualifierOnProperty() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/thisQualifier/thisQualifierOnProperty.kt");
            }

            @Test
            @TestMetadata(value="thisQualifierOnPropertyNoExtensionReceiver.kt")
            public void testThisQualifierOnPropertyNoExtensionReceiver() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/thisQualifier/thisQualifierOnPropertyNoExtensionReceiver.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Qualified {
            @Test
            public void testAllFilesPresentInQualified() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Stdlib {
                @Test
                public void testAllFilesPresentInStdlib() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="EnumEntryFromStdlibByFullName.kt")
                public void testEnumEntryFromStdlibByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/EnumEntryFromStdlibByFullName.kt");
                }

                @Test
                @TestMetadata(value="EnumEntryFromStdlibByShortName.kt")
                public void testEnumEntryFromStdlibByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/EnumEntryFromStdlibByShortName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelClassFromStdlibByFullName.kt")
                public void testTopLevelClassFromStdlibByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TopLevelClassFromStdlibByFullName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelClassFromStdlibByShortName.kt")
                public void testTopLevelClassFromStdlibByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TopLevelClassFromStdlibByShortName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelFunctionFromStdlibByFullName.kt")
                public void testTopLevelFunctionFromStdlibByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TopLevelFunctionFromStdlibByFullName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelFunctionFromStdlibByShortName.kt")
                public void testTopLevelFunctionFromStdlibByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TopLevelFunctionFromStdlibByShortName.kt");
                }

                @Test
                @TestMetadata(value="TypealiasFromStdlibByFullName.kt")
                public void testTypealiasFromStdlibByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TypealiasFromStdlibByFullName.kt");
                }

                @Test
                @TestMetadata(value="TypealiasFromStdlibByShortName.kt")
                public void testTypealiasFromStdlibByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/stdlib/TypealiasFromStdlibByShortName.kt");
                }
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile")
            @TestDataPath(value="$PROJECT_ROOT")
            public class FromOtherFile {
                @Test
                public void testAllFilesPresentInFromOtherFile() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="EnumEntryFromOtherByShortName.kt")
                public void testEnumEntryFromOtherByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/EnumEntryFromOtherByShortName.kt");
                }

                @Test
                @TestMetadata(value="EnumEntryFromOtherFileByFullName.kt")
                public void testEnumEntryFromOtherFileByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/EnumEntryFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="NestedClassFromOtherFileByFullName.kt")
                public void testNestedClassFromOtherFileByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/NestedClassFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="NestedClassFromOtherFileByShortName.kt")
                public void testNestedClassFromOtherFileByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/NestedClassFromOtherFileByShortName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelClassFromOtherFileByFullName.kt")
                public void testTopLevelClassFromOtherFileByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TopLevelClassFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelClassFromOtherFileByShortName.kt")
                public void testTopLevelClassFromOtherFileByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TopLevelClassFromOtherFileByShortName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelFunctionFromOtherFileByFullName.kt")
                public void testTopLevelFunctionFromOtherFileByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TopLevelFunctionFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="TopLevelFunctionFromStdlibByShortName.kt")
                public void testTopLevelFunctionFromStdlibByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TopLevelFunctionFromStdlibByShortName.kt");
                }

                @Test
                @TestMetadata(value="TypealiasFromOtherFileByFullName.kt")
                public void testTypealiasFromOtherFileByFullName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TypealiasFromOtherFileByFullName.kt");
                }

                @Test
                @TestMetadata(value="TypealiasFromOtherFileByShortName.kt")
                public void testTypealiasFromOtherFileByShortName() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/fromOtherFile/TypealiasFromOtherFileByShortName.kt");
                }
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified/conflictResolution")
            @TestDataPath(value="$PROJECT_ROOT")
            public class ConflictResolution {
                @Test
                public void testAllFilesPresentInConflictResolution() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/conflictResolution"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="resolveToPackage.kt")
                public void testResolveToPackage() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/conflictResolution/resolveToPackage.kt");
                }
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Callables {
                @Test
                public void testAllFilesPresentInCallables() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="callableFromTypealias.kt")
                public void testCallableFromTypealias() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/callableFromTypealias.kt");
                }

                @Test
                @TestMetadata(value="functionFromClass.kt")
                public void testFunctionFromClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/functionFromClass.kt");
                }

                @Test
                @TestMetadata(value="functionFromInnerClass.kt")
                public void testFunctionFromInnerClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/functionFromInnerClass.kt");
                }

                @Test
                @TestMetadata(value="functionFromInterface.kt")
                public void testFunctionFromInterface() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/functionFromInterface.kt");
                }

                @Test
                @TestMetadata(value="functionFromNestedClass.kt")
                public void testFunctionFromNestedClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/functionFromNestedClass.kt");
                }

                @Test
                @TestMetadata(value="functionFromPrivateNestedClass.kt")
                public void testFunctionFromPrivateNestedClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/functionFromPrivateNestedClass.kt");
                }

                @Test
                @TestMetadata(value="functionFromSuperClass.kt")
                public void testFunctionFromSuperClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/functionFromSuperClass.kt");
                }

                @Test
                @TestMetadata(value="functionFromSuperInterface.kt")
                public void testFunctionFromSuperInterface() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/functionFromSuperInterface.kt");
                }

                @Test
                @TestMetadata(value="functionFromSuperSuperInterface.kt")
                public void testFunctionFromSuperSuperInterface() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/functionFromSuperSuperInterface.kt");
                }

                @Test
                @TestMetadata(value="overloadedFunctionFromClass.kt")
                public void testOverloadedFunctionFromClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/overloadedFunctionFromClass.kt");
                }

                @Test
                @TestMetadata(value="overloadedFunctionFromClassWithPrivateOverload.kt")
                public void testOverloadedFunctionFromClassWithPrivateOverload() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/overloadedFunctionFromClassWithPrivateOverload.kt");
                }

                @Test
                @TestMetadata(value="privateFunctionFromClass.kt")
                public void testPrivateFunctionFromClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/privateFunctionFromClass.kt");
                }

                @Test
                @TestMetadata(value="privatePropertyFromClass.kt")
                public void testPrivatePropertyFromClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/privatePropertyFromClass.kt");
                }

                @Test
                @TestMetadata(value="propertyFromClass.kt")
                public void testPropertyFromClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/propertyFromClass.kt");
                }

                @Test
                @TestMetadata(value="propertyFromInnerClass.kt")
                public void testPropertyFromInnerClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/propertyFromInnerClass.kt");
                }

                @Test
                @TestMetadata(value="propertyFromInterface.kt")
                public void testPropertyFromInterface() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/propertyFromInterface.kt");
                }

                @Test
                @TestMetadata(value="propertyFromNestedClass.kt")
                public void testPropertyFromNestedClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/propertyFromNestedClass.kt");
                }

                @Test
                @TestMetadata(value="propertyFromPrivateNestedClass.kt")
                public void testPropertyFromPrivateNestedClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/propertyFromPrivateNestedClass.kt");
                }

                @Test
                @TestMetadata(value="propertyFromSuperClass.kt")
                public void testPropertyFromSuperClass() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/propertyFromSuperClass.kt");
                }

                @Test
                @TestMetadata(value="propertyFromSuperInterface.kt")
                public void testPropertyFromSuperInterface() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/propertyFromSuperInterface.kt");
                }

                @Test
                @TestMetadata(value="propertyFromSuperSuperInterface.kt")
                public void testPropertyFromSuperSuperInterface() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/propertyFromSuperSuperInterface.kt");
                }

                @Nested
                @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported")
                @TestDataPath(value="$PROJECT_ROOT")
                public class NotImported {
                    @Test
                    public void testAllFilesPresentInNotImported() {
                        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                    }

                    @Test
                    @TestMetadata(value="functionFromClass.kt")
                    public void testFunctionFromClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/functionFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="functionFromInnerClass.kt")
                    public void testFunctionFromInnerClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/functionFromInnerClass.kt");
                    }

                    @Test
                    @TestMetadata(value="functionFromInterface.kt")
                    public void testFunctionFromInterface() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/functionFromInterface.kt");
                    }

                    @Test
                    @TestMetadata(value="functionFromNestedClass.kt")
                    public void testFunctionFromNestedClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/functionFromNestedClass.kt");
                    }

                    @Test
                    @TestMetadata(value="functionFromPrivateNestedClass.kt")
                    public void testFunctionFromPrivateNestedClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/functionFromPrivateNestedClass.kt");
                    }

                    @Test
                    @TestMetadata(value="functionFromSuperClass.kt")
                    public void testFunctionFromSuperClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/functionFromSuperClass.kt");
                    }

                    @Test
                    @TestMetadata(value="functionFromSuperInterface.kt")
                    public void testFunctionFromSuperInterface() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/functionFromSuperInterface.kt");
                    }

                    @Test
                    @TestMetadata(value="functionFromSuperSuperInterface.kt")
                    public void testFunctionFromSuperSuperInterface() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/functionFromSuperSuperInterface.kt");
                    }

                    @Test
                    @TestMetadata(value="overloadedFunctionFromClass.kt")
                    public void testOverloadedFunctionFromClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/overloadedFunctionFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="overloadedFunctionFromClassWithPrivateOverload.kt")
                    public void testOverloadedFunctionFromClassWithPrivateOverload() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/overloadedFunctionFromClassWithPrivateOverload.kt");
                    }

                    @Test
                    @TestMetadata(value="privateFunctionFromClass.kt")
                    public void testPrivateFunctionFromClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/privateFunctionFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="privatePropertyFromClass.kt")
                    public void testPrivatePropertyFromClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/privatePropertyFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyFromClass.kt")
                    public void testPropertyFromClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/propertyFromClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyFromInnerClass.kt")
                    public void testPropertyFromInnerClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/propertyFromInnerClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyFromInterface.kt")
                    public void testPropertyFromInterface() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/propertyFromInterface.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyFromNestedClass.kt")
                    public void testPropertyFromNestedClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/propertyFromNestedClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyFromPrivateNestedClass.kt")
                    public void testPropertyFromPrivateNestedClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/propertyFromPrivateNestedClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyFromSuperClass.kt")
                    public void testPropertyFromSuperClass() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/propertyFromSuperClass.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyFromSuperInterface.kt")
                    public void testPropertyFromSuperInterface() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/propertyFromSuperInterface.kt");
                    }

                    @Test
                    @TestMetadata(value="propertyFromSuperSuperInterface.kt")
                    public void testPropertyFromSuperSuperInterface() {
                        FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/qualified/callables/notImported/propertyFromSuperSuperInterface.kt");
                    }
                }
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/parameters")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Parameters {
            @Test
            public void testAllFilesPresentInParameters() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/parameters"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="ClassPrimaryConstructorParameter.kt")
            public void testClassPrimaryConstructorParameter() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/ClassPrimaryConstructorParameter.kt");
            }

            @Test
            @TestMetadata(value="ClassPrimaryConstructorValParameter.kt")
            public void testClassPrimaryConstructorValParameter() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/ClassPrimaryConstructorValParameter.kt");
            }

            @Test
            @TestMetadata(value="ClassTypeParameter.kt")
            public void testClassTypeParameter() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/ClassTypeParameter.kt");
            }

            @Test
            @TestMetadata(value="ConstructorValueParameter.kt")
            public void testConstructorValueParameter() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/ConstructorValueParameter.kt");
            }

            @Test
            @TestMetadata(value="FunctionTypeParameter.kt")
            public void testFunctionTypeParameter() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/FunctionTypeParameter.kt");
            }

            @Test
            @TestMetadata(value="FunctionValueParameter.kt")
            public void testFunctionValueParameter() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/parameters/FunctionValueParameter.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/packages")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Packages {
            @Test
            public void testAllFilesPresentInPackages() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/packages"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="longPackage.kt")
            public void testLongPackage() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/packages/longPackage.kt");
            }

            @Test
            @TestMetadata(value="packageVsTopLevelDeclarations.kt")
            public void testPackageVsTopLevelDeclarations() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/packages/packageVsTopLevelDeclarations.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/localContext")
        @TestDataPath(value="$PROJECT_ROOT")
        public class LocalContext {
            @Test
            public void testAllFilesPresentInLocalContext() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/localContext"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="LocalSemiFullQualifiedCallableName.kt")
            public void testLocalSemiFullQualifiedCallableName() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/LocalSemiFullQualifiedCallableName.kt");
            }

            @Test
            @TestMetadata(value="LocalSemiFullQualifiedClassName.kt")
            public void testLocalSemiFullQualifiedClassName() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/LocalSemiFullQualifiedClassName.kt");
            }

            @Test
            @TestMetadata(value="NonLocalSemiFullQualifiedCallableName.kt")
            public void testNonLocalSemiFullQualifiedCallableName() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/NonLocalSemiFullQualifiedCallableName.kt");
            }

            @Test
            @TestMetadata(value="NonLocalSemiFullQualifiedClassName.kt")
            public void testNonLocalSemiFullQualifiedClassName() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/NonLocalSemiFullQualifiedClassName.kt");
            }

            @Test
            @TestMetadata(value="SelfLocalMethod.kt")
            public void testSelfLocalMethod() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfLocalMethod.kt");
            }

            @Test
            @TestMetadata(value="SelfLocalProperty.kt")
            public void testSelfLocalProperty() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfLocalProperty.kt");
            }

            @Test
            @TestMetadata(value="SelfNonLocalEnumEntry.kt")
            public void testSelfNonLocalEnumEntry() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfNonLocalEnumEntry.kt");
            }

            @Test
            @TestMetadata(value="SelfNonLocalMethod.kt")
            public void testSelfNonLocalMethod() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfNonLocalMethod.kt");
            }

            @Test
            @TestMetadata(value="SelfNonLocalNestedClass.kt")
            public void testSelfNonLocalNestedClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfNonLocalNestedClass.kt");
            }

            @Test
            @TestMetadata(value="SelfNonLocalProperty.kt")
            public void testSelfNonLocalProperty() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SelfNonLocalProperty.kt");
            }

            @Test
            @TestMetadata(value="SiblingLocalMethod.kt")
            public void testSiblingLocalMethod() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SiblingLocalMethod.kt");
            }

            @Test
            @TestMetadata(value="SiblingLocalProperty.kt")
            public void testSiblingLocalProperty() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SiblingLocalProperty.kt");
            }

            @Test
            @TestMetadata(value="SiblingNonLocalProperty.kt")
            public void testSiblingNonLocalProperty() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/localContext/SiblingNonLocalProperty.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations")
        @TestDataPath(value="$PROJECT_ROOT")
        public class JavaDeclarations {
            @Test
            public void testAllFilesPresentInJavaDeclarations() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="FunctionQualifiedWithJavaSubclass.kt")
            public void testFunctionQualifiedWithJavaSubclass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations/FunctionQualifiedWithJavaSubclass.kt");
            }

            @Test
            @TestMetadata(value="FunctionQualifiedWithKotlinSubclass.kt")
            public void testFunctionQualifiedWithKotlinSubclass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations/FunctionQualifiedWithKotlinSubclass.kt");
            }

            @Test
            @TestMetadata(value="StaticFieldQualified.kt")
            public void testStaticFieldQualified() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations/StaticFieldQualified.kt");
            }

            @Test
            @TestMetadata(value="StaticFunctionFromBaseClass.kt")
            public void testStaticFunctionFromBaseClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations/StaticFunctionFromBaseClass.kt");
            }

            @Test
            @TestMetadata(value="StaticFunctionFullyQualified.kt")
            public void testStaticFunctionFullyQualified() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations/StaticFunctionFullyQualified.kt");
            }

            @Test
            @TestMetadata(value="StaticFunctionQualified.kt")
            public void testStaticFunctionQualified() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations/StaticFunctionQualified.kt");
            }

            @Test
            @TestMetadata(value="StaticFunctionQualifiedWithJavaSubclass.kt")
            public void testStaticFunctionQualifiedWithJavaSubclass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations/StaticFunctionQualifiedWithJavaSubclass.kt");
            }

            @Test
            @TestMetadata(value="StaticFunctionQualifiedWithKotlinSubclass.kt")
            public void testStaticFunctionQualifiedWithKotlinSubclass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/javaDeclarations/StaticFunctionQualifiedWithKotlinSubclass.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/imports")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Imports {
            @Test
            public void testAllFilesPresentInImports() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/imports"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="SameNameClassesFromStarImports.kt")
            public void testSameNameClassesFromStarImports() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/imports/SameNameClassesFromStarImports.kt");
            }

            @Test
            @TestMetadata(value="TypeAliasedImport.kt")
            public void testTypeAliasedImport() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/imports/TypeAliasedImport.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/extensions")
        @TestDataPath(value="$PROJECT_ROOT")
        public class Extensions {
            @Test
            public void testAllFilesPresentInExtensions() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/extensions"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="callablesWithSameName.kt")
            public void testCallablesWithSameName() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/callablesWithSameName.kt");
            }

            @Test
            @TestMetadata(value="fromBaseClass.kt")
            public void testFromBaseClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/fromBaseClass.kt");
            }

            @Test
            @TestMetadata(value="functionOverloads.kt")
            public void testFunctionOverloads() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/functionOverloads.kt");
            }

            @Test
            @TestMetadata(value="nonExtensions.kt")
            public void testNonExtensions() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/nonExtensions.kt");
            }

            @Test
            @TestMetadata(value="qualifiers.kt")
            public void testQualifiers() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/qualifiers.kt");
            }

            @Test
            @TestMetadata(value="receiverTypesWithSameName_nestedScopes.kt")
            public void testReceiverTypesWithSameName_nestedScopes() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/receiverTypesWithSameName_nestedScopes.kt");
            }

            @Test
            @TestMetadata(value="receiverTypesWithSameName_starImports.kt")
            public void testReceiverTypesWithSameName_starImports() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/receiverTypesWithSameName_starImports.kt");
            }

            @Test
            @TestMetadata(value="topLevelFunction.kt")
            public void testTopLevelFunction() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/topLevelFunction.kt");
            }

            @Test
            @TestMetadata(value="topLevelProperty.kt")
            public void testTopLevelProperty() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/topLevelProperty.kt");
            }

            @Test
            @TestMetadata(value="topLevelTypeVsMemberFunctionAsReceiver.kt")
            public void testTopLevelTypeVsMemberFunctionAsReceiver() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/topLevelTypeVsMemberFunctionAsReceiver.kt");
            }

            @Test
            @TestMetadata(value="typeAliasReceiver.kt")
            public void testTypeAliasReceiver() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/typeAliasReceiver.kt");
            }

            @Test
            @TestMetadata(value="typeCompatibility.kt")
            public void testTypeCompatibility() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/typeCompatibility.kt");
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/extensions/generics")
            @TestDataPath(value="$PROJECT_ROOT")
            public class Generics {
                @Test
                public void testAllFilesPresentInGenerics() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/generics"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="genericParameterReceiver.kt")
                public void testGenericParameterReceiver() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/generics/genericParameterReceiver.kt");
                }

                @Test
                @TestMetadata(value="genericsCompatibility.kt")
                public void testGenericsCompatibility() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/generics/genericsCompatibility.kt");
                }

                @Test
                @TestMetadata(value="typeWithGenericsReceiver.kt")
                public void testTypeWithGenericsReceiver() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/extensions/generics/typeWithGenericsReceiver.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/kDoc/companionObject")
        @TestDataPath(value="$PROJECT_ROOT")
        public class CompanionObject {
            @Test
            public void testAllFilesPresentInCompanionObject() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="childQualifiedFunctionFromSuperClassCompanion.kt")
            public void testChildQualifiedFunctionFromSuperClassCompanion() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/childQualifiedFunctionFromSuperClassCompanion.kt");
            }

            @Test
            @TestMetadata(value="qualifiedClassNestedInClassNestedInCompanion.kt")
            public void testQualifiedClassNestedInClassNestedInCompanion() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/qualifiedClassNestedInClassNestedInCompanion.kt");
            }

            @Test
            @TestMetadata(value="qualifiedFunctionFromCompanion.kt")
            public void testQualifiedFunctionFromCompanion() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/qualifiedFunctionFromCompanion.kt");
            }

            @Test
            @TestMetadata(value="qualifiedFunctionFromCompanionInOtherFile.kt")
            public void testQualifiedFunctionFromCompanionInOtherFile() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/qualifiedFunctionFromCompanionInOtherFile.kt");
            }

            @Test
            @TestMetadata(value="qualifiedFunctionFromCompanionWithImport.kt")
            public void testQualifiedFunctionFromCompanionWithImport() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/qualifiedFunctionFromCompanionWithImport.kt");
            }

            @Test
            @TestMetadata(value="qualifiedFunctionFromOwnCompanion.kt")
            public void testQualifiedFunctionFromOwnCompanion() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/qualifiedFunctionFromOwnCompanion.kt");
            }

            @Test
            @TestMetadata(value="qualifiedFunctionFromSuperClassCompanion.kt")
            public void testQualifiedFunctionFromSuperClassCompanion() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/qualifiedFunctionFromSuperClassCompanion.kt");
            }

            @Test
            @TestMetadata(value="qualifiedFunctionFromSuperClassCompanionInOtherFile.kt")
            public void testQualifiedFunctionFromSuperClassCompanionInOtherFile() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/qualifiedFunctionFromSuperClassCompanionInOtherFile.kt");
            }

            @Test
            @TestMetadata(value="qualifiedFunctionOfClassNestedInCompanion.kt")
            public void testQualifiedFunctionOfClassNestedInCompanion() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/qualifiedFunctionOfClassNestedInCompanion.kt");
            }

            @Test
            @TestMetadata(value="unqualifiedFunctionFromOwnCompanion.kt")
            public void testUnqualifiedFunctionFromOwnCompanion() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/unqualifiedFunctionFromOwnCompanion.kt");
            }

            @Test
            @TestMetadata(value="unqualifiedFunctionFromSuperClassCompanion.kt")
            public void testUnqualifiedFunctionFromSuperClassCompanion() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/kDoc/companionObject/unqualifiedFunctionFromSuperClassCompanion.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/java")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Java {
        @Test
        public void testAllFilesPresentInJava() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/java"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="JavaAnnotationParameter.kt")
        public void testJavaAnnotationParameter() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/JavaAnnotationParameter.kt");
        }

        @Test
        @TestMetadata(value="JavaConstructorNotNullParameter.kt")
        public void testJavaConstructorNotNullParameter() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/JavaConstructorNotNullParameter.kt");
        }

        @Test
        @TestMetadata(value="JavaEnumEntry.kt")
        public void testJavaEnumEntry() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/JavaEnumEntry.kt");
        }

        @Test
        @TestMetadata(value="JavaEnumValueOf.kt")
        public void testJavaEnumValueOf() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/JavaEnumValueOf.kt");
        }

        @Test
        @TestMetadata(value="JavaReference.kt")
        public void testJavaReference() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/JavaReference.kt");
        }

        @Test
        @TestMetadata(value="JavaStaticMethod.kt")
        public void testJavaStaticMethod() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/JavaStaticMethod.kt");
        }

        @Test
        @TestMetadata(value="ReferenceToSam.kt")
        public void testReferenceToSam() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/ReferenceToSam.kt");
        }

        @Test
        @TestMetadata(value="SyntheticProperty.kt")
        public void testSyntheticProperty() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/SyntheticProperty.kt");
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/java/enumWithCustomGetName")
        @TestDataPath(value="$PROJECT_ROOT")
        public class EnumWithCustomGetName {
            @Test
            public void testAllFilesPresentInEnumWithCustomGetName() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/java/enumWithCustomGetName"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="FunctionCallOnConstant.kt")
            public void testFunctionCallOnConstant() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/enumWithCustomGetName/FunctionCallOnConstant.kt");
            }

            @Test
            @TestMetadata(value="FunctionCallOnVariable.kt")
            public void testFunctionCallOnVariable() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/enumWithCustomGetName/FunctionCallOnVariable.kt");
            }

            @Test
            @TestMetadata(value="PropertyAccessOnConstant.kt")
            public void testPropertyAccessOnConstant() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/enumWithCustomGetName/PropertyAccessOnConstant.kt");
            }

            @Test
            @TestMetadata(value="PropertyAccessOnVariable.kt")
            public void testPropertyAccessOnVariable() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/java/enumWithCustomGetName/PropertyAccessOnVariable.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/invoke")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Invoke {
        @Test
        public void testAllFilesPresentInInvoke() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/invoke"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="lambdaAndParens.kt")
        public void testLambdaAndParens() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaAndParens.kt");
        }

        @Test
        @TestMetadata(value="lambdaNoPar.kt")
        public void testLambdaNoPar() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoPar.kt");
        }

        @Test
        @TestMetadata(value="lambdaNoParLabel.kt")
        public void testLambdaNoParLabel() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoParLabel.kt");
        }

        @Test
        @TestMetadata(value="lambdaNoParRCurly.kt")
        public void testLambdaNoParRCurly() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaNoParRCurly.kt");
        }

        @Test
        @TestMetadata(value="lambdaWithExtensionParameter_extensionProperty_regularCall.kt")
        public void testLambdaWithExtensionParameter_extensionProperty_regularCall() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaWithExtensionParameter_extensionProperty_regularCall.kt");
        }

        @Test
        @TestMetadata(value="lambdaWithExtensionParameter_extensionProperty_safeCall.kt")
        public void testLambdaWithExtensionParameter_extensionProperty_safeCall() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaWithExtensionParameter_extensionProperty_safeCall.kt");
        }

        @Test
        @TestMetadata(value="lambdaWithExtensionParameter_parameter_regularCall.kt")
        public void testLambdaWithExtensionParameter_parameter_regularCall() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaWithExtensionParameter_parameter_regularCall.kt");
        }

        @Test
        @TestMetadata(value="lambdaWithExtensionParameter_parameter_safeCall.kt")
        public void testLambdaWithExtensionParameter_parameter_safeCall() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaWithExtensionParameter_parameter_safeCall.kt");
        }

        @Test
        @TestMetadata(value="lambdaWithExtensionParameter_property_regularCall.kt")
        public void testLambdaWithExtensionParameter_property_regularCall() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaWithExtensionParameter_property_regularCall.kt");
        }

        @Test
        @TestMetadata(value="lambdaWithExtensionParameter_property_safeCall.kt")
        public void testLambdaWithExtensionParameter_property_safeCall() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/lambdaWithExtensionParameter_property_safeCall.kt");
        }

        @Test
        @TestMetadata(value="noParams.kt")
        public void testNoParams() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/noParams.kt");
        }

        @Test
        @TestMetadata(value="noParamsRPar.kt")
        public void testNoParamsRPar() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/noParamsRPar.kt");
        }

        @Test
        @TestMetadata(value="nonemptyLambdaRPar.kt")
        public void testNonemptyLambdaRPar() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/nonemptyLambdaRPar.kt");
        }

        @Test
        @TestMetadata(value="oneParam.kt")
        public void testOneParam() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/oneParam.kt");
        }

        @Test
        @TestMetadata(value="oneParamRPar.kt")
        public void testOneParamRPar() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/oneParamRPar.kt");
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/invoke/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/invoke/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="lambdaAndParensIncorrectVararg.kt")
            public void testLambdaAndParensIncorrectVararg() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaAndParensIncorrectVararg.kt");
            }

            @Test
            @TestMetadata(value="lambdaNoParIncorrectVararg.kt")
            public void testLambdaNoParIncorrectVararg() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParIncorrectVararg.kt");
            }

            @Test
            @TestMetadata(value="lambdaNoParLabelIncorrectVararg.kt")
            public void testLambdaNoParLabelIncorrectVararg() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParLabelIncorrectVararg.kt");
            }

            @Test
            @TestMetadata(value="lambdaNoParRCurlyIncorrectVararg.kt")
            public void testLambdaNoParRCurlyIncorrectVararg() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/lambdaNoParRCurlyIncorrectVararg.kt");
            }

            @Test
            @TestMetadata(value="nonemptyLambdaRParIncorrectVararg.kt")
            public void testNonemptyLambdaRParIncorrectVararg() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/withErrors/nonemptyLambdaRParIncorrectVararg.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/invoke/onObjects")
        @TestDataPath(value="$PROJECT_ROOT")
        public class OnObjects {
            @Test
            public void testAllFilesPresentInOnObjects() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/invoke/onObjects"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="companionObject1.kt")
            public void testCompanionObject1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/companionObject1.kt");
            }

            @Test
            @TestMetadata(value="companionObject2.kt")
            public void testCompanionObject2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/companionObject2.kt");
            }

            @Test
            @TestMetadata(value="companionObjectWithName1.kt")
            public void testCompanionObjectWithName1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/companionObjectWithName1.kt");
            }

            @Test
            @TestMetadata(value="companionObjectWithName2.kt")
            public void testCompanionObjectWithName2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/companionObjectWithName2.kt");
            }

            @Test
            @TestMetadata(value="nestedObject1.kt")
            public void testNestedObject1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/nestedObject1.kt");
            }

            @Test
            @TestMetadata(value="nestedObject2.kt")
            public void testNestedObject2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/nestedObject2.kt");
            }

            @Test
            @TestMetadata(value="nestedObject3.kt")
            public void testNestedObject3() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/nestedObject3.kt");
            }

            @Test
            @TestMetadata(value="nestedObject4.kt")
            public void testNestedObject4() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/nestedObject4.kt");
            }

            @Test
            @TestMetadata(value="simpleObject1.kt")
            public void testSimpleObject1() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/simpleObject1.kt");
            }

            @Test
            @TestMetadata(value="simpleObject2.kt")
            public void testSimpleObject2() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/invoke/onObjects/simpleObject2.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/inImport")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InImport {
        @Test
        public void testAllFilesPresentInInImport() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/inImport"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="javaClass.kt")
        public void testJavaClass() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaClass.kt");
        }

        @Test
        @TestMetadata(value="javaPackageFirstQualifier.kt")
        public void testJavaPackageFirstQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata(value="javaPackageSecondQualifier.kt")
        public void testJavaPackageSecondQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/javaPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinClass.kt")
        public void testKotlinClass() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinClass.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageFirstQualifier.kt")
        public void testKotlinPackageFirstQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinPackageFirstQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinPackageSecondQualifier.kt")
        public void testKotlinPackageSecondQualifier() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinPackageSecondQualifier.kt");
        }

        @Test
        @TestMetadata(value="kotlinTopLevelFunction.kt")
        public void testKotlinTopLevelFunction() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/kotlinTopLevelFunction.kt");
        }

        @Test
        @TestMetadata(value="staticMethodFromJavaClass.kt")
        public void testStaticMethodFromJavaClass() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/staticMethodFromJavaClass.kt");
        }

        @Test
        @TestMetadata(value="staticMethodFromJavaClassJavaClass.kt")
        public void testStaticMethodFromJavaClassJavaClass() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/inImport/staticMethodFromJavaClassJavaClass.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ForLoopIn {
        @Test
        public void testAllFilesPresentInForLoopIn() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="unresolvedIterator.kt")
            public void testUnresolvedIterator() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/withErrors/unresolvedIterator.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InSource {
            @Test
            @TestMetadata(value="allExtensions.kt")
            public void testAllExtensions() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/allExtensions.kt");
            }

            @Test
            public void testAllFilesPresentInInSource() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="allMembers.kt")
            public void testAllMembers() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/allMembers.kt");
            }

            @Nested
            @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors")
            @TestDataPath(value="$PROJECT_ROOT")
            public class WithErrors {
                @Test
                public void testAllFilesPresentInWithErrors() {
                    KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
                }

                @Test
                @TestMetadata(value="nextMissing.kt")
                public void testNextMissing() {
                    FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inSource/withErrors/nextMissing.kt");
                }
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InLibrary {
            @Test
            public void testAllFilesPresentInInLibrary() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inLibrary/extension.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InBuiltIns {
            @Test
            public void testAllFilesPresentInInBuiltIns() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="extension.kt")
            public void testExtension() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns/extension.kt");
            }

            @Test
            @TestMetadata(value="member.kt")
            public void testMember() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/forLoopIn/inBuiltIns/member.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DelegatedPropertyAccessors {
        @Test
        public void testAllFilesPresentInDelegatedPropertyAccessors() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="unresolved.kt")
            public void testUnresolved() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/withErrors/unresolved.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InStandardLibrary {
            @Test
            public void testAllFilesPresentInInStandardLibrary() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="lazy.kt")
            public void testLazy() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary/lazy.kt");
            }

            @Test
            @TestMetadata(value="notNull.kt")
            public void testNotNull() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inStandardLibrary/notNull.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource")
        @TestDataPath(value="$PROJECT_ROOT")
        public class InSource {
            @Test
            public void testAllFilesPresentInInSource() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="getExtension.kt")
            public void testGetExtension() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getExtension.kt");
            }

            @Test
            @TestMetadata(value="getMember.kt")
            public void testGetMember() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getMember.kt");
            }

            @Test
            @TestMetadata(value="getMultipleDeclarations.kt")
            public void testGetMultipleDeclarations() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getMultipleDeclarations.kt");
            }

            @Test
            @TestMetadata(value="getOneFakeOverride.kt")
            public void testGetOneFakeOverride() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/delegatedPropertyAccessors/inSource/getOneFakeOverride.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/danglingAnnotations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class DanglingAnnotations {
        @Test
        public void testAllFilesPresentInDanglingAnnotations() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/danglingAnnotations"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedAnonymous.kt")
        public void testDanglingAnnotationsResolvedAnonymous() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedAnonymous.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedClass.kt")
        public void testDanglingAnnotationsResolvedClass() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedClass.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedFile.kt")
        public void testDanglingAnnotationsResolvedFile() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedFile.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedLocal.kt")
        public void testDanglingAnnotationsResolvedLocal() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedLocal.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedPackageFile.kt")
        public void testDanglingAnnotationsResolvedPackageFile() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedPackageFile.kt");
        }

        @Test
        @TestMetadata(value="DanglingAnnotationsResolvedTopLevel.kt")
        public void testDanglingAnnotationsResolvedTopLevel() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/danglingAnnotations/DanglingAnnotationsResolvedTopLevel.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ConstructorDelegatingReference {
        @Test
        public void testAllFilesPresentInConstructorDelegatingReference() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="toPrimary.kt")
        public void testToPrimary() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference/toPrimary.kt");
        }

        @Test
        @TestMetadata(value="toSecondary.kt")
        public void testToSecondary() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/constructorDelegatingReference/toSecondary.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/codeFragment")
    @TestDataPath(value="$PROJECT_ROOT")
    public class CodeFragment {
        @Test
        public void testAllFilesPresentInCodeFragment() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/codeFragment"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment")
        @TestDataPath(value="$PROJECT_ROOT")
        public class TypeCodeFragment {
            @Test
            public void testAllFilesPresentInTypeCodeFragment() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="FromContextFile.kt")
            public void testFromContextFile() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment/FromContextFile.kt");
            }

            @Test
            @TestMetadata(value="FromContextModule.kt")
            public void testFromContextModule() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment/FromContextModule.kt");
            }

            @Test
            @TestMetadata(value="GenericType.kt")
            public void testGenericType() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment/GenericType.kt");
            }

            @Test
            @TestMetadata(value="GenericTypeArgument.kt")
            public void testGenericTypeArgument() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment/GenericTypeArgument.kt");
            }

            @Test
            @TestMetadata(value="LocalClass.kt")
            public void testLocalClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment/LocalClass.kt");
            }

            @Test
            @TestMetadata(value="Simple.kt")
            public void testSimple() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment/Simple.kt");
            }

            @Test
            @TestMetadata(value="TypeAnnotation.kt")
            public void testTypeAnnotation() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/typeCodeFragment/TypeAnnotation.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment")
        @TestDataPath(value="$PROJECT_ROOT")
        public class ExpressionCodeFragment {
            @Test
            public void testAllFilesPresentInExpressionCodeFragment() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="ArrayAssignmentOperator.kt")
            public void testArrayAssignmentOperator() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/ArrayAssignmentOperator.kt");
            }

            @Test
            @TestMetadata(value="ArrayPlusAssignmentOperator.kt")
            public void testArrayPlusAssignmentOperator() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/ArrayPlusAssignmentOperator.kt");
            }

            @Test
            @TestMetadata(value="BinaryExpression.kt")
            public void testBinaryExpression() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/BinaryExpression.kt");
            }

            @Test
            @TestMetadata(value="CompanionCall.kt")
            public void testCompanionCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/CompanionCall.kt");
            }

            @Test
            @TestMetadata(value="ContextFunctionCall.kt")
            public void testContextFunctionCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/ContextFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="FunctionCall.kt")
            public void testFunctionCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/FunctionCall.kt");
            }

            @Test
            @TestMetadata(value="LocalFunctionCall.kt")
            public void testLocalFunctionCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/LocalFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="NestedCodeFragment.kt")
            public void testNestedCodeFragment() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/NestedCodeFragment.kt");
            }

            @Test
            @TestMetadata(value="NestedCodeFragmentUsage.kt")
            public void testNestedCodeFragmentUsage() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/NestedCodeFragmentUsage.kt");
            }

            @Test
            @TestMetadata(value="PropertyCall.kt")
            public void testPropertyCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/expressionCodeFragment/PropertyCall.kt");
            }
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment")
        @TestDataPath(value="$PROJECT_ROOT")
        public class BlockCodeFragment {
            @Test
            public void testAllFilesPresentInBlockCodeFragment() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="BinaryExpression.kt")
            public void testBinaryExpression() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/BinaryExpression.kt");
            }

            @Test
            @TestMetadata(value="CompanionCall.kt")
            public void testCompanionCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/CompanionCall.kt");
            }

            @Test
            @TestMetadata(value="ContextFunctionCall.kt")
            public void testContextFunctionCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/ContextFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="FunctionCall.kt")
            public void testFunctionCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/FunctionCall.kt");
            }

            @Test
            @TestMetadata(value="LocalFunctionCall.kt")
            public void testLocalFunctionCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/LocalFunctionCall.kt");
            }

            @Test
            @TestMetadata(value="NestedCodeFragment.kt")
            public void testNestedCodeFragment() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/NestedCodeFragment.kt");
            }

            @Test
            @TestMetadata(value="NestedCodeFragmentClass.kt")
            public void testNestedCodeFragmentClass() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/NestedCodeFragmentClass.kt");
            }

            @Test
            @TestMetadata(value="NestedCodeFragmentClassMember.kt")
            public void testNestedCodeFragmentClassMember() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/NestedCodeFragmentClassMember.kt");
            }

            @Test
            @TestMetadata(value="NestedCodeFragmentFunction.kt")
            public void testNestedCodeFragmentFunction() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/NestedCodeFragmentFunction.kt");
            }

            @Test
            @TestMetadata(value="PropertyCall.kt")
            public void testPropertyCall() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/PropertyCall.kt");
            }

            @Test
            @TestMetadata(value="SecondStatement.kt")
            public void testSecondStatement() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/codeFragment/blockCodeFragment/SecondStatement.kt");
            }
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/arrayAccess")
    @TestDataPath(value="$PROJECT_ROOT")
    public class ArrayAccess {
        @Test
        public void testAllFilesPresentInArrayAccess() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/arrayAccess"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="get.kt")
        public void testGet() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/get.kt");
        }

        @Test
        @TestMetadata(value="getOperator.kt")
        public void testGetOperator() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/getOperator.kt");
        }

        @Test
        @TestMetadata(value="set.kt")
        public void testSet() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/set.kt");
        }

        @Test
        @TestMetadata(value="setOperator.kt")
        public void testSetOperator() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/setOperator.kt");
        }

        @Test
        @TestMetadata(value="SetOperatorInc.kt")
        public void testSetOperatorInc() {
            FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/SetOperatorInc.kt");
        }

        @Nested
        @TestMetadata(value="analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors")
        @TestDataPath(value="$PROJECT_ROOT")
        public class WithErrors {
            @Test
            public void testAllFilesPresentInWithErrors() {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors"), (Pattern)Pattern.compile("^([^.]+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="getFunction.kt")
            public void testGetFunction() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors/getFunction.kt");
            }

            @Test
            @TestMetadata(value="setFunction.kt")
            public void testSetFunction() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors/setFunction.kt");
            }

            @Test
            @TestMetadata(value="SetOperatorInc.kt")
            public void testSetOperatorInc() {
                FirStandaloneNormalAnalysisSourceModuleReferenceResolveTestGenerated.this.runTest("analysis/analysis-api/testData/referenceResolve/arrayAccess/withErrors/SetOperatorInc.kt");
            }
        }
    }
}

