/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.test.cases.generated.cases.components.callResolver;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.fir.test.configurators.AnalysisApiFirTestConfiguratorFactory;
import org.jetbrains.kotlin.analysis.api.impl.base.test.cases.components.callResolver.AbstractResolveCallTest;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfigurator;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisApiTestConfiguratorFactoryData;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.AnalysisSessionMode;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.FrontendKind;
import org.jetbrains.kotlin.analysis.test.framework.test.configurators.TestModuleKind;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/analysis-api/testData/components/callResolver/resolveCall")
@TestDataPath(value="$PROJECT_ROOT")
public class FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated
extends AbstractResolveCallTest {
    @Override
    @NotNull
    public AnalysisApiTestConfigurator getConfigurator() {
        AnalysisApiTestConfigurator analysisApiTestConfigurator = AnalysisApiFirTestConfiguratorFactory.INSTANCE.createConfigurator(new AnalysisApiTestConfiguratorFactoryData(FrontendKind.Fir, TestModuleKind.Source, AnalysisSessionMode.Normal, AnalysisApiMode.Ide));
        if (analysisApiTestConfigurator == null) {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.$$$reportNull$$$0(0);
        }
        return analysisApiTestConfigurator;
    }

    @Test
    public void testAllFilesPresentInResolveCall() {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/components/callResolver/resolveCall"), (Pattern)Pattern.compile("^(.+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
    }

    @Test
    @TestMetadata(value="ambiguous.kt")
    public void testAmbiguous() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/ambiguous.kt");
    }

    @Test
    @TestMetadata(value="ambiguousImplicitInvoke.kt")
    public void testAmbiguousImplicitInvoke() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/ambiguousImplicitInvoke.kt");
    }

    @Test
    @TestMetadata(value="ambiguousWithExplicitTypeParameters.kt")
    public void testAmbiguousWithExplicitTypeParameters() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/ambiguousWithExplicitTypeParameters.kt");
    }

    @Test
    @TestMetadata(value="ambiguousWithInferredTypeParameters.kt")
    public void testAmbiguousWithInferredTypeParameters() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/ambiguousWithInferredTypeParameters.kt");
    }

    @Test
    @TestMetadata(value="annotationEntry.kt")
    public void testAnnotationEntry() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationEntry.kt");
    }

    @Test
    @TestMetadata(value="annotationInAnnotation_arrayOf.kt")
    public void testAnnotationInAnnotation_arrayOf() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationInAnnotation_arrayOf.kt");
    }

    @Test
    @TestMetadata(value="annotationInAnnotation_collectionLiteral.kt")
    public void testAnnotationInAnnotation_collectionLiteral() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationInAnnotation_collectionLiteral.kt");
    }

    @Test
    @TestMetadata(value="annotationInAnnotation_multipleAnnotations_arrayOf.kt")
    public void testAnnotationInAnnotation_multipleAnnotations_arrayOf() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationInAnnotation_multipleAnnotations_arrayOf.kt");
    }

    @Test
    @TestMetadata(value="annotationInAnnotation_multipleAnnotations_collectionLiteral.kt")
    public void testAnnotationInAnnotation_multipleAnnotations_collectionLiteral() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationInAnnotation_multipleAnnotations_collectionLiteral.kt");
    }

    @Test
    @TestMetadata(value="annotationInAnnotation_noarg.kt")
    public void testAnnotationInAnnotation_noarg() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationInAnnotation_noarg.kt");
    }

    @Test
    @TestMetadata(value="annotationInAnnotation_vararg.kt")
    public void testAnnotationInAnnotation_vararg() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationInAnnotation_vararg.kt");
    }

    @Test
    @TestMetadata(value="annotationOnDelegate.kt")
    public void testAnnotationOnDelegate() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnDelegate.kt");
    }

    @Test
    @TestMetadata(value="annotationOnExpression_asT.kt")
    public void testAnnotationOnExpression_asT() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnExpression_asT.kt");
    }

    @Test
    @TestMetadata(value="annotationOnExpression_destructuring.kt")
    public void testAnnotationOnExpression_destructuring() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnExpression_destructuring.kt");
    }

    @Test
    @TestMetadata(value="annotationOnExpression_if.kt")
    public void testAnnotationOnExpression_if() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnExpression_if.kt");
    }

    @Test
    @TestMetadata(value="annotationOnExpression_whenBranch.kt")
    public void testAnnotationOnExpression_whenBranch() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnExpression_whenBranch.kt");
    }

    @Test
    @TestMetadata(value="annotationOnFile.kt")
    public void testAnnotationOnFile() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnFile.kt");
    }

    @Test
    @TestMetadata(value="annotationOnParameter_param.kt")
    public void testAnnotationOnParameter_param() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnParameter_param.kt");
    }

    @Test
    @TestMetadata(value="annotationOnParameter_parameterProperty.kt")
    public void testAnnotationOnParameter_parameterProperty() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnParameter_parameterProperty.kt");
    }

    @Test
    @TestMetadata(value="annotationOnParameter_reified.kt")
    public void testAnnotationOnParameter_reified() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnParameter_reified.kt");
    }

    @Test
    @TestMetadata(value="annotationOnParameter_setparam.kt")
    public void testAnnotationOnParameter_setparam() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnParameter_setparam.kt");
    }

    @Test
    @TestMetadata(value="annotationOnProperty_field.kt")
    public void testAnnotationOnProperty_field() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnProperty_field.kt");
    }

    @Test
    @TestMetadata(value="annotationOnProperty_get.kt")
    public void testAnnotationOnProperty_get() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnProperty_get.kt");
    }

    @Test
    @TestMetadata(value="annotationOnProperty_property.kt")
    public void testAnnotationOnProperty_property() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnProperty_property.kt");
    }

    @Test
    @TestMetadata(value="annotationOnProperty_set.kt")
    public void testAnnotationOnProperty_set() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnProperty_set.kt");
    }

    @Test
    @TestMetadata(value="annotationOnReceiver.kt")
    public void testAnnotationOnReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/annotationOnReceiver.kt");
    }

    @Test
    @TestMetadata(value="arrayIncWithDotQualifier.kt")
    public void testArrayIncWithDotQualifier() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/arrayIncWithDotQualifier.kt");
    }

    @Test
    @TestMetadata(value="arrayOfInAnnotation.kt")
    public void testArrayOfInAnnotation() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/arrayOfInAnnotation.kt");
    }

    @Test
    @TestMetadata(value="builderInference.kt")
    public void testBuilderInference() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/builderInference.kt");
    }

    @Test
    @TestMetadata(value="callableReference_genericQualifier1.kt")
    public void testCallableReference_genericQualifier1() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/callableReference_genericQualifier1.kt");
    }

    @Test
    @TestMetadata(value="callableReference_genericQualifier2.kt")
    public void testCallableReference_genericQualifier2() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/callableReference_genericQualifier2.kt");
    }

    @Test
    @TestMetadata(value="calleeExpressionOfImplicitInvoke.kt")
    public void testCalleeExpressionOfImplicitInvoke() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/calleeExpressionOfImplicitInvoke.kt");
    }

    @Test
    @TestMetadata(value="checkNotNullCall.kt")
    public void testCheckNotNullCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/checkNotNullCall.kt");
    }

    @Test
    @TestMetadata(value="checkNotNullCallAsCallee.kt")
    public void testCheckNotNullCallAsCallee() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/checkNotNullCallAsCallee.kt");
    }

    @Test
    @TestMetadata(value="companionObjectReference.kt")
    public void testCompanionObjectReference() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/companionObjectReference.kt");
    }

    @Test
    @TestMetadata(value="comparisonCall.kt")
    public void testComparisonCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/comparisonCall.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignOnGenericVar.kt")
    public void testCompoundAssignOnGenericVar() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignOnGenericVar.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignOnVal.kt")
    public void testCompoundAssignOnVal() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignOnVal.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignOnVal_lhs.kt")
    public void testCompoundAssignOnVal_lhs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignOnVal_lhs.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignOnVar.kt")
    public void testCompoundAssignOnVar() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignOnVar.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignOnVar_lhs.kt")
    public void testCompoundAssignOnVar_lhs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignOnVar_lhs.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignWithArrayAccessConvention.kt")
    public void testCompoundAssignWithArrayAccessConvention() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignWithArrayAccessConvention.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignWithArrayAccessConvention_complexReceivers.kt")
    public void testCompoundAssignWithArrayAccessConvention_complexReceivers() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignWithArrayAccessConvention_complexReceivers.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignWithArrayAccessConvention_lhs.kt")
    public void testCompoundAssignWithArrayAccessConvention_lhs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignWithArrayAccessConvention_lhs.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignWithArrayGetConvention.kt")
    public void testCompoundAssignWithArrayGetConvention() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignWithArrayGetConvention.kt");
    }

    @Test
    @TestMetadata(value="compoundAssignWithArrayGetConvention_lhs.kt")
    public void testCompoundAssignWithArrayGetConvention_lhs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/compoundAssignWithArrayGetConvention_lhs.kt");
    }

    @Test
    @TestMetadata(value="consecutiveImplicitInvoke1.kt")
    public void testConsecutiveImplicitInvoke1() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/consecutiveImplicitInvoke1.kt");
    }

    @Test
    @TestMetadata(value="consecutiveImplicitInvoke2.kt")
    public void testConsecutiveImplicitInvoke2() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/consecutiveImplicitInvoke2.kt");
    }

    @Test
    @TestMetadata(value="consecutiveImplicitInvoke3.kt")
    public void testConsecutiveImplicitInvoke3() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/consecutiveImplicitInvoke3.kt");
    }

    @Test
    @TestMetadata(value="consecutiveImplicitInvoke_callee.kt")
    public void testConsecutiveImplicitInvoke_callee() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/consecutiveImplicitInvoke_callee.kt");
    }

    @Test
    @TestMetadata(value="defaultValueThatCallsPreviousParameter.kt")
    public void testDefaultValueThatCallsPreviousParameter() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/defaultValueThatCallsPreviousParameter.kt");
    }

    @Test
    @TestMetadata(value="delegatedConstructorCall_super.kt")
    public void testDelegatedConstructorCall_super() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/delegatedConstructorCall_super.kt");
    }

    @Test
    @TestMetadata(value="delegatedConstructorCall_super_unresolved.kt")
    public void testDelegatedConstructorCall_super_unresolved() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/delegatedConstructorCall_super_unresolved.kt");
    }

    @Test
    @TestMetadata(value="delegatedConstructorCall_this.kt")
    public void testDelegatedConstructorCall_this() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/delegatedConstructorCall_this.kt");
    }

    @Test
    @TestMetadata(value="delegatedConstructorCall_this_unresolved.kt")
    public void testDelegatedConstructorCall_this_unresolved() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/delegatedConstructorCall_this_unresolved.kt");
    }

    @Test
    @TestMetadata(value="enumAsAnnotationValue.kt")
    public void testEnumAsAnnotationValue() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/enumAsAnnotationValue.kt");
    }

    @Test
    @TestMetadata(value="enumSuperTypeInterface.kt")
    public void testEnumSuperTypeInterface() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/enumSuperTypeInterface.kt");
    }

    @Test
    @TestMetadata(value="eqEqCall_fromAny.kt")
    public void testEqEqCall_fromAny() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/eqEqCall_fromAny.kt");
    }

    @Test
    @TestMetadata(value="eqEqCall_fromDataClass.kt")
    public void testEqEqCall_fromDataClass() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/eqEqCall_fromDataClass.kt");
    }

    @Test
    @TestMetadata(value="eqEqCall_fromDataClass_overridden.kt")
    public void testEqEqCall_fromDataClass_overridden() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/eqEqCall_fromDataClass_overridden.kt");
    }

    @Test
    @TestMetadata(value="eqEqCall_fromSealedClass.kt")
    public void testEqEqCall_fromSealedClass() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/eqEqCall_fromSealedClass.kt");
    }

    @Test
    @TestMetadata(value="eqEqCall_fromSuperType.kt")
    public void testEqEqCall_fromSuperType() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/eqEqCall_fromSuperType.kt");
    }

    @Test
    @TestMetadata(value="eqEqCall_overridden.kt")
    public void testEqEqCall_overridden() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/eqEqCall_overridden.kt");
    }

    @Test
    @TestMetadata(value="functionCallInTheSameFile.kt")
    public void testFunctionCallInTheSameFile() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionCallInTheSameFile.kt");
    }

    @Test
    @TestMetadata(value="functionCallWithExtensionReceiverAndTypeArgument.kt")
    public void testFunctionCallWithExtensionReceiverAndTypeArgument() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionCallWithExtensionReceiverAndTypeArgument.kt");
    }

    @Test
    @TestMetadata(value="functionCallWithLambdaArgument.kt")
    public void testFunctionCallWithLambdaArgument() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionCallWithLambdaArgument.kt");
    }

    @Test
    @TestMetadata(value="functionCallWithNamedArgument.kt")
    public void testFunctionCallWithNamedArgument() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionCallWithNamedArgument.kt");
    }

    @Test
    @TestMetadata(value="functionCallWithNonTrailingLambdaArgument.kt")
    public void testFunctionCallWithNonTrailingLambdaArgument() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionCallWithNonTrailingLambdaArgument.kt");
    }

    @Test
    @TestMetadata(value="functionCallWithSpreadArgument.kt")
    public void testFunctionCallWithSpreadArgument() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionCallWithSpreadArgument.kt");
    }

    @Test
    @TestMetadata(value="functionCallWithTypeArgument.kt")
    public void testFunctionCallWithTypeArgument() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionCallWithTypeArgument.kt");
    }

    @Test
    @TestMetadata(value="functionCallWithVarargArgument.kt")
    public void testFunctionCallWithVarargArgument() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionCallWithVarargArgument.kt");
    }

    @Test
    @TestMetadata(value="functionTypeVariableCall_dispatchReceiver.kt")
    public void testFunctionTypeVariableCall_dispatchReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionTypeVariableCall_dispatchReceiver.kt");
    }

    @Test
    @TestMetadata(value="functionTypeVariableCall_extensionReceiver.kt")
    public void testFunctionTypeVariableCall_extensionReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionTypeVariableCall_extensionReceiver.kt");
    }

    @Test
    @TestMetadata(value="functionWithReceiverCall.kt")
    public void testFunctionWithReceiverCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionWithReceiverCall.kt");
    }

    @Test
    @TestMetadata(value="functionWithReceiverSafeCall.kt")
    public void testFunctionWithReceiverSafeCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/functionWithReceiverSafeCall.kt");
    }

    @Test
    @TestMetadata(value="hiddenConstructor.kt")
    public void testHiddenConstructor() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/hiddenConstructor.kt");
    }

    @Test
    @TestMetadata(value="hiddenDeprecated.kt")
    public void testHiddenDeprecated() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/hiddenDeprecated.kt");
    }

    @Test
    @TestMetadata(value="implicitConstructorDelegationCall.kt")
    public void testImplicitConstructorDelegationCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/implicitConstructorDelegationCall.kt");
    }

    @Test
    @TestMetadata(value="implicitConstuctorCall.kt")
    public void testImplicitConstuctorCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/implicitConstuctorCall.kt");
    }

    @Test
    @TestMetadata(value="implicitJavaConstuctorCall.kt")
    public void testImplicitJavaConstuctorCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/implicitJavaConstuctorCall.kt");
    }

    @Test
    @TestMetadata(value="incWithDotQualifier.kt")
    public void testIncWithDotQualifier() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/incWithDotQualifier.kt");
    }

    @Test
    @TestMetadata(value="indexedGet.kt")
    public void testIndexedGet() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/indexedGet.kt");
    }

    @Test
    @TestMetadata(value="indexedGetWithNotEnoughArgs.kt")
    public void testIndexedGetWithNotEnoughArgs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/indexedGetWithNotEnoughArgs.kt");
    }

    @Test
    @TestMetadata(value="indexedGetWithTooManyArgs.kt")
    public void testIndexedGetWithTooManyArgs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/indexedGetWithTooManyArgs.kt");
    }

    @Test
    @TestMetadata(value="indexedSet.kt")
    public void testIndexedSet() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/indexedSet.kt");
    }

    @Test
    @TestMetadata(value="indexedSetWithNotEnoughArgs.kt")
    public void testIndexedSetWithNotEnoughArgs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/indexedSetWithNotEnoughArgs.kt");
    }

    @Test
    @TestMetadata(value="indexedSetWithTooManyArgs.kt")
    public void testIndexedSetWithTooManyArgs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/indexedSetWithTooManyArgs.kt");
    }

    @Test
    @TestMetadata(value="intArrayOfInAnnotation.kt")
    public void testIntArrayOfInAnnotation() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/intArrayOfInAnnotation.kt");
    }

    @Test
    @TestMetadata(value="javaClassReference.kt")
    public void testJavaClassReference() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/javaClassReference.kt");
    }

    @Test
    @TestMetadata(value="javaFunctionCall.kt")
    public void testJavaFunctionCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/javaFunctionCall.kt");
    }

    @Test
    @TestMetadata(value="javaPropertyGetter.kt")
    public void testJavaPropertyGetter() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/javaPropertyGetter.kt");
    }

    @Test
    @TestMetadata(value="javaPropertyGetter_unqualified.kt")
    public void testJavaPropertyGetter_unqualified() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/javaPropertyGetter_unqualified.kt");
    }

    @Test
    @TestMetadata(value="javaPropertyNestedGetter.kt")
    public void testJavaPropertyNestedGetter() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/javaPropertyNestedGetter.kt");
    }

    @Test
    @TestMetadata(value="javaPropertySetter.kt")
    public void testJavaPropertySetter() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/javaPropertySetter.kt");
    }

    @Test
    @TestMetadata(value="javaPropertySetterIncomplete.kt")
    public void testJavaPropertySetterIncomplete() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/javaPropertySetterIncomplete.kt");
    }

    @Test
    @TestMetadata(value="javaPropertySetter_unqualified.kt")
    public void testJavaPropertySetter_unqualified() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/javaPropertySetter_unqualified.kt");
    }

    @Test
    @TestMetadata(value="kotlinPropertyGetter.kt")
    public void testKotlinPropertyGetter() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/kotlinPropertyGetter.kt");
    }

    @Test
    @TestMetadata(value="kotlinPropertyGetter_unqualified.kt")
    public void testKotlinPropertyGetter_unqualified() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/kotlinPropertyGetter_unqualified.kt");
    }

    @Test
    @TestMetadata(value="kotlinPropertyNestedGetter.kt")
    public void testKotlinPropertyNestedGetter() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/kotlinPropertyNestedGetter.kt");
    }

    @Test
    @TestMetadata(value="kotlinPropertySetter.kt")
    public void testKotlinPropertySetter() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/kotlinPropertySetter.kt");
    }

    @Test
    @TestMetadata(value="kotlinPropertySetterGeneric.kt")
    public void testKotlinPropertySetterGeneric() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/kotlinPropertySetterGeneric.kt");
    }

    @Test
    @TestMetadata(value="kotlinPropertySetter_unqualified.kt")
    public void testKotlinPropertySetter_unqualified() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/kotlinPropertySetter_unqualified.kt");
    }

    @Test
    @TestMetadata(value="memberFunctionCallWithTypeArgument.kt")
    public void testMemberFunctionCallWithTypeArgument() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/memberFunctionCallWithTypeArgument.kt");
    }

    @Test
    @TestMetadata(value="noBuiltIns.kt")
    public void testNoBuiltIns() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/noBuiltIns.kt");
    }

    @Test
    @TestMetadata(value="postfixUnaryOperatorOnVar.kt")
    public void testPostfixUnaryOperatorOnVar() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/postfixUnaryOperatorOnVar.kt");
    }

    @Test
    @TestMetadata(value="postfixUnaryOperatorOnVar_base.kt")
    public void testPostfixUnaryOperatorOnVar_base() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/postfixUnaryOperatorOnVar_base.kt");
    }

    @Test
    @TestMetadata(value="postfixUnaryOperatorWithArrayAccessConvention.kt")
    public void testPostfixUnaryOperatorWithArrayAccessConvention() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/postfixUnaryOperatorWithArrayAccessConvention.kt");
    }

    @Test
    @TestMetadata(value="postfixUnaryOperatorWithArrayAccessConvention_base.kt")
    public void testPostfixUnaryOperatorWithArrayAccessConvention_base() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/postfixUnaryOperatorWithArrayAccessConvention_base.kt");
    }

    @Test
    @TestMetadata(value="postfixUnaryOperatorWithArrayAccessConvention_complexDispatcher.kt")
    public void testPostfixUnaryOperatorWithArrayAccessConvention_complexDispatcher() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/postfixUnaryOperatorWithArrayAccessConvention_complexDispatcher.kt");
    }

    @Test
    @TestMetadata(value="prefixUnaryOperatorOnGenericVar.kt")
    public void testPrefixUnaryOperatorOnGenericVar() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/prefixUnaryOperatorOnGenericVar.kt");
    }

    @Test
    @TestMetadata(value="prefixUnaryOperatorOnVar.kt")
    public void testPrefixUnaryOperatorOnVar() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/prefixUnaryOperatorOnVar.kt");
    }

    @Test
    @TestMetadata(value="prefixUnaryOperatorOnVar_base.kt")
    public void testPrefixUnaryOperatorOnVar_base() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/prefixUnaryOperatorOnVar_base.kt");
    }

    @Test
    @TestMetadata(value="prefixUnaryOperatorWithArrayAccessConvention.kt")
    public void testPrefixUnaryOperatorWithArrayAccessConvention() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/prefixUnaryOperatorWithArrayAccessConvention.kt");
    }

    @Test
    @TestMetadata(value="prefixUnaryOperatorWithArrayAccessConvention_base.kt")
    public void testPrefixUnaryOperatorWithArrayAccessConvention_base() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/prefixUnaryOperatorWithArrayAccessConvention_base.kt");
    }

    @Test
    @TestMetadata(value="prefixUnaryOperatorWithArrayAccessConvention_complexDispatcher.kt")
    public void testPrefixUnaryOperatorWithArrayAccessConvention_complexDispatcher() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/prefixUnaryOperatorWithArrayAccessConvention_complexDispatcher.kt");
    }

    @Test
    @TestMetadata(value="privateMember.kt")
    public void testPrivateMember() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/privateMember.kt");
    }

    @Test
    @TestMetadata(value="qualifiedCalleeExpressionOfImplicitInvoke.kt")
    public void testQualifiedCalleeExpressionOfImplicitInvoke() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/qualifiedCalleeExpressionOfImplicitInvoke.kt");
    }

    @Test
    @TestMetadata(value="recursiveTypeParameter.kt")
    public void testRecursiveTypeParameter() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/recursiveTypeParameter.kt");
    }

    @Test
    @TestMetadata(value="resolveCallInSuperConstructorParam.kt")
    public void testResolveCallInSuperConstructorParam() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/resolveCallInSuperConstructorParam.kt");
    }

    @Test
    @TestMetadata(value="samConstructorCall.kt")
    public void testSamConstructorCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/samConstructorCall.kt");
    }

    @Test
    @TestMetadata(value="samFromJava_lambda.kt")
    public void testSamFromJava_lambda() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/samFromJava_lambda.kt");
    }

    @Test
    @TestMetadata(value="samFromJava_methodReference.kt")
    public void testSamFromJava_methodReference() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/samFromJava_methodReference.kt");
    }

    @Test
    @TestMetadata(value="samLambda.kt")
    public void testSamLambda() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/samLambda.kt");
    }

    @Test
    @TestMetadata(value="samMethodReference.kt")
    public void testSamMethodReference() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/samMethodReference.kt");
    }

    @Test
    @TestMetadata(value="simpleCallWithNonMatchingArgs.kt")
    public void testSimpleCallWithNonMatchingArgs() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/simpleCallWithNonMatchingArgs.kt");
    }

    @Test
    @TestMetadata(value="smartCastExplicitDispatchReceiver.kt")
    public void testSmartCastExplicitDispatchReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/smartCastExplicitDispatchReceiver.kt");
    }

    @Test
    @TestMetadata(value="smartCastExplicitExtensionReceiver.kt")
    public void testSmartCastExplicitExtensionReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/smartCastExplicitExtensionReceiver.kt");
    }

    @Test
    @TestMetadata(value="smartCastImplicitDispatchReceiver.kt")
    public void testSmartCastImplicitDispatchReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/smartCastImplicitDispatchReceiver.kt");
    }

    @Test
    @TestMetadata(value="smartCastImplicitExtensionReceiver.kt")
    public void testSmartCastImplicitExtensionReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/smartCastImplicitExtensionReceiver.kt");
    }

    @Test
    @TestMetadata(value="smartCastedArg.kt")
    public void testSmartCastedArg() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/smartCastedArg.kt");
    }

    @Test
    @TestMetadata(value="smartCastedNonNullArg.kt")
    public void testSmartCastedNonNullArg() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/smartCastedNonNullArg.kt");
    }

    @Test
    @TestMetadata(value="substituteOverrideResolution.kt")
    public void testSubstituteOverrideResolution() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/substituteOverrideResolution.kt");
    }

    @Test
    @TestMetadata(value="superTypeCallEntryResolveToCallInfo.kt")
    public void testSuperTypeCallEntryResolveToCallInfo() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/superTypeCallEntryResolveToCallInfo.kt");
    }

    @Test
    @TestMetadata(value="typecheckerRecursiveError.kt")
    public void testTypecheckerRecursiveError() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/typecheckerRecursiveError.kt");
    }

    @Test
    @TestMetadata(value="unresolvableOperator_elvis_1.kt")
    public void testUnresolvableOperator_elvis_1() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/unresolvableOperator_elvis_1.kt");
    }

    @Test
    @TestMetadata(value="unresolvableOperator_elvis_2.kt")
    public void testUnresolvableOperator_elvis_2() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/unresolvableOperator_elvis_2.kt");
    }

    @Test
    @TestMetadata(value="unresolvableOperator_eqeqeq_1.kt")
    public void testUnresolvableOperator_eqeqeq_1() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/unresolvableOperator_eqeqeq_1.kt");
    }

    @Test
    @TestMetadata(value="unresolvableOperator_eqeqeq_2.kt")
    public void testUnresolvableOperator_eqeqeq_2() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/unresolvableOperator_eqeqeq_2.kt");
    }

    @Test
    @TestMetadata(value="unresolvableOperator_excleqeq_1.kt")
    public void testUnresolvableOperator_excleqeq_1() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/unresolvableOperator_excleqeq_1.kt");
    }

    @Test
    @TestMetadata(value="unresolvableOperator_excleqeq_2.kt")
    public void testUnresolvableOperator_excleqeq_2() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/unresolvableOperator_excleqeq_2.kt");
    }

    @Test
    @TestMetadata(value="unresolvedSuperReference.kt")
    public void testUnresolvedSuperReference() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/unresolvedSuperReference.kt");
    }

    @Test
    @TestMetadata(value="unsignedArrayOf.kt")
    public void testUnsignedArrayOf() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/unsignedArrayOf.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunction.kt")
    public void testVariableAsFunction() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunction.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunctionLikeCall.kt")
    public void testVariableAsFunctionLikeCall() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunctionLikeCall.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunctionWithParameterName.kt")
    public void testVariableAsFunctionWithParameterName() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunctionWithParameterName.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunctionWithParameterNameAnnotation.kt")
    public void testVariableAsFunctionWithParameterNameAnnotation() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunctionWithParameterNameAnnotation.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunctionWithParameterNameAnnotationConflict.kt")
    public void testVariableAsFunctionWithParameterNameAnnotationConflict() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunctionWithParameterNameAnnotationConflict.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunctionWithParameterNameAnnotationConflict2.kt")
    public void testVariableAsFunctionWithParameterNameAnnotationConflict2() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunctionWithParameterNameAnnotationConflict2.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunctionWithParameterNameGeneric.kt")
    public void testVariableAsFunctionWithParameterNameGeneric() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunctionWithParameterNameGeneric.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunctionWithParameterNameInNonFunctionType.kt")
    public void testVariableAsFunctionWithParameterNameInNonFunctionType() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunctionWithParameterNameInNonFunctionType.kt");
    }

    @Test
    @TestMetadata(value="variableAsFunctionWithParameterNameMixed.kt")
    public void testVariableAsFunctionWithParameterNameMixed() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableAsFunctionWithParameterNameMixed.kt");
    }

    @Test
    @TestMetadata(value="variableWithExtensionInvoke.kt")
    public void testVariableWithExtensionInvoke() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableWithExtensionInvoke.kt");
    }

    @Test
    @TestMetadata(value="variableWithInvokeFunctionCall_dispatchReceiver.kt")
    public void testVariableWithInvokeFunctionCall_dispatchReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableWithInvokeFunctionCall_dispatchReceiver.kt");
    }

    @Test
    @TestMetadata(value="variableWithInvokeFunctionCall_extensionReceiver.kt")
    public void testVariableWithInvokeFunctionCall_extensionReceiver() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableWithInvokeFunctionCall_extensionReceiver.kt");
    }

    @Test
    @TestMetadata(value="variableWithMemberInvoke.kt")
    public void testVariableWithMemberInvoke() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/variableWithMemberInvoke.kt");
    }

    @Test
    @TestMetadata(value="whenSelectorSmartCast.kt")
    public void testWhenSelectorSmartCast() {
        this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/whenSelectorSmartCast.kt");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/analysis/api/fir/test/cases/generated/cases/components/callResolver/FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated", "getConfigurator"));
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/components/callResolver/resolveCall/withTestCompilerPluginEnabled")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WithTestCompilerPluginEnabled {
        @Test
        public void testAllFilesPresentInWithTestCompilerPluginEnabled() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/components/callResolver/resolveCall/withTestCompilerPluginEnabled"), (Pattern)Pattern.compile("^(.+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="customSerlializable.kt")
        public void testCustomSerlializable() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/withTestCompilerPluginEnabled/customSerlializable.kt");
        }

        @Test
        @TestMetadata(value="dummyFunction.kt")
        public void testDummyFunction() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/withTestCompilerPluginEnabled/dummyFunction.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/components/callResolver/resolveCall/nonCalls")
    @TestDataPath(value="$PROJECT_ROOT")
    public class NonCalls {
        @Test
        public void testAllFilesPresentInNonCalls() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/components/callResolver/resolveCall/nonCalls"), (Pattern)Pattern.compile("^(.+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="ifExpression.kt")
        public void testIfExpression() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/nonCalls/ifExpression.kt");
        }

        @Test
        @TestMetadata(value="literalExpression.kt")
        public void testLiteralExpression() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/nonCalls/literalExpression.kt");
        }

        @Test
        @TestMetadata(value="whenExpression.kt")
        public void testWhenExpression() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/nonCalls/whenExpression.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InvokeOnObjects {
        @Test
        public void testAllFilesPresentInInvokeOnObjects() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects"), (Pattern)Pattern.compile("^(.+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="companionObject1.kt")
        public void testCompanionObject1() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/companionObject1.kt");
        }

        @Test
        @TestMetadata(value="companionObject2.kt")
        public void testCompanionObject2() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/companionObject2.kt");
        }

        @Test
        @TestMetadata(value="companionObjectWithName1.kt")
        public void testCompanionObjectWithName1() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/companionObjectWithName1.kt");
        }

        @Test
        @TestMetadata(value="companionObjectWithName2.kt")
        public void testCompanionObjectWithName2() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/companionObjectWithName2.kt");
        }

        @Test
        @TestMetadata(value="nestedObject1.kt")
        public void testNestedObject1() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/nestedObject1.kt");
        }

        @Test
        @TestMetadata(value="nestedObject2.kt")
        public void testNestedObject2() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/nestedObject2.kt");
        }

        @Test
        @TestMetadata(value="nestedObject3.kt")
        public void testNestedObject3() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/nestedObject3.kt");
        }

        @Test
        @TestMetadata(value="nestedObject4.kt")
        public void testNestedObject4() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/nestedObject4.kt");
        }

        @Test
        @TestMetadata(value="simpleObject1.kt")
        public void testSimpleObject1() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/simpleObject1.kt");
        }

        @Test
        @TestMetadata(value="simpleObject2.kt")
        public void testSimpleObject2() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invokeOnObjects/simpleObject2.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InvalidCode {
        @Test
        public void testAllFilesPresentInInvalidCode() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode"), (Pattern)Pattern.compile("^(.+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="assignementInExpression.kt")
        public void testAssignementInExpression() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode/assignementInExpression.kt");
        }

        @Test
        @TestMetadata(value="getterAssignment.kt")
        public void testGetterAssignment() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode/getterAssignment.kt");
        }

        @Test
        @TestMetadata(value="incompleteCodeNoParenthesis.kt")
        public void testIncompleteCodeNoParenthesis() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode/incompleteCodeNoParenthesis.kt");
        }

        @Test
        @TestMetadata(value="incompleteCodeNoParenthesisDotQualifier.kt")
        public void testIncompleteCodeNoParenthesisDotQualifier() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode/incompleteCodeNoParenthesisDotQualifier.kt");
        }

        @Test
        @TestMetadata(value="incompleteCodeWithAmbiguity.kt")
        public void testIncompleteCodeWithAmbiguity() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode/incompleteCodeWithAmbiguity.kt");
        }

        @Test
        @TestMetadata(value="incorrectCodeJavaDeclaration.kt")
        public void testIncorrectCodeJavaDeclaration() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode/incorrectCodeJavaDeclaration.kt");
        }

        @Test
        @TestMetadata(value="invalidImplicitInvoke.kt")
        public void testInvalidImplicitInvoke() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode/invalidImplicitInvoke.kt");
        }

        @Test
        @TestMetadata(value="typeParameterAsValue.kt")
        public void testTypeParameterAsValue() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/invalidCode/typeParameterAsValue.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/analysis-api/testData/components/callResolver/resolveCall/assignments")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Assignments {
        @Test
        public void testAllFilesPresentInAssignments() {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/analysis-api/testData/components/callResolver/resolveCall/assignments"), (Pattern)Pattern.compile("^(.+)\\.kt$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="insidePlusAssignTarget.kt")
        public void testInsidePlusAssignTarget() {
            FirIdeNormalAnalysisSourceModuleResolveCallTestGenerated.this.runTest("analysis/analysis-api/testData/components/callResolver/resolveCall/assignments/insidePlusAssignTarget.kt");
        }
    }
}

