/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.project.structure;

import com.intellij.openapi.project.Project;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.standalone.base.project.structure.KtModuleWithFiles;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtLibrarySourceModuleFactoryKt;
import org.jetbrains.kotlin.analysis.test.framework.project.structure.KtModuleFactory;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompiledLibrary;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompiledLibraryProviderKt;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.TargetPlatformKt;
import org.jetbrains.kotlin.test.model.TestModule;
import org.jetbrains.kotlin.test.services.TestServices;
import org.junit.Assume;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtLibrarySourceModuleFactory;", "Lorg/jetbrains/kotlin/analysis/test/framework/project/structure/KtModuleFactory;", "<init>", "()V", "createModule", "Lorg/jetbrains/kotlin/analysis/api/standalone/base/project/structure/KtModuleWithFiles;", "testModule", "Lorg/jetbrains/kotlin/test/model/TestModule;", "contextModule", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "project", "Lcom/intellij/openapi/project/Project;", "analysis-test-framework_test"})
public final class KtLibrarySourceModuleFactory
implements KtModuleFactory {
    @NotNull
    public static final KtLibrarySourceModuleFactory INSTANCE = new KtLibrarySourceModuleFactory();

    private KtLibrarySourceModuleFactory() {
    }

    @Override
    @NotNull
    public KtModuleWithFiles createModule(@NotNull TestModule testModule, @Nullable KtModuleWithFiles contextModule, @NotNull TestServices testServices, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)testModule, (String)"testModule");
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Assume.assumeFalse((String)"Compilation of multi-platform libraries is not supported", (boolean)TargetPlatformKt.isMultiPlatform((TargetPlatform)testModule.getTargetPlatform()));
        CompiledLibrary compiledLibrary = CompiledLibraryProviderKt.getCompiledLibraryProvider(testServices).compileToLibrary(testModule);
        Path libraryJar = compiledLibrary.component1();
        Path librarySourcesJar = compiledLibrary.component2();
        if (!(librarySourcesJar != null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        return KtLibrarySourceModuleFactoryKt.createKtLibrarySourceModule(libraryJar, librarySourcesJar, testModule, project, testServices);
    }
}

