/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based;

import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.compiler.based.LLFirDivergenceUtilsKt;
import org.jetbrains.kotlin.test.frontend.fir.handlers.AbstractFirIdenticalChecker;
import org.jetbrains.kotlin.test.services.AssertionsKt;
import org.jetbrains.kotlin.test.services.TestServices;
import org.jetbrains.kotlin.test.utils.CustomTestDataUtilsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/LLFirIdenticalChecker;", "Lorg/jetbrains/kotlin/test/frontend/fir/handlers/AbstractFirIdenticalChecker;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "<init>", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "checkTestDataFile", "", "testDataFile", "Ljava/io/File;", "low-level-api-fir_test"})
@SourceDebugExtension(value={"SMAP\nLLFirIdenticalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LLFirIdenticalChecker.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/compiler/based/LLFirIdenticalChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,45:1\n1#2:46\n*E\n"})
public final class LLFirIdenticalChecker
extends AbstractFirIdenticalChecker {
    public LLFirIdenticalChecker(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    protected void checkTestDataFile(@NotNull File testDataFile) {
        String llContent;
        String baseContent;
        File baseFile;
        File file;
        Intrinsics.checkNotNullParameter((Object)testDataFile, (String)"testDataFile");
        if (!CustomTestDataUtilsKt.isLLFirTestData((File)testDataFile)) {
            return;
        }
        File originalFile = this.getHelper().getClassicFileToCompare(testDataFile);
        File it = file = this.getHelper().getFirFileToCompare(originalFile);
        boolean bl = false;
        File file2 = it.exists() ? file : null;
        if (file2 == null) {
            file2 = baseFile = originalFile;
        }
        if (Intrinsics.areEqual((Object)(baseContent = ((Object)StringsKt.trimStart((CharSequence)this.getHelper().readContent(baseFile, true))).toString()), (Object)(llContent = LLFirDivergenceUtilsKt.removeLlFirDivergenceDirective(this.getHelper().readContent(testDataFile, false), true)))) {
            AssertionsKt.getAssertions((TestServices)this.getTestServices()).fail((Function0)new Function0<String>(testDataFile, baseFile){
                final /* synthetic */ File $testDataFile;
                final /* synthetic */ File $baseFile;
                {
                    this.$testDataFile = $testDataFile;
                    this.$baseFile = $baseFile;
                    super(0);
                }

                public final String invoke() {
                    return '`' + this.$testDataFile.getName() + "` and `" + this.$baseFile.getName() + "` are identical. Remove `" + this.$testDataFile + "`.";
                }
            });
            throw null;
        }
        this.assertPreprocessedTestDataAreEqual(this.getTestServices(), baseFile, baseContent, testDataFile, llContent, (Function0)new Function0<String>(baseFile, testDataFile){
            final /* synthetic */ File $baseFile;
            final /* synthetic */ File $testDataFile;
            {
                this.$baseFile = $baseFile;
                this.$testDataFile = $testDataFile;
                super(0);
            }

            public final String invoke() {
                return "When ignoring diagnostics, the contents of `" + this.$baseFile.getName() + "` (expected) and `" + this.$testDataFile.getName() + "` (actual) are not identical. `.ll.kt` test data may only differ from its base `.fir.kt` or `.kt` test data in the reported diagnostics and the `LL_FIR_DIVERGENCE` directive. Update one of these test data files.";
            }
        });
    }
}

