/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services.libraries;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.FileTreeWalk;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.CompilerExecutor;
import org.jetbrains.kotlin.analysis.test.framework.services.libraries.LibraryWasNotCompiledDueToExpectedCompilationError;
import org.jetbrains.kotlin.cli.common.arguments.CommonToolArgumentsKt;
import org.jetbrains.kotlin.test.MockLibraryUtil;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rJ&\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor;", "", "<init>", "()V", "compileLibrary", "Ljava/nio/file/Path;", "compilerKind", "Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor$CompilerKind;", "sourcesPath", "options", "", "", "compilationErrorExpected", "", "compile", "CompilerKind", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\nCompilerExecutor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerExecutor.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,75:1\n1155#2,3:76\n1155#2,3:79\n*S KotlinDebug\n*F\n+ 1 CompilerExecutor.kt\norg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor\n*L\n46#1:76,3\n59#1:79,3\n*E\n"})
public final class CompilerExecutor {
    @NotNull
    public static final CompilerExecutor INSTANCE = new CompilerExecutor();

    private CompilerExecutor() {
    }

    @NotNull
    public final Path compileLibrary(@NotNull CompilerKind compilerKind, @NotNull Path sourcesPath, @NotNull List<String> options, boolean compilationErrorExpected) {
        Path library;
        block10: {
            block9: {
                boolean bl;
                Path path;
                Intrinsics.checkNotNullParameter((Object)((Object)compilerKind), (String)"compilerKind");
                Intrinsics.checkNotNullParameter((Object)sourcesPath, (String)"sourcesPath");
                Intrinsics.checkNotNullParameter(options, (String)"options");
                try {
                    path = this.compile(compilerKind, sourcesPath, options);
                }
                catch (Throwable e) {
                    if (!compilationErrorExpected) {
                        throw new IllegalStateException("Unexpected compilation error while compiling library", e);
                    }
                    path = null;
                }
                Path path2 = library = path;
                if (path2 != null) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    bl = Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                } else {
                    bl = false;
                }
                if (bl && compilationErrorExpected) {
                    throw new IllegalStateException("Compilation error expected but, code was compiled successfully".toString());
                }
                if (library == null) break block9;
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.notExists(library, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block10;
            }
            throw new LibraryWasNotCompiledDueToExpectedCompilationError();
        }
        return library;
    }

    /*
     * WARNING - void declaration
     */
    private final Path compile(CompilerKind compilerKind, Path sourcesPath, List<String> options) {
        Path path;
        File file = sourcesPath.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
        FileTreeWalk sourceFiles = FilesKt.walkBottomUp((File)file);
        switch (WhenMappings.$EnumSwitchMapping$0[compilerKind.ordinal()]) {
            case 1: {
                Path path2 = sourcesPath.resolve("library.jar");
                path = path2;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
                break;
            }
            case 2: {
                Path path3 = sourcesPath.resolve("library.klib");
                path = path3;
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Path library = path;
        switch (WhenMappings.$EnumSwitchMapping$0[compilerKind.ordinal()]) {
            case 1: {
                List list;
                List $this$compile_u24lambda_u241 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                Sequence $this$mapTo$iv = (Sequence)sourceFiles;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void it;
                    File file2 = (File)item$iv;
                    Collection collection = $this$compile_u24lambda_u241;
                    boolean bl2 = false;
                    collection.add(it.getAbsolutePath());
                }
                $this$compile_u24lambda_u241.addAll((Collection)options);
                $this$compile_u24lambda_u241.add(CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)compile.commands.1.2.INSTANCE)));
                $this$compile_u24lambda_u241.add(((Object)library.toAbsolutePath()).toString());
                $this$compile_u24lambda_u241.add("-XXLanguage:-SkipStandaloneScriptsInSourceRoots");
                List commands2 = CollectionsKt.build((List)list);
                MockLibraryUtil.INSTANCE.runJvmCompiler(commands2);
                break;
            }
            case 2: {
                List list;
                List $this$compile_u24lambda_u243 = list = CollectionsKt.createListBuilder();
                boolean bl = false;
                $this$compile_u24lambda_u243.add(CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)compile.commands.2.1.INSTANCE)));
                $this$compile_u24lambda_u243.add(CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)compile.commands.2.2.INSTANCE)));
                $this$compile_u24lambda_u243.add("library");
                $this$compile_u24lambda_u243.add(CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)compile.commands.2.3.INSTANCE)));
                Path path4 = library.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"getParent(...)");
                $this$compile_u24lambda_u243.add(((Object)path4.toAbsolutePath()).toString());
                $this$compile_u24lambda_u243.add(CommonToolArgumentsKt.getCliArgument((KProperty1)((KProperty1)compile.commands.2.4.INSTANCE)));
                Sequence $this$mapTo$iv = (Sequence)sourceFiles;
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    File it = (File)item$iv;
                    Collection collection = $this$compile_u24lambda_u243;
                    boolean bl3 = false;
                    collection.add(it.getAbsolutePath());
                }
                $this$compile_u24lambda_u243.addAll((Collection)options);
                List commands3 = CollectionsKt.build((List)list);
                MockLibraryUtil.INSTANCE.runJsCompiler(commands3);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return library;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/libraries/CompilerExecutor$CompilerKind;", "", "<init>", "(Ljava/lang/String;I)V", "JVM", "JS", "analysis-test-framework_test"})
    public static final class CompilerKind
    extends Enum<CompilerKind> {
        public static final /* enum */ CompilerKind JVM = new CompilerKind();
        public static final /* enum */ CompilerKind JS = new CompilerKind();
        private static final /* synthetic */ CompilerKind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static CompilerKind[] values() {
            return (CompilerKind[])$VALUES.clone();
        }

        public static CompilerKind valueOf(String value2) {
            return Enum.valueOf(CompilerKind.class, value2);
        }

        @NotNull
        public static EnumEntries<CompilerKind> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = compilerKindArray = new CompilerKind[]{CompilerKind.JVM, CompilerKind.JS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=50)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CompilerKind.values().length];
            try {
                nArray[CompilerKind.JVM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CompilerKind.JS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

