/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.decompiler.stub.files;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.stubs.PsiFileStub;
import com.intellij.psi.stubs.StubElement;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.decompiler.stub.file.KotlinClsStubBuilder;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractAdditionalStubInfoTest;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.AbstractDecompiledClassTest;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.KotlinContractRenderer;
import org.jetbrains.kotlin.analysis.decompiler.stub.files.TestData;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionElement;
import org.jetbrains.kotlin.contracts.description.KtContractDescriptionVisitor;
import org.jetbrains.kotlin.psi.KtProjectionKind;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinAnnotationEntryStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinClassTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFlexibleTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinFunctionStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinParameterStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinPropertyStubImpl;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeArgumentBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinTypeParameterTypeBean;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinUserTypeStubImpl;
import org.jetbrains.kotlin.test.KotlinTestUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=50, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J-\u0010\b\u001a\u00020\u00052\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\n\u0010\u000b\u001a\u00060\rj\u0002`\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010J!\u0010\u0011\u001a\u00020\u00052\n\u0010\u000b\u001a\u00060\rj\u0002`\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractAdditionalStubInfoTest;", "Lorg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractDecompiledClassTest;", "<init>", "()V", "runTest", "", "testDirectory", "", "extractAdditionInfo", "stub", "Lcom/intellij/psi/stubs/StubElement;", "builder", "Lkotlin/text/StringBuilder;", "Ljava/lang/StringBuilder;", "level", "", "(Lcom/intellij/psi/stubs/StubElement;Ljava/lang/StringBuilder;I)V", "appendFlexibleTypeInfo", "typeBean", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;", "(Ljava/lang/StringBuilder;Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinTypeBean;)V", "decompiler-to-file-stubs_test"})
@SourceDebugExtension(value={"SMAP\nAbstractAdditionalStubInfoTest.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractAdditionalStubInfoTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractAdditionalStubInfoTest\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1#2:163\n1862#3,3:164\n*S KotlinDebug\n*F\n+ 1 AbstractAdditionalStubInfoTest.kt\norg/jetbrains/kotlin/analysis/decompiler/stub/files/AbstractAdditionalStubInfoTest\n*L\n81#1:164,3\n*E\n"})
public abstract class AbstractAdditionalStubInfoTest
extends AbstractDecompiledClassTest {
    public final void runTest(@NotNull String testDirectory) {
        Intrinsics.checkNotNullParameter((Object)testDirectory, (String)"testDirectory");
        Path testDirectoryPath = Paths.get(testDirectory, new String[0]);
        Intrinsics.checkNotNull((Object)testDirectoryPath);
        TestData testData = TestData.Companion.createFromDirectory(testDirectoryPath);
        KotlinClsStubBuilder kotlinClsStubBuilder = new KotlinClsStubBuilder();
        FileContent fileContent = FileContentImpl.createByFile((VirtualFile)this.getClassFileToDecompile$decompiler_to_file_stubs_test(testData, false));
        Intrinsics.checkNotNullExpressionValue((Object)fileContent, (String)"createByFile(...)");
        PsiFileStub psiFileStub = kotlinClsStubBuilder.buildFileStub(fileContent);
        Intrinsics.checkNotNull((Object)psiFileStub);
        PsiFileStub stub = psiFileStub;
        StringBuilder builder = new StringBuilder();
        this.extractAdditionInfo((StubElement)stub, builder, 0);
        KotlinTestUtils.assertEqualsToFile((Path)testData.getExpectedFile(this.getUseK2ToCompileCode()), (String)builder.toString());
        testData.checkIfIdentical(this.getUseK2ToCompileCode());
    }

    private final void extractAdditionInfo(StubElement<?> stub, StringBuilder builder, int level) {
        builder.append(stub.toString());
        StubElement<?> stubElement = stub;
        if (stubElement instanceof KotlinUserTypeStubImpl) {
            KotlinTypeBean upperBound = ((KotlinUserTypeStubImpl)stub).getUpperBound();
            if (upperBound != null) {
                builder.append("    ft: ");
                this.appendFlexibleTypeInfo(builder, upperBound);
            }
        } else if (stubElement instanceof KotlinFunctionStubImpl) {
            List contract = ((KotlinFunctionStubImpl)stub).getContract();
            if (contract != null) {
                for (KtContractDescriptionElement element : contract) {
                    builder.append('\n' + StringsKt.repeat((CharSequence)"  ", (int)level)).append("effect:");
                    element.accept((KtContractDescriptionVisitor)new KotlinContractRenderer(builder), null);
                }
            }
        } else if (stubElement instanceof KotlinPropertyStubImpl) {
            ConstantValue initializer = ((KotlinPropertyStubImpl)stub).getConstantInitializer();
            if (initializer != null) {
                builder.append("\n").append(StringsKt.repeat((CharSequence)"  ", (int)level)).append("initializer: " + initializer.getValue());
            }
        } else if (stubElement instanceof KotlinAnnotationEntryStubImpl) {
            Map arguments = ((KotlinAnnotationEntryStubImpl)stub).getValueArguments();
            if (arguments != null) {
                builder.append("\n").append(StringsKt.repeat((CharSequence)"  ", (int)level)).append("valueArguments: ").append(CollectionsKt.joinToString$default((Iterable)arguments.entrySet(), (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, (Function1)extractAdditionInfo.1.INSTANCE, (int)24, null));
            }
        } else if (stubElement instanceof KotlinParameterStubImpl) {
            String string = ((KotlinParameterStubImpl)stub).getFunctionTypeParameterName();
            if (string != null) {
                String it = string;
                boolean bl = false;
                builder.append("   paramNameByAnnotation: ").append(it);
            }
        }
        for (StubElement child : stub.getChildrenStubs()) {
            builder.append("\n").append(StringsKt.repeat((CharSequence)"  ", (int)level));
            Intrinsics.checkNotNull((Object)child);
            this.extractAdditionInfo(child, builder, level + 1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void appendFlexibleTypeInfo(StringBuilder builder, KotlinTypeBean typeBean) {
        KotlinTypeBean kotlinTypeBean = typeBean;
        if (kotlinTypeBean instanceof KotlinClassTypeBean) {
            builder.append(((KotlinClassTypeBean)typeBean).getClassId().asFqNameString());
            List arguments = ((KotlinClassTypeBean)typeBean).getArguments();
            if (!((Collection)arguments).isEmpty()) {
                builder.append("<");
                Iterable $this$forEachIndexed$iv = arguments;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void arg;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    KotlinTypeArgumentBean kotlinTypeArgumentBean = (KotlinTypeArgumentBean)item$iv;
                    int index = n;
                    boolean bl = false;
                    if (index > 0) {
                        builder.append(", ");
                    }
                    if (arg.getProjectionKind() != KtProjectionKind.NONE) {
                        builder.append(arg.getProjectionKind().name());
                    }
                    if (arg.getProjectionKind() == KtProjectionKind.STAR) continue;
                    KotlinTypeBean kotlinTypeBean2 = arg.getType();
                    Intrinsics.checkNotNull((Object)kotlinTypeBean2);
                    this.appendFlexibleTypeInfo(builder, kotlinTypeBean2);
                }
                builder.append(">");
            }
            if (((KotlinClassTypeBean)typeBean).getNullable()) {
                builder.append("?");
            }
        } else if (kotlinTypeBean instanceof KotlinTypeParameterTypeBean) {
            builder.append(((KotlinTypeParameterTypeBean)typeBean).getTypeParameterName());
            if (((KotlinTypeParameterTypeBean)typeBean).getNullable()) {
                builder.append("?");
            }
            if (((KotlinTypeParameterTypeBean)typeBean).getDefinitelyNotNull()) {
                builder.append(" & Any");
            }
        } else if (kotlinTypeBean instanceof KotlinFlexibleTypeBean) {
            this.appendFlexibleTypeInfo(builder, ((KotlinFlexibleTypeBean)typeBean).getLowerBound());
            builder.append(" .. ");
            this.appendFlexibleTypeInfo(builder, ((KotlinFlexibleTypeBean)typeBean).getUpperBound());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }
}

