/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.utils;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.symbols.KtSymbol;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.test.directives.model.Directive;
import org.jetbrains.kotlin.test.directives.model.RegisteredDirectives;

@Metadata(mv={2, 0, 0}, k=2, xi=50, d1={"\u0000P\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a'\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u000e\b\u0004\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u001f\u0010\u0005\u001a\u0002H\u0006\"\u0004\b\u0000\u0010\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0003\u00a2\u0006\u0002\u0010\u0004\u001a\f\u0010\b\u001a\u00020\t*\u0004\u0018\u00010\n\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\f\u001a\u0012\u0010\r\u001a\u00020\t*\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\n\u0010\u000b\u001a\u00020\t*\u00020\u0010\u001a\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000f\u001a\u0010\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u0012*\u00020\u0018\u001a \u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0003\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001e"}, d2={"runReadAction", "T", "runnable", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "executeOnPooledThreadInReadAction", "R", "action", "position", "", "Lcom/intellij/psi/PsiElement;", "getNameWithPositionString", "Lorg/jetbrains/kotlin/analysis/api/symbols/KtSymbol;", "indented", "indent", "", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "findReferencesAtCaret", "", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "mainKtFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "caretPosition", "unwrapMultiReferences", "Lcom/intellij/psi/PsiReference;", "ignoreExceptionIfIgnoreDirectivePresent", "", "Lorg/jetbrains/kotlin/test/directives/model/RegisteredDirectives;", "ignoreDirective", "Lorg/jetbrains/kotlin/test/directives/model/Directive;", "analysis-test-framework_test"})
@SourceDebugExtension(value={"SMAP\ncommonTestUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 commonTestUtils.kt\norg/jetbrains/kotlin/analysis/test/framework/utils/CommonTestUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,79:1\n21#1:97\n800#2,11:80\n9972#3:91\n10394#3,5:92\n*S KotlinDebug\n*F\n+ 1 commonTestUtils.kt\norg/jetbrains/kotlin/analysis/test/framework/utils/CommonTestUtilsKt\n*L\n25#1:97\n51#1:80,11\n55#1:91\n55#1:92,5\n*E\n"})
public final class CommonTestUtilsKt {
    public static final <T> T runReadAction(@NotNull Function0<? extends T> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        boolean $i$f$runReadAction = false;
        return (T)ApplicationManager.getApplication().runReadAction(new Computable(runnable){
            final /* synthetic */ Function0<T> $runnable;
            {
                this.$runnable = $runnable;
            }

            public final T compute() {
                return (T)this.$runnable.invoke();
            }
        });
    }

    public static final <R> R executeOnPooledThreadInReadAction(@NotNull Function0<? extends R> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return (R)ApplicationManager.getApplication().executeOnPooledThread(() -> CommonTestUtilsKt.executeOnPooledThreadInReadAction$lambda$0(action)).get();
    }

    @NotNull
    public static final String position(@Nullable PsiElement $this$position) {
        if ($this$position == null) {
            return "(unknown)";
        }
        String string = PsiDiagnosticUtils.offsetToLineAndColumn((Document)$this$position.getContainingFile().getViewProvider().getDocument(), (int)$this$position.getTextRange().getStartOffset()).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String getNameWithPositionString(@NotNull KtSymbol $this$getNameWithPositionString) {
        Intrinsics.checkNotNullParameter((Object)$this$getNameWithPositionString, (String)"<this>");
        PsiElement psi = $this$getNameWithPositionString.getPsi();
        return (psi instanceof KtDeclarationWithBody ? ((KtDeclarationWithBody)psi).getName() : (psi instanceof KtNamedDeclaration ? ((KtNamedDeclaration)psi).getName() : (psi == null ? "null" : Reflection.getOrCreateKotlinClass(psi.getClass()).getSimpleName()))) + '@' + CommonTestUtilsKt.position($this$getNameWithPositionString.getPsi());
    }

    @NotNull
    public static final String indented(@NotNull String $this$indented, int indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indented, (String)"<this>");
        String indentString = StringsKt.repeat((CharSequence)" ", (int)indent);
        return indentString + StringsKt.replace$default((String)$this$indented, (String)"\n", (String)('\n' + indentString), (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String getNameWithPositionString(@NotNull KtDeclaration $this$getNameWithPositionString) {
        Intrinsics.checkNotNullParameter((Object)$this$getNameWithPositionString, (String)"<this>");
        StringBuilder stringBuilder = new StringBuilder();
        Object object = $this$getNameWithPositionString.getPresentation();
        if ((object == null || (object = object.getPresentableText()) == null) && (object = $this$getNameWithPositionString.getName()) == null) {
            object = Reflection.getOrCreateKotlinClass($this$getNameWithPositionString.getClass()).getSimpleName();
        }
        return stringBuilder.append((String)object).append('@').append(CommonTestUtilsKt.position((PsiElement)$this$getNameWithPositionString)).toString();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<KtReference> findReferencesAtCaret(@NotNull KtFile mainKtFile, int caretPosition) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)mainKtFile, (String)"mainKtFile");
        PsiReference psiReference = mainKtFile.findReferenceAt(caretPosition);
        List list = psiReference != null ? CommonTestUtilsKt.unwrapMultiReferences(psiReference) : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Iterable $this$filterIsInstance$iv = list;
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof KtReference)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<PsiReference> unwrapMultiReferences(@NotNull PsiReference $this$unwrapMultiReferences) {
        List list;
        Intrinsics.checkNotNullParameter((Object)$this$unwrapMultiReferences, (String)"<this>");
        PsiReference psiReference = $this$unwrapMultiReferences;
        if (psiReference instanceof KtReference) {
            list = CollectionsKt.listOf((Object)$this$unwrapMultiReferences);
        } else if (psiReference instanceof PsiMultiReference) {
            void $this$flatMapTo$iv$iv;
            PsiReference[] psiReferenceArray = ((PsiMultiReference)$this$unwrapMultiReferences).getReferences();
            Intrinsics.checkNotNullExpressionValue((Object)psiReferenceArray, (String)"getReferences(...)");
            Object[] $this$flatMap$iv = psiReferenceArray;
            boolean $i$f$flatMap = false;
            Object[] objectArray = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (void element$iv$iv : $this$flatMapTo$iv$iv) {
                PsiReference it = (PsiReference)element$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                Iterable list$iv$iv = CommonTestUtilsKt.unwrapMultiReferences(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            throw new IllegalStateException(("Unexpected reference " + $this$unwrapMultiReferences).toString());
        }
        return list;
    }

    public static final void ignoreExceptionIfIgnoreDirectivePresent(@NotNull RegisteredDirectives $this$ignoreExceptionIfIgnoreDirectivePresent, @NotNull Directive ignoreDirective, @NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter((Object)$this$ignoreExceptionIfIgnoreDirectivePresent, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)ignoreDirective, (String)"ignoreDirective");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Throwable exception = null;
        try {
            action.invoke();
        }
        catch (Throwable e) {
            exception = e;
        }
        if ($this$ignoreExceptionIfIgnoreDirectivePresent.contains(ignoreDirective)) {
            if (exception != null) {
                return;
            }
            throw new IllegalStateException((ignoreDirective + " is redundant").toString());
        }
        if (exception != null) {
            throw exception;
        }
    }

    private static final Object executeOnPooledThreadInReadAction$lambda$0(Function0 $action) {
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        boolean $i$f$runReadAction = false;
        return ApplicationManager.getApplication().runReadAction(new /* invalid duplicate definition of identical inner class */);
    }
}

