/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir;

import com.intellij.testFramework.TestDataPath;
import java.io.File;
import java.util.regex.Pattern;
import org.jetbrains.kotlin.analysis.low.level.api.fir.AbstractSourceGetOrBuildFirTest;
import org.jetbrains.kotlin.test.TestMetadata;
import org.jetbrains.kotlin.test.util.KtTestUtil;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

@TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir")
@TestDataPath(value="$PROJECT_ROOT")
public class SourceGetOrBuildFirTestGenerated
extends AbstractSourceGetOrBuildFirTest {
    @Test
    public void testAllFilesPresentInGetOrBuildFir() throws Exception {
        KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
    }

    @Test
    @TestMetadata(value="kt60638.kt")
    public void testKt60638() throws Exception {
        this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/kt60638.kt");
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration")
    @TestDataPath(value="$PROJECT_ROOT")
    public class WholeDeclaration {
        @Test
        public void testAllFilesPresentInWholeDeclaration() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="classTypeParemeter.kt")
        public void testClassTypeParemeter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/classTypeParemeter.kt");
        }

        @Test
        @TestMetadata(value="enum.kt")
        public void testEnum() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/enum.kt");
        }

        @Test
        @TestMetadata(value="enumEntry.kt")
        public void testEnumEntry() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/enumEntry.kt");
        }

        @Test
        @TestMetadata(value="externalJavaAnnotation.kt")
        public void testExternalJavaAnnotation() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/externalJavaAnnotation.kt");
        }

        @Test
        @TestMetadata(value="functionTypeParemeter.kt")
        public void testFunctionTypeParemeter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/functionTypeParemeter.kt");
        }

        @Test
        @TestMetadata(value="functionValueParameter.kt")
        public void testFunctionValueParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/functionValueParameter.kt");
        }

        @Test
        @TestMetadata(value="getter.kt")
        public void testGetter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/getter.kt");
        }

        @Test
        @TestMetadata(value="localClass.kt")
        public void testLocalClass() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localClass.kt");
        }

        @Test
        @TestMetadata(value="localFunction.kt")
        public void testLocalFunction() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localFunction.kt");
        }

        @Test
        @TestMetadata(value="localProperty.kt")
        public void testLocalProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/localProperty.kt");
        }

        @Test
        @TestMetadata(value="memberFunction.kt")
        public void testMemberFunction() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberFunction.kt");
        }

        @Test
        @TestMetadata(value="memberProperty.kt")
        public void testMemberProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberProperty.kt");
        }

        @Test
        @TestMetadata(value="memberTypeAlias.kt")
        public void testMemberTypeAlias() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/memberTypeAlias.kt");
        }

        @Test
        @TestMetadata(value="nestedClass.kt")
        public void testNestedClass() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/nestedClass.kt");
        }

        @Test
        @TestMetadata(value="notNullJavaAnnotation.kt")
        public void testNotNullJavaAnnotation() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/notNullJavaAnnotation.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorValValueParameter.kt")
        public void testPrimaryConstructorValValueParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/primaryConstructorValValueParameter.kt");
        }

        @Test
        @TestMetadata(value="primaryConstructorValueParameter.kt")
        public void testPrimaryConstructorValueParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/primaryConstructorValueParameter.kt");
        }

        @Test
        @TestMetadata(value="propagateFlexibleTypeToAnonymousFunction.kt")
        public void testPropagateFlexibleTypeToAnonymousFunction() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/propagateFlexibleTypeToAnonymousFunction.kt");
        }

        @Test
        @TestMetadata(value="propagateFlexibleTypeToAnonymousFunction2.kt")
        public void testPropagateFlexibleTypeToAnonymousFunction2() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/propagateFlexibleTypeToAnonymousFunction2.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructorValueParameter.kt")
        public void testSecondaryConstructorValueParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/secondaryConstructorValueParameter.kt");
        }

        @Test
        @TestMetadata(value="setter.kt")
        public void testSetter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/setter.kt");
        }

        @Test
        @TestMetadata(value="topLevelClass.kt")
        public void testTopLevelClass() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelClass.kt");
        }

        @Test
        @TestMetadata(value="topLevelFunction.kt")
        public void testTopLevelFunction() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelFunction.kt");
        }

        @Test
        @TestMetadata(value="topLevelProperty.kt")
        public void testTopLevelProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelProperty.kt");
        }

        @Test
        @TestMetadata(value="topLevelTypelTypeAlias.kt")
        public void testTopLevelTypelTypeAlias() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/wholeDeclaration/topLevelTypelTypeAlias.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/types")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Types {
        @Test
        public void testAllFilesPresentInTypes() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/types"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="functionalType.kt")
        public void testFunctionalType() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/functionalType.kt");
        }

        @Test
        @TestMetadata(value="functionalTypeArgument.kt")
        public void testFunctionalTypeArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/functionalTypeArgument.kt");
        }

        @Test
        @TestMetadata(value="invalidTypeArgumentsCount.kt")
        public void testInvalidTypeArgumentsCount() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/invalidTypeArgumentsCount.kt");
        }

        @Test
        @TestMetadata(value="invalidTypeArgumentsCountArgument.kt")
        public void testInvalidTypeArgumentsCountArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/invalidTypeArgumentsCountArgument.kt");
        }

        @Test
        @TestMetadata(value="invalidTypeArgumentsCountFirstArgument.kt")
        public void testInvalidTypeArgumentsCountFirstArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/invalidTypeArgumentsCountFirstArgument.kt");
        }

        @Test
        @TestMetadata(value="invalidTypeArgumentsCountLastArgument.kt")
        public void testInvalidTypeArgumentsCountLastArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/invalidTypeArgumentsCountLastArgument.kt");
        }

        @Test
        @TestMetadata(value="nestedClassType.kt")
        public void testNestedClassType() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nestedClassType.kt");
        }

        @Test
        @TestMetadata(value="nestedTypeArgument.kt")
        public void testNestedTypeArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nestedTypeArgument.kt");
        }

        @Test
        @TestMetadata(value="nullableType.kt")
        public void testNullableType() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nullableType.kt");
        }

        @Test
        @TestMetadata(value="nullableTypeWithooutQuestionMark.kt")
        public void testNullableTypeWithooutQuestionMark() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/nullableTypeWithooutQuestionMark.kt");
        }

        @Test
        @TestMetadata(value="receiverType.kt")
        public void testReceiverType() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/receiverType.kt");
        }

        @Test
        @TestMetadata(value="superType.kt")
        public void testSuperType() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superType.kt");
        }

        @Test
        @TestMetadata(value="superType2.kt")
        public void testSuperType2() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superType2.kt");
        }

        @Test
        @TestMetadata(value="superType3.kt")
        public void testSuperType3() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superType3.kt");
        }

        @Test
        @TestMetadata(value="superTypeAndGeneratedProperty.kt")
        public void testSuperTypeAndGeneratedProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeAndGeneratedProperty.kt");
        }

        @Test
        @TestMetadata(value="superTypeInObject.kt")
        public void testSuperTypeInObject() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeInObject.kt");
        }

        @Test
        @TestMetadata(value="superTypeInObject2.kt")
        public void testSuperTypeInObject2() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeInObject2.kt");
        }

        @Test
        @TestMetadata(value="superTypeInObject3.kt")
        public void testSuperTypeInObject3() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeInObject3.kt");
        }

        @Test
        @TestMetadata(value="superTypeOnEnumClass.kt")
        public void testSuperTypeOnEnumClass() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/superTypeOnEnumClass.kt");
        }

        @Test
        @TestMetadata(value="typeArgument.kt")
        public void testTypeArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/typeArgument.kt");
        }

        @Test
        @TestMetadata(value="typeParameterBound.kt")
        public void testTypeParameterBound() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/typeParameterBound.kt");
        }

        @Test
        @TestMetadata(value="typeParameterBoundNested.kt")
        public void testTypeParameterBoundNested() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/typeParameterBoundNested.kt");
        }

        @Test
        @TestMetadata(value="unresolvedTypeArgumentResolvedTypeConsturctor.kt")
        public void testUnresolvedTypeArgumentResolvedTypeConsturctor() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/unresolvedTypeArgumentResolvedTypeConsturctor.kt");
        }

        @Test
        @TestMetadata(value="unresolvedTypeConsturctorResolvedNestedTypeArgument.kt")
        public void testUnresolvedTypeConsturctorResolvedNestedTypeArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/unresolvedTypeConsturctorResolvedNestedTypeArgument.kt");
        }

        @Test
        @TestMetadata(value="unresolvedTypeConsturctorResolvedTypeArgument.kt")
        public void testUnresolvedTypeConsturctorResolvedTypeArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/unresolvedTypeConsturctorResolvedTypeArgument.kt");
        }

        @Test
        @TestMetadata(value="whereFunction.kt")
        public void testWhereFunction() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/whereFunction.kt");
        }

        @Test
        @TestMetadata(value="whereProperty.kt")
        public void testWhereProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/whereProperty.kt");
        }

        @Test
        @TestMetadata(value="wholeType.kt")
        public void testWholeType() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/types/wholeType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class QualifiedExpressions {
        @Test
        public void testAllFilesPresentInQualifiedExpressions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="firstPartOfQualifiedCallWithNestedClasses.kt")
        public void testFirstPartOfQualifiedCallWithNestedClasses() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/firstPartOfQualifiedCallWithNestedClasses.kt");
        }

        @Test
        @TestMetadata(value="lastPartOfQualifiedCallWithNestedClasses.kt")
        public void testLastPartOfQualifiedCallWithNestedClasses() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/lastPartOfQualifiedCallWithNestedClasses.kt");
        }

        @Test
        @TestMetadata(value="middlePartOfQualifiedCallWithNestedClasses.kt")
        public void testMiddlePartOfQualifiedCallWithNestedClasses() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/middlePartOfQualifiedCallWithNestedClasses.kt");
        }

        @Test
        @TestMetadata(value="qualifiedPartOfQualifiedCallUnresolved.kt")
        public void testQualifiedPartOfQualifiedCallUnresolved() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/qualifiedPartOfQualifiedCallUnresolved.kt");
        }

        @Test
        @TestMetadata(value="qualifiedPartOfQualifiedCallWithNestedClasses.kt")
        public void testQualifiedPartOfQualifiedCallWithNestedClasses() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/qualifiedExpressions/qualifiedPartOfQualifiedCallWithNestedClasses.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InvalidCode {
        @Test
        public void testAllFilesPresentInInvalidCode() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="delegatedProperty.kt")
        public void testDelegatedProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/delegatedProperty.kt");
        }

        @Test
        @TestMetadata(value="duplicatedClasses.kt")
        public void testDuplicatedClasses() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/duplicatedClasses.kt");
        }

        @Test
        @TestMetadata(value="duplicatedClassesFunctionParameter.kt")
        public void testDuplicatedClassesFunctionParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/duplicatedClassesFunctionParameter.kt");
        }

        @Test
        @TestMetadata(value="expectAndActualInTheSameFile.kt")
        public void testExpectAndActualInTheSameFile() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/expectAndActualInTheSameFile.kt");
        }

        @Test
        @TestMetadata(value="incompletePropertyWithAnnotation.kt")
        public void testIncompletePropertyWithAnnotation() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/incompletePropertyWithAnnotation.kt");
        }

        @Test
        @TestMetadata(value="javaClassLiteral.kt")
        public void testJavaClassLiteral() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/javaClassLiteral.kt");
        }

        @Test
        @TestMetadata(value="missedTypeArgumentsInAnnotationCall.kt")
        public void testMissedTypeArgumentsInAnnotationCall() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/missedTypeArgumentsInAnnotationCall.kt");
        }

        @Test
        @TestMetadata(value="secondaryConstructor.kt")
        public void testSecondaryConstructor() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/invalidCode/secondaryConstructor.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/inPackage")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InPackage {
        @Test
        public void testAllFilesPresentInInPackage() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="firstPackageNamePart.kt")
        public void testFirstPackageNamePart() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/firstPackageNamePart.kt");
        }

        @Test
        @TestMetadata(value="middlePackageNamePart.kt")
        public void testMiddlePackageNamePart() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/middlePackageNamePart.kt");
        }

        @Test
        @TestMetadata(value="qualifiedPackageNamePart.kt")
        public void testQualifiedPackageNamePart() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/qualifiedPackageNamePart.kt");
        }

        @Test
        @TestMetadata(value="wholePackageDirective.kt")
        public void testWholePackageDirective() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/wholePackageDirective.kt");
        }

        @Test
        @TestMetadata(value="wholePackageName.kt")
        public void testWholePackageName() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inPackage/wholePackageName.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/inImport")
    @TestDataPath(value="$PROJECT_ROOT")
    public class InImport {
        @Test
        public void testAllFilesPresentInInImport() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/inImport"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="firstImportNamePart.kt")
        public void testFirstImportNamePart() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/firstImportNamePart.kt");
        }

        @Test
        @TestMetadata(value="importList.kt")
        public void testImportList() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/importList.kt");
        }

        @Test
        @TestMetadata(value="middleImportNamePart.kt")
        public void testMiddleImportNamePart() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/middleImportNamePart.kt");
        }

        @Test
        @TestMetadata(value="qualifiedImportNamePart.kt")
        public void testQualifiedImportNamePart() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/qualifiedImportNamePart.kt");
        }

        @Test
        @TestMetadata(value="wholeImportDirective.kt")
        public void testWholeImportDirective() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/wholeImportDirective.kt");
        }

        @Test
        @TestMetadata(value="wholeImportName.kt")
        public void testWholeImportName() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/inImport/wholeImportName.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/expressions")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Expressions {
        @Test
        public void testAllFilesPresentInExpressions() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/expressions"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="arrayAccessExpression.kt")
        public void testArrayAccessExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/arrayAccessExpression.kt");
        }

        @Test
        @TestMetadata(value="arrayIndexExpressionWithInc.kt")
        public void testArrayIndexExpressionWithInc() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/arrayIndexExpressionWithInc.kt");
        }

        @Test
        @TestMetadata(value="asExpression.kt")
        public void testAsExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/asExpression.kt");
        }

        @Test
        @TestMetadata(value="binaryExpression.kt")
        public void testBinaryExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/binaryExpression.kt");
        }

        @Test
        @TestMetadata(value="binaryExpressionOperator.kt")
        public void testBinaryExpressionOperator() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/binaryExpressionOperator.kt");
        }

        @Test
        @TestMetadata(value="blockExpression.kt")
        public void testBlockExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/blockExpression.kt");
        }

        @Test
        @TestMetadata(value="boolLiteral.kt")
        public void testBoolLiteral() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/boolLiteral.kt");
        }

        @Test
        @TestMetadata(value="classAccessExpression.kt")
        public void testClassAccessExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/classAccessExpression.kt");
        }

        @Test
        @TestMetadata(value="forExpression.kt")
        public void testForExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpression.kt");
        }

        @Test
        @TestMetadata(value="forExpressionRange.kt")
        public void testForExpressionRange() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpressionRange.kt");
        }

        @Test
        @TestMetadata(value="forExpressionVariable.kt")
        public void testForExpressionVariable() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/forExpressionVariable.kt");
        }

        @Test
        @TestMetadata(value="ifExpression.kt")
        public void testIfExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/ifExpression.kt");
        }

        @Test
        @TestMetadata(value="incExpression.kt")
        public void testIncExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/incExpression.kt");
        }

        @Test
        @TestMetadata(value="insidePlusAssignTarget.kt")
        public void testInsidePlusAssignTarget() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/insidePlusAssignTarget.kt");
        }

        @Test
        @TestMetadata(value="intLiteral.kt")
        public void testIntLiteral() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral.kt");
        }

        @Test
        @TestMetadata(value="intLiteral_minusOne_entire.kt")
        public void testIntLiteral_minusOne_entire() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral_minusOne_entire.kt");
        }

        @Test
        @TestMetadata(value="intLiteral_minusOne_justOne.kt")
        public void testIntLiteral_minusOne_justOne() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral_minusOne_justOne.kt");
        }

        @Test
        @TestMetadata(value="intLiteral_plusOne_entire.kt")
        public void testIntLiteral_plusOne_entire() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral_plusOne_entire.kt");
        }

        @Test
        @TestMetadata(value="intLiteral_plusOne_justOne.kt")
        public void testIntLiteral_plusOne_justOne() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/intLiteral_plusOne_justOne.kt");
        }

        @Test
        @TestMetadata(value="isExpression.kt")
        public void testIsExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/isExpression.kt");
        }

        @Test
        @TestMetadata(value="lambdaExpression.kt")
        public void testLambdaExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/lambdaExpression.kt");
        }

        @Test
        @TestMetadata(value="objectLiteralExpression.kt")
        public void testObjectLiteralExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/objectLiteralExpression.kt");
        }

        @Test
        @TestMetadata(value="parenthesizedExpression.kt")
        public void testParenthesizedExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/parenthesizedExpression.kt");
        }

        @Test
        @TestMetadata(value="propertyReferenceExpression.kt")
        public void testPropertyReferenceExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/propertyReferenceExpression.kt");
        }

        @Test
        @TestMetadata(value="stringLiteral.kt")
        public void testStringLiteral() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/stringLiteral.kt");
        }

        @Test
        @TestMetadata(value="stringTemplateExpressionEntry.kt")
        public void testStringTemplateExpressionEntry() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/stringTemplateExpressionEntry.kt");
        }

        @Test
        @TestMetadata(value="throwExpression.kt")
        public void testThrowExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/throwExpression.kt");
        }

        @Test
        @TestMetadata(value="tryExpression.kt")
        public void testTryExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/tryExpression.kt");
        }

        @Test
        @TestMetadata(value="unraryExpression.kt")
        public void testUnraryExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/unraryExpression.kt");
        }

        @Test
        @TestMetadata(value="unraryExpressionOperator.kt")
        public void testUnraryExpressionOperator() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/unraryExpressionOperator.kt");
        }

        @Test
        @TestMetadata(value="whenExpression.kt")
        public void testWhenExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/whenExpression.kt");
        }

        @Test
        @TestMetadata(value="whileExpression.kt")
        public void testWhileExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/whileExpression.kt");
        }

        @Test
        @TestMetadata(value="wholeStringTemplate.kt")
        public void testWholeStringTemplate() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/expressions/wholeStringTemplate.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/destructuring")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Destructuring {
        @Test
        public void testAllFilesPresentInDestructuring() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="destructuringDeclaration.kt")
        public void testDestructuringDeclaration() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/destructuringDeclaration.kt");
        }

        @Test
        @TestMetadata(value="destructuringDeclarationInLambda.kt")
        public void testDestructuringDeclarationInLambda() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/destructuringDeclarationInLambda.kt");
        }

        @Test
        @TestMetadata(value="destructuringDeclarationParameterInLambda.kt")
        public void testDestructuringDeclarationParameterInLambda() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/destructuringDeclarationParameterInLambda.kt");
        }

        @Test
        @TestMetadata(value="entryInDestructuringDeclaration.kt")
        public void testEntryInDestructuringDeclaration() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/entryInDestructuringDeclaration.kt");
        }

        @Test
        @TestMetadata(value="entryInDestructuringDeclarationParameterInLambda.kt")
        public void testEntryInDestructuringDeclarationParameterInLambda() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/entryInDestructuringDeclarationParameterInLambda.kt");
        }

        @Test
        @TestMetadata(value="entryUnderscoreInDestructuringDeclaration.kt")
        public void testEntryUnderscoreInDestructuringDeclaration() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/entryUnderscoreInDestructuringDeclaration.kt");
        }

        @Test
        @TestMetadata(value="entryUnderscoreInDestructuringDeclarationParameterInLambda.kt")
        public void testEntryUnderscoreInDestructuringDeclarationParameterInLambda() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/destructuring/entryUnderscoreInDestructuringDeclarationParameterInLambda.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/declarations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Declarations {
        @Test
        public void testAllFilesPresentInDeclarations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/declarations"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="constructorParameter.kt")
        public void testConstructorParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/constructorParameter.kt");
        }

        @Test
        @TestMetadata(value="constructorProperty.kt")
        public void testConstructorProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/constructorProperty.kt");
        }

        @Test
        @TestMetadata(value="destructionWithNoRValue.kt")
        public void testDestructionWithNoRValue() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructionWithNoRValue.kt");
        }

        @Test
        @TestMetadata(value="destructuring.kt")
        public void testDestructuring() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructuring.kt");
        }

        @Test
        @TestMetadata(value="destructuringEntry.kt")
        public void testDestructuringEntry() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/destructuringEntry.kt");
        }

        @Test
        @TestMetadata(value="initializerConflict.kt")
        public void testInitializerConflict() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/initializerConflict.kt");
        }

        @Test
        @TestMetadata(value="kt60387.kt")
        public void testKt60387() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/kt60387.kt");
        }

        @Test
        @TestMetadata(value="ktij23263.kt")
        public void testKtij23263() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/ktij23263.kt");
        }

        @Test
        @TestMetadata(value="ktij24730.kt")
        public void testKtij24730() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/ktij24730.kt");
        }

        @Test
        @TestMetadata(value="objectLiteral.kt")
        public void testObjectLiteral() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/objectLiteral.kt");
        }

        @Test
        @TestMetadata(value="objectLiteralExpression.kt")
        public void testObjectLiteralExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/objectLiteralExpression.kt");
        }

        @Test
        @TestMetadata(value="propertyDelegate.kt")
        public void testPropertyDelegate() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/propertyDelegate.kt");
        }

        @Test
        @TestMetadata(value="propertyDelegateExpression.kt")
        public void testPropertyDelegateExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/propertyDelegateExpression.kt");
        }

        @Test
        @TestMetadata(value="whereClause1.kt")
        public void testWhereClause1() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/whereClause1.kt");
        }

        @Test
        @TestMetadata(value="whereClause2.kt")
        public void testWhereClause2() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/declarations/whereClause2.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/calls")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Calls {
        @Test
        public void testAllFilesPresentInCalls() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/calls"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="callArgument.kt")
        public void testCallArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callArgument.kt");
        }

        @Test
        @TestMetadata(value="callInsideLambdaInsideSuperCallAndExplicitConstructor.kt")
        public void testCallInsideLambdaInsideSuperCallAndExplicitConstructor() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallAndExplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="callInsideLambdaInsideSuperCallAndImplicitConstructor.kt")
        public void testCallInsideLambdaInsideSuperCallAndImplicitConstructor() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallAndImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="callInsideLambdaInsideSuperCallFromSecondaryConstructor.kt")
        public void testCallInsideLambdaInsideSuperCallFromSecondaryConstructor() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallFromSecondaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="callInsideLambdaInsideSuperCallFromSingleSecondaryConstructor.kt")
        public void testCallInsideLambdaInsideSuperCallFromSingleSecondaryConstructor() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallFromSingleSecondaryConstructor.kt");
        }

        @Test
        @TestMetadata(value="callInsideLambdaInsideSuperCallInsideImplicitConstructor.kt")
        public void testCallInsideLambdaInsideSuperCallInsideImplicitConstructor() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/callInsideLambdaInsideSuperCallInsideImplicitConstructor.kt");
        }

        @Test
        @TestMetadata(value="calllTypeArguments.kt")
        public void testCalllTypeArguments() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/calllTypeArguments.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignOnVal.kt")
        public void testCompoundAssignOnVal() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVal.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignOnVal_lhs.kt")
        public void testCompoundAssignOnVal_lhs() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVal_lhs.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignOnVar.kt")
        public void testCompoundAssignOnVar() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVar.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignOnVar_lhs.kt")
        public void testCompoundAssignOnVar_lhs() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignOnVar_lhs.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignWithArrayAccessConvention.kt")
        public void testCompoundAssignWithArrayAccessConvention() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayAccessConvention.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignWithArrayAccessConvention_lhs.kt")
        public void testCompoundAssignWithArrayAccessConvention_lhs() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayAccessConvention_lhs.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignWithArrayAccessConvention_propertyAccess.kt")
        public void testCompoundAssignWithArrayAccessConvention_propertyAccess() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayAccessConvention_propertyAccess.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignWithArrayGetConvention.kt")
        public void testCompoundAssignWithArrayGetConvention() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayGetConvention.kt");
        }

        @Test
        @TestMetadata(value="compoundAssignWithArrayGetConvention_lhs.kt")
        public void testCompoundAssignWithArrayGetConvention_lhs() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/compoundAssignWithArrayGetConvention_lhs.kt");
        }

        @Test
        @TestMetadata(value="constructorDelegationSuperCall.kt")
        public void testConstructorDelegationSuperCall() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/constructorDelegationSuperCall.kt");
        }

        @Test
        @TestMetadata(value="constructorDelegationThisCall.kt")
        public void testConstructorDelegationThisCall() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/constructorDelegationThisCall.kt");
        }

        @Test
        @TestMetadata(value="functionCallArgumentList.kt")
        public void testFunctionCallArgumentList() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/functionCallArgumentList.kt");
        }

        @Test
        @TestMetadata(value="incWithArrayAccessConvention.kt")
        public void testIncWithArrayAccessConvention() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/incWithArrayAccessConvention.kt");
        }

        @Test
        @TestMetadata(value="incWithArrayAccessConvention_propertyAccess.kt")
        public void testIncWithArrayAccessConvention_propertyAccess() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/incWithArrayAccessConvention_propertyAccess.kt");
        }

        @Test
        @TestMetadata(value="incWithArrayAccessConvention_set.kt")
        public void testIncWithArrayAccessConvention_set() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/incWithArrayAccessConvention_set.kt");
        }

        @Test
        @TestMetadata(value="invokeCallArgumentList.kt")
        public void testInvokeCallArgumentList() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/invokeCallArgumentList.kt");
        }

        @Test
        @TestMetadata(value="noReceiverOnLambda.kt")
        public void testNoReceiverOnLambda() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/noReceiverOnLambda.kt");
        }

        @Test
        @TestMetadata(value="qualifiedCallInsidePropertyInsideConstructor.kt")
        public void testQualifiedCallInsidePropertyInsideConstructor() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsidePropertyInsideConstructor.kt");
        }

        @Test
        @TestMetadata(value="qualifiedCallInsideSuperCall.kt")
        public void testQualifiedCallInsideSuperCall() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall.kt");
        }

        @Test
        @TestMetadata(value="qualifiedCallInsideSuperCall2.kt")
        public void testQualifiedCallInsideSuperCall2() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall2.kt");
        }

        @Test
        @TestMetadata(value="qualifiedCallInsideSuperCall3.kt")
        public void testQualifiedCallInsideSuperCall3() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall3.kt");
        }

        @Test
        @TestMetadata(value="qualifiedCallInsideSuperCall4.kt")
        public void testQualifiedCallInsideSuperCall4() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall4.kt");
        }

        @Test
        @TestMetadata(value="qualifiedCallInsideSuperCall5.kt")
        public void testQualifiedCallInsideSuperCall5() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallInsideSuperCall5.kt");
        }

        @Test
        @TestMetadata(value="qualifiedCallSelector.kt")
        public void testQualifiedCallSelector() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedCallSelector.kt");
        }

        @Test
        @TestMetadata(value="qualifiedWholeCall.kt")
        public void testQualifiedWholeCall() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/qualifiedWholeCall.kt");
        }

        @Test
        @TestMetadata(value="setOperator.kt")
        public void testSetOperator() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/setOperator.kt");
        }

        @Test
        @TestMetadata(value="superType.kt")
        public void testSuperType() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/calls/superType.kt");
        }
    }

    @Nested
    @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/annotations")
    @TestDataPath(value="$PROJECT_ROOT")
    public class Annotations {
        @Test
        public void testAllFilesPresentInAnnotations() throws Exception {
            KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/annotations"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
        }

        @Test
        @TestMetadata(value="annotationApplicationArgument.kt")
        public void testAnnotationApplicationArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationArgument.kt");
        }

        @Test
        @TestMetadata(value="annotationApplicationArgumentList.kt")
        public void testAnnotationApplicationArgumentList() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationArgumentList.kt");
        }

        @Test
        @TestMetadata(value="annotationApplicationCallExpression.kt")
        public void testAnnotationApplicationCallExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationCallExpression.kt");
        }

        @Test
        @TestMetadata(value="annotationApplicationVarargArgument.kt")
        public void testAnnotationApplicationVarargArgument() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationVarargArgument.kt");
        }

        @Test
        @TestMetadata(value="annotationApplicationWithArguments.kt")
        public void testAnnotationApplicationWithArguments() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationWithArguments.kt");
        }

        @Test
        @TestMetadata(value="annotationApplicationWithArgumentsOnCallSite.kt")
        public void testAnnotationApplicationWithArgumentsOnCallSite() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationApplicationWithArgumentsOnCallSite.kt");
        }

        @Test
        @TestMetadata(value="annotationInsideWhereFunction.kt")
        public void testAnnotationInsideWhereFunction() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationInsideWhereFunction.kt");
        }

        @Test
        @TestMetadata(value="annotationInsideWhereProperty.kt")
        public void testAnnotationInsideWhereProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationInsideWhereProperty.kt");
        }

        @Test
        @TestMetadata(value="annotationOnConstructorProperty.kt")
        public void testAnnotationOnConstructorProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationOnConstructorProperty.kt");
        }

        @Test
        @TestMetadata(value="annotationOnEnumClass.kt")
        public void testAnnotationOnEnumClass() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationOnEnumClass.kt");
        }

        @Test
        @TestMetadata(value="annotationOnReturnType.kt")
        public void testAnnotationOnReturnType() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/annotationOnReturnType.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotation.kt")
        public void testDanglingAnnotation() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/danglingAnnotation.kt");
        }

        @Test
        @TestMetadata(value="danglingAnnotationInClass.kt")
        public void testDanglingAnnotationInClass() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/danglingAnnotationInClass.kt");
        }

        @Test
        @TestMetadata(value="fileAnnotation.kt")
        public void testFileAnnotation() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/fileAnnotation.kt");
        }

        @Test
        @TestMetadata(value="jvmFieldAnnotationOnConstructorProperty.kt")
        public void testJvmFieldAnnotationOnConstructorProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/jvmFieldAnnotationOnConstructorProperty.kt");
        }

        @Test
        @TestMetadata(value="retentionValue.kt")
        public void testRetentionValue() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/retentionValue.kt");
        }

        @Test
        @TestMetadata(value="superCallAnnotation.kt")
        public void testSuperCallAnnotation() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/superCallAnnotation.kt");
        }

        @Test
        @TestMetadata(value="superCallAnnotation2.kt")
        public void testSuperCallAnnotation2() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/superCallAnnotation2.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnConstructorParameter.kt")
        public void testTypeOnAnnotationOnConstructorParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorParameter.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnConstructorParameterExpression.kt")
        public void testTypeOnAnnotationOnConstructorParameterExpression() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorParameterExpression.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnConstructorProperty.kt")
        public void testTypeOnAnnotationOnConstructorProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorProperty.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnConstructorPropertyAndParameter.kt")
        public void testTypeOnAnnotationOnConstructorPropertyAndParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorPropertyAndParameter.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnConstructorPropertyWithArguments.kt")
        public void testTypeOnAnnotationOnConstructorPropertyWithArguments() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnConstructorPropertyWithArguments.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnFunctionParameter.kt")
        public void testTypeOnAnnotationOnFunctionParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnFunctionParameter.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnFunctionParameterWithArguments.kt")
        public void testTypeOnAnnotationOnFunctionParameterWithArguments() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnFunctionParameterWithArguments.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnReceiverFunction.kt")
        public void testTypeOnAnnotationOnReceiverFunction() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverFunction.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnReceiverParameter.kt")
        public void testTypeOnAnnotationOnReceiverParameter() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverParameter.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnReceiverProperty.kt")
        public void testTypeOnAnnotationOnReceiverProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverProperty.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnReceiverPropertyCall.kt")
        public void testTypeOnAnnotationOnReceiverPropertyCall() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReceiverPropertyCall.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnReturnFunction.kt")
        public void testTypeOnAnnotationOnReturnFunction() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReturnFunction.kt");
        }

        @Test
        @TestMetadata(value="typeOnAnnotationOnReturnProperty.kt")
        public void testTypeOnAnnotationOnReturnProperty() throws Exception {
            SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/typeOnAnnotationOnReturnProperty.kt");
        }

        @Nested
        @TestMetadata(value="analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite")
        @TestDataPath(value="$PROJECT_ROOT")
        public class UseSite {
            @Test
            public void testAllFilesPresentInUseSite() throws Exception {
                KtTestUtil.assertAllTestsPresentByMetadataWithExcluded(this.getClass(), (File)new File("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite"), (Pattern)Pattern.compile("^(.+)\\.(kt)$"), null, (boolean)true, (String[])new String[0]);
            }

            @Test
            @TestMetadata(value="delegate.kt")
            public void testDelegate() throws Exception {
                SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/delegate.kt");
            }

            @Test
            @TestMetadata(value="field.kt")
            public void testField() throws Exception {
                SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/field.kt");
            }

            @Test
            @TestMetadata(value="file.kt")
            public void testFile() throws Exception {
                SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/file.kt");
            }

            @Test
            @TestMetadata(value="getter.kt")
            public void testGetter() throws Exception {
                SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/getter.kt");
            }

            @Test
            @TestMetadata(value="param.kt")
            public void testParam() throws Exception {
                SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/param.kt");
            }

            @Test
            @TestMetadata(value="property.kt")
            public void testProperty() throws Exception {
                SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/property.kt");
            }

            @Test
            @TestMetadata(value="setParam.kt")
            public void testSetParam() throws Exception {
                SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/setParam.kt");
            }

            @Test
            @TestMetadata(value="setter.kt")
            public void testSetter() throws Exception {
                SourceGetOrBuildFirTestGenerated.this.runTest("analysis/low-level-api-fir/testData/getOrBuildFir/annotations/useSite/setter.kt");
            }
        }
    }
}

