/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.test.framework.services;

import com.intellij.openapi.util.TextRange;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkerProvider;
import org.jetbrains.kotlin.analysis.test.framework.services.ExpressionMarkersSourceFilePreprocessorKt;
import org.jetbrains.kotlin.test.model.TestFile;
import org.jetbrains.kotlin.test.services.SourceFilePreprocessor;
import org.jetbrains.kotlin.test.services.TestServices;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0001\fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/ExpressionMarkersSourceFilePreprocessor;", "Lorg/jetbrains/kotlin/test/services/SourceFilePreprocessor;", "testServices", "Lorg/jetbrains/kotlin/test/services/TestServices;", "(Lorg/jetbrains/kotlin/test/services/TestServices;)V", "process", "", "file", "Lorg/jetbrains/kotlin/test/model/TestFile;", "content", "processCaretExpression", "processSelectedExpression", "TAGS", "analysis-test-framework_test"})
public final class ExpressionMarkersSourceFilePreprocessor
extends SourceFilePreprocessor {
    public ExpressionMarkersSourceFilePreprocessor(@NotNull TestServices testServices) {
        Intrinsics.checkNotNullParameter((Object)testServices, (String)"testServices");
        super(testServices);
    }

    @NotNull
    public String process(@NotNull TestFile file, @NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String withSelectedProcessed = this.processSelectedExpression(file, content);
        return this.processCaretExpression(file, withSelectedProcessed);
    }

    private final String processSelectedExpression(TestFile file, String content) {
        Integer n = ExpressionMarkersSourceFilePreprocessorKt.indexOfOrNull(content, "<expr>");
        if (n == null) {
            return content;
        }
        int startCaretPosition = n;
        Integer n2 = ExpressionMarkersSourceFilePreprocessorKt.indexOfOrNull(content, "</expr>");
        if (n2 == null) {
            throw new IllegalStateException("</expr> was not found in the file".toString());
        }
        int endCaretPosition = n2;
        if (!(startCaretPosition < endCaretPosition)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        ExpressionMarkerProvider expressionMarkerProvider = ExpressionMarkersSourceFilePreprocessorKt.getExpressionMarkerProvider(this.getTestServices());
        TextRange textRange = TextRange.create((int)startCaretPosition, (int)(endCaretPosition - 6));
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(startCaretPositio\u2026NG_EXPRESSION_TAG.length)");
        expressionMarkerProvider.addSelectedExpression(file, textRange);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)content, (String)"<expr>", (String)"", (boolean)false, (int)4, null), (String)"</expr>", (String)"", (boolean)false, (int)4, null);
    }

    private final String processCaretExpression(TestFile file, String content) {
        String result = content;
        MatchResult match = Regex.find$default((Regex)TAGS.INSTANCE.getCARET_REGEXP(), (CharSequence)result, (int)0, (int)2, null);
        while (match != null) {
            int startCaretPosition = match.getRange().getFirst();
            MatchGroup matchGroup = match.getGroups().get(2);
            String tag = matchGroup != null ? matchGroup.getValue() : null;
            ExpressionMarkersSourceFilePreprocessorKt.getExpressionMarkerProvider(this.getTestServices()).addCaret(file, tag, startCaretPosition);
            String string = result;
            IntRange intRange = match.getRange();
            result = ((Object)StringsKt.removeRange((CharSequence)string, (IntRange)intRange)).toString();
            match = Regex.find$default((Regex)TAGS.INSTANCE.getCARET_REGEXP(), (CharSequence)result, (int)0, (int)2, null);
        }
        return result;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/analysis/test/framework/services/ExpressionMarkersSourceFilePreprocessor$TAGS;", "", "()V", "CARET_REGEXP", "Lkotlin/text/Regex;", "getCARET_REGEXP", "()Lkotlin/text/Regex;", "CLOSING_EXPRESSION_TAG", "", "OPENING_EXPRESSION_TAG", "analysis-test-framework_test"})
    public static final class TAGS {
        @NotNull
        public static final TAGS INSTANCE = new TAGS();
        @NotNull
        public static final String OPENING_EXPRESSION_TAG = "<expr>";
        @NotNull
        public static final String CLOSING_EXPRESSION_TAG = "</expr>";
        @NotNull
        private static final Regex CARET_REGEXP = new Regex("<caret(_(\\w+))?>");

        private TAGS() {
        }

        @NotNull
        public final Regex getCARET_REGEXP() {
            return CARET_REGEXP;
        }
    }
}

